/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network.c_to_s;

import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record DragonFlightStatusPacket(int dragonId, boolean flying) {
    public static void encoder(DragonFlightStatusPacket packet, FriendlyByteBuf buff) {
        buff.writeInt(packet.dragonId);
        buff.writeBoolean(packet.flying);
    }

    public static DragonFlightStatusPacket decoder(FriendlyByteBuf buff) {
        return new DragonFlightStatusPacket(buff.readInt(), buff.readBoolean());
    }

    public static void handler(DragonFlightStatusPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            RedDragonOffspringEntity dragon;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            Entity entity = player.m_9236_().m_6815_(packet.dragonId());
            if (entity instanceof RedDragonOffspringEntity && (dragon = (RedDragonOffspringEntity)entity).m_20160_() && player.m_20202_() == dragon) {
                dragon.setFlying(packet.flying());
            }
        });
        context.get().setPacketHandled(true);
    }
}

