/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.network;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.network.c_to_s.CycleQuiverPacket;
import com.legacy.rediscovered.network.c_to_s.DragonFlightStatusPacket;
import com.legacy.rediscovered.network.c_to_s.DragonStaminaDecreasePacket;
import com.legacy.rediscovered.network.s_to_c.AddClientMotionPacket;
import com.legacy.rediscovered.network.s_to_c.SendBossIdPacket;
import com.legacy.rediscovered.network.s_to_c.SendScreenShakePacket;
import com.legacy.rediscovered.network.s_to_c.SetLocalRainPacket;
import com.legacy.rediscovered.network.s_to_c.UpdateAnimationPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static int index = 0;
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)RediscoveredMod.locate("main"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        PacketHandler.register(UpdateAnimationPacket.class, UpdateAnimationPacket::encoder, UpdateAnimationPacket::decoder, UpdateAnimationPacket::handler);
        PacketHandler.register(SendBossIdPacket.class, SendBossIdPacket::encoder, SendBossIdPacket::decoder, SendBossIdPacket::handler);
        PacketHandler.register(AddClientMotionPacket.class, AddClientMotionPacket::encoder, AddClientMotionPacket::decoder, AddClientMotionPacket::handler);
        PacketHandler.register(SendScreenShakePacket.class, SendScreenShakePacket::encoder, SendScreenShakePacket::decoder, SendScreenShakePacket::handler);
        PacketHandler.register(CycleQuiverPacket.class, CycleQuiverPacket::encoder, CycleQuiverPacket::decoder, CycleQuiverPacket::handler);
        PacketHandler.register(DragonFlightStatusPacket.class, DragonFlightStatusPacket::encoder, DragonFlightStatusPacket::decoder, DragonFlightStatusPacket::handler);
        PacketHandler.register(DragonStaminaDecreasePacket.class, DragonStaminaDecreasePacket::encoder, DragonStaminaDecreasePacket::decoder, DragonStaminaDecreasePacket::handler);
        PacketHandler.register(SetLocalRainPacket.class, SetLocalRainPacket::encoder, SetLocalRainPacket::decoder, SetLocalRainPacket::handler);
    }

    private static <MSG> void register(Class<MSG> packet, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        INSTANCE.registerMessage(index, packet, encoder, decoder, messageConsumer);
        ++index;
    }

    public static void sendToClient(Object packet, ServerPlayer serverPlayer) {
        if (!(serverPlayer instanceof FakePlayer)) {
            INSTANCE.sendTo(packet, serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendToClients(Object packet, ServerLevel level, BlockPos pos) {
        PacketHandler.sendToClients(packet, level, pos, 256);
    }

    public static void sendToClients(Object packet, ServerLevel level, BlockPos pos, int range) {
        Vec3 centerPos = Vec3.m_82512_((Vec3i)pos);
        level.m_6907_().forEach(player -> {
            if (centerPos.m_82554_(player.m_20182_()) <= (double)range) {
                PacketHandler.sendToClient(packet, player);
            }
        });
    }

    public static void sendToAllClients(Object packet, Level level) {
        level.m_6907_().forEach(player -> PacketHandler.sendToClient(packet, (ServerPlayer)player));
    }

    public static void sendToServer(Object packet) {
        INSTANCE.sendToServer(packet);
    }
}

