/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.mixin;

import com.legacy.rediscovered.capability.util.QuiverDataHolder;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.legacy.rediscovered.item.util.QuiverData;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemStackMixin
implements QuiverDataHolder {
    @Nullable
    private QuiverData rediscovered$quiverData = null;
    @Nullable
    private ItemStack rediscovered$quiverWeapon = null;
    @Nullable
    private ItemStack rediscovered$attachedItemCache;

    @Override
    @Nullable
    public QuiverData rediscovered$getQuiverData() {
        return this.rediscovered$quiverData;
    }

    @Override
    public void rediscovered$setQuiverData(@Nullable QuiverData data, @Nullable ItemStack weapon) {
        this.rediscovered$quiverData = data;
        this.rediscovered$quiverWeapon = weapon;
    }

    @Inject(at={@At(value="TAIL")}, method={"setCount"})
    private void setCountHook(CallbackInfo callback) {
        if (this.rediscovered$quiverData != null) {
            this.rediscovered$quiverData.onConsumeAmmo(this.rediscovered$quiverWeapon == null ? ItemStack.f_41583_ : this.rediscovered$quiverWeapon);
            this.rediscovered$setQuiverData(null, null);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"overrideStackedOnOther"}, cancellable=true)
    private void overrideStackedOnOtherHook(Slot pSlot, ClickAction pAction, Player pPlayer, CallbackInfoReturnable<Boolean> callback) {
        Optional<AttachedItem> attached = AttachedItem.get((ItemStack)this);
        if (attached.isPresent() && attached.get().getAttached().m_150926_(pSlot, pAction, pPlayer)) {
            attached.get().save();
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"overrideOtherStackedOnMe"}, cancellable=true)
    private void overrideOtherStackedOnMeHook(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess, CallbackInfoReturnable<Boolean> callback) {
        Optional<AttachedItem> attached = AttachedItem.get((ItemStack)this);
        if (attached.isPresent() && attached.get().getAttached().m_150932_(pStack, pSlot, pAction, pPlayer, pAccess)) {
            attached.get().save();
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt(ILnet/minecraft/util/RandomSource;Lnet/minecraft/server/level/ServerPlayer;)Z"})
    private void onDamaged(CallbackInfoReturnable<Boolean> callback) {
        Optional<AttachedItem> attached;
        if (((Boolean)callback.getReturnValue()).booleanValue() && (attached = AttachedItem.get((ItemStack)this)).isPresent()) {
            this.rediscovered$attachedItemCache = attached.get().getAttached();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")}, method={"hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"})
    private void onBroken(int amount, LivingEntity entity, Consumer<LivingEntity> onBroken, CallbackInfo callback) {
        if (this.rediscovered$attachedItemCache != null) {
            ItemStack me = (ItemStack)this;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (entity.m_6844_(slot) != me) continue;
                entity.m_8061_(slot, this.rediscovered$attachedItemCache.m_41777_());
                this.rediscovered$attachedItemCache = null;
                break;
            }
        }
    }
}

