/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item.util;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.data.RediscoveredTags;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;

public enum RediscoveredArmorMaterial implements ArmorMaterial
{
    QUIVER("quiver", -1, RediscoveredArmorMaterial.armorValues(0, 0, 0, 0), 0, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_(RediscoveredTags.Items.QUIVER_REPAIR_MATERIALS), 0.0f, 0.0f),
    STUDDED("studded", 13, RediscoveredArmorMaterial.armorValues(2, 4, 5, 2), 13, RediscoveredSounds.ITEM_ARMOR_EQUIP_STUDDED, 0.0f, 0.0f, () -> Ingredient.m_204132_(RediscoveredTags.Items.STUDDED_ARMOR_REPAIR_MATERIALS), 0.0f, 0.08f),
    PLATE("plate", 25, RediscoveredArmorMaterial.armorValues(2, 5, 6, 2), 12, RediscoveredSounds.ITEM_ARMOR_EQUIP_PLATE, 3.0f, 0.1f, () -> Ingredient.m_204132_(RediscoveredTags.Items.PLATE_ARMOR_REPAIR_MATERIALS), 0.15f, 0.0f);

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResist;
    private final Lazy<Ingredient> repairMaterial;
    private final float explosionResist;
    private final float fireResist;

    private RediscoveredArmorMaterial(String name, int durabilityMultiplier, EnumMap<ArmorItem.Type, Integer> damageReductionArray, int enchantability, SoundEvent equipSound, float toughness, float knockbackResist, Supplier<Ingredient> repairMaterial, float explosionResist, float fireResist) {
        this.name = RediscoveredMod.find(name);
        this.durabilityMultiplier = durabilityMultiplier;
        this.damageReductionAmountArray = damageReductionArray;
        this.enchantability = enchantability;
        this.soundEvent = equipSound;
        this.toughness = toughness;
        this.knockbackResist = knockbackResist;
        this.repairMaterial = Lazy.of(repairMaterial);
        this.explosionResist = explosionResist;
        this.fireResist = fireResist;
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.damageReductionAmountArray.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResist;
    }

    public float getExplosionResistance() {
        return this.explosionResist;
    }

    public float getFireResistance() {
        return this.fireResist;
    }

    public static EnumMap<ArmorItem.Type, Integer> armorValues(int boots, int legs, int chest, int helmet) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), material -> {
            material.put(ArmorItem.Type.BOOTS, boots);
            material.put(ArmorItem.Type.LEGGINGS, legs);
            material.put(ArmorItem.Type.CHESTPLATE, chest);
            material.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = RediscoveredArmorMaterial.armorValues(13, 15, 16, 11);
    }
}

