/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item.util;

import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;

public class QuiverData
implements AttachedItem.AttachedTracker {
    public static final byte QUIVER_SIZE = 5;
    public static final Codec<QuiverData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.listOf().fieldOf("ammo").forGetter(i -> i.getAmmo()), (App)Codec.BYTE.fieldOf(SELECTED_SLOT_KEY).forGetter(i -> i.getSelectedSlot())).apply((Applicative)instance, QuiverData::new));
    private ItemStack stack = null;
    private AttachedItem attachedItem = null;
    private final NonNullList<ItemStack> ammo = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private byte selectedSlot = 0;
    private static final String QUIVER_DATA_TAG = "rediscovered_quiver_data";
    private static final String SELECTED_SLOT_KEY = "selected_slot";

    public QuiverData(List<ItemStack> ammo, byte selectedSlot) {
        int size = Math.min(5, ammo.size());
        this.ammo.clear();
        for (int i = 0; i < size; i = (int)((byte)(i + 1))) {
            this.ammo.set(i, (Object)ammo.get(i));
        }
        this.selectedSlot = selectedSlot;
    }

    public QuiverData() {
    }

    public QuiverData setQuiver(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public static QuiverData getOrCreate(ItemStack stack) {
        Optional<QuiverData> data = QuiverData.get(stack);
        if (data.isPresent()) {
            return data.get();
        }
        return new QuiverData().setQuiver(stack);
    }

    public static Optional<QuiverData> get(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && (tag = stack.m_41783_()) != null && tag.m_128425_(QUIVER_DATA_TAG, 10)) {
            QuiverData data = new QuiverData().setQuiver(stack);
            CompoundTag dataTag = tag.m_128469_(QUIVER_DATA_TAG);
            ContainerHelper.m_18980_((CompoundTag)dataTag, data.ammo);
            data.selectedSlot = dataTag.m_128445_(SELECTED_SLOT_KEY);
            return Optional.of(data);
        }
        return Optional.empty();
    }

    public void save() {
        if (this.stack != null) {
            CompoundTag tag = this.stack.m_41784_();
            CompoundTag dataTag = new CompoundTag();
            ContainerHelper.m_18973_((CompoundTag)dataTag, this.ammo);
            dataTag.m_128344_(SELECTED_SLOT_KEY, this.selectedSlot);
            tag.m_128365_(QUIVER_DATA_TAG, (Tag)dataTag);
        }
        if (this.attachedItem != null) {
            this.attachedItem.save();
        }
    }

    public static boolean isPresent(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_(QUIVER_DATA_TAG, 10);
    }

    public void cycleNextSlot(ItemStack weapon) {
        Set<Byte> slotsWithAmmo = this.getSlotsWithAmmo(weapon);
        if (slotsWithAmmo.size() < 1) {
            this.selectedSlot = 0;
        } else {
            for (int i = 0; i < 5; ++i) {
                this.selectedSlot = (byte)(this.selectedSlot + 1);
                if (this.selectedSlot >= 5) {
                    this.selectedSlot = 0;
                }
                if (slotsWithAmmo.contains(this.selectedSlot)) break;
            }
        }
        this.save();
    }

    private Set<Byte> getSlotsWithAmmo(ItemStack weapon) {
        HashSet<Byte> slots = new HashSet<Byte>();
        for (byte i = 0; i < 5; i = (byte)(i + 1)) {
            if (!QuiverData.isAmmo((ItemStack)this.ammo.get((int)i), weapon)) continue;
            slots.add(i);
        }
        return slots;
    }

    public byte getSelectedSlot() {
        return this.selectedSlot;
    }

    public ItemStack getSelectedAmmo(ItemStack weapon) {
        ItemStack ammo = (ItemStack)this.ammo.get((int)this.selectedSlot);
        if (QuiverData.isAmmo(ammo, weapon)) {
            return ammo;
        }
        this.cycleNextSlot(weapon);
        ammo = (ItemStack)this.ammo.get((int)this.selectedSlot);
        return QuiverData.isAmmo(ammo, weapon) ? ammo : ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getAmmo() {
        return this.ammo;
    }

    public void setAmmo(int slot, ItemStack stack) {
        this.ammo.set(slot, (Object)stack);
        this.save();
    }

    public boolean add(ItemStack stack) {
        boolean addedAmmo = false;
        for (int i = 0; i < 5; ++i) {
            ItemStack ammo = (ItemStack)this.ammo.get(i);
            if (ammo.m_41619_()) {
                this.ammo.set(i, (Object)stack.m_278832_());
                addedAmmo = true;
                break;
            }
            if (stack.m_41619_() || ammo.m_41613_() >= ammo.m_41741_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)ammo)) continue;
            int canAdd = ammo.m_41741_() - ammo.m_41613_();
            int toAdd = Math.min(canAdd, stack.m_41613_());
            ammo.m_41769_(toAdd);
            stack.m_41774_(toAdd);
            addedAmmo = true;
        }
        if (addedAmmo) {
            this.save();
        }
        return addedAmmo;
    }

    public void injectData(NonNullList<ItemStack> ammo) {
        int size = Math.min(5, ammo.size());
        this.ammo.clear();
        for (int i = 0; i < size; i = (int)((byte)(i + 1))) {
            this.ammo.set(i, (Object)((ItemStack)ammo.get(i)));
        }
        if (((ItemStack)this.ammo.get((int)this.selectedSlot)).m_41619_()) {
            this.cycleNextSlot(Items.f_42411_.m_7968_());
        }
        this.save();
    }

    public void onConsumeAmmo(ItemStack weapon) {
        ItemStack stack = (ItemStack)this.ammo.get((int)this.selectedSlot);
        if (stack.m_41619_()) {
            this.cycleNextSlot(weapon);
        }
        this.save();
    }

    public ItemStack getQuiver() {
        return this.stack;
    }

    public static Optional<QuiverData> getFromChestplate(ItemStack chestplate) {
        return Optional.ofNullable(AttachedItem.getFromSelfOrAttached(chestplate, (s, q) -> q != null, s -> QuiverData.get(s).orElseGet(() -> null), () -> null));
    }

    public static Pair<InteractionHand, ItemStack> getHeldBow(LivingEntity entity) {
        ItemStack stack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_204117_(RediscoveredTags.Items.QUIVER_USER)) {
            return Pair.of((Object)InteractionHand.MAIN_HAND, (Object)stack);
        }
        stack = entity.m_21120_(InteractionHand.OFF_HAND);
        return stack.m_204117_(RediscoveredTags.Items.QUIVER_USER) ? Pair.of((Object)InteractionHand.OFF_HAND, (Object)stack) : Pair.of((Object)InteractionHand.MAIN_HAND, (Object)ItemStack.f_41583_);
    }

    public static boolean isHoldingBow(LivingEntity entity) {
        return !((ItemStack)QuiverData.getHeldBow(entity).getSecond()).m_41619_();
    }

    public static boolean isHoldingAmmo(LivingEntity entity, ItemStack weaponStack) {
        Predicate predicate;
        Item item = weaponStack.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem projWeapon = (ProjectileWeaponItem)item;
            predicate = projWeapon.m_6442_();
        } else {
            predicate = s -> true;
        }
        Predicate predicate2 = predicate;
        return !ProjectileWeaponItem.m_43010_((LivingEntity)entity, predicate2.and(s -> s.m_204117_(RediscoveredTags.Items.QUIVER_AMMO))).m_41619_();
    }

    public static boolean isAmmo(ItemStack ammoStack, ItemStack weaponStack) {
        Predicate predicate;
        Item item = weaponStack.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem projWeapon = (ProjectileWeaponItem)item;
            predicate = projWeapon.m_6442_();
        } else {
            predicate = s -> true;
        }
        return QuiverData.isAmmo(ammoStack, predicate);
    }

    public static boolean isAmmo(ItemStack ammoStack, Predicate<ItemStack> predicate) {
        return predicate.and(s -> s.m_204117_(RediscoveredTags.Items.QUIVER_AMMO)).test(ammoStack);
    }

    public static boolean canAttachQuiver(ItemStack stack) {
        return stack.m_204117_(RediscoveredTags.Items.QUIVER_APPLICABLE) && !stack.m_204117_(RediscoveredTags.Items.QUIVER_INAPPLICABLE);
    }

    @Override
    @Nullable
    public AttachedItem getAttachedItem() {
        return this.attachedItem;
    }

    @Override
    public void setAttachedItem(@Nullable AttachedItem attached) {
        this.attachedItem = attached;
    }
}

