/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item.util;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import org.apache.logging.log4j.Logger;

public record DragonArmorTrim(Optional<Holder<TrimMaterial>> chain, Optional<Holder<TrimMaterial>> plating, Optional<Holder<TrimMaterial>> inlay) {
    public static final Codec<DragonArmorTrim> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TrimMaterial.f_266056_.optionalFieldOf(Decoration.CHAIN.m_7912_()).forGetter(DragonArmorTrim::chain), (App)TrimMaterial.f_266056_.optionalFieldOf(Decoration.PLATING.m_7912_()).forGetter(DragonArmorTrim::plating), (App)TrimMaterial.f_266056_.optionalFieldOf(Decoration.INLAY.m_7912_()).forGetter(DragonArmorTrim::inlay)).apply((Applicative)instance, DragonArmorTrim::new));
    public static final DragonArmorTrim EMPTY = new DragonArmorTrim(Optional.empty(), Optional.empty(), Optional.empty());

    public static DragonArmorTrim create(Registry<TrimMaterial> materialRegistry, @Nullable ResourceKey<TrimMaterial> base, @Nullable ResourceKey<TrimMaterial> plate, @Nullable ResourceKey<TrimMaterial> accent) {
        Optional<Holder<TrimMaterial>> baseH = Optional.ofNullable(base).map(k -> materialRegistry.m_203636_(k).orElse(null));
        Optional<Holder<TrimMaterial>> plateH = Optional.ofNullable(plate).map(k -> materialRegistry.m_203636_(k).orElse(null));
        Optional<Holder<TrimMaterial>> accentH = Optional.ofNullable(accent).map(k -> materialRegistry.m_203636_(k).orElse(null));
        return new DragonArmorTrim(baseH, plateH, accentH);
    }

    public static DragonArmorTrim combine(Optional<DragonArmorTrim> original, DragonArmorTrim toAdd) {
        if (original.isPresent()) {
            DragonArmorTrim o = original.get();
            return new DragonArmorTrim(toAdd.chain.isPresent() ? toAdd.chain : o.chain, toAdd.plating.isPresent() ? toAdd.plating : o.plating, toAdd.inlay.isPresent() ? toAdd.inlay : o.inlay);
        }
        return toAdd;
    }

    public static DragonArmorTrim create(Decoration decoration, Holder<TrimMaterial> material) {
        Optional<Holder<TrimMaterial>> m = Optional.ofNullable(material);
        return switch (decoration) {
            default -> throw new IncompatibleClassChangeError();
            case Decoration.CHAIN -> new DragonArmorTrim(m, Optional.empty(), Optional.empty());
            case Decoration.PLATING -> new DragonArmorTrim(Optional.empty(), m, Optional.empty());
            case Decoration.INLAY -> new DragonArmorTrim(Optional.empty(), Optional.empty(), m);
        };
    }

    public static DragonArmorTrim createRandom(Registry<TrimMaterial> materialRegistry, RandomSource rand) {
        List<ResourceKey> keys = Stream.concat(materialRegistry.m_214010_().stream(), Stream.of((ResourceKey)null)).toList();
        return DragonArmorTrim.create(materialRegistry, (ResourceKey<TrimMaterial>)((ResourceKey)Util.m_214621_(keys, (RandomSource)rand)), (ResourceKey<TrimMaterial>)((ResourceKey)Util.m_214621_(keys, (RandomSource)rand)), (ResourceKey<TrimMaterial>)((ResourceKey)Util.m_214621_(keys, (RandomSource)rand)));
    }

    public DragonArmorTrim remove(Decoration decoration) {
        return switch (decoration) {
            default -> throw new IncompatibleClassChangeError();
            case Decoration.CHAIN -> new DragonArmorTrim(Optional.empty(), this.plating, this.inlay);
            case Decoration.PLATING -> new DragonArmorTrim(this.chain, Optional.empty(), this.inlay);
            case Decoration.INLAY -> new DragonArmorTrim(this.chain, this.plating, Optional.empty());
        };
    }

    public int getColor(int modelLayer) {
        return switch (modelLayer) {
            case 0 -> this.getColor(this.chain, 8029864);
            case 1 -> this.getColor(this.plating, 10662067);
            default -> this.getColor(this.inlay, this.getColor(1));
        };
    }

    private int getColor(Optional<Holder<TrimMaterial>> material, int defaultColor) {
        return material.map(m -> ((TrimMaterial)m.get()).f_266021_().m_7383_().m_131135_().m_131265_()).orElse(defaultColor);
    }

    public Optional<Holder<TrimMaterial>> getMaterial(Decoration decoration) {
        return switch (decoration) {
            default -> throw new IncompatibleClassChangeError();
            case Decoration.CHAIN -> this.chain;
            case Decoration.PLATING -> this.plating;
            case Decoration.INLAY -> this.inlay;
        };
    }

    public boolean materialMatches(Decoration decoration, Holder<TrimMaterial> material) {
        Optional<Holder<TrimMaterial>> mat = this.getMaterial(decoration);
        return mat.isPresent() && mat.get() == material;
    }

    public static boolean setTrim(RegistryAccess registryAccess, ItemStack armor, DragonArmorTrim trim) {
        if (armor.m_150930_(RediscoveredItems.dragon_armor)) {
            armor.m_41784_().m_128365_("trim", (Tag)CODEC.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess), (Object)trim).result().orElseThrow());
            return true;
        }
        return false;
    }

    public static Optional<DragonArmorTrim> getTrim(RegistryAccess registryAccess, ItemStack armor) {
        if (armor.m_150930_(RediscoveredItems.dragon_armor) && armor.m_41783_() != null && armor.m_41783_().m_128441_("trim")) {
            CompoundTag compoundtag = armor.m_41737_("trim");
            DragonArmorTrim armortrim = CODEC.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess), (Object)compoundtag).resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).orElse(null);
            return Optional.ofNullable(armortrim);
        }
        return Optional.empty();
    }

    public static void appendHoverText(ItemStack armor, RegistryAccess registryAccess, List<Component> tooltips) {
        Optional<DragonArmorTrim> optional = DragonArmorTrim.getTrim(registryAccess, armor);
        if (optional.isPresent()) {
            DragonArmorTrim trim = optional.get();
            DragonArmorTrim.addTooltip(Decoration.CHAIN.localeKey(), trim.chain, tooltips);
            DragonArmorTrim.addTooltip(Decoration.PLATING.localeKey(), trim.plating, tooltips);
            DragonArmorTrim.addTooltip(Decoration.INLAY.localeKey(), trim.inlay, tooltips);
        }
    }

    private static void addTooltip(String key, Optional<Holder<TrimMaterial>> material, List<Component> tooltips) {
        if (material.isPresent()) {
            MutableComponent tooltip = Component.m_237110_((String)"%s: %s", (Object[])new Object[]{Component.m_237115_((String)key), ((TrimMaterial)material.get().get()).f_266021_()}).m_130940_(ChatFormatting.GRAY);
            tooltips.add((Component)tooltip);
        }
    }

    public static enum Decoration implements StringRepresentable
    {
        CHAIN("chain"),
        PLATING("plating"),
        INLAY("inlay");

        public static final Codec<Decoration> CODEC;
        final String name;
        final String localeKey;

        private Decoration(String name) {
            this.name = name;
            this.localeKey = "dragon_armor_trim.rediscovered." + name;
        }

        public String m_7912_() {
            return this.name;
        }

        public final String toString() {
            return this.name;
        }

        public static Decoration byName(String name) {
            for (Decoration d : Decoration.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return PLATING;
        }

        public String localeKey() {
            return this.localeKey;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Decoration::values);
        }
    }
}

