/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class AttachedItem {
    public static final Codec<AttachedItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("attached").forGetter(i -> i.getAttached())).apply((Applicative)instance, AttachedItem::new));
    private ItemStack stack = null;
    private ItemStack attachedStack;
    private static final String ATTACHED_ITEM_TAG = "rediscovered_attached_item";
    private static final String ITEM_KEY = "item";

    private AttachedItem(ItemStack attachedStack) {
        this.attachedStack = attachedStack;
    }

    public AttachedItem setOwner(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public static Optional<AttachedItem> getOrCreate(ItemStack stack) {
        Optional<AttachedItem> attached = AttachedItem.get(stack);
        if (attached.isPresent()) {
            return attached;
        }
        return Optional.of(new AttachedItem(ItemStack.f_41583_).setOwner(stack));
    }

    public static Optional<AttachedItem> get(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && (tag = stack.m_41783_()) != null && tag.m_128425_(ATTACHED_ITEM_TAG, 10)) {
            CompoundTag attachedTag = tag.m_128469_(ATTACHED_ITEM_TAG);
            ItemStack attachedItem = ItemStack.m_41712_((CompoundTag)attachedTag.m_128469_(ITEM_KEY));
            return Optional.of(new AttachedItem(attachedItem).setOwner(stack));
        }
        return Optional.empty();
    }

    public void save() {
        if (this.stack == null) {
            return;
        }
        if (this.attachedStack.m_41619_()) {
            CompoundTag tag = this.stack.m_41783_();
            if (tag != null && tag.m_128425_(ATTACHED_ITEM_TAG, 10)) {
                tag.m_128473_(ATTACHED_ITEM_TAG);
            }
        } else {
            CompoundTag tag = this.stack.m_41784_();
            CompoundTag attachedTag = new CompoundTag();
            attachedTag.m_128365_(ITEM_KEY, (Tag)this.attachedStack.m_41739_(new CompoundTag()));
            tag.m_128365_(ATTACHED_ITEM_TAG, (Tag)attachedTag);
        }
    }

    public ItemStack getAttached() {
        return this.attachedStack;
    }

    public void setAttached(ItemStack attachedStack) {
        this.attachedStack = attachedStack.m_41777_();
        this.save();
    }

    public static boolean hasAttached(ItemStack stack) {
        Optional<AttachedItem> attached = AttachedItem.get(stack);
        return attached.isPresent() && !attached.get().getAttached().m_41619_();
    }

    public static ItemStack attachItem(ItemStack stack, ItemStack attachment) {
        Optional<AttachedItem> data = AttachedItem.getOrCreate(stack);
        if (data.isPresent()) {
            data.get().setAttached(attachment);
        }
        return stack;
    }

    public static ItemStack removeAttachment(ItemStack stack) {
        Optional<AttachedItem> data = AttachedItem.getOrCreate(stack);
        if (data.isPresent()) {
            data.get().setAttached(ItemStack.f_41583_);
        }
        return stack;
    }

    public static <T extends AttachedTracker> T getFromSelfOrAttached(ItemStack stack, BiPredicate<ItemStack, T> validator, Function<ItemStack, T> function, Supplier<T> defaultVal) {
        ItemStack attached;
        AttachedTracker ret = (AttachedTracker)function.apply(stack);
        if (validator.test(stack, (ItemStack)ret)) {
            return (T)ret;
        }
        Optional<AttachedItem> attachedItem = AttachedItem.getOrCreate(stack);
        if (attachedItem.isPresent() && validator.test(attached = attachedItem.get().getAttached(), (ItemStack)(ret = (AttachedTracker)function.apply(attached)))) {
            ret.setAttachedItem(attachedItem.get());
            return (T)ret;
        }
        return (T)((AttachedTracker)defaultVal.get());
    }

    public static interface AttachedTracker {
        public void setAttachedItem(@Nullable AttachedItem var1);

        @Nullable
        public AttachedItem getAttachedItem();
    }
}

