/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item.crafting;

import com.google.gson.JsonObject;
import com.legacy.rediscovered.item.util.DragonArmorTrim;
import com.legacy.rediscovered.registry.RediscoveredRecipeSerializers;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SmithingDragonArmorRecipeBuilder {
    private final RecipeCategory category;
    private final Ingredient template;
    private final DragonArmorTrim.Decoration decoration;
    private final Ingredient base;
    private final Ingredient addition;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private final RecipeSerializer<?> type;

    public SmithingDragonArmorRecipeBuilder(RecipeSerializer<?> pType, RecipeCategory pCategory, Ingredient pTemplate, DragonArmorTrim.Decoration decoration, Ingredient pBase, Ingredient pAddition) {
        this.category = pCategory;
        this.type = pType;
        this.template = pTemplate;
        this.decoration = decoration;
        this.base = pBase;
        this.addition = pAddition;
    }

    public static SmithingDragonArmorRecipeBuilder smithingTrim(Ingredient pTemplate, DragonArmorTrim.Decoration decoration, Ingredient pBase, Ingredient pAddition, RecipeCategory pCategory) {
        return new SmithingDragonArmorRecipeBuilder((RecipeSerializer)RediscoveredRecipeSerializers.DRAGON_ARMOR.get(), pCategory, pTemplate, decoration, pBase, pAddition);
    }

    public SmithingDragonArmorRecipeBuilder unlocks(String pKey, CriterionTriggerInstance pCriterion) {
        this.advancement.m_138386_(pKey, pCriterion);
        return this;
    }

    public void save(Consumer<FinishedRecipe> pRecipeConsumer, ResourceLocation pLocation) {
        this.ensureValid(pLocation);
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pLocation)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pLocation)).m_138360_(RequirementsStrategy.f_15979_);
        pRecipeConsumer.accept(new Result(pLocation, this.type, this.template, this.decoration, this.base, this.addition, this.advancement, pLocation.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation pLocation) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pLocation);
        }
    }

    public record Result(ResourceLocation id, RecipeSerializer<?> type, Ingredient template, DragonArmorTrim.Decoration decoration, Ingredient base, Ingredient addition, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.add("template", this.template.m_43942_());
            json.addProperty("decoration", this.decoration.m_7912_());
            json.add("base", this.base.m_43942_());
            json.add("addition", this.addition.m_43942_());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

