/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.rediscovered.item.util.DragonArmorTrim;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.registry.RediscoveredRecipeSerializers;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class SmithingDragonArmorRecipe
implements SmithingRecipe {
    private final ResourceLocation id;
    final Ingredient template;
    final DragonArmorTrim.Decoration decoration;
    final Ingredient base;
    final Ingredient addition;

    public SmithingDragonArmorRecipe(ResourceLocation id, Ingredient template, DragonArmorTrim.Decoration decoration, Ingredient base, Ingredient addition) {
        this.id = id;
        this.template = template;
        this.decoration = decoration;
        this.base = base;
        this.addition = addition;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.template.test(container.m_8020_(0)) && this.base.test(container.m_8020_(1)) && this.addition.test(container.m_8020_(2));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        Optional material;
        ItemStack baseItem = container.m_8020_(1);
        if (this.base.test(baseItem) && (material = TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)container.m_8020_(2))).isPresent()) {
            Optional<DragonArmorTrim> currentTrim = DragonArmorTrim.getTrim(registryAccess, baseItem);
            if (currentTrim.isPresent() && currentTrim.get().materialMatches(this.decoration, (Holder<TrimMaterial>)((Holder)material.get()))) {
                return ItemStack.f_41583_;
            }
            ItemStack resultItem = baseItem.m_41777_();
            resultItem.m_41764_(1);
            DragonArmorTrim trim = DragonArmorTrim.combine(currentTrim, DragonArmorTrim.create(this.decoration, (Holder<TrimMaterial>)((Holder)material.get())));
            if (DragonArmorTrim.setTrim(registryAccess, resultItem, trim)) {
                return resultItem;
            }
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return RediscoveredItems.dragon_armor.m_7968_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RediscoveredRecipeSerializers.DRAGON_ARMOR.get();
    }

    public boolean m_266166_(ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean m_266343_(ItemStack stack) {
        return this.base.test(stack);
    }

    public boolean m_266253_(ItemStack stack) {
        return this.addition.test(stack);
    }

    public boolean m_142505_() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(ForgeHooks::hasNoElements);
    }

    public static class Serializer
    implements RecipeSerializer<SmithingDragonArmorRecipe> {
        public SmithingDragonArmorRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"template"));
            DragonArmorTrim.Decoration decoration = DragonArmorTrim.Decoration.byName(GsonHelper.m_13906_((JsonObject)json, (String)"decoration"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"addition"));
            return new SmithingDragonArmorRecipe(id, ingredient, decoration, ingredient1, ingredient2);
        }

        public SmithingDragonArmorRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf byteBuff) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)byteBuff);
            DragonArmorTrim.Decoration decoration = DragonArmorTrim.Decoration.byName(byteBuff.m_130277_());
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)byteBuff);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)byteBuff);
            return new SmithingDragonArmorRecipe(id, ingredient, decoration, ingredient1, ingredient2);
        }

        public void toNetwork(FriendlyByteBuf byteBuff, SmithingDragonArmorRecipe recipe) {
            recipe.template.m_43923_(byteBuff);
            byteBuff.m_130070_(recipe.decoration.m_7912_());
            recipe.base.m_43923_(byteBuff);
            recipe.addition.m_43923_(byteBuff);
        }
    }
}

