/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item;

import com.legacy.rediscovered.client.item.RubyFluteClient;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class RubyFluteItem
extends Item {
    public static final String DRAGON_NOT_LOADED_KEY = "rediscovered.message.dragon_not_loaded";
    public static final String DRAGON_STUCK_KEY = "rediscovered.message.dragon_stuck";
    public static final String DRAGON_TIRED_KEY = "rediscovered.message.dragon_too_tired";
    private static final String TARGET_KEY = "target";
    private static final String TARGET_NAME_KEY = "target_name";

    public RubyFluteItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 1200;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_5496_((SoundEvent)SoundEvents.f_12212_.get(), 10.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        player.m_36335_().m_41524_((Item)this, 20);
        UUID target = RubyFluteItem.getTargetUUID(stack);
        if (target != null && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            Entity summon = sl.m_8791_(target);
            if (summon != null) {
                RubyFluteItem.trySummon(player, sl.m_8791_(target));
            } else {
                player.m_5661_((Component)Component.m_237110_((String)DRAGON_NOT_LOADED_KEY, (Object[])new Object[]{RubyFluteItem.getTargetName(stack)}), true);
            }
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public static boolean trySummon(Player player, Entity entity) {
        RedDragonOffspringEntity dragon;
        if (entity instanceof RedDragonOffspringEntity && (dragon = (RedDragonOffspringEntity)entity).m_269323_() == player) {
            dragon.summonFromFlute(player);
            return true;
        }
        return false;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        RedDragonOffspringEntity dragon;
        if (target instanceof RedDragonOffspringEntity && (dragon = (RedDragonOffspringEntity)target).m_269323_() == player) {
            RubyFluteItem.setTarget(stack, target);
            player.m_21008_(usedHand, stack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(TARGET_KEY);
    }

    public boolean canGrindstoneRepair(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltips, TooltipFlag isAdvanced) {
        Component targetName = RubyFluteItem.getTargetName(stack);
        if (targetName != null) {
            tooltips.add((Component)targetName.m_6881_().m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new RubyFluteClient());
    }

    public static ItemStack setTarget(ItemStack stack, @Nullable LivingEntity target) {
        if (target != null) {
            RubyFluteItem.setTargetName(stack, target.m_5446_());
            RubyFluteItem.setTargetUUID(stack, target.m_20148_());
        } else {
            RubyFluteItem.setTargetName(stack, null);
            RubyFluteItem.setTargetUUID(stack, null);
        }
        return stack;
    }

    @Nullable
    public static UUID getTargetUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128403_(TARGET_KEY)) {
            return tag.m_128342_(TARGET_KEY);
        }
        return null;
    }

    public static ItemStack setTargetUUID(ItemStack stack, @Nullable UUID uuid) {
        if (uuid == null) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_(TARGET_KEY);
            }
        } else {
            CompoundTag tag = stack.m_41784_();
            tag.m_128362_(TARGET_KEY, uuid);
        }
        return stack;
    }

    @Nullable
    public static Component getTargetName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TARGET_NAME_KEY, 8)) {
            String s = tag.m_128461_(TARGET_NAME_KEY);
            MutableComponent name = Component.Serializer.m_130701_((String)s);
            return name == null ? Component.m_237113_((String)s) : name;
        }
        return null;
    }

    public static ItemStack setTargetName(ItemStack stack, @Nullable Component name) {
        if (name == null) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                tag.m_128473_(TARGET_NAME_KEY);
            }
        } else {
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_(TARGET_NAME_KEY, Component.Serializer.m_130703_((Component)name.m_6881_().m_6270_(name.m_7383_().m_131144_(null).m_131142_(null).m_131138_(null))));
        }
        return stack;
    }
}

