/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item;

import com.legacy.rediscovered.registry.RediscoveredPoiTypes;
import com.legacy.rediscovered.registry.RediscoveredTriggers;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;

public class RubyEyeItem
extends BlockItem {
    public static final int TEXTURE_COUNT = 4;
    private static final String DIMENSION_KEY = "dimension";
    private static final String STRUCTURE_KEY = "structure";
    private static final String POS_KEY = "pos";
    private static final String TEXTURE_INDEX_KEY = "texture_index";

    public RubyEyeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = this.m_40576_(new BlockPlaceContext(context));
        if (!result.m_19077_()) {
            InteractionResult useResult = this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
            return useResult == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : useResult;
        }
        return result;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (stack.m_150930_((Item)this)) {
                    BlockPos pos;
                    if (RubyEyeItem.getStructure(stack) == null) {
                        RubyEyeItem.setStructure(stack, (ResourceKey<Structure>)BuiltinStructures.f_276588_);
                    }
                    if ((pos = RubyEyeItem.findAndStoreStructure(stack, serverLevel, player.m_20183_(), serverPlayer)) != null) {
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                }
            }
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotID, boolean isSelected) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if ((isSelected || serverPlayer.m_21206_() == stack) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (level.m_46467_() % 60L == 0L) {
                    RubyEyeItem.findAndStorePoi(stack, serverLevel, entity.m_20183_(), serverPlayer);
                }
            }
        }
    }

    @Nullable
    public static ResourceKey<Level> getStructureDimension(ItemStack stack) {
        String dimensionS;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(DIMENSION_KEY, 8) && ResourceLocation.m_135830_((String)(dimensionS = tag.m_128461_(DIMENSION_KEY)))) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionS));
        }
        return null;
    }

    public static void setStructureDimension(ItemStack stack, @Nullable ResourceKey<Level> dimension) {
        CompoundTag tag = stack.m_41784_();
        if (dimension == null) {
            tag.m_128473_(DIMENSION_KEY);
        } else {
            tag.m_128359_(DIMENSION_KEY, dimension.m_135782_().toString());
        }
    }

    @Nullable
    public static BlockPos findAndStoreStructure(ItemStack stack, ServerLevel level, BlockPos searchPos, ServerPlayer player) {
        Pair nearest;
        Optional holder;
        BlockPos poiPos = RubyEyeItem.findAndStorePoi(stack, level, searchPos, player);
        if (poiPos != null) {
            return poiPos;
        }
        ResourceKey<Structure> structure = RubyEyeItem.getStructure(stack);
        if (structure != null && (holder = level.m_9598_().m_175515_(Registries.f_256944_).m_203636_(structure)).isPresent() && (nearest = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)holder.get()}), searchPos, 100, false)) != null) {
            BlockPos pos = (BlockPos)nearest.getFirst();
            RubyEyeItem.setStructurePos(stack, pos);
            RubyEyeItem.setStructureDimension(stack, (ResourceKey<Level>)level.m_46472_());
            return pos;
        }
        return null;
    }

    @Nullable
    protected static BlockPos findAndStorePoi(ItemStack stack, ServerLevel level, BlockPos searchPos, ServerPlayer player) {
        Optional poiData = level.m_8904_().m_218002_(h -> ((PoiType)RediscoveredPoiTypes.GLOWING_OBSIDIAN.get()).equals(h.get()), searchPos, 48, PoiManager.Occupancy.ANY);
        if (poiData.isPresent()) {
            BlockPos pos = (BlockPos)((Pair)poiData.get()).getSecond();
            RubyEyeItem.setStructurePos(stack, pos);
            RubyEyeItem.setStructure(stack, (ResourceKey<Structure>)BuiltinStructures.f_276588_);
            RubyEyeItem.setStructureDimension(stack, (ResourceKey<Level>)level.m_46472_());
            RediscoveredTriggers.LOCATE_PORTAL.trigger(player);
            return pos;
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Structure> getStructure(ItemStack stack) {
        String structureS;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(STRUCTURE_KEY, 8) && ResourceLocation.m_135830_((String)(structureS = tag.m_128461_(STRUCTURE_KEY)))) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structureS));
        }
        return null;
    }

    public static void setStructure(ItemStack stack, @Nullable ResourceKey<Structure> structure) {
        CompoundTag tag = stack.m_41784_();
        if (structure == null) {
            tag.m_128473_(STRUCTURE_KEY);
        } else {
            tag.m_128359_(STRUCTURE_KEY, structure.m_135782_().toString());
        }
    }

    @Nullable
    public static BlockPos getStructurePos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(POS_KEY, 4)) {
            return BlockPos.m_122022_((long)tag.m_128454_(POS_KEY));
        }
        return null;
    }

    public static void setStructurePos(ItemStack stack, @Nullable BlockPos structurePos) {
        CompoundTag tag = stack.m_41784_();
        if (structurePos == null) {
            tag.m_128473_(POS_KEY);
        } else {
            tag.m_128356_(POS_KEY, structurePos.m_121878_());
        }
    }

    public static ItemStack setTextureIndex(ItemStack stack, int textureIndex) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128344_(TEXTURE_INDEX_KEY, (byte)textureIndex);
        return stack;
    }

    public static int getTextureIndex(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TEXTURE_INDEX_KEY, 1)) {
            return tag.m_128445_(TEXTURE_INDEX_KEY);
        }
        return -1;
    }
}

