/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legacy.rediscovered.item.util.RediscoveredArmorMaterial;
import com.legacy.rediscovered.registry.RediscoveredAttributes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import java.util.EnumMap;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RediscoveredArmorItem
extends ArmorItem {
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), p_266744_ -> {
        p_266744_.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        p_266744_.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        p_266744_.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        p_266744_.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    private final Multimap<Attribute, AttributeModifier> customModifiers;

    public RediscoveredArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.m_7167_(type.m_266308_()));
        UUID uuid = ARMOR_MODIFIER_UUID_PER_TYPE.get(this.m_266204_());
        if (material instanceof RediscoveredArmorMaterial) {
            RediscoveredArmorMaterial mat = (RediscoveredArmorMaterial)material;
            builder.put((Object)((Attribute)RediscoveredAttributes.EXPLOSION_RESISTANCE.get()), (Object)new AttributeModifier(uuid, "Armor explosion resistance", (double)mat.getExplosionResistance(), AttributeModifier.Operation.MULTIPLY_BASE));
            builder.put((Object)((Attribute)RediscoveredAttributes.FIRE_RESISTANCE.get()), (Object)new AttributeModifier(uuid, "Armor fire resistance", (double)mat.getFireResistance(), AttributeModifier.Operation.MULTIPLY_BASE));
        }
        this.customModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return this.m_266204_().m_266308_() == slot ? this.customModifiers : ImmutableMultimap.of();
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.m_150930_(RediscoveredItems.studded_boots) || super.canWalkOnPowderedSnow(stack, wearer);
    }

    public static class Dyeable
    extends RediscoveredArmorItem
    implements DyeableLeatherItem {
        public Dyeable(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
            super(material, type, properties);
        }
    }
}

