/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legacy.rediscovered.client.gui.QuiverMenu;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.item.util.QuiverData;
import com.legacy.rediscovered.item.util.QuiverTooltip;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class QuiverItem
extends ArmorItem
implements DyeableLeatherItem {
    public static final int DEFAULT_COLOR = 14444608;

    public QuiverItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        QuiverData quiverData = QuiverData.getOrCreate(stack);
        return Optional.of(new QuiverTooltip(quiverData, this.m_41121_(stack)));
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction click, Player player, SlotAccess access) {
        QuiverData quiver;
        if (click == ClickAction.SECONDARY && slot.m_150651_(player) && !other.m_41619_() && other.m_204117_(RediscoveredTags.Items.QUIVER_AMMO) && !(player.f_36096_ instanceof QuiverMenu) && (quiver = QuiverData.getOrCreate(stack)).add(other)) {
            this.playInsertSound((Entity)player);
            return true;
        }
        return false;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction click, Player player) {
        if (click == ClickAction.SECONDARY && slot.m_150651_(player) && !(player.f_36096_ instanceof QuiverMenu)) {
            QuiverData quiver = QuiverData.getOrCreate(stack);
            ItemStack other = slot.m_7993_();
            if (other.m_41619_()) {
                for (int i = 0; i < 5; ++i) {
                    ItemStack ammo = (ItemStack)quiver.getAmmo().get(i);
                    if (ammo.m_41619_()) continue;
                    this.playRemoveOneSound((Entity)player);
                    slot.m_5852_(ammo.m_41777_());
                    quiver.setAmmo(i, ItemStack.f_41583_);
                    return true;
                }
            } else if (other.m_204117_(RediscoveredTags.Items.QUIVER_AMMO) && quiver.add(other)) {
                this.playInsertSound((Entity)player);
                return true;
            }
        }
        return false;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            ItemStack stack = player.m_21120_(hand);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new QuiverMenu.Provider(stack, QuiverData.getOrCreate(stack)));
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pSlot) {
        return ImmutableMultimap.of();
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag displayTag = stack.m_41737_("display");
        return displayTag != null && displayTag.m_128425_("color", 99) ? displayTag.m_128451_("color") : 14444608;
    }

    public void m_142023_(ItemEntity itemEntity) {
        QuiverData.get(itemEntity.m_32055_()).ifPresent(quiverData -> ItemUtils.m_150952_((ItemEntity)itemEntity, (Stream)quiverData.getAmmo().stream()));
    }
}

