/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.event;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.capability.entity.DragonTPCapability;
import com.legacy.rediscovered.capability.entity.IDragonTPCapability;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.registry.RediscoveredTriggers;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public record SkyTransitionTeleporter(boolean atMax) implements ITeleporter
{
    public static final SkyTransitionTeleporter AT_TOP = new SkyTransitionTeleporter(true);
    public static final SkyTransitionTeleporter AT_BOTTOM = new SkyTransitionTeleporter(false);

    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        return new PortalInfo(new Vec3(entity.m_20185_(), this.atMax() ? (double)(destWorld.m_151558_() + 5) : (double)(destWorld.m_141937_() - 50), entity.m_20189_()), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public static boolean doTeleport(LivingEntity entity, ResourceKey<Level> dimension) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Entity vehicle = player.m_20202_();
            if (player.m_20202_() instanceof RedDragonOffspringEntity) {
                RediscoveredMod.LOGGER.debug("--- Red Dragon Sky Transition ({}) ---", (Object)player.m_7755_().getString());
                RedDragonOffspringEntity dragon = (RedDragonOffspringEntity)vehicle;
                boolean goingToSkylands = dimension == RediscoveredDimensions.skylandsKey();
                SkyTransitionTeleporter teleporter = goingToSkylands ? AT_BOTTOM : AT_TOP;
                ServerLevel destLevel = player.m_20194_().m_129880_(dimension);
                ChunkPos destChunk = new ChunkPos(player.m_20183_());
                destLevel.m_7726_().m_8387_(TicketType.f_9448_, destChunk, 2, (Object)dragon.m_19879_());
                ArrayList<Player> passengers = new ArrayList<Player>(2);
                for (Object passenger : dragon.m_20197_()) {
                    if (passenger instanceof Player) {
                        passengers.add((Player)passenger);
                    }
                    passenger.m_19877_();
                }
                dragon.m_19877_();
                ArrayList<ServerPlayer> teleportedPlayers = new ArrayList<ServerPlayer>(2);
                for (Player passengerPlayer : passengers) {
                    RediscoveredMod.LOGGER.debug(passengerPlayer.m_5446_().getString() + "'s Before: + " + player.m_20182_());
                    Entity entity2 = passengerPlayer.changeDimension(destLevel, (ITeleporter)teleporter);
                    RediscoveredMod.LOGGER.debug(entity2.m_5446_().getString() + "'s After: + " + entity2.m_20182_());
                    RediscoveredMod.LOGGER.debug("------------------");
                    if (!(entity2 instanceof ServerPlayer)) continue;
                    teleportedPlayers.add((ServerPlayer)entity2);
                }
                RediscoveredMod.LOGGER.debug("Dragon's Before: + " + dragon.m_20182_());
                Entity teleportedDragon = dragon.changeDimension(destLevel, teleporter);
                RediscoveredMod.LOGGER.debug("Dragon's After: + " + teleportedDragon.m_20182_());
                if (teleportedDragon instanceof RedDragonOffspringEntity) {
                    for (ServerPlayer serverPlayer : teleportedPlayers) {
                        IDragonTPCapability dragonTP = DragonTPCapability.get(serverPlayer);
                        if (dragonTP == null) continue;
                        dragonTP.setDragonUUID(teleportedDragon.m_20148_());
                        if (goingToSkylands) continue;
                        RediscoveredTriggers.DRAGON_TELEPORT.trigger(serverPlayer);
                    }
                }
                return true;
            }
            Vec3 motion = player.m_20184_();
            ServerLevel ow = player.m_20194_().m_129880_(Level.f_46428_);
            player.f_19802_ = 20;
            player.f_19862_ = false;
            player.m_8999_(ow, player.m_20185_(), (double)ow.m_151558_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
            player.f_19802_ = 20;
            player.f_19862_ = false;
            player.m_20256_(motion);
            player.f_19864_ = true;
            return true;
        }
        if (entity instanceof RedDragonOffspringEntity) {
            RedDragonOffspringEntity dragon = (RedDragonOffspringEntity)entity;
            if (!dragon.m_20160_() && dragon.m_9236_().m_46472_().equals(RediscoveredDimensions.skylandsKey())) {
                dragon.changeDimension(dragon.m_20194_().m_129880_(dimension), AT_TOP);
            }
            return true;
        }
        return false;
    }
}

