/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.event;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.block.ChairBlock;
import com.legacy.rediscovered.block.SpikeBlock;
import com.legacy.rediscovered.block.util.IShovelFlattenable;
import com.legacy.rediscovered.block.util.ITillable;
import com.legacy.rediscovered.capability.entity.DragonTPCapability;
import com.legacy.rediscovered.capability.entity.DragonTPCapabilityProvider;
import com.legacy.rediscovered.capability.entity.IDragonTPCapability;
import com.legacy.rediscovered.capability.entity.RainCapability;
import com.legacy.rediscovered.capability.entity.RainCapabilityProvider;
import com.legacy.rediscovered.capability.util.QuiverDataHolder;
import com.legacy.rediscovered.client.gui.QuiverMenu;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.ScarecrowEntity;
import com.legacy.rediscovered.entity.ZombiePigmanEntity;
import com.legacy.rediscovered.entity.ai.AvoidScarecrowGoal;
import com.legacy.rediscovered.entity.ai.TargetScarecrowGoal;
import com.legacy.rediscovered.entity.dragon.RedDragonOffspringEntity;
import com.legacy.rediscovered.entity.util.IPigman;
import com.legacy.rediscovered.event.SkyTransitionTeleporter;
import com.legacy.rediscovered.item.RubyFluteItem;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.legacy.rediscovered.item.util.QuiverData;
import com.legacy.rediscovered.registry.RediscoveredAttributes;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredDamageTypes;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.legacy.rediscovered.registry.RediscoveredEnchantments;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.registry.RediscoveredTriggers;
import com.legacy.structure_gel.api.events.LoadStructureTemplateEvent;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawAccessHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkHooks;

public class RediscoveredEvents {
    @SubscribeEvent
    public static void onCapabilityAttached(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        event.addCapability(RainCapability.RAIN_ID, (ICapabilityProvider)new RainCapabilityProvider());
        Object object = event.getObject();
        if (object instanceof Player && !((player = (Player)object) instanceof FakePlayer)) {
            event.addCapability(DragonTPCapability.DRAGON_TP_ID, (ICapabilityProvider)new DragonTPCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void anvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        if (QuiverData.canAttachQuiver(left) && !AttachedItem.hasAttached(left) && event.getRight().m_204117_(RediscoveredTags.Items.QUIVERS)) {
            ItemStack output = AttachedItem.attachItem(left.m_41777_(), event.getRight().m_41777_());
            if (!event.getName().isEmpty()) {
                output.m_41714_((Component)Component.m_237113_((String)event.getName()));
            }
            int c = 0;
            if (left.m_41788_()) {
                if (!Component.m_237113_((String)event.getName()).toString().equals(left.m_41786_().toString())) {
                    c = 1;
                }
            } else if (!event.getName().isEmpty()) {
                c = 1;
            }
            event.setOutput(output);
            event.setCost(3 + c);
        }
    }

    @SubscribeEvent
    public static void grindstonePlace(GrindstoneEvent.OnPlaceItem event) {
        ItemStack top = event.getTopItem();
        ItemStack bottom = event.getBottomItem();
        ItemStack quiverItem = null;
        if (bottom.m_41619_() && AttachedItem.hasAttached(top)) {
            quiverItem = top;
        } else if (top.m_41619_() && AttachedItem.hasAttached(bottom)) {
            quiverItem = bottom;
        }
        if (quiverItem != null) {
            event.setOutput(AttachedItem.removeAttachment(quiverItem.m_41777_()));
            event.setXp(0);
            return;
        }
        ItemStack fluteItem = null;
        if (bottom.m_41619_() && top.m_150930_(RediscoveredItems.ruby_flute) && RubyFluteItem.getTargetUUID(top) != null) {
            fluteItem = top;
        } else if (top.m_41619_() && bottom.m_150930_(RediscoveredItems.ruby_flute) && RubyFluteItem.getTargetUUID(bottom) != null) {
            fluteItem = bottom;
        }
        if (fluteItem != null) {
            event.setOutput(RubyFluteItem.setTarget(fluteItem.m_41777_(), null));
            event.setXp(0);
            return;
        }
    }

    @SubscribeEvent
    public static void grindstoneTake(GrindstoneEvent.OnTakeItem event) {
        ItemStack top = event.getTopItem();
        ItemStack bottom = event.getBottomItem();
        boolean wasTopSlot = true;
        ItemStack quiverItem = null;
        if (bottom.m_41619_() && AttachedItem.hasAttached(top)) {
            quiverItem = top;
        } else if (top.m_41619_() && AttachedItem.hasAttached(bottom)) {
            quiverItem = bottom;
            wasTopSlot = false;
        }
        if (quiverItem != null) {
            if (wasTopSlot) {
                event.setNewTopItem(AttachedItem.getOrCreate(top).get().getAttached().m_41777_());
            } else {
                event.setNewBottomItem(AttachedItem.getOrCreate(bottom).get().getAttached().m_41777_());
            }
            Player player = ForgeHooks.getCraftingPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                RediscoveredTriggers.REMOVE_QUIVER.trigger(player2);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_5776_() && entity.m_9236_().m_46472_() == RediscoveredDimensions.skylandsKey() && event.getSource() == entity.m_269291_().m_269341_() && entity.m_20186_() <= 10.0) {
            event.setCanceled(SkyTransitionTeleporter.doTeleport(entity, (ResourceKey<Level>)Level.f_46428_));
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        float fireDamageScaling;
        float explosionDamageScaling;
        float crimsonDamageScaling;
        float goldAuraDamageScaling;
        LivingEntity living;
        Entity entity;
        LivingEntity target = event.getEntity();
        DamageSource damageSource = event.getSource();
        if ((damageSource.m_269533_(RediscoveredTags.DamageTypes.IS_DEATHLY) || (entity = damageSource.m_7640_()) instanceof LivingEntity && (living = (LivingEntity)entity).m_6336_() == MobType.f_21641_) && (goldAuraDamageScaling = (float)RediscoveredEvents.getInvertAttribute(target, (Attribute)RediscoveredAttributes.UNDEAD_DAMAGE_SCALING.get())) != 1.0f) {
            event.setAmount(event.getAmount() * goldAuraDamageScaling);
        }
        if ((crimsonDamageScaling = (float)RediscoveredEvents.getInvertAttribute(target, (Attribute)RediscoveredAttributes.CRIMSON_VEIL_DAMAGE_SCALING.get())) != 1.0f) {
            event.setAmount(event.getAmount() * crimsonDamageScaling);
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268415_) && (explosionDamageScaling = (float)RediscoveredEvents.getInvertAttribute(target, (Attribute)RediscoveredAttributes.EXPLOSION_RESISTANCE.get())) != 1.0f) {
            event.setAmount(event.getAmount() * explosionDamageScaling);
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268745_) && (fireDamageScaling = (float)RediscoveredEvents.getInvertAttribute(target, (Attribute)RediscoveredAttributes.FIRE_RESISTANCE.get())) != 1.0f) {
            event.setAmount(event.getAmount() * fireDamageScaling);
        }
    }

    private static double getInvertAttribute(LivingEntity entity, Attribute attribute) {
        if (entity.m_21204_().m_22171_(attribute)) {
            double baseVal = entity.m_21172_(attribute);
            double val = entity.m_21133_(attribute);
            return baseVal - (val - baseVal);
        }
        return 1.0;
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        Level level = event.getEntity().m_9236_();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        if (level.m_46472_() == RediscoveredDimensions.skylandsKey() && state.m_204336_(BlockTags.f_13038_)) {
            event.setCancellationResult(InteractionResult.PASS);
            event.setCanceled(true);
        }
        if (RediscoveredEvents.shearDoublePlant(level, state, pos, itemStack, (Entity)player)) {
            event.setCanceled(true);
            player.m_21011_(event.getHand(), true);
            itemStack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(event.getHand()));
        }
    }

    public static boolean shearDoublePlant(Level level, BlockState state, BlockPos pos, ItemStack shears, @Nullable Entity actor) {
        if (state.m_60734_() instanceof DoublePlantBlock && shears.canPerformAction(ToolActions.SHEARS_HARVEST)) {
            ItemLike item = RediscoveredEvents.shearDoublePlant(level, state, pos, shears, actor, Blocks.f_50357_, RediscoveredBlocks.empty_rose_bush, (ItemLike)RediscoveredBlocks.rose);
            if (item == null) {
                item = RediscoveredEvents.shearDoublePlant(level, state, pos, shears, actor, Blocks.f_50358_, RediscoveredBlocks.empty_peony_bush, (ItemLike)RediscoveredBlocks.paeonia);
            }
            if (item != null) {
                ItemStack flowerStack = new ItemStack(item, level.m_213780_().m_188503_(3) + 1);
                ItemEntity itemEntity = new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), flowerStack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
                level.m_247517_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS);
                return true;
            }
        }
        return false;
    }

    private static ItemLike shearDoublePlant(Level level, BlockState state, BlockPos pos, ItemStack shears, @Nullable Entity actor, Block test, Block empty, ItemLike droppedItem) {
        if (state.m_60713_(test)) {
            if (actor instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)actor;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, shears);
            }
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)actor, (BlockState)level.m_8055_(pos)));
            int flags = 18;
            BlockState emptyState = empty.m_49966_();
            level.m_7731_(pos, IModifyState.mergeStates((BlockState)emptyState, (BlockState)state), flags);
            state = level.m_8055_(pos.m_7494_());
            if (state.m_60713_(test)) {
                level.m_7731_(pos.m_7494_(), IModifyState.mergeStates((BlockState)emptyState, (BlockState)state), flags);
            }
            if ((state = level.m_8055_(pos.m_7495_())).m_60713_(test)) {
                level.m_7731_(pos.m_7495_(), IModifyState.mergeStates((BlockState)emptyState, (BlockState)state), flags);
            }
            return droppedItem;
        }
        return null;
    }

    @SubscribeEvent
    public static void onToolAction(BlockEvent.BlockToolModificationEvent event) {
        BlockState state;
        Block block;
        if (event.getToolAction() == ToolActions.SHOVEL_FLATTEN) {
            BlockState state2 = event.getFinalState();
            Block block2 = state2.m_60734_();
            if (block2 instanceof IShovelFlattenable) {
                IShovelFlattenable flattenable = (IShovelFlattenable)block2;
                event.setFinalState(flattenable.getShovelFlattenedState(state2, (LevelReader)event.getLevel(), event.getPos()));
            }
        } else if (event.getToolAction() == ToolActions.HOE_TILL && (block = (state = event.getFinalState()).m_60734_()) instanceof ITillable) {
            ITillable tillable = (ITillable)block;
            event.setFinalState(tillable.getHoeTilledState(state, (LevelReader)event.getLevel(), event.getPos()));
        }
    }

    @SubscribeEvent
    public static void onJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        EntityType type = entity.m_6095_();
        if (!type.m_204039_(RediscoveredTags.Entities.IGNORES_SCARECROW) && entity instanceof PathfinderMob) {
            PathfinderMob pfMob = (PathfinderMob)entity;
            if (type.m_204039_(RediscoveredTags.Entities.TARGETS_SCARECROW)) {
                pfMob.f_21346_.m_25352_(2, new TargetScarecrowGoal<ScarecrowEntity>((Mob)pfMob, ScarecrowEntity.class, true));
            } else if (type.m_204039_(RediscoveredTags.Entities.FEARS_SCARECROW) || type.m_20674_() != MobCategory.MONSTER && pfMob.f_21345_.m_148105_().stream().filter(wrapped -> wrapped.m_26015_() instanceof PanicGoal).findAny().isPresent()) {
                pfMob.f_21345_.m_25352_(1, new AvoidScarecrowGoal<ScarecrowEntity>(pfMob, ScarecrowEntity.class, 8.0f, 1.0, 1.0));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityCheckSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Set<MobSpawnType> plateArmorTypes;
        Mob mob = event.getEntity();
        EntityType type = mob.m_6095_();
        ServerLevelAccessor level = event.getLevel();
        BlockPos pos = BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ());
        if (mob.m_217043_().m_188501_() < RediscoveredConfig.WORLD.zombieHorseSiegePercentage() && event.getSpawnType() == MobSpawnType.EVENT && level.m_45527_(pos) && type == EntityType.f_20501_) {
            ZombieHorse horse = (ZombieHorse)EntityType.f_20502_.m_20615_(mob.m_9236_());
            horse.m_30651_(true);
            horse.m_20359_((Entity)mob);
            level.m_7967_((Entity)horse);
            mob.m_7998_((Entity)horse, true);
        }
        if (event.getSpawnType() == MobSpawnType.STRUCTURE && type.m_204039_(RediscoveredTags.Entities.BECOMES_ZOMBIE_HORSE_IN_ZOMBIE_VILLAGE) && mob.m_217043_().m_188501_() < RediscoveredConfig.WORLD.zombieHorseVillagePercentage()) {
            Optional villageTag;
            StructureManager structureManager;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                v0 = sl.m_215010_();
            } else if (level instanceof WorldGenRegion) {
                WorldGenRegion wg = (WorldGenRegion)level;
                v0 = level.m_6018_().m_215010_().m_220468_(wg);
            } else {
                v0 = structureManager = null;
            }
            if (structureManager != null && (villageTag = level.m_9598_().m_175515_(Registries.f_256944_).m_203431_(StructureTags.f_215889_)).isPresent()) {
                for (Holder village : (HolderSet.Named)villageTag.get()) {
                    StructureStart start = structureManager.m_220494_(pos, (Structure)village.get());
                    if (!start.m_73603_()) continue;
                    int pieceCount = start.m_73602_().size();
                    int zombiePieces = 0;
                    for (StructurePiece piece : start.m_73602_()) {
                        try {
                            SinglePoolElement singleElement;
                            ResourceLocation name;
                            PoolElementStructurePiece poolElement;
                            StructurePoolElement element;
                            if (!(piece instanceof PoolElementStructurePiece) || !((element = (poolElement = (PoolElementStructurePiece)piece).m_209918_()) instanceof SinglePoolElement) || !(name = JigsawAccessHelper.getSingleJigsawPieceLocation((SinglePoolElement)(singleElement = (SinglePoolElement)element))).m_135815_().contains("zombie/")) continue;
                            ++zombiePieces;
                        }
                        catch (Exception exception) {}
                    }
                    if (pieceCount <= 0 || !((double)((float)zombiePieces / (float)pieceCount) >= 0.3)) continue;
                    ZombieHorse horse = (ZombieHorse)EntityType.f_20502_.m_20615_(mob.m_9236_());
                    horse.m_30651_(true);
                    horse.m_20359_((Entity)mob);
                    level.m_7967_((Entity)horse);
                    event.setSpawnCancelled(true);
                    break;
                }
            }
        }
        if (mob instanceof PathfinderMob) {
            PathfinderMob pfMob = (PathfinderMob)mob;
            if (mob instanceof Giant) {
                pfMob.m_146922_(Mth.m_14177_((float)(level.m_213780_().m_188501_() * 360.0f)));
                pfMob.f_20885_ = pfMob.m_146908_();
                pfMob.f_20883_ = pfMob.m_146908_();
                pfMob.m_21051_(Attributes.f_22281_).m_22100_(10.0);
                pfMob.m_21051_(Attributes.f_22278_).m_22100_(1.0);
                pfMob.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal(pfMob, 0.5, true){

                    protected double m_6639_(LivingEntity attackTarget) {
                        return 19.0;
                    }
                });
                pfMob.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal(pfMob, 0.5));
                pfMob.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)pfMob, Player.class, 8.0f));
                pfMob.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)pfMob));
                pfMob.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal(pfMob, new Class[0]));
                pfMob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)pfMob, Player.class, true));
            }
            if (type == EntityType.f_20531_ && event.getSpawnType() == MobSpawnType.NATURAL && level.m_213780_().m_188501_() < 0.2f && !mob.m_20159_()) {
                ZombiePigmanEntity pigman = (ZombiePigmanEntity)RediscoveredEntityTypes.ZOMBIE_PIGMAN.m_20615_(mob.m_9236_());
                pigman.m_20359_((Entity)mob);
                pigman.m_6518_(event.getLevel(), event.getDifficulty(), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
                mob.m_9236_().m_7967_((Entity)pigman);
                event.setSpawnCancelled(true);
                event.setCanceled(true);
            }
        }
        if ((plateArmorTypes = Set.of(MobSpawnType.NATURAL, MobSpawnType.CHUNK_GENERATION, MobSpawnType.SPAWN_EGG, MobSpawnType.SPAWNER)).contains(event.getSpawnType()) && mob.m_6095_().m_204039_(RediscoveredTags.Entities.PLATE_ARMOR_SPAWNS) && mob.m_217043_().m_188501_() < RediscoveredConfig.WORLD.taggedPlateArmorPercentage()) {
            ArrayList<Item> plateArmor = new ArrayList<Item>(level.m_9598_().m_175515_(Registries.f_256913_).m_203431_(RediscoveredTags.Items.PLATE_ARMOR).stream().flatMap(HolderSet::m_203614_).map(Holder::m_203334_).toList());
            for (int i = 2; i > 0 && !plateArmor.isEmpty(); --i) {
                ItemStack armor = ((Item)plateArmor.remove(mob.m_217043_().m_188503_(plateArmor.size()))).m_7968_();
                EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)armor);
                if (slot == null || !mob.m_6844_(slot).m_41619_()) continue;
                mob.m_8061_(slot, armor);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack attached;
        Optional<AttachedItem> attachedItem;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (stack.canApplyAtEnchantingTable(RediscoveredEnchantments.RAPID_SHOT) && stack.getEnchantmentLevel(RediscoveredEnchantments.RAPID_SHOT) > 0) {
            stack.m_41720_().m_5551_(stack, player.m_9236_(), (LivingEntity)player, 71989);
            player.m_21011_(event.getHand(), true);
            event.setCanceled(true);
        }
        if ((attachedItem = AttachedItem.get(stack)).isPresent() && (attached = attachedItem.get().getAttached()).m_204117_(RediscoveredTags.Items.QUIVERS) && player.m_36341_()) {
            QuiverData quiverData = QuiverData.getOrCreate(attached);
            quiverData.setAttachedItem(attachedItem.get());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new QuiverMenu.Provider(stack, quiverData));
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void getProjectile(LivingGetProjectileEvent event) {
        ItemStack weapon = event.getProjectileWeaponItemStack();
        if (weapon.m_204117_(RediscoveredTags.Items.QUIVER_USER)) {
            QuiverData data;
            ItemStack ammo;
            LivingEntity entity = event.getEntity();
            ItemStack originalArrow = event.getProjectileItemStack();
            if (!(originalArrow.m_41619_() || originalArrow != entity.m_21120_(InteractionHand.OFF_HAND) && originalArrow != entity.m_21120_(InteractionHand.MAIN_HAND))) {
                return;
            }
            Optional<QuiverData> quiverData = QuiverData.getFromChestplate(entity.m_6844_(EquipmentSlot.CHEST));
            if (quiverData.isPresent() && !(ammo = (data = quiverData.get()).getSelectedAmmo(weapon)).m_41619_()) {
                ((QuiverDataHolder)ammo).rediscovered$setQuiverData(data, weapon);
                event.setProjectileItemStack(ammo);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            Entity possibleDragon;
            UUID dragonUUID;
            IDragonTPCapability dragonTp;
            ServerPlayer sp = (ServerPlayer)player;
            if (player.f_19797_ % 100 == 0) {
                RediscoveredTriggers.IN_FARLANDS_TRIGGER.trigger(sp);
            }
            if (player.m_20202_() instanceof RedDragonOffspringEntity && player.m_20186_() > (double)(player.m_9236_().m_151558_() + 20) && player.m_9236_().m_46472_() == Level.f_46428_) {
                SkyTransitionTeleporter.doTeleport((LivingEntity)player, RediscoveredDimensions.skylandsKey());
            }
            if ((dragonTp = DragonTPCapability.get(player)) != null && (dragonUUID = dragonTp.getDragonUUID()) != null && (possibleDragon = sp.m_284548_().m_8791_(dragonUUID)) != null) {
                if (possibleDragon instanceof RedDragonOffspringEntity) {
                    RedDragonOffspringEntity dragon = (RedDragonOffspringEntity)possibleDragon;
                    sp.m_7998_((Entity)dragon, true);
                    dragon.setFlying(true);
                    dragon.dismountDelay = 50;
                }
                dragonTp.setDragonUUID(null);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        if (!player.m_36341_() && state.m_204336_(RediscoveredTags.Blocks.CHAIRS)) {
            if (event.getSide() == LogicalSide.CLIENT) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
            ChairBlock.tryInteract((LivingEntity)player, pos, event.getHand());
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Mob mob;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (entity instanceof IPigman && entity instanceof Mob && IPigman.zombify(mob = (Mob)entity, event.getSource())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource().m_276093_(RediscoveredDamageTypes.SPIKES.getKey()) && level instanceof ServerLevel) {
            SpikeBlock.tryAwardKillingAdvancement((ServerLevel)level, entity, event.getSource());
        }
    }

    public static BlockPos verifyRespawnCoordinates(Level par0World, BlockPos par1ChunkCoordinates, boolean par2, ServerPlayer player) {
        if (player.m_20194_().m_129880_(Level.f_46428_).m_8055_(par1ChunkCoordinates).m_60734_() instanceof BedBlock) {
            return par1ChunkCoordinates;
        }
        return null;
    }

    @SubscribeEvent
    public static void livingConversionPre(LivingConversionEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (RediscoveredAttributes.isConversionImmune(entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void livingConversionPost(LivingConversionEvent.Post event) {
        Mob mob;
        LivingEntity livingEntity;
        if (event.getEntity() instanceof Pig && (livingEntity = event.getOutcome()) instanceof Mob && (mob = (Mob)livingEntity).m_6095_() == EntityType.f_20531_) {
            ZombiePigmanEntity pigman = (ZombiePigmanEntity)mob.m_21406_(RediscoveredEntityTypes.ZOMBIE_PIGMAN, false);
            pigman.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            mob.m_9236_().m_7967_((Entity)pigman);
            mob.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onTemplateLoad(LoadStructureTemplateEvent event) {
        if (event.getId().equals((Object)new ResourceLocation("trail_ruins/roads/long_road_end"))) {
            for (int z = 1; z < event.getSize().m_123343_(); ++z) {
                event.setBlock(new BlockPos(0, 0, z), Blocks.f_50652_.m_49966_(), null);
                event.setBlock(new BlockPos(0, 1, z), Blocks.f_49994_.m_49966_(), null);
                event.setBlock(new BlockPos(0, 2, z), Blocks.f_49994_.m_49966_(), null);
            }
            event.setJigsaw((BlockState)Blocks.f_50678_.m_49966_().m_61124_((Property)JigsawBlock.f_54222_, (Comparable)FrontAndTop.WEST_UP), event.moveInBounds(new BlockPos(0, 1, 3)), jigsaw -> {
                jigsaw.m_222763_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)RediscoveredMod.locate("skylands_portal/trail_ruins/portal_room")));
                jigsaw.m_59435_(RediscoveredMod.locate("portal_room_connector"));
                jigsaw.m_59438_(RediscoveredMod.locate("portal_room"));
                jigsaw.m_59431_(Blocks.f_49994_.m_204297_().m_205785_().m_135782_().toString());
            });
        }
    }
}

