/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.util.animation;

import com.legacy.rediscovered.network.PacketHandler;
import com.legacy.rediscovered.network.s_to_c.UpdateAnimationPacket;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class AnimData {
    private static final float MAX = 6.0f;
    private final float increasePerTick;
    private final float decreasePerTick;
    private final boolean hasApex;
    private final int ticksBeforeReset;
    public final int id;
    private float animTicks;
    private float animTicksOld;
    private boolean shouldPlay;
    private boolean wasPlaying;
    private int apexTicks;
    private boolean serverControlledStops;
    private boolean resetWhenComplete;
    private boolean atApex;

    public AnimData(List<AnimData> anims, float increasePerTick, float decreasePerTick, boolean hasApex, int ticksBeforeReset) {
        this.increasePerTick = increasePerTick;
        this.decreasePerTick = decreasePerTick;
        this.hasApex = hasApex;
        this.ticksBeforeReset = ticksBeforeReset;
        this.id = anims.size();
        anims.add(this);
    }

    public AnimData(List<AnimData> anims, float increasePerTick, float decreasePerTick, boolean hasApex) {
        this(anims, increasePerTick, decreasePerTick, hasApex, 0);
    }

    public AnimData(List<AnimData> anims, float increasePerTick, boolean hasApex) {
        this(anims, increasePerTick, increasePerTick, hasApex);
    }

    public AnimData serverControlledStops() {
        this.serverControlledStops = true;
        return this;
    }

    public AnimData resetWhenComplete() {
        this.resetWhenComplete = true;
        return this;
    }

    public <T extends Entity> void tick(T entity) {
        Level level;
        this.animTicksOld = this.animTicks;
        this.animTicks = this.tickValue(this.animTicks);
        if (this.serverControlledStops && !entity.m_9236_().f_46443_ || !this.serverControlledStops) {
            this.atApex = false;
            if (this.atApex() && (!this.hasApex || this.ticksBeforeReset > 0 && this.apexTicks >= this.ticksBeforeReset)) {
                if (!this.resetWhenComplete) {
                    this.animTicks -= this.decreasePerTick;
                    this.atApex = true;
                    this.stop();
                } else {
                    this.cancel();
                }
            }
            this.apexTicks = this.atApex() && (this.ticksBeforeReset > 0 && this.apexTicks < this.ticksBeforeReset || this.ticksBeforeReset == 0) ? ++this.apexTicks : 0;
        }
        if (this.wasPlaying != this.shouldPlay && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!this.hasApex && this.shouldPlay || this.serverControlledStops || this.hasApex) {
                PacketHandler.sendToAllClients(new UpdateAnimationPacket(entity.m_19879_(), this.id, this.shouldPlay), (Level)sl);
            }
            this.wasPlaying = this.shouldPlay;
        }
    }

    private final float tickValue(float value) {
        value = Mth.m_14036_((float)(this.shouldPlay ? value + this.increasePerTick : value - this.decreasePerTick), (float)0.0f, (float)6.0f);
        return value;
    }

    public float getTicks() {
        return this.animTicks;
    }

    public float getLastTick() {
        return this.animTicksOld;
    }

    private float getAnimScale(float partialTicks) {
        float trans = Mth.m_14179_((float)partialTicks, (float)this.animTicksOld, (float)this.animTicks);
        return trans / 6.0f;
    }

    public float getValue(float partialTicks) {
        float f1 = this.getAnimScale(partialTicks);
        f1 *= f1;
        return f1;
    }

    public float getSpecialValue(float partialTicks, float range) {
        float f1 = this.getValue(partialTicks);
        float f2 = -1.5707964f + f1 * range;
        return 1.5707964f + f2;
    }

    public boolean atApex() {
        return this.animTicks > 0.0f && this.animTicks == this.animTicksOld || this.atApex;
    }

    public int getApexTicks() {
        return this.apexTicks;
    }

    public boolean isPlaying() {
        return this.shouldPlay;
    }

    public boolean wasPlaying() {
        return this.wasPlaying;
    }

    public boolean isActive() {
        return this.getTicks() > 0.0f || this.getLastTick() > 0.0f;
    }

    public boolean isStopping() {
        return this.isActive() && !this.isPlaying();
    }

    public boolean play() {
        return this.play(true);
    }

    public boolean play(boolean should) {
        boolean playing = this.isPlaying();
        this.shouldPlay = should;
        return playing != this.isPlaying();
    }

    public final void forcePlay(boolean play) {
        this.shouldPlay = play;
    }

    public void stop() {
        this.shouldPlay = false;
        this.apexTicks = 0;
    }

    public void cancel() {
        this.shouldPlay = false;
        this.animTicksOld = 0.0f;
        this.animTicks = 0.0f;
        this.apexTicks = 0;
    }
}

