/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.util;

import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class MountableBlockEntity
extends Entity {
    public MountableBlockEntity(EntityType<? extends MountableBlockEntity> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.f_19794_ = true;
    }

    public MountableBlockEntity(Level world, double x, double y, double z) {
        this(RediscoveredEntityTypes.MOUNTABLE_BLOCK, world);
        this.m_6034_(x, y, z);
    }

    public MountableBlockEntity(Level world, int i, int j, int k, float mountingX, float mountingY, float mountingZ) {
        this(RediscoveredEntityTypes.MOUNTABLE_BLOCK, world);
        this.m_6034_(mountingX, mountingY, mountingZ);
    }

    public MountableBlockEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(RediscoveredEntityTypes.MOUNTABLE_BLOCK, world);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return this.interactBasic((LivingEntity)player);
    }

    public InteractionResult interactBasic(LivingEntity entity) {
        if (this.m_20202_() != null && this.m_20202_() instanceof Player && this.m_20202_() != entity) {
            return InteractionResult.CONSUME;
        }
        if (!this.m_9236_().m_5776_()) {
            entity.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!(this.f_19797_ <= 10 || !this.m_20197_().isEmpty() && ((Entity)this.m_20197_().get(0)).m_6084_() && this.m_9236_().m_8055_(this.m_20183_()).m_204336_(RediscoveredTags.Blocks.CHAIRS))) {
            this.m_146870_();
        }
        double floorY = Math.ceil(this.m_20186_());
        if (this.m_20186_() != floorY) {
            this.m_6034_(this.m_20185_(), floorY, this.m_20189_());
        }
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        this.updateComparators(this.m_9236_(), this.m_20183_());
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        this.updateComparators(this.m_9236_(), this.m_20183_());
    }

    public void m_20153_() {
        super.m_20153_();
        this.updateComparators(this.m_9236_(), this.m_20183_());
    }

    private void updateComparators(Level level, BlockPos pos) {
        if (!level.f_46443_ && level.isAreaLoaded(pos, 16)) {
            level.m_46717_(pos, level.m_8055_(pos).m_60734_());
        }
    }

    public double m_6048_() {
        return super.m_6048_() - 0.5;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_19956_(Entity rider, Entity.MoveFunction pCallback) {
        super.m_19956_(rider, pCallback);
        this.clampRotation(rider);
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        for (Direction dir : List.of(pLivingEntity.m_6350_(), this.m_6350_(), this.m_6350_().m_122427_(), this.m_6350_().m_122428_(), this.m_6350_().m_122424_())) {
            BlockPos pos = this.m_20183_().m_121945_(dir);
            double d2 = this.m_9236_().m_45573_(pos);
            if (!DismountHelper.m_38439_((double)d2) || !this.m_9236_().m_45772_(new AABB(pos).m_82406_((double)0.1f))) continue;
            return Vec3.m_82539_((Vec3i)pos);
        }
        return super.m_7688_(pLivingEntity);
    }

    public void m_7340_(Entity pEntityToUpdate) {
        this.clampRotation(pEntityToUpdate);
    }

    protected void clampRotation(Entity pEntityToUpdate) {
        pEntityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(pEntityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        pEntityToUpdate.f_19859_ += f1 - f;
        if (pEntityToUpdate instanceof Player) {
            pEntityToUpdate.m_146922_(pEntityToUpdate.m_146908_() + f1 - f);
            pEntityToUpdate.m_5616_(pEntityToUpdate.m_146908_());
        } else {
            int maxHeadRot = 70;
            pEntityToUpdate.m_5616_(Mth.m_14036_((float)pEntityToUpdate.m_6080_(), (float)(this.m_146908_() - (float)maxHeadRot), (float)(this.m_146908_() + (float)maxHeadRot)));
            pEntityToUpdate.m_146922_(this.m_146908_());
        }
    }

    public void m_8097_() {
    }

    public void m_7378_(CompoundTag nbttagcompound) {
    }

    public void m_7380_(CompoundTag nbttagcompound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

