/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.util;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.entity.ZombiePigmanEntity;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.registry.RediscoveredAttributes;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;

public interface IPigman {
    public static final String ZOMBIFICATION_TIME_KEY = "ZombificationTime";
    public static final String ZOMBIFICATION_IMMUNE_KEY = "IsImmuneToZombification";
    public static final int NATURAL_CONVERSION_TIME = 300;

    public Type getPigmanType();

    public boolean isImmuneToZombification();

    default public boolean shouldConvert(Mob entity) {
        return !this.isImmuneToZombification() && !entity.m_21525_() && !RediscoveredAttributes.isConversionImmune((LivingEntity)entity) && (entity.m_9236_().m_6042_().f_63857_() || entity.m_21023_((MobEffect)RediscoveredEffects.CRIMSON_VEIL.get()));
    }

    public static boolean zombify(Mob killed, @Nullable DamageSource source) {
        Level level = killed.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (source != null && !(source.m_7639_() instanceof Zombie)) {
            return false;
        }
        if ((source == null || level2.m_46791_() == Difficulty.NORMAL || level2.m_46791_() == Difficulty.HARD) && killed instanceof IPigman) {
            IPigman pigman = (IPigman)killed;
            if (source == null || source != null && ForgeEventFactory.canLivingConvert((LivingEntity)killed, RediscoveredEntityTypes.ZOMBIE_PIGMAN, timer -> {})) {
                if (source != null && level2.m_46791_() != Difficulty.HARD && level2.m_213780_().m_188499_()) {
                    return false;
                }
                ZombiePigmanEntity zombie = (ZombiePigmanEntity)killed.m_21406_(RediscoveredEntityTypes.ZOMBIE_PIGMAN, true);
                if (zombie != null) {
                    RediscoveredMod.LOGGER.debug("Pigman zombified with type {} ({}) at {} in {}", (Object)pigman.getPigmanType().ordinal(), (Object)Type.get((byte)pigman.getPigmanType().ordinal()), (Object)killed.m_20183_(), (Object)killed.m_9236_().m_46472_());
                    zombie.setConversionType((byte)pigman.getPigmanType().ordinal());
                    zombie.m_6518_((ServerLevelAccessor)level2, level2.m_6436_(zombie.m_20183_()), MobSpawnType.CONVERSION, null, null);
                    zombie.m_21559_(killed.m_21526_());
                    zombie.m_6863_(killed.m_6162_());
                    if (killed instanceof PigmanEntity) {
                        PigmanEntity trader = (PigmanEntity)killed;
                        zombie.setPigmanData(trader.getPigmanData());
                        zombie.tradeOffers = trader.m_6616_().m_45388_();
                        zombie.traderXp = trader.m_7809_();
                        trader.releaseAllPois();
                    }
                    ForgeEventFactory.onLivingConvert((LivingEntity)killed, (LivingEntity)zombie);
                    if (!killed.m_20067_()) {
                        level2.m_5594_(null, killed.m_20183_(), RediscoveredSounds.ENTITY_PIGMAN_ZOMBIFY, SoundSource.HOSTILE, 2.0f, 1.0f);
                    }
                    zombie.m_21530_();
                    return true;
                }
            }
        }
        return false;
    }

    public static enum Type {
        UNASSIGNED,
        TRADER,
        MELEE,
        RANGED;


        public <P extends Mob> EntityType<P> getTypeResult() {
            return this == MELEE ? RediscoveredEntityTypes.MELEE_PIGMAN : (this == RANGED ? RediscoveredEntityTypes.RANGED_PIGMAN : RediscoveredEntityTypes.PIGMAN);
        }

        public SoundEvent getZombieTypeSelectSound() {
            return this == MELEE ? RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_SELECT_MELEE : (this == RANGED ? RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_SELECT_RANGED : SoundEvents.f_12019_);
        }

        public boolean isValidHandEquip(ItemStack stack) {
            if (this == MELEE) {
                return stack.m_204117_(ItemTags.f_271388_) || stack.m_204117_(ItemTags.f_271207_);
            }
            if (this == RANGED) {
                return stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem;
            }
            return false;
        }

        public boolean isValidOffHandEquip(ItemStack stack) {
            if (this == MELEE) {
                return stack.canPerformAction(ToolActions.SHIELD_BLOCK);
            }
            if (this == RANGED) {
                return stack.m_204117_(ItemTags.f_13161_) || stack.m_150930_(Items.f_42688_);
            }
            return false;
        }

        public static boolean isValidHandEquipForAny(ItemStack stack) {
            for (Type type : Type.values()) {
                if (!type.isValidHandEquip(stack)) continue;
                return true;
            }
            return false;
        }

        public static Type get(byte id) {
            for (Type type : Type.values()) {
                if (id != type.ordinal()) continue;
                return type;
            }
            return UNASSIGNED;
        }
    }
}

