/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.legacy.rediscovered.RediscoveredUtil;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.item.util.QuiverData;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredEnchantments;
import com.legacy.rediscovered.registry.RediscoveredItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class PigmanTrades {
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> METALWORKER_OFFERS = PigmanTrades.tradeMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)Items.f_42414_, 16).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 3).result(Items.f_42387_.m_7968_()).givenXP(6).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 2).result(Items.f_42384_.m_7968_()).givenXP(4).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42416_, 4).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(5).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)Items.f_42417_, 5).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(13).priceMultiplier(0.1f).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 4).result(Items.f_42386_.m_7968_()).givenXP(12).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 5).result(Items.f_42383_.m_7968_()).givenXP(15).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 2).result(Items.f_42385_.m_7968_()).givenXP(11).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 5).secondItem(Items.f_42446_.m_7968_()).result(Items.f_42448_.m_7968_()).givenXP(13).priceMultiplier(0.1f).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result(Items.f_42466_.m_7968_()).givenXP(10).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 3).result(Items.f_42467_.m_7968_()).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new EnchantedItemAtLevelTrade(13, 6, Items.f_42416_, Items.f_42383_, 3, 15, 8, 10), new EnchantedItemAtLevelTrade(15, 6, Items.f_42416_, Items.f_42385_, 3, 18, 8, 10), new EnchantedItemAtLevelTrade(13, 6, Items.f_42416_, Items.f_42386_, 3, 15, 8, 10), new EnchantedItemAtLevelTrade(9, 6, Items.f_42416_, Items.f_42384_, 3, 16, 8, 10), new Trade.Builder().firstItem((ItemLike)Items.f_42148_, 1).secondItem((ItemLike)RediscoveredItems.ruby, 8).result(Items.f_42146_.m_7968_()).givenXP(11).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result(Items.f_42464_.m_7968_()).givenXP(11).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 4).result(Items.f_42465_.m_7968_()).givenXP(11).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 3).result(RediscoveredItems.plate_helmet.m_7968_()).givenXP(13).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 5).result(RediscoveredItems.plate_boots.m_7968_()).givenXP(15).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 20).result(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44977_, 1))).givenXP(23).priceMultiplier(0.25f).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new EnchantedItemAtLevelTrade(15, 10, Items.f_42534_, RediscoveredItems.plate_leggings, 3, 17, 15, 8), new EnchantedItemAtLevelTrade(17, 10, Items.f_42534_, RediscoveredItems.plate_chestplate, 3, 18, 15, 8), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 25).result(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44986_, 1))).givenXP(27).priceMultiplier(0.25f).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 18).result(RediscoveredItems.dragon_armor.m_7968_()).givenXP(10).maxUses(3).build()}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> BOWYER_OFFERS = PigmanTrades.tradeMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)Items.f_42412_, 18).givenXP(2).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42484_, 20).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(5).priceMultiplier(0.2f).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 2).result(Items.f_42411_.m_7968_()).givenXP(12).maxUses(12).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 3).result(Items.f_42717_.m_7968_()).givenXP(13).maxUses(12).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42454_, 5).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(8).build(), new QuiverWithRandomArrowsTrade(6, 2, 64, 16, 52, 32, 3, 5, 15, false)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)RediscoveredItems.purple_arrow, 12).givenXP(6).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42714_, 16).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(10).priceMultiplier(0.3f).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42401_, 13).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(10).priceMultiplier(0.2f).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new EnchantedItemAtLevelTrade(12, 14, Items.f_42534_, Items.f_42411_, 3, 23, 15, 10), new EnchantedItemAtLevelTrade(14, 10, Items.f_42534_, Items.f_42717_, 3, 24, 15, 10), new QuiverWithRandomArrowsTrade(12, 4, 128, 16, 52, 64, 5, 5, 17, true)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)Items.f_42735_, 1).result((ItemLike)RediscoveredItems.ruby, 16).givenXP(20).maxUses(1).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 16).result(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(RediscoveredEnchantments.RAPID_SHOT, 1))).givenXP(23).priceMultiplier(0.2f).build()}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> TECHNICIAN_OFFERS = PigmanTrades.tradeMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)RediscoveredBlocks.gear, 8).givenXP(5).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42451_, 32).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(3).priceMultiplier(0.4f).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Items.f_42416_, 4).result((ItemLike)RediscoveredBlocks.spikes, 8).givenXP(12).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)Blocks.f_50039_, 3).givenXP(12).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42416_, 4).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(10).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Items.f_41978_, 4).result((ItemLike)Items.f_42451_, 4).givenXP(12).maxUses(24).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42692_, 12).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(10).priceMultiplier(0.1f).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 2).secondItem((ItemLike)Items.f_42451_, 12).result((ItemLike)Blocks.f_50146_, 6).givenXP(12).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Items.f_42451_, 2).result((ItemLike)Blocks.f_50061_, 2).givenXP(18).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Items.f_42692_, 2).result((ItemLike)RediscoveredBlocks.rotational_converter, 2).givenXP(18).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42525_, 24).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(15).priceMultiplier(0.3f).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)Items.f_42518_, 2).givenXP(30).maxUses(10).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 30).result(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44985_, 1))).givenXP(23).priceMultiplier(0.4f).build()}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> TAILOR_OFFERS = PigmanTrades.tradeMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)Blocks.f_50041_, 8).givenXP(5).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42401_, 18).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(3).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Blocks.f_50041_, 8).result((ItemLike)Items.f_42401_, 32).givenXP(12).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 2).result(Items.f_42574_.m_7968_()).givenXP(12).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Blocks.f_50041_, 8).result((ItemLike)RediscoveredBlocks.spring_green_wool, 8).givenXP(14).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Blocks.f_50041_, 8).result((ItemLike)RediscoveredBlocks.bright_green_wool, 8).givenXP(14).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Blocks.f_50041_, 8).result((ItemLike)RediscoveredBlocks.lavender_wool, 8).givenXP(14).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Blocks.f_50041_, 8).result((ItemLike)RediscoveredBlocks.rose_wool, 8).givenXP(14).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 7).result((ItemLike)RediscoveredItems.studded_boots, 1).givenXP(22).priceMultiplier(0.15f).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 10).result((ItemLike)RediscoveredItems.studded_leggings, 1).givenXP(22).priceMultiplier(0.15f).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Blocks.f_50041_, 8).result((ItemLike)RediscoveredBlocks.sky_blue_wool, 8).givenXP(14).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).secondItem((ItemLike)Blocks.f_50041_, 8).result((ItemLike)RediscoveredBlocks.slate_blue_wool, 8).givenXP(14).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 12).result((ItemLike)RediscoveredItems.studded_chestplate, 1).givenXP(22).priceMultiplier(0.15f).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 8).result((ItemLike)RediscoveredItems.studded_helmet, 1).givenXP(22).priceMultiplier(0.15f).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new EnchantedItemAtLevelTrade(10, 9, Items.f_42534_, RediscoveredItems.studded_boots, 3, 23, 16, 10), new EnchantedItemAtLevelTrade(13, 9, Items.f_42534_, RediscoveredItems.studded_leggings, 3, 23, 16, 10), new EnchantedItemAtLevelTrade(15, 9, Items.f_42534_, RediscoveredItems.studded_chestplate, 3, 23, 16, 10), new EnchantedItemAtLevelTrade(11, 9, Items.f_42534_, RediscoveredItems.studded_helmet, 3, 23, 16, 10), new RandomTaggedItemTrade(2, 0, new ItemStack((ItemLike)Items.f_42499_, 16), (TagKey<Item>)ItemTags.f_13145_, RediscoveredTags.Items.TAILOR_UNSELLABLE_FLOWERS, 6, 16, 10)}));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> DOCTOR_OFFERS = PigmanTrades.tradeMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)Items.f_42619_, 12).givenXP(5).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42588_, 20).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(3).priceMultiplier(0.25f).build()}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 1).result((ItemLike)Blocks.f_50072_, 4).givenXP(12).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42591_, 26).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(13).priceMultiplier(0.3f).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42417_, 3).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(15).build()}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)Blocks.f_49992_, 32).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(10).priceMultiplier(0.4f).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 2).result((ItemLike)Items.f_42501_, 18).givenXP(12).build()}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 2).secondItem((ItemLike)Items.f_42403_, 8).result(PotionUtils.m_43549_((ItemStack)Items.f_42736_.m_7968_(), (Potion)Potions.f_43593_)).givenXP(12).maxUses(24).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42586_, 3).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(26).build(), new Trade.Builder().firstItem((ItemLike)Items.f_42585_, 16).result((ItemLike)RediscoveredItems.ruby, 1).givenXP(22).priceMultiplier(0.1f).build()}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 3).result((ItemLike)Items.f_42677_, 3).givenXP(30).build(), new Trade.Builder().firstItem((ItemLike)RediscoveredItems.ruby, 8).result(PotionUtils.m_43549_((ItemStack)Items.f_42589_.m_7968_(), (Potion)((Potion)RediscoveredEffects.GOLDEN_AURA_POTION.get()))).maxUses(6).givenXP(30).build()}));

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> tradeMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> tradeListIn) {
        return new Int2ObjectOpenHashMap(tradeListIn);
    }

    private static DyeItem getRandomDye(RandomSource pRandom) {
        return DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)pRandom.m_188503_(16)));
    }

    public record Trade(ItemStack itemGiven1, ItemStack itemGiven2, ItemStack itemSold, int maxUses, int givenXP, float priceMultiplier) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_213663_(@Nullable Entity trader, @Nullable RandomSource rand) {
            MerchantOffer offer = this.itemGiven2.m_41619_() ? new MerchantOffer(this.itemGiven1, this.itemSold, this.maxUses, this.givenXP, this.priceMultiplier) : new MerchantOffer(this.itemGiven1, this.itemGiven2, this.itemSold, this.maxUses, this.givenXP, this.priceMultiplier);
            return offer;
        }

        public static class Builder {
            private ItemStack itemGiven1 = Items.f_42405_.m_7968_();
            private ItemStack itemGiven2 = ItemStack.f_41583_;
            private ItemStack itemSold = Items.f_42406_.m_7968_();
            private int maxUses = 16;
            private int givenXP = 3;
            private float priceMultiplier = 0.05f;

            public Builder firstItem(ItemLike item, int count) {
                return this.firstItem(new ItemStack(item, count));
            }

            public Builder secondItem(ItemLike item, int count) {
                return this.secondItem(new ItemStack(item, count));
            }

            public Builder result(ItemLike item, int count) {
                return this.result(new ItemStack(item, count));
            }

            public Builder firstItem(ItemStack stack) {
                this.itemGiven1 = stack;
                return this;
            }

            public Builder secondItem(ItemStack stack) {
                this.itemGiven2 = stack;
                return this;
            }

            public Builder result(ItemStack stack) {
                this.itemSold = stack;
                return this;
            }

            public Builder maxUses(int maxUses) {
                this.maxUses = maxUses;
                return this;
            }

            public Builder givenXP(int givenXp) {
                this.givenXP = givenXp;
                return this;
            }

            public Builder priceMultiplier(float priceMultiplier) {
                this.priceMultiplier = priceMultiplier;
                return this;
            }

            public Trade build() {
                return new Trade(this.itemGiven1, this.itemGiven2, this.itemSold, this.maxUses, this.givenXP, this.priceMultiplier);
            }
        }
    }

    record EnchantedItemAtLevelTrade(int rubyCount, int rubyVariance, @Nullable Item toolMaterial, Item toolItem, int maxUses, int xpValue, int enchantLevel, int enchantVariance) implements VillagerTrades.ItemListing
    {
        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ItemStack itemstack = new ItemStack((ItemLike)this.toolItem);
            if (itemstack.m_41720_() instanceof DyeableLeatherItem) {
                ArrayList list = Lists.newArrayList();
                list.add(PigmanTrades.getRandomDye(rand));
                if (rand.m_188501_() > 0.7f) {
                    list.add(PigmanTrades.getRandomDye(rand));
                }
                if (rand.m_188501_() > 0.8f) {
                    list.add(PigmanTrades.getRandomDye(rand));
                }
                itemstack = DyeableLeatherItem.m_41118_((ItemStack)itemstack, (List)list);
            }
            if (this.enchantLevel > 0) {
                EnchantmentHelper.m_220292_((RandomSource)rand, (ItemStack)itemstack, (int)(this.enchantLevel + rand.m_188503_(this.enchantVariance)), (boolean)false);
            }
            return this.toolMaterial != null ? new MerchantOffer(new ItemStack((ItemLike)RediscoveredItems.ruby, this.rubyCount + rand.m_188503_(this.rubyVariance)), new ItemStack((ItemLike)this.toolMaterial), itemstack, this.maxUses, this.xpValue, 0.2f) : new MerchantOffer(new ItemStack((ItemLike)RediscoveredItems.ruby, this.rubyCount + rand.m_188503_(this.rubyVariance)), itemstack, this.maxUses, this.xpValue, 0.3f);
        }
    }

    record QuiverWithRandomArrowsTrade(int rubyCost, int rubyVariance, int arrowBudget, int arrowMinumum, int arrowMaximum, int maxStickCost, int minumumArrowStacks, int maxUses, int xpValue, boolean dye) implements VillagerTrades.ItemListing
    {
        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ItemStack stack = RediscoveredItems.quiver.m_7968_();
            if (this.dye && stack.m_41720_() instanceof DyeableLeatherItem) {
                ArrayList list = Lists.newArrayList();
                list.add(PigmanTrades.getRandomDye(rand));
                if (rand.m_188501_() > 0.7f) {
                    list.add(PigmanTrades.getRandomDye(rand));
                }
                if (rand.m_188501_() > 0.8f) {
                    list.add(PigmanTrades.getRandomDye(rand));
                }
                stack = DyeableLeatherItem.m_41118_((ItemStack)stack, (List)list);
            }
            QuiverData quiver = QuiverData.getOrCreate(stack);
            int stickCount = 128;
            int arrowTypeCount = this.minumumArrowStacks;
            if (arrowTypeCount < 5) {
                arrowTypeCount += rand.m_188503_(5 - this.minumumArrowStacks + 1);
            }
            NonNullList contents = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
            Set<Item> immuneArrows = Set.of(Items.f_42412_, Items.f_42738_, RediscoveredItems.purple_arrow);
            HashSet<Item> usedArrows = new HashSet<Item>();
            List<Item> arrowTypes = BuiltInRegistries.f_257033_.m_123024_().filter(i -> i != Items.f_42412_ && i != RediscoveredItems.purple_arrow && QuiverData.isAmmo(i.m_7968_(), Items.f_42411_.m_7968_())).toList();
            ArrayList<Potion> usedPotions = new ArrayList<Potion>();
            for (int i2 = 0; i2 < arrowTypeCount; ++i2) {
                int split;
                Item arrow = i2 == 0 ? Items.f_42412_ : (i2 == 1 ? RediscoveredItems.purple_arrow : arrowTypes.get(rand.m_188503_(arrowTypes.size())));
                int attempts = 0;
                while (usedArrows.contains(arrow) || arrow.m_204114_().m_203656_(RediscoveredTags.Items.BOWYER_UNSELLABLE_ARROWS)) {
                    if (attempts++ == 20) {
                        arrow = Items.f_42412_;
                        break;
                    }
                    arrow = arrowTypes.get(rand.m_188503_(arrowTypes.size()));
                }
                if (!immuneArrows.contains(arrow)) {
                    usedArrows.add(arrow);
                }
                if ((split = (int)Math.min((double)(this.arrowMaximum + rand.m_188503_(5)), Math.max((double)(this.arrowMinumum + rand.m_188503_(5)), rand.m_188500_() * (double)stickCount))) <= 0) continue;
                stickCount -= split;
                ItemStack arrowStack = new ItemStack((ItemLike)arrow, split);
                if (arrow == Items.f_42738_) {
                    List list = BuiltInRegistries.f_256980_.m_123024_().filter(potion -> !potion.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)potion) && !usedPotions.contains(potion)).collect(Collectors.toList());
                    Potion potion2 = (Potion)list.get(rand.m_188503_(list.size()));
                    arrowStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)arrow, split), (Potion)potion2);
                    usedPotions.add(potion2);
                }
                contents.set(i2, (Object)arrowStack);
            }
            quiver.injectData((NonNullList<ItemStack>)contents);
            return new MerchantOffer(new ItemStack((ItemLike)RediscoveredItems.ruby, this.rubyCost + rand.m_188503_(this.rubyVariance)), new ItemStack((ItemLike)Items.f_42398_, this.maxStickCost / 2 + rand.m_188503_(this.maxStickCost / 2)), stack, this.maxUses, this.xpValue, 0.2f);
        }
    }

    record RandomTaggedItemTrade(int rubyCount, int rubyVariance, @Nullable ItemStack secondItem, TagKey<Item> tag, @Nullable TagKey<Item> exclusions, int itemCount, int maxUses, int xpValue) implements VillagerTrades.ItemListing
    {
        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            if (trader == null) {
                return null;
            }
            ItemStack result = null;
            Optional<Holder<Item>> item = RediscoveredUtil.getRandom(Registries.f_256913_, this.tag, trader.m_9236_().m_9598_(), rand);
            if (this.exclusions != null) {
                item = item.filter(i -> !i.m_203656_(this.exclusions));
            }
            if (item.isPresent()) {
                result = new ItemStack((ItemLike)item.get().m_203334_(), this.itemCount);
            }
            if (result == null || result.m_41619_()) {
                return null;
            }
            Trade.Builder trade = new Trade.Builder().maxUses(this.maxUses).givenXP(this.xpValue).firstItem(new ItemStack((ItemLike)RediscoveredItems.ruby, this.rubyCount + (this.rubyVariance > 1 ? rand.m_188503_(this.rubyVariance) : 0))).result(result);
            if (this.secondItem != null && !this.secondItem.m_41619_()) {
                trade.secondItem(this.secondItem);
            }
            return trade.build().m_213663_(trader, rand);
        }
    }

    record DyedItemTrade(Item item, int rubyCost, int maxUses, int givenXp) implements VillagerTrades.ItemListing
    {
        @Nullable
        public MerchantOffer m_213663_(Entity trader, RandomSource rand) {
            ItemStack stack = this.item.m_7968_();
            if (stack.m_41720_() instanceof DyeableLeatherItem) {
                ArrayList list = Lists.newArrayList();
                list.add(PigmanTrades.getRandomDye(rand));
                if (rand.m_188501_() > 0.7f) {
                    list.add(PigmanTrades.getRandomDye(rand));
                }
                if (rand.m_188501_() > 0.8f) {
                    list.add(PigmanTrades.getRandomDye(rand));
                }
                stack = DyeableLeatherItem.m_41118_((ItemStack)stack, (List)list);
            }
            return new Trade.Builder().maxUses(this.maxUses).givenXP(this.givenXp).firstItem(new ItemStack((ItemLike)RediscoveredItems.ruby, this.rubyCost)).result(stack).build().m_213663_(trader, rand);
        }
    }
}

