/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman.data;

import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.pigman.data.PigmanTrades;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraftforge.common.IExtensibleEnum;

public class PigmanData {
    public static final Predicate<Holder<PoiType>> ALL_ACQUIRABLE_JOBS = holder -> holder.m_203656_(RediscoveredTags.Poi.APPLICABLE_PIGMAN_WORKSTATION);
    private static final int[] NEXT_LEVEL_XP_THRESHOLDS = new int[]{0, 10, 70, 150, 250};
    public static final Codec<PigmanData> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.STRING.fieldOf("profession").orElseGet(() -> Profession.NONE.profName).forGetter(data -> data.profession.profName), (App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(data -> data.level)).apply((Applicative)codec, PigmanData::new));
    private final Profession profession;
    private final int level;

    public PigmanData(Profession profession, int level) {
        this.profession = profession;
        this.level = Math.max(1, level);
    }

    public PigmanData(String professionName, int level) {
        this(Profession.fromName(professionName), level);
    }

    public Profession getProfession() {
        return this.profession;
    }

    public int getLevel() {
        return this.level;
    }

    public PigmanData setProfession(Profession profession) {
        return new PigmanData(profession, this.level);
    }

    public PigmanData setLevel(int level) {
        return new PigmanData(this.profession, level);
    }

    public static int getMinXpPerLevel(int level) {
        return PigmanData.canLevelUp(level) ? NEXT_LEVEL_XP_THRESHOLDS[level - 1] : 0;
    }

    public static int getMaxXpPerLevel(int level) {
        return PigmanData.canLevelUp(level) ? NEXT_LEVEL_XP_THRESHOLDS[level] : 0;
    }

    public static boolean canLevelUp(int level) {
        return level >= 1 && level < 5;
    }

    public static enum Profession implements IExtensibleEnum
    {
        NONE("none", PoiType.f_218034_, ALL_ACQUIRABLE_JOBS, null, null, true, false),
        METALWORKER("metalworker", (ResourceKey<PoiType>)PoiTypes.f_218058_, PigmanTrades.METALWORKER_OFFERS, RediscoveredSounds.ENTITY_PIGMAN_WORK_METALWORKER, true, true),
        BOWYER("bowyer", (ResourceKey<PoiType>)PoiTypes.f_218053_, PigmanTrades.BOWYER_OFFERS, RediscoveredSounds.ENTITY_PIGMAN_WORK_BOWYER, false, false),
        TECHNICIAN("technician", (ResourceKey<PoiType>)PoiTypes.f_218055_, PigmanTrades.TECHNICIAN_OFFERS, RediscoveredSounds.ENTITY_PIGMAN_WORK_TECHNICIAN, false, false),
        TAILOR("tailor", (ResourceKey<PoiType>)PoiTypes.f_218057_, PigmanTrades.TAILOR_OFFERS, RediscoveredSounds.ENTITY_PIGMAN_WORK_TAILOR, false, false),
        DOCTOR("doctor", (ResourceKey<PoiType>)PoiTypes.f_218050_, PigmanTrades.DOCTOR_OFFERS, RediscoveredSounds.ENTITY_PIGMAN_WORK_DOCTOR, false, false);

        public final String profName;
        public final Predicate<Holder<PoiType>> jobSite;
        public final Predicate<Holder<PoiType>> usableJobSites;
        public final Int2ObjectMap<VillagerTrades.ItemListing[]> trades;
        @Nullable
        public final SoundEvent workSound;
        public final boolean renderZombiePigmanLoincloth;
        public final boolean renderLevelOnJacket;

        private Profession(String name, Predicate<Holder<PoiType>> jobSite, @Nullable Predicate<Holder<PoiType>> usableJobSites, Int2ObjectMap<VillagerTrades.ItemListing[]> trades, SoundEvent workSound, boolean renderZombiePigmanLoincloth, boolean renderLevelOnJacket) {
            this.profName = name;
            this.jobSite = jobSite;
            this.usableJobSites = usableJobSites;
            this.trades = trades;
            this.workSound = workSound;
            this.renderZombiePigmanLoincloth = renderZombiePigmanLoincloth;
            this.renderLevelOnJacket = renderLevelOnJacket;
        }

        private Profession(String name, @Nullable ResourceKey<PoiType> jobSite, Int2ObjectMap<VillagerTrades.ItemListing[]> trades, SoundEvent workSound, boolean renderZombiePigmanLoincloth, boolean renderLevelOnJacket) {
            this(name, h -> h.m_203565_(jobSite), h -> h.m_203565_(jobSite), trades, workSound, renderZombiePigmanLoincloth, renderLevelOnJacket);
        }

        public static Profession create(String name, String profName, Predicate<Holder<PoiType>> jobSite, Predicate<Holder<PoiType>> usableJobSites, Int2ObjectMap<VillagerTrades.ItemListing[]> trades, @Nullable SoundEvent workSound, boolean renderZombiePigmanLoincloth, boolean renderLevelOnJacket) {
            throw new IllegalStateException("Enum not extended");
        }

        public static Profession fromName(String name) {
            for (Profession type : Profession.values()) {
                if (!name.equals(type.profName)) continue;
                return type;
            }
            return NONE;
        }

        public Schedule getSchedule() {
            return Schedule.f_38015_;
        }
    }
}

