/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman.ai;

import com.legacy.rediscovered.block.ChairBlock;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.ai.SearchForPoiGoal;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.entity.pigman.data.PigmanData;
import com.legacy.rediscovered.entity.util.MountableBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredAttributes;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredPoiTypes;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PigmanGoals {
    protected static final float distanceTo(Entity entity, BlockPos pos) {
        return Mth.m_14116_((float)((float)entity.m_20238_(Vec3.m_82512_((Vec3i)pos))));
    }

    public static class DoctorDrinkAuraPotionGoal<T extends PigmanEntity>
    extends UseItemGoal<T> {
        public DoctorDrinkAuraPotionGoal(T mob) {
            super(mob, PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)RediscoveredEffects.GOLDEN_AURA_POTION.get())), RediscoveredSounds.ENTITY_PIGMAN_IDLE, DoctorDrinkAuraPotionGoal::getPredicate);
        }

        private static final <P extends PigmanEntity> boolean getPredicate(P pigman) {
            return pigman.getPigmanData().getProfession() == PigmanData.Profession.DOCTOR && pigman.getConvertTime() > 0 && !pigman.m_21023_((MobEffect)RediscoveredEffects.GOLDEN_AURA.get());
        }
    }

    private static abstract class AvoidPoiGoal
    extends SearchForPoiGoal<PigmanEntity> {
        private final int escapeDistance;

        public AvoidPoiGoal(PigmanEntity mob, ResourceKey<PoiType> poi, int radius, int checkDelay, int escapeDistance) {
            super(mob, (T e) -> mob.m_20183_(), poi, radius, checkDelay);
            this.escapeDistance = escapeDistance;
        }

        @Override
        public void onPoiFound(BlockPos pos) {
            ((PigmanEntity)this.mob).sitTimer = 0;
            ((PigmanEntity)this.mob).m_5496_(RediscoveredSounds.ENTITY_PIGMAN_SCARED, 1.0f, 0.7f);
        }

        @Override
        public void tickFound(BlockPos pos) {
            ServerLevel sl;
            Level level;
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)((PathfinderMob)this.mob), (int)16, (int)7, (Vec3)Vec3.m_82512_((Vec3i)pos));
            if (vec3 == null) {
                return;
            }
            if (((PigmanEntity)this.mob).m_21573_().m_26571_()) {
                ((PigmanEntity)this.mob).m_21573_().m_26519_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), (double)0.7f);
            }
            if (this.distanceTo() > (float)this.escapeDistance || (level = ((PigmanEntity)this.mob).m_9236_()) instanceof ServerLevel && !(sl = (ServerLevel)level).m_8904_().m_27091_(pos, this.poi)) {
                this.finish();
            }
        }
    }

    public static class AcquireJobSiteGoal<T extends PigmanEntity>
    extends Goal {
        private static final int TIMEOUT = 60;
        T mob;
        int noPathTimeout;
        PigmanData.Profession profession;

        public AcquireJobSiteGoal(T mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !this.mob.m_6162_() && ((PigmanEntity)this.mob).possibleJobSite != null;
        }

        public boolean m_8045_() {
            ServerLevel sl;
            Level level;
            GlobalPos site = ((PigmanEntity)this.mob).possibleJobSite;
            return site != null && this.profession != null && this.profession != PigmanData.Profession.NONE && (level = this.mob.m_9236_()) instanceof ServerLevel && (sl = (ServerLevel)level).m_46472_().equals((Object)site.m_122640_()) && sl.m_8904_().m_27091_(site.m_122646_(), p -> p.m_203656_(RediscoveredTags.Poi.APPLICABLE_PIGMAN_WORKSTATION)) && this.noPathTimeout > 0;
        }

        public void m_8056_() {
            ServerLevel sl;
            Optional type;
            this.noPathTimeout = 60;
            BlockPos pos = ((PigmanEntity)this.mob).possibleJobSite.m_122646_();
            Level level = this.mob.m_9236_();
            if (level instanceof ServerLevel && (type = (sl = (ServerLevel)level).m_8904_().m_27177_(pos)).isPresent()) {
                for (PigmanData.Profession prof : PigmanData.Profession.values()) {
                    if (!prof.jobSite.test((Holder<PoiType>)((Holder)type.get()))) continue;
                    sl.m_8904_().m_217946_(prof.usableJobSites, (poi, blockpos) -> blockpos.equals((Object)pos), pos, 1);
                    ((PigmanEntity)this.mob).possibleJobSite = GlobalPos.m_122643_((ResourceKey)sl.m_46472_(), (BlockPos)pos);
                    this.profession = prof;
                    this.yieldJob(50.0);
                    break;
                }
            }
        }

        public void m_8037_() {
            if (((PigmanEntity)this.mob).possibleJobSite == null || this.profession == null || this.profession == PigmanData.Profession.NONE) {
                return;
            }
            BlockPos pos = ((PigmanEntity)this.mob).possibleJobSite.m_122646_();
            Vec3 vec = Vec3.m_82512_((Vec3i)pos);
            this.mob.m_21563_().m_24964_(vec);
            if (this.mob.m_21573_().m_26571_()) {
                ((PigmanEntity)this.mob).setMovingToRemembered(true);
                Path path = this.mob.m_21573_().m_26524_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1);
                if (path != null) {
                    this.mob.m_21573_().m_26536_(path, 0.5);
                }
            }
            if (PigmanGoals.distanceTo(this.mob, pos) <= 2.0f && this.profession != null) {
                ((PigmanEntity)this.mob).setPigmanData(((PigmanEntity)this.mob).getPigmanData().setProfession(this.profession));
                ((PigmanEntity)this.mob).jobSite = ((PigmanEntity)this.mob).possibleJobSite;
                ((PigmanEntity)this.mob).possibleJobSite = null;
                this.mob.m_9236_().m_7605_(this.mob, (byte)14);
                this.mob.m_21573_().m_26573_();
            }
            if (!this.mob.m_21691_()) {
                --this.noPathTimeout;
            } else if (!this.mob.m_21573_().m_26577_()) {
                this.noPathTimeout = 60;
            }
        }

        public void m_8041_() {
            ((PigmanEntity)this.mob).releasePossibleJobSite();
        }

        private void yieldJob(double range) {
            ServerLevel sl;
            Optional poi;
            Level level = this.mob.m_9236_();
            if (level instanceof ServerLevel && (poi = (sl = (ServerLevel)level).m_8904_().m_27177_(((PigmanEntity)this.mob).possibleJobSite.m_122646_())).isPresent()) {
                sl.m_45933_(this.mob, new AABB(this.mob.m_20183_()).m_82400_(range)).stream().filter(p_258898_ -> p_258898_ instanceof PigmanEntity && p_258898_ != this.mob).map(p_258896_ -> (PigmanEntity)p_258896_).filter(LivingEntity::m_6084_).filter(newPigman -> {
                    BlockPos p = ((PigmanEntity)this.mob).possibleJobSite.m_122646_();
                    return AcquireJobSiteGoal.nearbyWantsJobsite((Holder<PoiType>)((Holder)poi.get()), newPigman, p) && PigmanGoals.distanceTo((Entity)newPigman, p) < PigmanGoals.distanceTo(this.mob, p);
                }).findFirst().ifPresent(newPigman -> {
                    this.mob.m_21573_().m_26573_();
                    newPigman.possibleJobSite = ((PigmanEntity)this.mob).possibleJobSite;
                    ((PigmanEntity)this.mob).possibleJobSite = null;
                });
            }
        }

        private static boolean nearbyWantsJobsite(Holder<PoiType> pPoi, PigmanEntity pigman, BlockPos pPos) {
            boolean hasJob;
            boolean bl = hasJob = pigman.possibleJobSite != null || pigman.jobSite != null;
            if (hasJob) {
                return false;
            }
            PigmanData.Profession villagerprofession = pigman.getPigmanData().getProfession();
            return villagerprofession.usableJobSites.test(pPoi);
        }
    }

    public static class SearchForJobGoal<T extends PigmanEntity>
    extends SearchForPoiGoal<T> {
        PigmanData.Profession profession;

        public SearchForJobGoal(T mob) {
            super(mob, Entity::m_20183_, (Holder<PoiType> poi) -> mob.getPigmanData().getProfession().usableJobSites.test((Holder<PoiType>)poi), 50, 100, 0);
        }

        @Override
        public boolean m_8036_() {
            return !((PigmanEntity)this.mob).m_6162_() && ((PigmanEntity)this.mob).jobSite == null && ((PigmanEntity)this.mob).possibleJobSite == null && (((PigmanEntity)this.mob).f_19797_ <= 40 || ((PigmanEntity)this.mob).getCurrentActivity() == Activity.f_37980_) && super.m_8036_();
        }

        @Override
        public void onPoiFound(BlockPos pos) {
            ((PigmanEntity)this.mob).possibleJobSite = GlobalPos.m_122643_((ResourceKey)((PigmanEntity)this.mob).m_9236_().m_46472_(), (BlockPos)pos);
            this.finish();
        }

        @Override
        public void tickFound(BlockPos pos) {
        }

        @Override
        protected PoiManager.Occupancy getOccupancyType() {
            return PoiManager.Occupancy.HAS_SPACE;
        }
    }

    public static class SearchForHomeGoal<T extends PigmanEntity>
    extends SearchForPoiGoal<T> {
        public SearchForHomeGoal(T mob) {
            super(mob, Entity::m_20183_, (ResourceKey<PoiType>)PoiTypes.f_218060_, 50, 100);
        }

        @Override
        public boolean m_8036_() {
            return ((PigmanEntity)this.mob).homePos == null && super.m_8036_();
        }

        @Override
        public void onPoiFound(BlockPos pos) {
            Level level = ((PigmanEntity)this.mob).m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.m_8904_().m_217946_(this.poi, (poi, blockpos) -> blockpos.equals((Object)pos), pos, 1);
                ((PigmanEntity)this.mob).homePos = GlobalPos.m_122643_((ResourceKey)sl.m_46472_(), (BlockPos)pos);
                sl.m_7605_((Entity)this.mob, (byte)14);
            }
            this.finish();
        }

        @Override
        protected PoiManager.Occupancy getOccupancyType() {
            return PoiManager.Occupancy.HAS_SPACE;
        }
    }

    public static class SearchForMeetingPointGoal<T extends PigmanEntity>
    extends SearchForPoiGoal<T> {
        public SearchForMeetingPointGoal(T mob) {
            super(mob, e -> !e.originFoundNaturally && e.villageOrigin != null ? e.villageOrigin.m_122646_() : e.m_20183_(), (ResourceKey<PoiType>)PoiTypes.f_218061_, 60, 200);
        }

        @Override
        public boolean m_8036_() {
            return !((PigmanEntity)this.mob).originFoundNaturally && super.m_8036_();
        }

        @Override
        public void onPoiFound(BlockPos pos) {
            Level level = ((PigmanEntity)this.mob).m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.m_8904_().m_217946_(this.poi, (poi, blockpos) -> blockpos.equals((Object)pos), pos, 1);
                ((PigmanEntity)this.mob).originFoundNaturally = true;
                ((PigmanEntity)this.mob).villageOrigin = GlobalPos.m_122643_((ResourceKey)sl.m_46472_(), (BlockPos)pos);
            }
            this.finish();
        }
    }

    public static class FindAndSitInChairGoal<T extends PigmanEntity>
    extends SearchForPoiGoal<T> {
        public FindAndSitInChairGoal(T mob) {
            super(mob, Entity::m_20183_, (ResourceKey<PoiType>)RediscoveredPoiTypes.CHAIR.getKey(), 15, 600, 1200);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean m_8036_() {
            if (((PigmanEntity)this.mob).m_20202_() != null) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_();
        }

        @Override
        public void onPoiFound(BlockPos pos) {
            ((PigmanEntity)this.mob).m_21573_().m_26573_();
        }

        @Override
        public void tickFound(BlockPos pos) {
            ((PigmanEntity)this.mob).m_21563_().m_24964_(Vec3.m_82512_((Vec3i)pos));
            if (((PigmanEntity)this.mob).m_21573_().m_26571_()) {
                ((PigmanEntity)this.mob).m_21573_().m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.5);
            }
            if (this.distanceTo() <= 2.0f) {
                ((PigmanEntity)this.mob).m_21573_().m_26573_();
                if (ChairBlock.tryInteract((LivingEntity)this.mob, this.foundPos, null)) {
                    ((PigmanEntity)this.mob).sitTimer = 600 + ((PigmanEntity)this.mob).m_217043_().m_188503_(1200);
                }
                this.finish();
            }
        }

        @Override
        public void onPoiNotFound() {
            this.resetDelay();
            this.currentDelay /= 2;
        }

        @Override
        public Predicate<PoiRecord> poiFilter() {
            return record -> ChairBlock.canMount(((PigmanEntity)this.mob).m_9236_(), record.m_27257_(), false);
        }
    }

    public static class AvoidNetherPortalGoal
    extends AvoidPoiGoal {
        public AvoidNetherPortalGoal(PigmanEntity mob) {
            super(mob, (ResourceKey<PoiType>)PoiTypes.f_218064_, 10, 100, 10);
            this.setMovementFlags();
        }
    }

    public static class AvoidNetherReactorGoal
    extends AvoidPoiGoal {
        public AvoidNetherReactorGoal(PigmanEntity mob) {
            super(mob, (ResourceKey<PoiType>)RediscoveredPoiTypes.NETHER_REACTOR_CORE.getKey(), 50, 200, 50);
            this.setMovementFlags();
        }

        @Override
        public boolean m_8036_() {
            return !((PigmanEntity)this.mob).isImmuneToZombification() && (super.m_8036_() || ((PigmanEntity)this.mob).m_21023_((MobEffect)RediscoveredEffects.CRIMSON_VEIL.get())) && !RediscoveredAttributes.isConversionImmune((LivingEntity)this.mob);
        }

        @Override
        public boolean m_8045_() {
            return !((PigmanEntity)this.mob).isImmuneToZombification() && !RediscoveredAttributes.isConversionImmune((LivingEntity)this.mob) && super.m_8045_();
        }
    }

    public static class StrollWithVillageBiasGoal
    extends WaterAvoidingRandomStrollGoal {
        private final PigmanEntity pigman;

        public StrollWithVillageBiasGoal(PigmanEntity mob) {
            super((PathfinderMob)mob, 0.5, 0.01f);
            this.pigman = mob;
        }

        public boolean m_8036_() {
            if (this.pigman.m_20202_() instanceof MountableBlockEntity) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.pigman.m_20202_() instanceof MountableBlockEntity) {
                return false;
            }
            return super.m_8045_();
        }

        protected Vec3 m_7037_() {
            SectionPos sectionpos;
            SectionPos sectionpos1;
            ServerLevel sl;
            PathfinderMob mob;
            int verticalDist;
            int horizontalDist;
            block3: {
                block2: {
                    horizontalDist = 10;
                    verticalDist = 7;
                    mob = this.f_25725_;
                    Level level = mob.m_9236_();
                    if (!(level instanceof ServerLevel)) break block2;
                    sl = (ServerLevel)level;
                    if (this.pigman.homePos != null && !(this.f_25725_.m_217043_().m_188501_() < 0.3f)) break block3;
                }
                return super.m_7037_();
            }
            BlockPos blockpos = mob.m_20183_();
            Vec3 vec3 = sl.m_8802_(blockpos) ? LandRandomPos.m_148488_((PathfinderMob)mob, (int)horizontalDist, (int)verticalDist) : ((sectionpos1 = BehaviorUtils.m_22581_((ServerLevel)sl, (SectionPos)(sectionpos = SectionPos.m_123199_((BlockPos)blockpos)), (int)2)) != sectionpos ? DefaultRandomPos.m_148412_((PathfinderMob)mob, (int)horizontalDist, (int)verticalDist, (Vec3)Vec3.m_82539_((Vec3i)sectionpos1.m_123250_()), (double)1.5707963705062866) : LandRandomPos.m_148488_((PathfinderMob)mob, (int)horizontalDist, (int)verticalDist));
            return vec3;
        }
    }

    public static class TradeWithPlayerOffGroundGoal
    extends TradeWithPlayerGoal {
        private final AbstractVillager mob;

        public TradeWithPlayerOffGroundGoal(AbstractVillager villager) {
            super(villager);
            this.mob = villager;
        }

        public boolean m_8036_() {
            if (!this.mob.m_6084_() || this.mob.m_20069_() || this.mob.f_19864_) {
                return false;
            }
            Player player = this.mob.m_7962_();
            if (player == null) {
                return false;
            }
            if (this.mob.m_20280_((Entity)player) > 16.0) {
                return false;
            }
            return player.f_36096_ != null;
        }
    }
}

