/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman.ai;

import com.legacy.rediscovered.entity.pigman.GuardPigmanEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class PigmanFollowNearestPlayerGoal
extends Goal {
    private final GuardPigmanEntity pigman;
    @Nullable
    private LivingEntity nearestPlayer;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public PigmanFollowNearestPlayerGoal(GuardPigmanEntity pigman, double pSpeedModifier, float pStartDistance, float stopDistance) {
        this.pigman = pigman;
        this.speedModifier = pSpeedModifier;
        this.navigation = pigman.m_21573_();
        this.startDistance = pStartDistance;
        this.stopDistance = stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.pigman.isDismissedUnsafely() || this.pigman.safetySeenTimer > 0) {
            this.nearestPlayer = null;
            return false;
        }
        Player livingentity = this.pigman.m_9236_().m_5788_(this.pigman.m_20185_(), this.pigman.m_20186_(), this.pigman.m_20189_(), 20.0, EntitySelector.f_20406_.and(EntitySelector.f_20403_));
        if (livingentity == null || livingentity.m_5833_() || this.unableToMove() || this.pigman.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.nearestPlayer = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_() || this.unableToMove() || this.pigman.safetySeenTimer > 0) {
            return false;
        }
        return !(this.pigman.m_20280_((Entity)this.nearestPlayer) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.pigman.m_20159_() || this.pigman.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.pigman.m_21439_(BlockPathTypes.WATER);
        this.pigman.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.nearestPlayer = null;
        this.navigation.m_26573_();
        this.pigman.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.pigman.m_21563_().m_24960_((Entity)this.nearestPlayer, 10.0f, (float)this.pigman.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            this.navigation.m_5624_((Entity)this.nearestPlayer, this.speedModifier);
        }
    }
}

