/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman;

import com.legacy.rediscovered.entity.pigman.GuardPigmanEntity;
import com.legacy.rediscovered.entity.pigman.ai.PigmanCrossbowAttackGoal;
import com.legacy.rediscovered.entity.util.IPigman;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.legacy.rediscovered.registry.RediscoveredItems;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeHooks;

public class RangedPigmanEntity
extends GuardPigmanEntity
implements RangedAttackMob,
CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> CHARGING_CROSSBOW = SynchedEntityData.m_135353_(RangedPigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RangedPigmanEntity(EntityType<? extends RangedPigmanEntity> type, Level world) {
        super(type, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING_CROSSBOW, (Object)false);
    }

    @Override
    public void registerAdditionalGoals() {
        this.f_21345_.m_25352_(2, (Goal)new RangedBowAttackGoal((Mob)this, 0.65, 20, 15.0f));
        this.f_21345_.m_25352_(2, new PigmanCrossbowAttackGoal<RangedPigmanEntity>(this, 1.0, 8.0f));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        if (random.m_188499_()) {
            this.m_8061_(EquipmentSlot.HEAD, RediscoveredItems.plate_helmet.m_7968_());
            this.m_8061_(EquipmentSlot.CHEST, AttachedItem.attachItem(RediscoveredItems.plate_chestplate.m_7968_(), RediscoveredItems.quiver.m_7968_()));
        } else {
            this.m_8061_(EquipmentSlot.HEAD, RediscoveredItems.studded_helmet.m_7968_());
            this.m_8061_(EquipmentSlot.CHEST, RediscoveredItems.quiver.m_7968_());
        }
        this.m_8061_(EquipmentSlot.MAINHAND, random.m_188501_() < 0.4f ? Items.f_42717_.m_7968_() : Items.f_42411_.m_7968_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return GuardPigmanEntity.createBasePigmanAttributes().m_22268_(Attributes.f_22276_, 20.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    public boolean m_7327_(Entity entity) {
        return super.m_7327_(entity);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean charging) {
        this.f_19804_.m_135381_(CHARGING_CROSSBOW, (Object)charging);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Override
    public boolean m_8023_() {
        return true;
    }

    @Override
    public GuardPigmanEntity.PigmanArmPose getArmPose() {
        if (this.m_21093_(is -> is.m_41720_() instanceof BowItem) && this.m_5912_()) {
            return GuardPigmanEntity.PigmanArmPose.BOW_AND_ARROW;
        }
        if (this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            return this.isChargingCrossbow() ? GuardPigmanEntity.PigmanArmPose.CROSSBOW_CHARGE : GuardPigmanEntity.PigmanArmPose.CROSSBOW_HOLD;
        }
        return GuardPigmanEntity.PigmanArmPose.NEUTRAL;
    }

    @Override
    public IPigman.Type getPigmanType() {
        return IPigman.Type.RANGED;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            this.m_32336_((LivingEntity)this, 1.6f);
            return;
        }
        ItemStack shotStack = this.m_6298_(this.m_21205_());
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)shotStack, (float)distanceFactor);
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - arrow.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
        if (this.isPlayerCured()) {
            this.m_21205_().m_41622_(1, (LivingEntity)this, e -> {});
            shotStack.m_41774_(1);
        }
    }

    public void m_5811_(LivingEntity pTarget, ItemStack pCrossbowStack, Projectile pProjectile, float pProjectileAngle) {
        this.m_32322_((LivingEntity)this, pTarget, pProjectile, pProjectileAngle, 1.6f);
    }

    public ItemStack m_6298_(ItemStack weapon) {
        ItemStack offhand = this.m_6844_(EquipmentSlot.OFFHAND);
        return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)weapon, (ItemStack)(offhand.m_204117_(ItemTags.f_13161_) || weapon.m_41720_() instanceof CrossbowItem && offhand.m_150930_(Items.f_42688_) ? offhand : RediscoveredItems.purple_arrow.m_7968_()));
    }
}

