/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.pigman.ai.PigmanGoals;
import com.legacy.rediscovered.entity.pigman.data.PigmanData;
import com.legacy.rediscovered.entity.util.IPigman;
import com.legacy.rediscovered.entity.util.IPigmanDataHolder;
import com.legacy.rediscovered.entity.util.MountableBlockEntity;
import com.legacy.rediscovered.registry.RediscoveredDataSerialization;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.Logger;

public class PigmanEntity
extends AbstractVillager
implements IPigman,
IPigmanDataHolder {
    protected static final EntityDataAccessor<PigmanData> PIGMAN_DATA = SynchedEntityData.m_135353_(PigmanEntity.class, RediscoveredDataSerialization.PIGMAN_DATA);
    protected static final EntityDataAccessor<Boolean> IMMUNE_TO_ZOMBIFICATION = SynchedEntityData.m_135353_(PigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ZOMBIFICATION_TIME = SynchedEntityData.m_135353_(PigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final Set<UUID> curedUuids = new HashSet<UUID>();
    private int xp;
    private int timeUntilReset;
    private int numberOfRestocksToday;
    private long lastRestockGameTime;
    private long lastRestockCheckDayTime;
    private boolean customer;
    private boolean movingToRemembered;
    @Nullable
    public GlobalPos homePos;
    @Nullable
    public GlobalPos villageOrigin;
    @Nullable
    public GlobalPos jobSite;
    @Nullable
    public GlobalPos possibleJobSite;
    public boolean originFoundNaturally;
    public boolean jobSiteLocated;
    public int sitTimer;
    private static final String HOME_POS_KEY = "HomePosition";
    private static final String VILLAGE_ORIGIN_KEY = "VillageOrigin";
    private static final String JOB_SITE_KEY = "JobSite";
    private static final String POSSIBLE_JOB_SITE_KEY = "PossibleJobSite";
    private static final String CURED_UUIDS = "CuredUUIDs";

    public PigmanEntity(EntityType<? extends PigmanEntity> type, Level world) {
        super(type, world);
        PathNavigation pathNavigation = this.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation p = (GroundPathNavigation)pathNavigation;
            p.m_26477_(true);
            p.m_7008_(true);
            p.m_255224_(false);
        }
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -5.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level){

            protected PathFinder m_5532_(int maxNodes) {
                this.f_26508_ = new PigmanWalkNodeEvaluator();
                this.f_26508_.m_77351_(true);
                this.f_26508_.m_254850_(false);
                return new PathFinder(this.f_26508_, maxNodes){

                    protected float m_214208_(Node start, Node end) {
                        return PigmanEntity.this.movingToRemembered ? 0.0f : start.m_230613_(end);
                    }
                };
            }
        };
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(1, (Goal)new PigmanGoals.TradeWithPlayerOffGroundGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new GoToBedGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new GoToMeetingGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new GoToWorkGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(8, (Goal)new PigmanGoals.StrollWithVillageBiasGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(7, new PigmanGoals.FindAndSitInChairGoal<PigmanEntity>(this));
        this.f_21345_.m_25352_(3, (Goal)new PigmanGoals.AvoidNetherReactorGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PigmanGoals.AvoidNetherPortalGoal(this));
        this.f_21345_.m_25352_(0, new PigmanGoals.SearchForHomeGoal<PigmanEntity>(this));
        this.f_21345_.m_25352_(0, new PigmanGoals.SearchForMeetingPointGoal<PigmanEntity>(this));
        this.f_21345_.m_25352_(1, new PigmanGoals.SearchForJobGoal<PigmanEntity>(this));
        this.f_21345_.m_25352_(1, new PigmanGoals.AcquireJobSiteGoal<PigmanEntity>(this));
        this.f_21345_.m_25352_(0, new PigmanGoals.DoctorDrinkAuraPotionGoal<PigmanEntity>(this));
        this.addAvoidGoals(0.6f, 0.8f);
    }

    public void addAvoidGoals(float farSpeed, float closeSpeed) {
        this.f_21346_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, ZombifiedPiglin.class, 8.0f, (double)farSpeed, (double)closeSpeed));
        this.f_21346_.m_25352_(1, new AvoidAndAlertGuardsGoal<Zombie>((PathfinderMob)this, Zombie.class, e -> !(e instanceof ZombifiedPiglin), 8.0f, farSpeed, closeSpeed));
    }

    public boolean m_21444_(BlockPos pos) {
        return super.m_21444_(pos);
    }

    protected void m_30232_() {
        super.m_30232_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? 0.85f : 1.8f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PIGMAN_DATA, (Object)new PigmanData(PigmanData.Profession.NONE, 1));
        this.f_19804_.m_135372_(IMMUNE_TO_ZOMBIFICATION, (Object)false);
        this.f_19804_.m_135372_(ZOMBIFICATION_TIME, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, SpawnGroupData pSpawnData, CompoundTag pDataTag) {
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        PigmanData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getPigmanData()).resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(data -> compound.m_128365_("PigmanData", data));
        compound.m_128405_("Xp", this.xp);
        compound.m_128356_("LastRestock", this.lastRestockGameTime);
        compound.m_128405_("RestocksToday", this.numberOfRestocksToday);
        if (this.homePos != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.homePos).resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(data -> compound.m_128365_(HOME_POS_KEY, data));
        }
        if (this.villageOrigin != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.villageOrigin).resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(data -> compound.m_128365_(VILLAGE_ORIGIN_KEY, data));
        }
        if (this.jobSite != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.jobSite).resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(data -> compound.m_128365_(JOB_SITE_KEY, data));
        }
        if (this.possibleJobSite != null) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.possibleJobSite).resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(data -> compound.m_128365_(POSSIBLE_JOB_SITE_KEY, data));
        }
        compound.m_128379_("OriginFoundNaturally", this.originFoundNaturally);
        compound.m_128405_("ZombificationTime", this.getConvertTime());
        compound.m_128379_("IsImmuneToZombification", this.isImmuneToZombification());
        compound.m_128405_("SittingTime", this.sitTimer);
        if (!this.curedUuids.isEmpty()) {
            ListTag victorsTag = new ListTag();
            this.curedUuids.forEach(victor -> victorsTag.add((Object)NbtUtils.m_129226_((UUID)victor)));
            compound.m_128365_(CURED_UUIDS, (Tag)victorsTag);
        }
    }

    public void m_7378_(CompoundTag compound) {
        DataResult dataresult;
        super.m_7378_(compound);
        if (compound.m_128425_("PigmanData", 10)) {
            dataresult = PigmanData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("PigmanData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(this::setPigmanData);
        }
        if (compound.m_128425_("Offers", 10)) {
            this.f_35261_ = new MerchantOffers(compound.m_128469_("Offers"));
        }
        if (compound.m_128425_("Xp", 3)) {
            this.xp = compound.m_128451_("Xp");
        }
        this.lastRestockGameTime = compound.m_128454_("LastRestock");
        this.numberOfRestocksToday = compound.m_128451_("RestocksToday");
        if (compound.m_128425_(HOME_POS_KEY, 10)) {
            dataresult = GlobalPos.f_122633_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_(HOME_POS_KEY)));
            dataresult.resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(r -> {
                this.homePos = r;
            });
        }
        if (compound.m_128425_(VILLAGE_ORIGIN_KEY, 10)) {
            dataresult = GlobalPos.f_122633_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_(VILLAGE_ORIGIN_KEY)));
            dataresult.resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(r -> {
                this.villageOrigin = r;
            });
        }
        if (compound.m_128425_(JOB_SITE_KEY, 10)) {
            dataresult = GlobalPos.f_122633_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_(JOB_SITE_KEY)));
            dataresult.resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(r -> {
                this.jobSite = r;
            });
        }
        if (compound.m_128425_(POSSIBLE_JOB_SITE_KEY, 10)) {
            dataresult = GlobalPos.f_122633_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_(POSSIBLE_JOB_SITE_KEY)));
            dataresult.resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(r -> {
                this.possibleJobSite = r;
            });
        }
        this.originFoundNaturally = compound.m_128471_("OriginFoundNaturally");
        this.setConvertTime(compound.m_128451_("ZombificationTime"));
        this.setImmuneToZombification(compound.m_128471_("IsImmuneToZombification"));
        this.sitTimer = compound.m_128451_("SittingTime");
        if (compound.m_128425_(CURED_UUIDS, 9)) {
            compound.m_128437_(CURED_UUIDS, 11).forEach(t -> this.curedUuids.add(NbtUtils.m_129233_((Tag)t)));
        }
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        return super.m_5610_(pos, reader);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46468_() % 6000L == 0L && this.m_9236_().m_46461_() && this.shouldRestock()) {
            SoundEvent workSound = this.getPigmanData().getProfession().workSound;
            if (workSound != null) {
                this.m_216990_(workSound);
            }
            this.restock();
        }
    }

    protected void m_8024_() {
        Level level;
        if (this.f_21344_.m_26571_()) {
            this.setMovingToRemembered(false);
        }
        if (!this.m_35306_() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.customer) {
                    this.levelUp();
                    this.customer = false;
                }
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
            }
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!(this.homePos == null || this.m_9236_().m_46472_().equals((Object)this.homePos.m_122640_()) && sl.m_8904_().m_217874_(PoiTypes.f_218060_, this.homePos.m_122646_()))) {
                this.releaseHome();
                this.m_9236_().m_7605_((Entity)this, (byte)13);
            }
            if (!(this.villageOrigin == null || sl.m_46472_().equals((Object)this.villageOrigin.m_122640_()) && sl.m_8904_().m_217874_(PoiTypes.f_218061_, this.villageOrigin.m_122646_()))) {
                this.releaseOrigin();
                this.villageOrigin = null;
                this.originFoundNaturally = false;
            }
            PigmanData data = this.getPigmanData();
            if (!(this.jobSite == null || !this.m_6162_() && sl.m_46472_().equals((Object)this.jobSite.m_122640_()) && sl.m_8904_().m_27091_(this.jobSite.m_122646_(), p -> p.m_203656_(RediscoveredTags.Poi.APPLICABLE_PIGMAN_WORKSTATION)))) {
                this.releaseJobSite();
                this.jobSite = null;
            }
            if (data != null && this.m_7809_() <= 0 && data.getLevel() <= 1 && data.getProfession() != PigmanData.Profession.NONE && this.jobSite == null) {
                this.setPigmanData(data.setProfession(PigmanData.Profession.NONE));
            }
            if (data != null && this.jobSite != null && this.getCurrentActivity() == Activity.f_37980_) {
                this.m_21446_(this.jobSite.m_122646_(), 10);
            } else {
                this.m_147271_();
            }
        }
        super.m_8024_();
        if (this.shouldConvert((Mob)this)) {
            this.setConvertTime(this.getConvertTime() + 1);
        } else {
            this.setConvertTime(0);
        }
        if (this.getConvertTime() > 300 && ForgeEventFactory.canLivingConvert((LivingEntity)this, RediscoveredEntityTypes.ZOMBIE_PIGMAN, timer -> this.setConvertTime((int)timer))) {
            IPigman.zombify((Mob)this, null);
        }
        boolean inChair = this.m_20202_() instanceof MountableBlockEntity;
        if (this.m_21691_()) {
            this.sitTimer = 0;
        }
        if (inChair && !this.m_35306_() && --this.sitTimer <= 0) {
            this.m_8127_();
        }
        if (!inChair && this.m_35306_() && this.m_20270_((Entity)this.m_7962_()) > 1.5f) {
            this.f_21344_.m_5624_((Entity)this.m_7962_(), 0.5);
        }
        if (this.m_5803_() && this.getCurrentActivity() != Activity.f_37982_) {
            this.m_5796_();
        }
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 12: {
                this.m_35287_((ParticleOptions)ParticleTypes.f_123750_);
                break;
            }
            case 13: {
                this.m_35287_((ParticleOptions)ParticleTypes.f_123792_);
                break;
            }
            case 14: {
                this.m_35287_((ParticleOptions)ParticleTypes.f_123748_);
                break;
            }
            case 42: {
                this.m_35287_((ParticleOptions)ParticleTypes.f_123769_);
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_5803_() ? null : RediscoveredSounds.ENTITY_PIGMAN_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return RediscoveredSounds.ENTITY_PIGMAN_HURT;
    }

    protected SoundEvent m_5592_() {
        return RediscoveredSounds.ENTITY_PIGMAN_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public SoundEvent m_7596_() {
        return RediscoveredSounds.ENTITY_PIGMAN_AGREE;
    }

    protected SoundEvent m_6068_(boolean positive) {
        return positive ? RediscoveredSounds.ENTITY_PIGMAN_AGREE : RediscoveredSounds.ENTITY_PIGMAN_DISAGREE;
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        PigmanEntity baby = (PigmanEntity)RediscoveredEntityTypes.PIGMAN.m_20615_((Level)level);
        baby.m_146762_(Integer.MAX_VALUE);
        baby.villageOrigin = this.villageOrigin;
        baby.originFoundNaturally = true;
        return baby;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() != RediscoveredItems.pigman_spawn_egg && this.m_6084_() && !this.m_5803_() && !this.m_6162_() && !player.m_36341_()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                this.m_5496_(this.m_6068_(false), this.m_6121_(), this.m_6100_());
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            if (!this.m_9236_().m_5776_() && !this.f_35261_.isEmpty()) {
                this.updateSpecialPrices(player);
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), this.getPigmanData().getLevel());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7996_() {
        super.m_7996_();
        this.resetSpecialPrices();
    }

    private void levelUp() {
        this.setPigmanData(this.getPigmanData().setLevel(this.getPigmanData().getLevel() + 1));
        this.m_7604_();
    }

    public void m_7189_(@Nullable Player pPlayer) {
        boolean flag = this.m_7962_() != null && pPlayer == null;
        super.m_7189_(pPlayer);
        if (flag) {
            this.m_7996_();
        }
    }

    private void resetSpecialPrices() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45376_();
        }
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45372_();
        }
        this.lastRestockGameTime = this.m_9236_().m_46467_();
        ++this.numberOfRestocksToday;
    }

    private boolean needsToRestock() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            if (!merchantoffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.m_9236_().m_46467_() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        if (this.m_6616_().isEmpty()) {
            return false;
        }
        long i = this.lastRestockGameTime + 12000L;
        long j = this.m_9236_().m_46467_();
        boolean flag = j > i;
        long k = this.m_9236_().m_46468_();
        if (this.lastRestockCheckDayTime > 0L) {
            long i1 = k / 24000L;
            long l = this.lastRestockCheckDayTime / 24000L;
            flag |= i1 > l;
        }
        this.lastRestockCheckDayTime = k;
        if (flag) {
            this.lastRestockGameTime = j;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void catchUpDemand() {
        int i = 2 - this.numberOfRestocksToday;
        if (i > 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                merchantoffer.m_45372_();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.updateDemand();
        }
    }

    private void updateDemand() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            merchantoffer.m_45369_();
        }
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    public boolean m_7862_() {
        return true;
    }

    public void setOffers(MerchantOffers pOffers) {
        this.f_35261_ = pOffers;
    }

    protected void m_8058_(MerchantOffer offer) {
        int i = 3 + this.f_19796_.m_188503_(4);
        this.xp += offer.m_45379_();
        if (this.canLevelUp()) {
            this.timeUntilReset = 40;
            this.customer = true;
            i += 5;
        }
        if (offer.m_45383_()) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected void m_7604_() {
        VillagerTrades.ItemListing[] tradeListing;
        PigmanData data = this.getPigmanData();
        Int2ObjectMap<VillagerTrades.ItemListing[]> trades = data.getProfession().trades;
        if (trades != null && !trades.isEmpty() && (tradeListing = (VillagerTrades.ItemListing[])trades.get(data.getLevel())) != null) {
            this.m_35277_(this.m_6616_(), tradeListing, 2);
        }
    }

    private boolean canLevelUp() {
        int i = this.getPigmanData().getLevel();
        return VillagerData.m_35582_((int)i) && this.xp >= VillagerData.m_35577_((int)i);
    }

    public void setPigmanData(PigmanData data) {
        PigmanData currentData = this.getPigmanData();
        if (currentData.getProfession() != data.getProfession()) {
            this.f_35261_ = null;
        }
        this.f_19804_.m_135381_(PIGMAN_DATA, (Object)data);
    }

    @Override
    public PigmanData getPigmanData() {
        return (PigmanData)this.f_19804_.m_135370_(PIGMAN_DATA);
    }

    public int m_7809_() {
        return this.xp;
    }

    public void setXp(int amount) {
        this.xp = amount;
    }

    public void setImmuneToZombification(boolean flag) {
        this.m_20088_().m_135381_(IMMUNE_TO_ZOMBIFICATION, (Object)flag);
    }

    @Override
    public boolean isImmuneToZombification() {
        return (Boolean)this.m_20088_().m_135370_(IMMUNE_TO_ZOMBIFICATION);
    }

    public void setConvertTime(int flag) {
        this.m_20088_().m_135381_(ZOMBIFICATION_TIME, (Object)flag);
    }

    public int getConvertTime() {
        return (Integer)this.m_20088_().m_135370_(ZOMBIFICATION_TIME);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.sitTimer = 0;
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource cause) {
        this.releaseAllPois();
        super.m_6667_(cause);
    }

    public double getPosDistance(BlockPos pos) {
        return this.getPosDistance(Vec3.m_82539_((Vec3i)pos));
    }

    public double getPosDistance(Vec3 vec) {
        return this.getPosDistance(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
    }

    public double getPosDistance(double x, double y, double z) {
        double f = this.m_20185_() - x;
        double f1 = this.m_20186_() - y;
        double f2 = this.m_20189_() - z;
        return Math.sqrt(f * f + f1 * f1 + f2 * f2);
    }

    public boolean m_7307_(Entity entityIn) {
        return entityIn.m_6095_().m_204039_(RediscoveredTags.Entities.PIGMAN_ALLIES) || super.m_20031_(entityIn.m_5647_());
    }

    public boolean m_35506_() {
        return this.m_146764_() == 0;
    }

    public void m_5802_(BlockPos pos) {
        super.m_5802_(pos);
    }

    @Override
    public IPigman.Type getPigmanType() {
        return IPigman.Type.TRADER;
    }

    protected Component m_5677_() {
        PigmanData.Profession prof = this.getPigmanData().getProfession();
        if (prof != PigmanData.Profession.NONE) {
            return Component.m_237115_((String)(this.m_6095_().m_20675_() + "." + prof.profName));
        }
        return super.m_5677_();
    }

    public double m_6049_() {
        return -0.35;
    }

    protected void releaseHome() {
        if (this.homePos != null) {
            this.releasePoi(p -> p.m_203565_(PoiTypes.f_218060_), this.homePos);
            this.homePos = null;
        }
    }

    protected void releaseOrigin() {
        if (this.villageOrigin != null && this.originFoundNaturally) {
            this.releasePoi(p -> p.m_203565_(PoiTypes.f_218061_), this.villageOrigin);
            this.originFoundNaturally = false;
            this.villageOrigin = null;
        }
    }

    protected void releaseJobSite() {
        PigmanData data = this.getPigmanData();
        if (this.jobSite != null) {
            if (data != null) {
                this.releasePoi(p -> p.m_203656_(RediscoveredTags.Poi.APPLICABLE_PIGMAN_WORKSTATION), this.jobSite);
            }
            this.jobSite = null;
        }
    }

    public void releasePossibleJobSite() {
        if (this.possibleJobSite != null) {
            this.releasePoi(p -> p.m_203656_(RediscoveredTags.Poi.APPLICABLE_PIGMAN_WORKSTATION), this.possibleJobSite);
            this.possibleJobSite = null;
        }
    }

    public void releaseAllPois() {
        this.releaseHome();
        this.releaseOrigin();
        this.releaseJobSite();
        this.releasePossibleJobSite();
    }

    public void releasePoi(Predicate<Holder<PoiType>> poi, @Nullable GlobalPos pos) {
        PoiManager poimanager;
        Optional optional;
        ServerLevel sl;
        MinecraftServer minecraftserver;
        ServerLevel serverlevel;
        if (pos == null) {
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (serverlevel = (minecraftserver = (sl = (ServerLevel)level).m_7654_()).m_129880_(pos.m_122640_())) != null && (optional = (poimanager = serverlevel.m_8904_()).m_27177_(pos.m_122646_())).isPresent() && poi.test((Holder<PoiType>)((Holder)optional.get()))) {
            poimanager.m_27154_(pos.m_122646_());
            DebugPackets.m_133719_((ServerLevel)serverlevel, (BlockPos)pos.m_122646_());
        }
    }

    public Activity getCurrentActivity() {
        return this.getPigmanData().getProfession().getSchedule().m_38019_((int)(this.m_9236_().m_8044_() % 24000L));
    }

    public void setMovingToRemembered(boolean movingToRemembered) {
        this.movingToRemembered = movingToRemembered;
    }

    private void updateSpecialPrices(Player player) {
        int i;
        int n = i = this.curedUuids.contains(player.m_20148_()) ? 20 : 0;
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.m_6616_()) {
                System.out.println(merchantoffer.m_45368_() + " " + merchantoffer.m_45378_());
                merchantoffer.m_45353_(-Mth.m_14143_((float)((float)i * merchantoffer.m_45378_())));
            }
        }
    }

    class GoToBedGoal
    extends Goal {
        final PigmanEntity mob;

        public GoToBedGoal(PigmanEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.homePos != null && this.mob.getCurrentActivity() == Activity.f_37982_;
        }

        public void m_8037_() {
            if (this.mob.homePos == null || this.mob.m_5803_()) {
                return;
            }
            Vec3 vec = Vec3.m_82512_((Vec3i)this.mob.homePos.m_122646_());
            if (this.mob.f_21344_.m_26571_()) {
                this.mob.setMovingToRemembered(true);
                Path path = this.mob.m_21573_().m_26524_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1);
                if (path != null) {
                    this.mob.m_21573_().m_26536_(path, 0.5);
                }
            }
            if (Mth.m_14116_((float)((float)this.mob.m_20238_(vec))) <= 2.0f) {
                this.mob.m_5802_(this.mob.homePos.m_122646_());
                this.mob.f_21344_.m_26573_();
            }
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
        }
    }

    class GoToMeetingGoal
    extends Goal {
        final PigmanEntity mob;

        public GoToMeetingGoal(PigmanEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.villageOrigin != null && this.mob.getPosDistance(this.mob.villageOrigin.m_122646_()) > 20.0 && this.mob.getCurrentActivity() == Activity.f_37983_;
        }

        public void m_8037_() {
            if (this.mob.villageOrigin == null) {
                return;
            }
            Vec3 vec = Vec3.m_82512_((Vec3i)this.mob.villageOrigin.m_122646_());
            if (this.mob.f_21344_.m_26571_()) {
                this.mob.setMovingToRemembered(true);
                Path path = this.mob.m_21573_().m_26524_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1);
                if (path != null) {
                    this.mob.m_21573_().m_26536_(path, 0.5);
                }
            }
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
        }
    }

    class GoToWorkGoal
    extends Goal {
        final PigmanEntity mob;

        public GoToWorkGoal(PigmanEntity mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.jobSite != null && this.mob.getPosDistance(this.mob.jobSite.m_122646_()) > 10.0 && this.mob.getCurrentActivity() == Activity.f_37980_;
        }

        public void m_8037_() {
            if (this.mob.jobSite == null) {
                return;
            }
            Vec3 vec = Vec3.m_82512_((Vec3i)this.mob.jobSite.m_122646_());
            if (this.mob.f_21344_.m_26571_()) {
                this.mob.setMovingToRemembered(true);
                Path path = this.mob.m_21573_().m_26524_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), 1);
                if (path != null) {
                    this.mob.m_21573_().m_26536_(path, 0.5);
                }
            }
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
        }
    }

    class AvoidAndAlertGuardsGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public AvoidAndAlertGuardsGoal(PathfinderMob pMob, Class<T> pEntityClassToAvoid, Predicate<LivingEntity> pAvoidPredicate, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super(pMob, pEntityClassToAvoid, pAvoidPredicate, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, EntitySelector.f_20406_::test);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.f_25016_ != null && this.f_25015_.f_19797_ % 20 <= 2) {
                double range = 20.0;
                Mob nearestGuard = (Mob)this.f_25015_.m_9236_().m_45963_(Mob.class, TargetingConditions.m_148353_().m_148355_().m_26883_(range).m_26893_().m_26888_(e -> e.m_6095_().m_204039_(RediscoveredTags.Entities.PIGMAN_VILLAGE_GUARDS)), (LivingEntity)this.f_25015_, this.f_25015_.m_20185_(), this.f_25015_.m_20186_(), this.f_25015_.m_20189_(), this.f_25015_.m_20191_().m_82400_(range));
                if (nearestGuard != null) {
                    nearestGuard.m_6710_(this.f_25016_);
                }
            }
        }
    }

    private class PigmanWalkNodeEvaluator
    extends WalkNodeEvaluator {
        private PigmanWalkNodeEvaluator() {
        }

        public BlockPathTypes m_8086_(BlockGetter pLevel, int pX, int pY, int pZ) {
            BlockPathTypes belowType = PigmanWalkNodeEvaluator.m_77604_((BlockGetter)pLevel, (BlockPos.MutableBlockPos)new BlockPos.MutableBlockPos(pX, pY - 1, pZ));
            BlockPathTypes type = PigmanWalkNodeEvaluator.m_77604_((BlockGetter)pLevel, (BlockPos.MutableBlockPos)new BlockPos.MutableBlockPos(pX, pY, pZ));
            if (belowType == BlockPathTypes.FENCE && type == BlockPathTypes.WALKABLE) {
                return BlockPathTypes.FENCE;
            }
            return type;
        }
    }
}

