/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.pigman;

import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.gui.GuardPigmanInventoryMenu;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.ai.SearchForPoiGoal;
import com.legacy.rediscovered.entity.pigman.PigmanInventory;
import com.legacy.rediscovered.entity.pigman.ai.GuardedHurtByTargetGoal;
import com.legacy.rediscovered.entity.pigman.ai.GuardedHurtTargetGoal;
import com.legacy.rediscovered.entity.pigman.ai.PigmanFollowGuardedGoal;
import com.legacy.rediscovered.entity.pigman.ai.PigmanFollowNearestPlayerGoal;
import com.legacy.rediscovered.entity.util.IPigman;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public abstract class GuardPigmanEntity
extends PathfinderMob
implements IPigman,
InventoryCarrier,
ContainerListener {
    public static final Map<EquipmentSlot, Integer> SLOT_MAP = Map.of(EquipmentSlot.MAINHAND, 0, EquipmentSlot.OFFHAND, 1, EquipmentSlot.FEET, 2, EquipmentSlot.LEGS, 3, EquipmentSlot.CHEST, 4, EquipmentSlot.HEAD, 5);
    protected static final EntityDataAccessor<Boolean> PLAYER_CURED = SynchedEntityData.m_135353_(GuardPigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IMMUNE_TO_ZOMBIFICATION = SynchedEntityData.m_135353_(GuardPigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ZOMBIFICATION_TIME = SynchedEntityData.m_135353_(GuardPigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> GUARDED_UUID = SynchedEntityData.m_135353_(GuardPigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Long> TIME_PAID = SynchedEntityData.m_135353_(GuardPigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    protected static final EntityDataAccessor<Boolean> DISMISSED = SynchedEntityData.m_135353_(GuardPigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final PigmanInventory inventory;
    public int safetySeenTimer;
    protected static final String CURED_KEY = "PlayerCured";
    protected static final String GUARDED_UUID_KEY = "GuardedUUID";
    protected static final String TIME_PAID_KEY = "TimePaid";
    protected static final String DISMISSED_KEY = "DismissedUnsafely";

    public GuardPigmanEntity(EntityType<? extends GuardPigmanEntity> type, Level world) {
        super(type, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
        this.inventory = new PigmanInventory(this, 6);
        this.inventory.m_19164_(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLAYER_CURED, (Object)false);
        this.f_19804_.m_135372_(IMMUNE_TO_ZOMBIFICATION, (Object)false);
        this.f_19804_.m_135372_(ZOMBIFICATION_TIME, (Object)0);
        this.f_19804_.m_135372_(GUARDED_UUID, Optional.empty());
        this.f_19804_.m_135372_(TIME_PAID, (Object)0L);
        this.f_19804_.m_135372_(DISMISSED, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SearchForSafetyGoal(this, (ResourceKey<PoiType>)PoiTypes.f_218060_, 30, 60));
        this.f_21345_.m_25352_(2, (Goal)new PigmanFollowNearestPlayerGoal(this, 0.7, 8.0f, 4.0f));
        this.f_21345_.m_25352_(3, (Goal)new MoveThroughVillageGoal(this, 0.6, false, 4, () -> true){

            public boolean m_8036_() {
                return GuardPigmanEntity.this.getGuardedUUID().isEmpty() && !GuardPigmanEntity.this.isDismissedUnsafely() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{GuardPigmanEntity.class}));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal<Mob>((Mob)this, Mob.class, 5, false, false, mob -> mob instanceof Enemy && !(mob instanceof Creeper) && !(mob instanceof ZombifiedPiglin)){

            public boolean m_8036_() {
                return GuardPigmanEntity.this.getGuardedUUID().isEmpty() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, ZombifiedPiglin.class, 8.0f, 0.6, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new PigmanFollowGuardedGoal(this, 0.7, 10.0f, 2.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new GuardedHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new GuardedHurtTargetGoal(this));
        this.registerAdditionalGoals();
    }

    public void registerAdditionalGoals() {
    }

    public static AttributeSupplier.Builder createBasePigmanAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (reason != MobSpawnType.CONVERSION) {
            this.m_213945_(level.m_213780_(), difficulty);
            this.m_213946_(level.m_213780_(), difficulty);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(CURED_KEY, this.isPlayerCured());
        if (this.getGuardedUUID().isPresent()) {
            tag.m_128362_(GUARDED_UUID_KEY, this.getGuardedUUID().get());
            tag.m_128356_(TIME_PAID_KEY, this.getTimePaid());
        }
        tag.m_128405_("ZombificationTime", this.getConvertTime());
        tag.m_128379_("IsImmuneToZombification", this.isImmuneToZombification());
        tag.m_128379_(DISMISSED_KEY, this.isDismissedUnsafely());
        this.m_252802_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setPlayerCured(tag.m_128471_(CURED_KEY));
        if (tag.m_128425_(GUARDED_UUID_KEY, 11)) {
            this.setGuardedUUID(tag.m_128342_(GUARDED_UUID_KEY));
            this.setTimePaid(tag.m_128454_(TIME_PAID_KEY));
        }
        this.setConvertTime(tag.m_128451_("ZombificationTime"));
        this.setImmuneToZombification(tag.m_128471_("IsImmuneToZombification"));
        this.setDismissedUnsafely(tag.m_128471_(DISMISSED_KEY));
        this.m_253224_(tag);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? 0.85f : 1.8f;
    }

    public boolean m_7327_(Entity entity) {
        if (this.isPlayerCured()) {
            ItemStack stack = this.m_21205_();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                stack.m_41720_().m_7579_(this.m_21205_(), living, (LivingEntity)this);
            } else if (stack.m_41763_()) {
                stack.m_41622_(2, (LivingEntity)this, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return super.m_7327_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.safetySeenTimer > 0) {
            --this.safetySeenTimer;
        }
        if (this.m_217043_().m_188503_(900) == 0 && this.f_20919_ == 0) {
            this.m_5634_(1.0f);
        }
        if (this.isPlayerCured() && this.getGuardedUUID().isPresent()) {
            LivingEntity guarded = this.getGuardedEntity();
            if (guarded != null) {
                this.m_21446_(guarded.m_20183_(), 10);
            }
            if (this.m_9236_().m_46467_() - this.getTimePaid() >= this.timeToBodyguard() * 20L) {
                this.dismissBodyguard();
            }
        }
        if (this.shouldConvert((Mob)this)) {
            this.setConvertTime(this.getConvertTime() + 1);
        } else {
            this.setConvertTime(0);
        }
        if (this.getConvertTime() > 300 && ForgeEventFactory.canLivingConvert((LivingEntity)this, RediscoveredEntityTypes.ZOMBIE_PIGMAN, timer -> this.setConvertTime((int)timer))) {
            IPigman.zombify((Mob)this, null);
        }
    }

    public long timeToBodyguard() {
        return 900L;
    }

    public boolean m_7307_(Entity entity) {
        if (entity instanceof Player && this.isPlayerCured() || entity.m_6095_().m_204039_(RediscoveredTags.Entities.PIGMAN_ALLIES)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return this.m_20031_(entity.m_5647_());
    }

    public LivingEntity getGuardedEntity() {
        Optional<UUID> uuid = this.getGuardedUUID();
        if (uuid.isEmpty()) {
            return null;
        }
        return this.m_9236_().m_46003_(uuid.get());
    }

    protected SoundEvent m_7515_() {
        return RediscoveredSounds.ENTITY_PIGMAN_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RediscoveredSounds.ENTITY_PIGMAN_HURT;
    }

    protected SoundEvent m_5592_() {
        return RediscoveredSounds.ENTITY_PIGMAN_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public boolean isPlayerCured() {
        return (Boolean)this.f_19804_.m_135370_(PLAYER_CURED);
    }

    public void setPlayerCured(boolean flag) {
        this.f_19804_.m_135381_(PLAYER_CURED, (Object)flag);
    }

    public void setImmuneToZombification(boolean flag) {
        this.m_20088_().m_135381_(IMMUNE_TO_ZOMBIFICATION, (Object)flag);
    }

    @Override
    public boolean isImmuneToZombification() {
        return (Boolean)this.m_20088_().m_135370_(IMMUNE_TO_ZOMBIFICATION);
    }

    public void setConvertTime(int time) {
        this.m_20088_().m_135381_(ZOMBIFICATION_TIME, (Object)time);
    }

    public int getConvertTime() {
        return (Integer)this.m_20088_().m_135370_(ZOMBIFICATION_TIME);
    }

    public Optional<UUID> getGuardedUUID() {
        return (Optional)this.f_19804_.m_135370_(GUARDED_UUID);
    }

    public void setGuardedUUID(UUID id) {
        this.f_19804_.m_135381_(GUARDED_UUID, Optional.ofNullable(id));
    }

    public void setTimePaid(long time) {
        this.m_20088_().m_135381_(TIME_PAID, (Object)time);
    }

    public long getTimePaid() {
        return (Long)this.m_20088_().m_135370_(TIME_PAID);
    }

    public boolean isDismissedUnsafely() {
        return (Boolean)this.f_19804_.m_135370_(DISMISSED);
    }

    public void setDismissedUnsafely(boolean flag) {
        this.f_19804_.m_135381_(DISMISSED, (Object)flag);
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_21531_() {
        return super.m_21531_() || this.isPlayerCured();
    }

    public boolean isValidHandEquip(ItemStack stack) {
        return this.getPigmanType().isValidHandEquip(stack);
    }

    public boolean isValidOffHandEquip(ItemStack stack) {
        return this.getPigmanType().isValidOffHandEquip(stack);
    }

    public void hireAsBodyguard(UUID uuid) {
        this.setDismissedUnsafely(false);
        this.setTimePaid(this.m_9236_().m_46467_());
        this.setGuardedUUID(uuid);
        this.m_5496_(RediscoveredSounds.ENTITY_PIGMAN_AGREE, this.m_6121_(), 1.0f);
    }

    public void dismissBodyguard() {
        this.m_147271_();
        this.setGuardedUUID(null);
        this.setTimePaid(0L);
        this.setDismissedUnsafely(true);
        this.m_5496_(RediscoveredSounds.ENTITY_PIGMAN_DISAGREE, this.m_6121_(), 1.0f);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (this.isPlayerCured()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new SimpleMenuProvider((id, inventory, playerIn) -> new GuardPigmanInventoryMenu(id, inventory, this), this.m_7755_()), buffer -> buffer.writeInt(this.m_19879_()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public void m_5757_(Container pContainer) {
        SLOT_MAP.forEach((slot, id) -> {
            if (this.isPlayerCured()) {
                this.m_21468_((EquipmentSlot)slot, this.inventory.m_8020_((int)id));
            } else {
                this.m_8061_((EquipmentSlot)slot, this.inventory.m_8020_((int)id));
            }
        });
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        this.inventory.setItemNoUpdate(SLOT_MAP.get(pSlot), pStack);
    }

    protected void m_6472_(DamageSource source, float damage) {
        if (this.isPlayerCured()) {
            this.inventory.damageArmor(source, damage);
        }
    }

    public boolean m_7243_(ItemStack stack) {
        if (!this.isPlayerCured()) {
            return super.m_7243_(stack);
        }
        return false;
    }

    public PigmanArmPose getArmPose() {
        return PigmanArmPose.NEUTRAL;
    }

    private class SearchForSafetyGoal
    extends SearchForPoiGoal<GuardPigmanEntity> {
        public SearchForSafetyGoal(GuardPigmanEntity mob, ResourceKey<PoiType> poi, int radius, int checkDelay) {
            super(mob, (T e) -> mob.m_20183_(), poi, radius, checkDelay);
        }

        @Override
        public boolean m_8036_() {
            return ((GuardPigmanEntity)this.mob).isDismissedUnsafely() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && ((GuardPigmanEntity)this.mob).isDismissedUnsafely();
        }

        @Override
        public void onPoiFound(BlockPos pos) {
            ((GuardPigmanEntity)this.mob).m_5496_(RediscoveredSounds.ENTITY_PIGMAN_AGREE, 1.0f, 1.5f);
        }

        @Override
        public void tickFound(BlockPos pos) {
            ServerLevel sl;
            Level level;
            ((GuardPigmanEntity)this.mob).safetySeenTimer = 60;
            ((GuardPigmanEntity)this.mob).m_21563_().m_24964_(Vec3.m_82512_((Vec3i)pos));
            if (((GuardPigmanEntity)this.mob).m_21573_().m_26571_()) {
                ((GuardPigmanEntity)this.mob).m_21573_().m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)0.8f);
            }
            if (this.distanceTo() <= 10.0f || (level = ((GuardPigmanEntity)this.mob).m_9236_()) instanceof ServerLevel && !(sl = (ServerLevel)level).m_8904_().m_27091_(pos, this.poi)) {
                ((GuardPigmanEntity)this.mob).setDismissedUnsafely(false);
                this.finish();
            }
        }
    }

    public static enum PigmanArmPose {
        NEUTRAL,
        BOW_AND_ARROW,
        CROSSBOW_CHARGE,
        CROSSBOW_HOLD;

    }
}

