/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.dragon;

import com.legacy.rediscovered.client.particles.ShockwaveData;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.util.LogicUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ThunderCloudEntity
extends Entity
implements TraceableEntity {
    protected static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(ThunderCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DESPAWN_DELAY = SynchedEntityData.m_135353_(ThunderCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> STRIKE_DISTANCE = SynchedEntityData.m_135353_(ThunderCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> STRIKE_TIME = SynchedEntityData.m_135353_(ThunderCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    public final List<Vec3> renderOffsets;
    static final String DELAY_KEY = "Delay";
    static final String DESPAWN_DELAY_KEY = "DespawnDelay";
    static final String OWNER_KEY = "Owner";
    static final String STRIKE_DISTANCE_KEY = "StrikeDistance";
    static final String STRIKE_TIME_KEY = "StrikeTime";

    public ThunderCloudEntity(EntityType<? extends ThunderCloudEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
        this.renderOffsets = new ArrayList<Vec3>();
        double distance = 1.0;
        for (int a = 0; a < 8; ++a) {
            this.renderOffsets.add(Vec3.f_82478_.m_82520_(this.f_19796_.m_188583_() * distance, this.f_19796_.m_188583_() * distance, this.f_19796_.m_188583_() * distance));
        }
        this.f_19811_ = true;
    }

    public ThunderCloudEntity(Level level, double pX, double pY, double pZ) {
        this(RediscoveredEntityTypes.THUNDER_CLOUD, level);
        this.m_6034_(pX, pY, pZ);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DELAY, (Object)40);
        this.f_19804_.m_135372_(DESPAWN_DELAY, (Object)20);
        this.f_19804_.m_135372_(STRIKE_DISTANCE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STRIKE_TIME, (Object)0);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setDelay(tag.m_128451_(DELAY_KEY));
        this.setDespawnDelay(tag.m_128451_(DESPAWN_DELAY_KEY));
        if (tag.m_128403_(OWNER_KEY)) {
            this.ownerUUID = tag.m_128342_(OWNER_KEY);
            this.cachedOwner = null;
        }
        this.setStrikeDistance(tag.m_128457_(STRIKE_DISTANCE_KEY));
        this.setStrikeTime(tag.m_128451_(STRIKE_TIME_KEY));
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128405_(DELAY_KEY, this.getDelay());
        tag.m_128405_(DESPAWN_DELAY_KEY, this.getDespawnDelay());
        if (this.ownerUUID != null) {
            tag.m_128362_(OWNER_KEY, this.ownerUUID);
        }
        tag.m_128350_(STRIKE_DISTANCE_KEY, this.getStrikeDistance());
        tag.m_128405_(STRIKE_TIME_KEY, this.getStrikeTime());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            float hRange = 2.0f;
            if (this.f_19796_.m_188501_() < 0.6f) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)LogicUtil.withinRange(hRange, this.f_19796_), this.m_20186_() + (double)LogicUtil.withinRange(1.3f, this.f_19796_) + (double)(this.m_20206_() / 2.0f), this.m_20189_() + (double)LogicUtil.withinRange(hRange, this.f_19796_), (double)LogicUtil.withinRange(0.1f, this.f_19796_), (double)LogicUtil.withinRange(0.1f, this.f_19796_), (double)LogicUtil.withinRange(0.1f, this.f_19796_));
            }
            if (this.getDelay() > 0) {
                if (this.f_19797_ % 8 == 0) {
                    float sRange = 0.5f;
                    for (int i = 0; i < 20; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (double)LogicUtil.withinRange(sRange, this.f_19796_), this.m_20186_() - (double)(this.f_19796_.m_188501_() * this.getStrikeDistance()), this.m_20189_() + (double)LogicUtil.withinRange(sRange, this.f_19796_), (double)LogicUtil.withinRange(0.1f, this.f_19796_), (double)LogicUtil.withinRange(0.1f, this.f_19796_), (double)LogicUtil.withinRange(0.1f, this.f_19796_));
                    }
                }
                if (this.getDelay() == 1) {
                    // empty if block
                }
            }
            if (this.getDespawnDelay() == 1) {
                for (int i = 0; i < 25; ++i) {
                    this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123796_, true, this.m_20185_() + (double)LogicUtil.withinRange(hRange, this.f_19796_), this.m_20186_() + (double)LogicUtil.withinRange(1.3f, this.f_19796_) + (double)(this.m_20206_() / 2.0f), this.m_20189_() + (double)LogicUtil.withinRange(hRange, this.f_19796_), (double)LogicUtil.withinRange(0.5f, this.f_19796_), (double)LogicUtil.withinRange(0.5f, this.f_19796_), (double)LogicUtil.withinRange(0.5f, this.f_19796_));
                }
            }
        } else {
            BlockPos offset = this.m_20183_();
            int height = this.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, offset.m_123341_(), offset.m_123343_());
            this.setStrikeDistance((float)(this.m_20186_() - (double)height));
            if (this.getDelay() > 0) {
                int oldDelay = this.getDelay();
                this.setDelay(this.getDelay() - 1);
                if (oldDelay > 0 && this.getDelay() == 0) {
                    Level level;
                    this.setStrikeTime(10);
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, this.m_5720_(), 5.0f, 1.0f);
                        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_() - (double)this.getStrikeDistance(), this.m_20189_(), SoundEvents.f_12089_, this.m_5720_(), 1.0f, 1.0f);
                    }
                    if ((level = this.m_9236_()) instanceof ServerLevel) {
                        ServerLevel sl = (ServerLevel)level;
                        sl.m_8767_((ParticleOptions)new ShockwaveData(), this.m_20185_(), this.m_20186_() - (double)this.getStrikeDistance(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (!this.m_9236_().m_5776_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46131_)) {
                        BlockPos blockpos = this.m_20183_().m_175288_(height);
                        BlockState blockstate = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos);
                        if (this.m_9236_().m_8055_(blockpos).m_60795_() && blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos)) {
                            this.m_9236_().m_46597_(blockpos, blockstate);
                        }
                        for (int i = 0; i < 4; ++i) {
                            BlockPos blockpos1 = blockpos.m_7918_(this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1);
                            blockstate = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)blockpos1);
                            if (!this.m_9236_().m_8055_(blockpos1).m_60795_() || !blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos1)) continue;
                            this.m_9236_().m_46597_(blockpos1, blockstate);
                        }
                    }
                }
            } else {
                if (this.getStrikeTime() > 0) {
                    List list1 = this.m_9236_().m_6249_((Entity)this, AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(2.0, (double)this.getStrikeDistance(), 2.0).m_82386_(-0.5, (double)(-this.getStrikeDistance()), -0.5), Entity::m_6084_);
                    for (Entity entity : list1) {
                        if (entity == this.m_19749_()) continue;
                        entity.m_7311_(entity.m_20094_() + 1);
                        if (entity.m_20094_() == 0) {
                            entity.m_20254_(8);
                        }
                        entity.m_6469_(entity.m_269291_().m_269548_(), 10.0f);
                    }
                    this.setStrikeTime(this.getStrikeTime() - 1);
                }
                if (this.getDespawnDelay() == 0) {
                    this.m_216990_(SoundEvents.f_12639_);
                    this.m_146870_();
                } else if (this.getDespawnDelay() > 0) {
                    this.setDespawnDelay(this.getDespawnDelay() - 1);
                }
            }
        }
    }

    public int getDelay() {
        return (Integer)this.f_19804_.m_135370_(DELAY);
    }

    public void setDelay(int delay) {
        this.f_19804_.m_135381_(DELAY, (Object)delay);
    }

    public int getDespawnDelay() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_DELAY);
    }

    public void setDespawnDelay(int time) {
        this.f_19804_.m_135381_(DESPAWN_DELAY, (Object)time);
    }

    public float getStrikeDistance() {
        return ((Float)this.f_19804_.m_135370_(STRIKE_DISTANCE)).floatValue();
    }

    public void setStrikeDistance(float dist) {
        this.f_19804_.m_135381_(STRIKE_DISTANCE, (Object)Float.valueOf(dist));
    }

    public int getStrikeTime() {
        return (Integer)this.f_19804_.m_135370_(STRIKE_TIME);
    }

    public void setStrikeTime(int time) {
        this.f_19804_.m_135381_(STRIKE_TIME, (Object)time);
    }

    public void setOwner(@Nullable Entity pOwner) {
        if (pOwner != null) {
            this.ownerUUID = pOwner.m_20148_();
            this.cachedOwner = pOwner;
        }
    }

    @Nullable
    public Entity m_19749_() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.cachedOwner = sl.m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }
}

