/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.dragon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.gui.DragonInventoryMenu;
import com.legacy.rediscovered.entity.dragon.AbstractRedDragonEntity;
import com.legacy.rediscovered.entity.util.animation.AnimData;
import com.legacy.rediscovered.entity.util.animation.IAnimated;
import com.legacy.rediscovered.item.DragonArmorItem;
import com.legacy.rediscovered.network.PacketHandler;
import com.legacy.rediscovered.network.c_to_s.DragonFlightStatusPacket;
import com.legacy.rediscovered.network.c_to_s.DragonStaminaDecreasePacket;
import com.legacy.rediscovered.network.s_to_c.SendScreenShakePacket;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.registry.RediscoveredTriggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public class RedDragonOffspringEntity
extends AbstractRedDragonEntity
implements IAnimated,
HasCustomInventoryScreen,
Saddleable,
ContainerListener {
    public static final String MOUNT_DRAGON_KEY = "gui.rediscovered.tooltip.mount_red_dragon";
    private static final AttributeModifier DRAGON_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("b8cfda89-c9a8-4eb9-9226-d5a47e770a41"), "Dragon Armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(RedDragonOffspringEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> MOVEMENT_TYPE = SynchedEntityData.m_135353_(RedDragonOffspringEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(RedDragonOffspringEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> STAMINA = SynchedEntityData.m_135353_(RedDragonOffspringEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> TIRED = SynchedEntityData.m_135353_(RedDragonOffspringEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final List<AnimData> anims = new ArrayList<AnimData>();
    public final AnimData flyingAnim = new AnimData(this.anims, 1.0f, true);
    public final AnimData hoverAnim = new AnimData(this.anims, 0.5f, true);
    public final AnimData fallingAnim = new AnimData(this.anims, 1.0f, true).serverControlledStops();
    public final AnimData reverseAnim = new AnimData(this.anims, 2.0f, true);
    public final AnimData sufferingAnim = new AnimData(this.anims, 0.2f, 0.5f, true);
    public final AnimData tiredAnim = new AnimData(this.anims, 0.5f, true);
    public int minimumLandTime;
    public int timeOffGround;
    public int dismountDelay = 30;
    public Vec3 fluteCallVec;
    protected SimpleContainer inventory;
    public int jumpTimer;
    private boolean wasRiderJumping;
    public float riderZza = 0.0f;
    public float oStamina = 100.0f;
    static final String FLYING_KEY = "IsFlying";
    static final String MOVEMENT_TYPE_KEY = "MovementType";
    static final String SADDLE_KEY = "SaddleItem";
    static final String ARMOR_KEY = "ArmorItem";
    static final String STAMINA_KEY = "Stamina";
    static final String TIRED_KEY = "Tired";
    float turnAnim;

    public RedDragonOffspringEntity(EntityType<? extends RedDragonOffspringEntity> type, Level level) {
        super(type, level);
        this.createInventory();
        this.f_21365_ = new LookControl((Mob)this){

            public void m_8128_() {
                if (!RedDragonOffspringEntity.this.m_217005_()) {
                    super.m_8128_();
                }
            }
        };
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractRedDragonEntity.createDragonAttributes().m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22279_, 0.7);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TravelToFluteCallGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new DragonStrollGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new DragonLookAtEntityGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(8, (Goal)new DragonLookAroundGoal((Mob)this));
    }

    protected void m_5849_() {
        super.m_5849_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FLYING, (Object)false);
        this.m_20088_().m_135372_(SADDLED, (Object)false);
        this.m_20088_().m_135372_(MOVEMENT_TYPE, (Object)MovementType.WANDER.getName());
        this.m_20088_().m_135372_(STAMINA, (Object)Float.valueOf(100.0f));
        this.m_20088_().m_135372_(TIRED, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (FLYING.equals(pKey) && this.isFlying()) {
            this.prevAnimTime = 0.0f;
            this.animTime = 0.0f;
            this.playFlapSound();
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(FLYING_KEY, this.isFlying());
        tag.m_128359_(MOVEMENT_TYPE_KEY, this.getMovementType().getName());
        tag.m_128350_(STAMINA_KEY, this.getStamina());
        tag.m_128379_(TIRED_KEY, this.isTired());
        ItemStack saddle = this.inventory.m_8020_(0);
        ItemStack armor = this.inventory.m_8020_(1);
        tag.m_128365_(SADDLE_KEY, (Tag)saddle.m_41739_(new CompoundTag()));
        tag.m_128365_(ARMOR_KEY, (Tag)armor.m_41739_(new CompoundTag()));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFlying(tag.m_128471_(FLYING_KEY));
        this.setMovementType(MovementType.getFromName(tag.m_128461_(MOVEMENT_TYPE_KEY)));
        this.setStamina(tag.m_128457_(STAMINA_KEY));
        this.oStamina = this.getStamina();
        this.setTired(tag.m_128471_(TIRED_KEY));
        ItemStack saddle = ItemStack.m_41712_((CompoundTag)tag.m_128469_(SADDLE_KEY));
        ItemStack armor = ItemStack.m_41712_((CompoundTag)tag.m_128469_(ARMOR_KEY));
        this.inventory.m_6836_(0, saddle);
        this.inventory.m_6836_(1, armor);
        this.updateContainerEquipment();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tickAnims((Entity)this);
        this.flyingAnim.play(this.isFlying());
        this.tiredAnim.play(this.isTired());
        this.sufferingAnim.play(this.isFlying() && this.getStamina() <= 20.0f);
        if (!this.m_20096_()) {
            this.dismountDelay = 15;
        } else if (this.dismountDelay > 0) {
            --this.dismountDelay;
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_217043_().m_188503_(700) == 0 && this.f_20919_ == 0) {
                this.m_5634_(1.0f);
            }
            if (this.getStamina() <= 0.0f) {
                this.setTired(true);
            } else if (this.getStamina() > 50.0f) {
                this.setTired(false);
            }
            if (!RediscoveredConfig.WORLD.redDragonStamina()) {
                this.setStamina(100.0f);
            } else if (this.m_20096_() && RediscoveredConfig.WORLD.redDragonStamina()) {
                this.setStamina(this.getStamina() + (this.isTired() ? 0.03f : 0.06f));
            }
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.riderZza = player.f_20902_;
                this.m_5616_(player.m_6080_());
            }
            this.reverseAnim.play(this.f_20902_ < 0.0f || this.riderZza < 0.0f);
            if (!this.m_217005_() && this.fluteCallVec == null) {
                this.setFlying(this.getDragonTarget() != null || this.targetVec != null);
            }
            if (this.getDragonTarget() != null && this.m_20270_(this.getDragonTarget()) <= 20.0f && this.minimumLandTime <= 0 && this.m_20096_()) {
                this.setDragonTarget(null);
                this.setNewTarget();
            }
            this.m_20242_(this.isFlying());
            this.hoverAnim.play(this.isFlying() && (this.m_217005_() && this.riderZza <= 0.0f || !this.m_217005_() && this.targetVec == null && this.getDragonTarget() == null));
        } else {
            this.fallingAnim.play(!this.isFlying() && !this.m_20096_() && this.timeOffGround >= 5);
            if (this.m_20096_() || this.m_20069_()) {
                this.timeOffGround = 0;
            } else if (this.f_19797_ > 80) {
                ++this.timeOffGround;
            }
            if (this.jumpTimer > 0) {
                --this.jumpTimer;
            }
        }
        if (this.isFlying()) {
            this.f_21344_.m_26573_();
            this.m_146926_(this.m_146909_() * 0.8f);
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = Math.min(pPartialTick * 4.0f, 1.0f) * (this.isTired() && this.m_20160_() ? 0.8f : 1.0f);
        this.f_267362_.m_267566_(this.reverseAnim.isPlaying() ? -f : f, 0.4f);
    }

    @Override
    protected boolean useNormalAI() {
        return !this.isFlying() || this.m_217005_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.minimumLandTime > 0) {
            --this.minimumLandTime;
        }
    }

    public void m_8024_() {
        Entity entity;
        super.m_8024_();
        if (this.m_217005_() && this.m_21824_() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            this.setDragonTarget(null);
            this.targetVec = null;
        }
    }

    @Override
    protected void m_6153_() {
        super.m_6153_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
    }

    @Override
    protected boolean shouldResetYawVelocity() {
        return this.m_21824_() && this.m_217005_();
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public boolean m_6573_(Player player) {
        return player == this.m_269323_();
    }

    protected double m_5823_() {
        return 0.7;
    }

    protected boolean m_213814_() {
        return false;
    }

    public void summonFromFlute(Player player) {
        if (this.m_269323_() == player) {
            this.fluteCallVec = player.m_20182_();
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult base = super.m_6071_(player, hand);
        ItemStack itemstack = player.m_21120_(hand);
        if (!base.m_19077_()) {
            if (player.m_20202_() != this && this.m_269323_() == player) {
                if (player.m_6144_()) {
                    this.m_213583_(player);
                    return InteractionResult.SUCCESS;
                }
                FoodProperties food = itemstack.getFoodProperties((LivingEntity)this);
                if (food != null && food.m_38746_() && this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(food.m_38744_());
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_146850_(GameEvent.f_157806_);
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_(RediscoveredItems.ruby_flute) || itemstack.m_150930_(Items.f_42655_)) {
                    return InteractionResult.PASS;
                }
                if (itemstack.m_41720_() instanceof DragonArmorItem) {
                    if (!this.m_9236_().m_5776_()) {
                        if (!this.getArmor().m_41619_()) {
                            player.m_21008_(hand, this.getArmor());
                        }
                        this.equipArmor(player, itemstack);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_(Items.f_42450_) && this.getSaddle().m_41619_()) {
                    itemstack.m_41647_(player, (LivingEntity)this, hand);
                    return InteractionResult.SUCCESS;
                }
            }
            if (player.m_20202_() == this && itemstack.m_41619_()) {
                player.m_8127_();
                if (!this.m_20096_() && player == this.m_269323_()) {
                    this.minimumLandTime = 60;
                    this.setDragonTarget((Entity)player);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_269323_() != null && this.m_21824_() && (player == this.m_269323_() || this.m_20197_().contains(this.m_269323_())) && this.mount(player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return base;
    }

    public boolean mount(Player player) {
        if (!this.m_9236_().m_5776_() && !this.m_6162_()) {
            boolean mounted;
            boolean bl = mounted = !this.m_6162_() && player.m_20329_((Entity)this);
            if (mounted) {
                player.m_20260_(false);
                player.m_146922_(this.m_146908_());
                player.m_5618_(player.m_146908_());
                this.m_5616_(this.m_146908_());
            }
            return mounted;
        }
        return false;
    }

    protected void m_20348_(Entity pPassenger) {
        if (pPassenger.m_20202_() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.m_20197_().isEmpty()) {
            this.f_19823_ = ImmutableList.of((Object)pPassenger);
        } else {
            ArrayList list = Lists.newArrayList((Iterable)this.m_20197_());
            if (!(this.m_9236_().m_5776_() || !(pPassenger instanceof Player) || this.m_146895_() instanceof Player && this.m_146895_() == this.m_269323_())) {
                list.add(0, pPassenger);
            } else {
                list.add(pPassenger);
            }
            this.f_19823_ = ImmutableList.copyOf((Collection)list);
        }
        this.m_146852_(GameEvent.f_268500_, pPassenger);
    }

    protected boolean m_7310_(Entity pPassenger) {
        return this.m_20197_().size() < 2;
    }

    @Override
    protected boolean canPathfind() {
        return super.canPathfind();
    }

    @Override
    protected void forceDragonHeadRot() {
        if (this.isFlying() && !this.m_217005_()) {
            super.forceDragonHeadRot();
        }
    }

    public void m_7023_(Vec3 pTravelVector) {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_20182_().f_82480_ < (double)this.m_9236_().m_141937_() && this.m_9236_().m_46472_().equals((Object)Level.f_46428_) && this.f_19797_ < 20) {
                RediscoveredMod.LOGGER.debug(player + " likely teleported into the overworld void while on the Red Dragon. Attempting to move to world height.");
                this.m_6027_(this.m_20182_().f_82479_, this.m_9236_().m_151558_(), this.m_20182_().f_82481_);
            }
            player.m_150110_().f_35935_ = false;
            if (this.m_6109_()) {
                boolean jumping = player.f_20899_;
                float forward = player.f_20902_;
                float strafe = player.f_20900_;
                this.riderZza = forward;
                if (forward > 0.0f) {
                    forward = 1.0f;
                } else if (forward < 0.0f) {
                    forward = -1.0f;
                }
                if (strafe > 0.0f) {
                    strafe = 1.0f;
                } else if (strafe < 0.0f) {
                    strafe = -1.0f;
                }
                strafe *= forward;
                if (forward <= 0.0f) {
                    forward *= this.m_20096_() ? 0.5f : 0.25f;
                }
                if (!this.m_20096_() && !this.isFlying()) {
                    forward *= 0.2f;
                }
                if (this.isTired()) {
                    forward *= 0.8f;
                }
                if (RediscoveredConfig.WORLD.redDragonStamina() && this.getStamina() > 0.0f && this.isFlying()) {
                    float decrease = 0.02f;
                    decrease += 0.06f * (forward * (player.m_6144_() && !jumping ? 0.8f : 1.0f));
                    if (jumping) {
                        decrease += 0.04f;
                    }
                    PacketHandler.sendToServer(new DragonStaminaDecreasePacket(this.m_19879_(), decrease * 0.8f));
                }
                this.setStamina(Mth.m_14036_((float)this.getStamina(), (float)0.0f, (float)100.0f));
                this.turnAnim = Mth.m_14189_((float)0.15f, (float)this.turnAnim, (float)strafe);
                float rotDest = player.m_6080_() - this.turnAnim * 57.295776f;
                this.m_146922_(!this.isFlying() ? Mth.m_14189_((float)(strafe != 0.0f ? 0.8f : 0.15f), (float)this.m_146908_(), (float)rotDest) : rotDest);
                this.m_5616_(player.m_6080_());
                this.f_20883_ = Mth.m_14177_((float)(this.m_20096_() ? Mth.m_14189_((float)0.1f, (float)this.f_20883_, (float)rotDest) : rotDest));
                this.f_19859_ = this.m_6080_();
                float leftRight = (float)(-this.getLatencyPos(7, 1.0f)[0]) * ((float)Math.PI / 180);
                player.m_5618_(rotDest - leftRight);
                player.f_20883_ = rotDest - leftRight;
                float xRotDest = this.isFlying() && this.hoverAnim.isPlaying() ? player.m_146909_() * 1.2f : 0.0f;
                this.m_146926_(Mth.m_14189_((float)0.15f, (float)this.m_146909_(), (float)xRotDest));
                if (jumping && !this.isFlying() && this.m_20096_()) {
                    this.m_6853_(false);
                    this.m_6135_();
                    this.timeOffGround += 5;
                }
                boolean noStamina = RediscoveredConfig.WORLD.redDragonStamina() && (this.getStamina() <= 0.0f || this.isTired());
                boolean breakNextJump = false;
                if (!this.wasRiderJumping && jumping && !noStamina) {
                    if (this.jumpTimer == 0) {
                        this.jumpTimer = 7;
                    } else {
                        PacketHandler.sendToServer(new DragonFlightStatusPacket(this.m_19879_(), !this.isFlying()));
                        if (!this.isFlying()) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, 1.0, 0.0));
                        }
                        this.jumpTimer = 0;
                        this.wasRiderJumping = false;
                        breakNextJump = true;
                    }
                } else if (this.isFlying() && this.m_20096_() || noStamina) {
                    PacketHandler.sendToServer(new DragonFlightStatusPacket(this.m_19879_(), false));
                }
                float verticalSpeed = 0.03f;
                Vec3 movement = player.m_20252_(1.0f).m_193103_(Direction.Axis.Y, 0.0).m_82541_().m_82490_((double)Mth.m_14036_((float)forward, (float)-1.0f, (float)1.0f)).m_82524_(strafe).m_82490_((double)0.15f);
                if (this.isFlying()) {
                    this.m_20256_(this.m_20184_().m_82549_(movement).m_82549_(Vec3.f_82478_.m_193103_(Direction.Axis.Y, jumping ? (double)verticalSpeed : (player.m_6144_() ? (double)(-verticalSpeed) : 0.0))));
                } else {
                    this.m_20256_(this.m_20184_().m_82549_(movement));
                }
                if (!breakNextJump) {
                    this.wasRiderJumping = jumping;
                }
                super.m_7023_(Vec3.f_82478_);
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Override
    public double m_6048_() {
        return super.m_6048_();
    }

    @Override
    public void m_19956_(Entity passenger, Entity.MoveFunction pCallback) {
        if (this.m_20363_(passenger)) {
            int i = this.m_20197_().indexOf(passenger);
            boolean notDriver = i != 0;
            float fly = this.flyingAnim.getValue(1.0f);
            float hover = this.hoverAnim.getValue(1.0f);
            float hoverInv = 1.0f - hover;
            float upDown = (float)(this.getLatencyPos(5, 0.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * fly * hoverInv;
            float leftRight = (float)(-this.getLatencyPos(7, 1.0f)[0]) * ((float)Math.PI / 180) * fly - Mth.m_14177_((float)this.f_20883_) * ((float)Math.PI / 180) * (1.0f - fly);
            float tilt = Mth.m_14177_((float)((float)(this.getLatencyPos(5, 1.0f)[0] - this.getLatencyPos(10, 1.0f)[0]))) * ((float)Math.PI / 180) * fly;
            float mul = 1.0f + 2.0f * (upDown * -0.35f) - (float)i * 1.2f;
            float x = -Mth.m_14031_((float)leftRight) * mul;
            float z = Mth.m_14089_((float)(-leftRight)) * mul;
            float y = upDown * (upDown < 0.0f ? (notDriver ? -0.15f : 0.32f) : (notDriver ? 0.2f : 0.1f)) - Mth.m_14154_((float)tilt) * 0.1f;
            if (notDriver) {
                y = -y;
            }
            y += 2.8f - (float)i * 1.2f * hover;
            y = (float)((double)y - (Math.sin(this.animTime * ((float)Math.PI * 2) - 1.0f) * (double)0.2f * (double)fly + (double)(0.2f * (1.0f - fly))));
            if (!this.getSaddle().m_41619_()) {
                y = (float)((double)y + 0.1);
            }
            pCallback.m_20372_(passenger, this.m_20185_() - (double)x, this.m_20186_() + (double)y + passenger.m_6049_(), this.m_20189_() + (double)z);
        }
    }

    @Override
    public float getFlapSpeed(float motion) {
        float startPercent = 30.0f;
        float maxPercent = 5.0f;
        float lowStaminaMul = Mth.m_14036_((float)((-this.getStamina() + startPercent) * (1.0f / (startPercent - maxPercent))), (float)0.0f, (float)1.0f);
        return !this.isFlying() ? 0.0f : super.getFlapSpeed(!this.m_6109_() && this.m_217005_() ? (this.hoverAnim.isPlaying() ? 0.1f : 0.02f) : motion) + (this.hoverAnim.isPlaying() ? 0.02f : 0.1f) * lowStaminaMul;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (!(entity instanceof LivingEntity)) return null;
        LivingEntity living = (LivingEntity)entity;
        if (!this.m_21824_()) return null;
        if (!this.m_6254_()) return null;
        if (this.m_269323_() != living) return null;
        LivingEntity livingEntity = living;
        return livingEntity;
    }

    public void setFlying(boolean flag) {
        this.m_20088_().m_135381_(FLYING, (Object)flag);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.m_20088_().m_135370_(FLYING);
    }

    public void setStamina(float stamina) {
        this.oStamina = this.getStamina();
        this.m_20088_().m_135381_(STAMINA, (Object)Float.valueOf(stamina));
    }

    public float getStamina() {
        return ((Float)this.m_20088_().m_135370_(STAMINA)).floatValue();
    }

    public void setTired(boolean flag) {
        this.m_20088_().m_135381_(TIRED, (Object)flag);
    }

    public boolean isTired() {
        return (Boolean)this.m_20088_().m_135370_(TIRED);
    }

    public void setMovementType(MovementType type) {
        this.m_20088_().m_135381_(MOVEMENT_TYPE, (Object)type.getName());
    }

    public MovementType getMovementType() {
        return MovementType.getFromName((String)this.m_20088_().m_135370_(MOVEMENT_TYPE));
    }

    public float lerpedStamina(float partialTick) {
        return Mth.m_14036_((float)Mth.m_14179_((float)partialTick, (float)this.oStamina, (float)this.getStamina()), (float)0.0f, (float)100.0f) / 100.0f;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return this.m_6162_() ? 1.0f : 2.0f;
    }

    @Override
    protected void setNewTarget() {
        this.forceNewTarget = false;
        this.targetVec = null;
    }

    @Override
    public boolean isMultipartEntity() {
        return false;
    }

    @Override
    public List<AnimData> getAnimations() {
        return this.anims;
    }

    @Override
    protected SoundEvent m_7515_() {
        return !this.isFlying() && this.m_217043_().m_188501_() < 0.95f || this.isTired() ? RediscoveredSounds.ENTITY_RED_DRAGON_IDLE_CALM : super.m_7515_();
    }

    @Override
    protected float m_6121_() {
        return this.m_6162_() ? 2.0f : 4.0f;
    }

    public int m_8100_() {
        return super.m_8100_() * (!this.isFlying() ? 3 : 5);
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        if (!this.isFlying()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (!this.m_6162_()) {
                    Vec3 centerPos = this.m_20182_();
                    sl.m_6907_().forEach(player -> {
                        float dist;
                        if (player.m_20202_() == this) {
                            PacketHandler.sendToClient(new SendScreenShakePacket(0.03f), player);
                        } else if (player.m_20096_() && (dist = (float)centerPos.m_82554_(player.m_20182_())) <= 30.0f) {
                            PacketHandler.sendToClient(new SendScreenShakePacket(Math.min(0.8f, 1.0f / dist)), player);
                        }
                    });
                }
            }
            this.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_STEP, this.m_6162_() ? 0.6f : 2.0f, (this.m_6162_() ? 1.2f : 0.8f) + this.f_19796_.m_188501_() * 0.2f);
        }
    }

    protected float m_6059_() {
        return this.f_19788_ + (this.m_6162_() ? 0.5f : (!this.m_217005_() ? 1.7f : 2.0f));
    }

    @Override
    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (!this.m_6162_()) {
                Vec3 centerPos = this.m_20182_();
                sl.m_6907_().forEach(player -> {
                    float dist;
                    float d = Math.min(10.0f, pFallDistance / 2.0f);
                    if (player.m_20202_() == this) {
                        PacketHandler.sendToClient(new SendScreenShakePacket(0.03f * d), player);
                    } else if (player.m_20096_() && (dist = (float)centerPos.m_82554_(player.m_20182_())) <= 30.0f) {
                        PacketHandler.sendToClient(new SendScreenShakePacket(Math.min(0.8f, 1.0f / dist) * d), player);
                    }
                });
            }
        }
        return false;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Vec3 vec3 = RedDragonOffspringEntity.m_19903_((double)this.m_20205_(), (double)pLivingEntity.m_20205_(), (float)(this.m_146908_() + (pLivingEntity.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec31 = this.getDismountLocationInDirection(vec3, pLivingEntity);
        if (vec31 != null) {
            return vec31;
        }
        Vec3 vec32 = RedDragonOffspringEntity.m_19903_((double)this.m_20205_(), (double)pLivingEntity.m_20205_(), (float)(this.m_146908_() + (pLivingEntity.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec33 = this.getDismountLocationInDirection(vec32, pLivingEntity);
        return vec33 != null ? vec33 : this.m_20182_();
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 pDirection, LivingEntity pPassenger) {
        double d0 = this.m_20185_() + pDirection.f_82479_;
        double d1 = this.m_20191_().f_82289_;
        double d2 = this.m_20189_() + pDirection.f_82481_;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : pPassenger.m_7431_()) {
            blockpos$mutableblockpos.m_122169_(d0, d1, d2);
            double d3 = this.m_20191_().f_82292_ + 0.75;
            do {
                double d4 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.m_123342_() + d4 > d3) continue block0;
                if (DismountHelper.m_38439_((double)d4)) {
                    AABB aabb = pPassenger.m_21270_(pose);
                    Vec3 vec3 = new Vec3(d0, (double)blockpos$mutableblockpos.m_123342_() + d4, d2);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)pPassenger, (AABB)aabb.m_82383_(vec3))) {
                        pPassenger.m_20124_(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.m_122173_(Direction.UP);
            } while ((double)blockpos$mutableblockpos.m_123342_() < d3);
        }
        return null;
    }

    public void m_213583_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)new SimpleMenuProvider((id, inventory, playerIn) -> new DragonInventoryMenu(id, inventory, this), this.m_7755_()), buffer -> buffer.writeInt(this.m_19879_()));
        }
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public void m_5853_(@Nullable SoundSource pSource) {
        if (this.m_6162_()) {
            return;
        }
        this.inventory.m_6836_(0, Items.f_42450_.m_7968_());
    }

    public void equipArmor(@Nullable Player player, ItemStack armor) {
        if (this.m_6162_()) {
            return;
        }
        if (armor.m_41720_() instanceof DragonArmorItem) {
            this.inventory.m_6836_(1, armor.m_255036_(1));
            if (player != null && !player.m_150110_().f_35937_) {
                armor.m_41774_(1);
            }
        }
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(2);
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(SADDLED, (Object)(!this.inventory.m_8020_(0).m_41619_() ? 1 : 0));
            this.m_8061_(EquipmentSlot.CHEST, this.inventory.m_8020_(1));
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
    }

    public ItemStack getSaddle() {
        return this.inventory.m_8020_(0);
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public void m_5757_(Container pContainer) {
        ItemStack newArmor;
        boolean flag = this.m_6254_();
        ItemStack oldArmor = this.getArmor();
        this.m_21051_(Attributes.f_22284_).m_22130_(DRAGON_ARMOR_MODIFIER);
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 1.0f, 1.0f);
        }
        if ((newArmor = this.getArmor()).m_41720_() instanceof DragonArmorItem) {
            if (!this.m_21051_(Attributes.f_22284_).m_22109_(DRAGON_ARMOR_MODIFIER)) {
                this.m_21051_(Attributes.f_22284_).m_22118_(DRAGON_ARMOR_MODIFIER);
            }
            if (this.f_19797_ > 20 && !oldArmor.equals(newArmor)) {
                this.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_EQUIP_ARMOR, 1.0f, 1.0f);
            }
        }
    }

    public SoundEvent m_246265_() {
        return RediscoveredSounds.ENTITY_RED_DRAGON_EQUIP_SADDLE;
    }

    public Container getDragonInventory() {
        return this.inventory;
    }

    protected boolean canUseGoals() {
        return !this.isFlying() && !this.m_217005_() && this.fluteCallVec == null;
    }

    @Override
    protected boolean shouldEnforcedFlyingDistanceLimit() {
        return this.fluteCallVec == null;
    }

    public int m_6056_() {
        return this.fluteCallVec != null ? 30 : 10;
    }

    private class TravelToFluteCallGoal
    extends Goal {
        private final RedDragonOffspringEntity mob;
        boolean reachedUpVec;
        int flightCooldown = 0;
        int tickCount;
        Vec3 lastVec;
        int stuckChecks = 0;

        public TravelToFluteCallGoal(RedDragonOffspringEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return !this.mob.m_217005_() && this.mob.fluteCallVec != null && this.mob.m_269323_() != null;
        }

        public boolean m_8045_() {
            return !this.mob.m_217005_() && this.mob.fluteCallVec != null;
        }

        public void m_8056_() {
            this.mob.f_21344_.m_26573_();
            this.mob.targetVec = null;
            this.flightCooldown = 0;
            this.reachedUpVec = false;
            this.lastVec = null;
            this.stuckChecks = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void m_8037_() {
            Vec3 vec = this.mob.fluteCallVec;
            if (vec == null) {
                return;
            }
            boolean ownerNear = false;
            if (this.mob.m_269323_() != null && this.mob.m_20270_((Entity)this.mob.m_269323_()) <= 20.0f) {
                ServerPlayer sp;
                this.mob.fluteCallVec = this.mob.m_269323_().m_20182_();
                this.mob.m_21563_().m_148051_((Entity)this.mob.m_269323_());
                ownerNear = true;
                LivingEntity livingEntity = this.mob.m_269323_();
                if (livingEntity instanceof ServerPlayer && this.mob.m_20270_((Entity)(sp = (ServerPlayer)livingEntity)) <= 8.0f && this.mob.m_6254_() && !sp.m_20096_() && !this.mob.m_6162_()) {
                    this.mob.mount((Player)sp);
                    RediscoveredTriggers.DRAGON_CATCH.trigger(sp);
                }
            }
            int groundHeight = this.mob.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE_WG, (int)this.mob.m_20185_(), (int)this.mob.m_20189_());
            int groundHeightFromCall = this.mob.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE_WG, (int)this.mob.fluteCallVec.m_7096_(), (int)this.mob.fluteCallVec.m_7094_());
            if (this.distanceTo(vec) <= 30.0 && Mth.m_14154_((float)((float)(this.mob.m_20186_() - (double)groundHeight))) <= 15.0f && Mth.m_14154_((float)((float)(this.mob.fluteCallVec.m_7098_() - (double)groundHeightFromCall))) <= 5.0f) {
                if (this.mob.isFlying()) {
                    this.mob.m_20256_(Vec3.f_82478_);
                }
                this.flightCooldown = 20;
                this.mob.setFlying(false);
                if (this.mob.getDragonTarget() != null) {
                    this.mob.setDragonTarget(null);
                }
                if (this.mob.targetVec != null) {
                    this.mob.targetVec = null;
                }
                if (!ownerNear) {
                    this.mob.m_21563_().m_24964_(vec);
                }
                if (!(this.distanceTo(vec) >= (double)(ownerNear ? 12 : 8))) {
                    this.m_8041_();
                    return;
                }
                this.mob.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.5);
            } else if (this.flightCooldown <= 0) {
                if (this.mob.isTired()) {
                    LivingEntity livingEntity = this.mob.m_269323_();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_5661_((Component)Component.m_237110_((String)"rediscovered.message.dragon_too_tired", (Object[])new Object[]{this.mob.m_5446_()}), true);
                    }
                    this.m_8041_();
                    return;
                }
                if (!this.mob.isFlying() && this.mob.m_20096_()) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, 2.0, 0.0));
                }
                this.mob.setFlying(true);
                Vec3 upVec = vec.m_82520_(0.0, 20.0, 0.0);
                double dist = this.distanceTo(new Vec3(upVec.m_7096_(), this.mob.m_20186_(), upVec.m_7094_()));
                if (this.mob.m_20186_() < vec.m_7098_()) {
                    this.mob.targetVec = new Vec3(this.mob.m_20185_(), upVec.m_7098_(), this.mob.m_20189_());
                } else if (this.mob.f_19862_ && this.mob.m_9236_().m_46861_(this.mob.m_20183_())) {
                    this.mob.targetVec = new Vec3(this.mob.m_20185_(), this.mob.m_20186_() + 10.0, this.mob.m_20189_());
                } else if (!this.reachedUpVec && dist > 20.0) {
                    this.mob.targetVec = upVec;
                } else {
                    this.mob.targetVec = vec;
                    this.reachedUpVec = true;
                }
                if (this.stuckChecks >= 10) {
                    LivingEntity livingEntity = this.mob.m_269323_();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_5661_((Component)Component.m_237110_((String)"rediscovered.message.dragon_stuck", (Object[])new Object[]{this.mob.m_5446_()}), true);
                    }
                    this.m_8041_();
                    return;
                }
                if (this.lastVec != null) {
                    if (this.distanceTo(this.lastVec) <= 5.0) {
                        ++this.stuckChecks;
                    } else if (this.stuckChecks > 0) {
                        --this.stuckChecks;
                    }
                }
            }
            if (this.flightCooldown > 0) {
                --this.flightCooldown;
            }
            if (this.tickCount % 10 == 0) {
                this.lastVec = this.mob.m_20182_();
            }
            ++this.tickCount;
        }

        public void m_8041_() {
            this.reachedUpVec = false;
            this.mob.fluteCallVec = null;
            this.mob.targetVec = null;
        }

        public boolean m_183429_() {
            return super.m_183429_();
        }

        private double distanceTo(Vec3 vec) {
            return Math.sqrt(this.mob.m_20238_(vec));
        }
    }

    private class DragonStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public DragonStrollGoal(PathfinderMob pMob) {
            super(pMob, (double)0.4f, 1.0f);
        }

        public boolean m_8036_() {
            return RedDragonOffspringEntity.this.canUseGoals() && super.m_8036_();
        }

        public boolean m_8045_() {
            return RedDragonOffspringEntity.this.canUseGoals() && super.m_8045_();
        }
    }

    private class DragonLookAtEntityGoal
    extends LookAtPlayerGoal {
        public DragonLookAtEntityGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance) {
            super(pMob, pLookAtType, pLookDistance, 0.1f);
        }

        public boolean m_8036_() {
            return RedDragonOffspringEntity.this.canUseGoals() && super.m_8036_();
        }

        public boolean m_8045_() {
            return RedDragonOffspringEntity.this.canUseGoals() && super.m_8045_();
        }
    }

    private class DragonLookAroundGoal
    extends RandomLookAroundGoal {
        public DragonLookAroundGoal(Mob pMob) {
            super(pMob);
        }

        public boolean m_8036_() {
            return RedDragonOffspringEntity.this.canUseGoals() && super.m_8036_();
        }

        public boolean m_8045_() {
            return RedDragonOffspringEntity.this.canUseGoals() && super.m_8045_();
        }
    }

    private static enum MovementType {
        WANDER(0),
        SIT(1),
        FOLLOW(2);


        private MovementType(int id) {
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }

        public static MovementType getFromName(String name) {
            for (MovementType type : MovementType.values()) {
                if (name != type.getName()) continue;
                return type;
            }
            return WANDER;
        }
    }

    public static enum ControlType {
        MOUSE,
        KEYS;

    }
}

