/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.dragon;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.capability.entity.RainCapability;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.particles.LightningBoltData;
import com.legacy.rediscovered.client.particles.WindData;
import com.legacy.rediscovered.entity.dragon.AbstractRedDragonEntity;
import com.legacy.rediscovered.entity.dragon.BoltBallEntity;
import com.legacy.rediscovered.entity.dragon.PylonBurstEntity;
import com.legacy.rediscovered.entity.dragon.ThunderCloudEntity;
import com.legacy.rediscovered.entity.util.animation.AnimData;
import com.legacy.rediscovered.entity.util.animation.IAnimated;
import com.legacy.rediscovered.network.PacketHandler;
import com.legacy.rediscovered.network.s_to_c.AddClientMotionPacket;
import com.legacy.rediscovered.network.s_to_c.SendBossIdPacket;
import com.legacy.rediscovered.network.s_to_c.SetLocalRainPacket;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.util.LogicUtil;
import com.legacy.structure_gel.api.util.Positions;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RedDragonBossEntity
extends AbstractRedDragonEntity
implements Enemy,
IAnimated {
    private static final BiPredicate<RedDragonBossEntity, Entity> ATTACKABLE_TARGET = (d, p) -> EntitySelector.f_20406_.and(EntitySelector.f_20403_).test((Entity)p) && d.m_21574_().m_148306_(p) && p instanceof Player;
    public final List<AnimData> anims = new ArrayList<AnimData>();
    public final AnimData boltChargeAnim = new AnimData(this.anims, 0.15f, 0.4f, true);
    public final AnimData boltShootAnim = new AnimData(this.anims, 0.7f, 0.35f, true);
    public final AnimData windBlowAnim = new AnimData(this.anims, 0.3f, 0.4f, true);
    public final AnimData cloudPrepAnim = new AnimData(this.anims, 0.3f, 0.4f, true);
    private final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private static final int DUNGEON_CHUNK_RADIUS = 9;
    public static final TicketType<ChunkPos> RED_DRAGON_TICKET = TicketType.m_9465_((String)RediscoveredMod.find("red_dragon"), Comparator.comparingLong(ChunkPos::m_45588_), (int)60);
    private static final EntityDataAccessor<Integer> PYLON_TIME = SynchedEntityData.m_135353_(RedDragonBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IN_DEATH = SynchedEntityData.m_135353_(RedDragonBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> X_ROT_MOD_OLD = SynchedEntityData.m_135353_(RedDragonBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_ROT_MOD = SynchedEntityData.m_135353_(RedDragonBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int dragonDeathTicks;
    public int burstSpawnDelay = 60;
    public int extraLightningTime;
    private boolean spawnsRain = true;
    int boltBallCooldown = 80;
    int thunderCloudCooldown = 100;
    int windCooldown = 120;
    int attackCooldown = 60;
    AttackType attackType = AttackType.BALL;
    public long passiveBoltSeed;
    public long chargeBoltSeed;
    static final String HOME_POS_KEY = "DragonHomePos";
    static final String PYLON_TIME_KEY = "PylonChargeTime";
    static final String DEATH_TICKS_KEY = "DragonDeathTicks";
    static final String BURST_SPAWN_DELAY = "BurstSpawnDelay";
    static final String ATTACK_TYPE_KEY = "AttackType";
    static final String ATTACK_COOLDOWN_KEY = "AttackCooldown";

    public RedDragonBossEntity(EntityType<? extends RedDragonBossEntity> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.f_21364_ = 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractRedDragonEntity.createDragonAttributes().m_22268_(Attributes.f_22276_, 300.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PYLON_TIME, (Object)0);
        this.m_20088_().m_135372_(IN_DEATH, (Object)false);
        this.m_20088_().m_135372_(X_ROT_MOD, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_ROT_MOD_OLD, (Object)Float.valueOf(0.0f));
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ShootBoltBallGoal());
        this.f_21345_.m_25352_(2, (Goal)new CloudLineGoal());
        this.f_21345_.m_25352_(3, (Goal)new FlapWindAttackGoal());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.homePos != null) {
            pCompound.m_128365_(HOME_POS_KEY, (Tag)NbtUtils.m_129224_((BlockPos)this.homePos));
        }
        pCompound.m_128405_(PYLON_TIME_KEY, this.getPylonTime());
        pCompound.m_128405_(DEATH_TICKS_KEY, this.dragonDeathTicks);
        pCompound.m_128405_(BURST_SPAWN_DELAY, this.burstSpawnDelay);
        pCompound.m_128405_(ATTACK_COOLDOWN_KEY, this.attackCooldown);
        pCompound.m_128405_(ATTACK_TYPE_KEY, this.attackType.getId());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_(HOME_POS_KEY, 10)) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_(HOME_POS_KEY));
        }
        this.setPylonTime(pCompound.m_128451_(PYLON_TIME_KEY));
        this.dragonDeathTicks = pCompound.m_128451_(DEATH_TICKS_KEY);
        this.burstSpawnDelay = pCompound.m_128451_(BURST_SPAWN_DELAY);
        this.attackCooldown = pCompound.m_128451_(ATTACK_COOLDOWN_KEY);
        this.attackType = AttackType.getFromId(pCompound.m_128451_(ATTACK_TYPE_KEY));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tickAnims((Entity)this);
        if (this.m_9236_().m_5776_()) {
            this.chargeBoltSeed = this.f_19796_.m_188505_();
            if (this.f_19797_ % 2 == 0) {
                this.passiveBoltSeed = this.f_19796_.m_188505_();
            }
            if (this.windBlowAnim.atApex()) {
                float boxDistance = 20.0f;
                float boxSize = 20.0f;
                Vector3f boxCenter = new Vector3f(0.0f, 0.0f, boxDistance).rotate((Quaternionfc)Axis.f_252392_.m_252977_(this.m_146908_()));
                Vec3 moveVec = this.m_20182_().m_82520_((double)boxCenter.x(), (double)boxCenter.y(), (double)boxCenter.z());
                Vec3 baseMotion = moveVec.m_82546_(this.m_20182_()).m_82541_();
                Vec3 motion = baseMotion.m_82490_((double)(2 + LogicUtil.withinRange(1, this.f_19796_)));
                for (int i = 0; i < 12; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new WindData(4, 1.0f), moveVec.m_7096_() + (double)LogicUtil.withinRange(boxSize, this.f_19796_), moveVec.m_7098_() + (double)LogicUtil.withinRange(boxSize, this.f_19796_), moveVec.m_7094_() + (double)LogicUtil.withinRange(boxSize, this.f_19796_), motion.m_7096_(), motion.m_7098_(), motion.m_7094_());
                }
                float wingSin = Mth.m_14089_((float)(this.animTime * (float)Math.PI * 2.0f));
                float wingSinOld = Mth.m_14089_((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
                if (wingSinOld <= -0.3f && wingSin >= -0.3f) {
                    float speed = 2.5f;
                    Vec3 m = baseMotion.m_82542_((double)speed, (double)speed, (double)speed);
                    this.m_9236_().m_6493_((ParticleOptions)new WindData(0, 10.0f), true, this.m_20185_(), this.m_20186_() - 1.5, this.m_20189_(), m.m_7096_(), m.m_7098_(), m.m_7094_());
                }
            }
        } else {
            boolean bl = this.spawnsRain = !this.m_21525_();
            if (!this.m_21525_() && (this.targetVec == null || this.targetVec == Vec3.f_82478_ || this.targetVec != null && Math.sqrt(this.m_20238_(this.targetVec)) > 300.0) && (this.f_19797_ <= 40 || this.getPylonTime() > 0)) {
                this.setNewTarget();
            }
        }
    }

    @Override
    public float getFlapSpeed(float motion) {
        float boltPose = this.boltChargeAnim.getValue(1.0f);
        float windPose = this.windBlowAnim.getValue(1.0f);
        float cloudPose = this.cloudPrepAnim.getValue(1.0f);
        float mixed = Mth.m_14036_((float)(boltPose + windPose + cloudPose), (float)0.0f, (float)1.0f);
        return super.getFlapSpeed(motion) * (1.0f - mixed) + 0.12f * boltPose + 0.08f * windPose + 0.15f * cloudPose;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.boltBallCooldown > 0) {
                --this.boltBallCooldown;
            }
            if (this.thunderCloudCooldown > 0) {
                --this.thunderCloudCooldown;
            }
            if (this.windCooldown > 0) {
                --this.windCooldown;
            }
            if (this.homePos != null && this.getPlayersInArea(true).findAny().isPresent()) {
                ChunkPos homeChunk = new ChunkPos(this.homePos);
                sl.m_7726_().m_8387_(RED_DRAGON_TICKET, homeChunk, 9, (Object)homeChunk);
            }
            if (this.getPylonTime() > 0) {
                this.setPylonTime(this.getPylonTime() - 1);
                if (this.getPylonTime() == 1) {
                    this.extraLightningTime = 60;
                    this.f_21363_ = -this.m_8100_();
                    this.m_9236_().m_6269_(null, (Entity)this, RediscoveredSounds.ENTITY_RED_DRAGON_SHIELD_DOWN, this.m_5720_(), 20.0f, 1.0f);
                }
                ServerPlayer player = null;
                if (--this.burstSpawnDelay <= 0 && (player = this.findTarget()) != null) {
                    float dist = 3.5f;
                    for (int w = 0; w < 3 + this.m_217043_().m_188503_(2); ++w) {
                        float offset = this.m_217043_().m_188501_() * 360.0f;
                        double x = (double)dist * Math.cos(offset);
                        double z = (double)dist * Math.sin(offset);
                        Vec3 offsetVec = this.m_20182_().m_82520_(x, 0.0, z);
                        PylonBurstEntity projectile = new PylonBurstEntity(this.m_9236_(), (LivingEntity)this, (Entity)player);
                        projectile.m_6034_(offsetVec.f_82479_, offsetVec.f_82480_, offsetVec.f_82481_);
                        double xc = this.m_20182_().f_82479_ - offsetVec.f_82479_;
                        double zc = this.m_20182_().f_82481_ - offsetVec.f_82481_;
                        float vertMul = 0.15f;
                        projectile.m_20334_(xc * (double)(-vertMul), 0.28f + this.m_217043_().m_188501_() * 0.05f, zc * (double)(-vertMul));
                        this.m_9236_().m_7967_((Entity)projectile);
                        projectile.timeUntilBlast = (12 + this.m_217043_().m_188503_(5)) * 20;
                        projectile.speedAddition = this.f_19796_.m_188501_() * 0.05f;
                    }
                    this.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_SHED_BURSTS, 5.0f, 0.5f + this.m_217043_().m_188501_() * 0.1f);
                    this.burstSpawnDelay = (10 + this.m_217043_().m_188503_(5)) * 20;
                }
            } else if (this.spawnsRain && this.getPlayersInArea().findAny().isPresent()) {
                if (this.extraLightningTime > 0 && this.f_19797_ % 10 == 9 || this.m_21224_() && this.f_19797_ % 15 == 0 || this.m_217043_().m_188503_(100) == 0 && this.homePos != null) {
                    int length = 80;
                    BlockPos offset = this.homePos.m_7918_(this.m_217043_().m_188503_(length) - this.m_217043_().m_188503_(length), 0, this.m_217043_().m_188503_(length) - this.m_217043_().m_188503_(length));
                    int height = this.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, offset.m_123341_(), offset.m_123343_());
                    if (height > 10) {
                        LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                        bolt.m_20874_(true);
                        bolt.m_6034_((double)offset.m_123341_(), (double)height, (double)offset.m_123343_());
                        this.m_9236_().m_7967_((Entity)bolt);
                    }
                }
                if (this.extraLightningTime > 0) {
                    --this.extraLightningTime;
                }
                BlockPos particleCenter = this.homePos != null ? this.homePos : this.m_20183_();
                for (ServerPlayer player : this.getPlayersInArea().toList()) {
                    sl.m_8624_(player, (ParticleOptions)new LightningBoltData(this.m_217043_()), true, (double)particleCenter.m_123341_(), 250.0, (double)particleCenter.m_123343_(), this.f_19796_.m_188503_(2) + 1, 200.0, 10.0, 200.0, 0.0);
                }
            }
            if (!this.m_21525_() && this.spawnsRain && this.f_19797_ % 10 == 0) {
                this.applyLocalEffects(sl);
            }
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public void applyLocalEffects(ServerLevel level) {
        Set playersOutside = this.bossEvent.m_8324_().stream().filter(player -> !this.isInBossArea((Entity)player, this.getLocalEffectsDist(), true)).collect(Collectors.toSet());
        for (ServerPlayer player2 : playersOutside) {
            this.bossEvent.m_6539_(player2);
        }
        long gameTime = level.m_46467_();
        this.getEntitiesInArea(true).forEach(entity -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayer p = (ServerPlayer)entity;
                if (!playersOutside.contains(p)) {
                    if (this.getPylonTime() <= 0) {
                        if (!this.bossEvent.m_8324_().contains(p)) {
                            PacketHandler.sendToClient(new SendBossIdPacket(this.bossEvent.m_18860_()), p);
                        }
                        this.bossEvent.m_6543_(p);
                        this.setRainTime(level, (Entity)entity, gameTime);
                    } else {
                        this.bossEvent.m_6539_(p);
                    }
                }
            } else if (this.getPylonTime() <= 0) {
                this.setRainTime(level, (Entity)entity, gameTime);
            }
        });
    }

    private void setRainTime(ServerLevel level, Entity entity, long rainTime) {
        BlockPos pos = entity.m_20183_();
        if (level.m_45527_(pos)) {
            RainCapability.ifPresent(entity, rain -> rain.setRainTime(rainTime));
            PacketHandler.sendToClients(new SetLocalRainPacket(entity.m_19879_()), level, pos, 500);
        }
    }

    public void m_8024_() {
        super.m_8024_();
    }

    @Override
    protected void m_6153_() {
        int var5;
        this.f_20916_ = 5;
        if (this.m_9236_().m_5776_() && !((Boolean)this.m_20088_().m_135370_(IN_DEATH)).booleanValue()) {
            return;
        }
        BlockPos home = this.homePos;
        if (home != null) {
            Vec3 vec3 = new Vec3((double)home.m_123341_(), (double)(home.m_123342_() + 20), (double)home.m_123343_());
            if (Mth.m_14116_((float)((float)this.m_20238_(vec3))) > 10.0f && this.dragonDeathTicks <= 0) {
                this.targetVec = Vec3.m_82512_((Vec3i)home.m_6630_(20));
                return;
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_20088_().m_135381_(IN_DEATH, (Object)true);
        }
        this.prevAnimTime = this.animTime;
        ++this.dragonDeathTicks;
        if (this.dragonDeathTicks >= 180 && this.dragonDeathTicks <= 200) {
            double xOffs = (this.f_19796_.m_188500_() - 0.5) * 8.0;
            double yOffs = (this.f_19796_.m_188500_() - 0.5) * 4.0;
            double zOffs = (this.f_19796_.m_188500_() - 0.5) * 8.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + xOffs, this.m_20186_() + 2.0 + yOffs, this.m_20189_() + zOffs, 0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.dragonDeathTicks > 150 && this.dragonDeathTicks % 5 == 0) {
                int var4;
                int n = var4 = !this.m_21824_() ? 100 : 0;
                while (var4 > 0) {
                    var5 = ExperienceOrb.m_20782_((int)var4);
                    var4 -= var5;
                    this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), var5));
                }
            }
            if (this.dragonDeathTicks == 1) {
                this.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_DEATH, this.m_6121_(), 1.0f);
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)0.1f, 0.0));
        this.m_146922_(this.m_146908_() + 20.0f);
        if (this.dragonDeathTicks == 200 && !this.m_9236_().f_46443_) {
            int var4;
            int n = var4 = !this.m_21824_() ? 100 : 0;
            while (var4 > 0) {
                var5 = ExperienceOrb.m_20782_((int)var4);
                var4 -= var5;
                this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), var5));
            }
            if (this.homePos != null) {
                BlockPos eggPos = this.homePos;
                int maxEggOffset = 32;
                for (int i = 0; i <= maxEggOffset && !this.m_9236_().m_8055_(eggPos).m_247087_(); ++i) {
                    if (i == maxEggOffset) {
                        eggPos = this.homePos;
                        break;
                    }
                    eggPos = eggPos.m_7494_();
                }
                BlockState egg = RediscoveredBlocks.red_dragon_egg.m_49966_();
                this.m_9236_().m_46961_(eggPos, true);
                this.m_9236_().m_46597_(eggPos, egg);
                this.m_9236_().m_46796_(2001, eggPos, Block.m_49956_((BlockState)egg));
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                lightning.m_20874_(true);
                lightning.m_146884_(Vec3.m_82539_((Vec3i)eggPos));
                this.m_9236_().m_7967_((Entity)lightning);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (!this.m_20197_().isEmpty()) {
            ((Entity)this.m_20197_().get(0)).m_8127_();
        }
    }

    public void setPylonTime(int time) {
        this.m_20088_().m_135381_(PYLON_TIME, (Object)time);
    }

    public int getPylonTime() {
        return (Integer)this.m_20088_().m_135370_(PYLON_TIME);
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource != this.m_269291_().m_269548_() && super.m_6673_(pSource);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Player p;
        Entity entity;
        if (source.m_19390_() && (entity = source.m_7639_()) instanceof Player && (p = (Player)entity).m_21205_().m_41720_() == Items.f_42751_ && !this.m_9236_().f_46443_) {
            this.targetVec = null;
            return false;
        }
        if (this.getPylonTime() > 0) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.homePos != null) {
                ChunkPos homeChunk = new ChunkPos(this.homePos);
                sl.m_7726_().m_8438_(RED_DRAGON_TICKET, homeChunk, 9, (Object)homeChunk);
            }
        }
        super.m_6667_(pCause);
    }

    @Override
    protected void setNewTarget() {
        this.m_146926_(0.0f);
        super.setNewTarget();
    }

    @Override
    public float maxHorizontalWanderDistance() {
        return this.getPylonTime() <= 0 ? 80.0f : super.maxHorizontalWanderDistance();
    }

    @Override
    public float verticalWanderDistance() {
        return this.getPylonTime() <= 0 ? -25.0f + this.f_19796_.m_188501_() * 20.0f : super.verticalWanderDistance();
    }

    @Override
    public Vec3 wanderCenterVector() {
        return super.wanderCenterVector();
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (this.m_21525_() || !this.spawnsRain || this.getPylonTime() <= 0 || this.homePos == null) {
            // empty if block
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    public boolean m_21824_() {
        return false;
    }

    public void m_7105_(boolean pTamed) {
    }

    @Nullable
    public LivingEntity m_269323_() {
        return null;
    }

    @Nullable
    public UUID m_21805_() {
        return null;
    }

    public void m_21816_(UUID pUuid) {
    }

    public boolean m_21825_() {
        return false;
    }

    public int m_146764_() {
        return 0;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    protected boolean canPathfind() {
        return (Boolean)this.m_20088_().m_135370_(IN_DEATH) == false;
    }

    public Stream<ServerPlayer> getPlayersInArea() {
        return this.getPlayersInArea(false);
    }

    public Stream<ServerPlayer> getPlayersInArea(boolean includeDragon) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            int maxDist = this.getLocalEffectsDist();
            return sl.m_6907_().stream().filter(p -> this.isInBossArea((Entity)p, maxDist, includeDragon)).sorted((e1, e2) -> Double.compare(e1.m_20280_((Entity)this), e2.m_20280_((Entity)this)));
        }
        return Stream.empty();
    }

    public Stream<Entity> getEntitiesInArea(boolean includeDragon) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            int maxDist = this.getLocalEffectsDist();
            return StreamSupport.stream(sl.m_8583_().spliterator(), false).filter(entity -> this.isInBossArea((Entity)entity, maxDist, includeDragon));
        }
        return Stream.empty();
    }

    public boolean isInBossArea(Entity entity, int maxDist, boolean includeDragon) {
        int dist = maxDist * maxDist;
        return (this.homePos == null || includeDragon) && (float)entity.m_20275_(this.m_20185_(), entity.m_20186_(), this.m_20189_()) < (float)dist || this.homePos != null && (float)entity.m_20275_((double)this.homePos.m_123341_(), entity.m_20186_(), (double)this.homePos.m_123343_()) < (float)dist;
    }

    public int getLocalEffectsDist() {
        return 160;
    }

    @Override
    public List<AnimData> getAnimations() {
        return this.anims;
    }

    public ServerPlayer findTarget() {
        return this.getPlayersInArea().filter(e -> ATTACKABLE_TARGET.test(this, (Entity)e)).findFirst().orElse(null);
    }

    public AttackType randomizeAttackType(AttackType type) {
        AttackType newType;
        this.attackType = newType = (AttackType)((Object)Util.m_214621_(Arrays.asList(AttackType.values()).stream().filter(t -> type == null || t != type).toList(), (RandomSource)this.m_217043_()));
        this.attackCooldown = newType.getRandomCooldown(this.m_217043_());
        return newType;
    }

    public float getXRotModifier() {
        return ((Float)this.m_20088_().m_135370_(X_ROT_MOD)).floatValue();
    }

    public float getOldXRotModifier() {
        return ((Float)this.m_20088_().m_135370_(X_ROT_MOD_OLD)).floatValue();
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    private static enum AttackType {
        BALL(0, 80, 20),
        THUNDER(1, 100, 20),
        WIND(2, 60, 10);

        final int id;
        final int cooldown;
        final int cooldownAddition;

        private AttackType(int id, int cooldown, int cooldownAddition) {
            this.id = id;
            this.cooldown = cooldown;
            this.cooldownAddition = cooldownAddition;
        }

        public int getId() {
            return this.id;
        }

        public int getRandomCooldown(RandomSource rand) {
            return this.cooldown + rand.m_188503_(this.cooldownAddition);
        }

        public static AttackType getFromId(int id) {
            for (AttackType type : AttackType.values()) {
                if (id != type.id) continue;
                return type;
            }
            return BALL;
        }
    }

    class ShootBoltBallGoal
    extends Goal {
        private final RedDragonBossEntity boss;
        private ServerPlayer target;
        private int baseTime;
        private int chargeTime;

        public ShootBoltBallGoal() {
            this.boss = RedDragonBossEntity.this;
            this.baseTime = 200;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            boolean base;
            boolean bl = base = this.boss.getPylonTime() <= 0 && this.boss.attackCooldown <= 0 && this.boss.attackType == AttackType.BALL && !this.boss.inWall && (this.target = this.boss.findTarget()) != null;
            if (base) {
                if (this.boss.m_20270_((Entity)this.target) <= 20.0f) {
                    this.boss.setDragonTarget(null);
                } else {
                    if (this.boss.m_20270_((Entity)this.target) <= 40.0f) {
                        return true;
                    }
                    this.boss.setDragonTarget((Entity)this.target);
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return this.chargeTime > 0 && this.target != null && !this.target.m_213877_() && this.target.m_6084_();
        }

        public void m_8056_() {
            this.boss.boltChargeAnim.play();
            this.boss.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_BOLT_BALL_CHARGE, this.boss.m_6121_(), 1.0f);
            this.chargeTime = this.baseTime;
            this.boss.targetVec = null;
            this.boss.setDragonTarget(null);
        }

        public void m_8037_() {
            if (this.target == null || this.target.m_213877_() || !this.target.m_6084_()) {
                return;
            }
            if (this.chargeTime > 20) {
                this.boss.m_20256_(this.boss.m_20184_().m_82490_((double)0.9f));
                Vec3 pv = this.target.m_20182_();
                float rotDest = (float)(-Mth.m_14136_((double)(pv.m_7096_() - this.boss.m_20185_()), (double)(pv.m_7094_() - this.boss.m_20189_()))) * 57.295776f;
                this.boss.m_146922_(Mth.m_14189_((float)0.2f, (float)this.boss.m_146908_(), (float)rotDest));
                double d0 = pv.m_7096_() - RedDragonBossEntity.this.neck.m_20185_();
                double d1 = pv.m_7098_() - (RedDragonBossEntity.this.neck.m_20186_() + 0.5);
                double d2 = pv.m_7094_() - RedDragonBossEntity.this.neck.m_20189_();
                float xr = (float)(-Mth.m_14136_((double)d1, (double)Math.sqrt(d0 * d0 + d2 * d2)) * 57.2957763671875);
                this.boss.m_20088_().m_135381_(X_ROT_MOD_OLD, (Object)Float.valueOf(this.boss.getXRotModifier()));
                this.boss.m_20088_().m_135381_(X_ROT_MOD, (Object)Float.valueOf(Mth.m_14177_((float)xr) * ((float)Math.PI / 180)));
                if (RedDragonBossEntity.this.boltChargeAnim.atApex()) {
                    RedDragonBossEntity.this.boltShootAnim.play();
                }
                if (this.boss.boltShootAnim.getApexTicks() == 1) {
                    this.boss.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_BOLT_BALL_SHOOT, this.boss.m_6121_(), 1.0f);
                    BoltBallEntity ball = new BoltBallEntity(this.boss.m_9236_(), (LivingEntity)this.boss, null);
                    ball.timeUntilBlast = 200;
                    ball.m_146884_(this.boss.head.m_20182_());
                    ball.m_20256_(this.target.m_20182_().m_82546_(this.boss.head.m_20182_()).m_82541_().m_82490_(1.0));
                    this.boss.m_9236_().m_7967_((Entity)ball);
                } else if (RedDragonBossEntity.this.boltShootAnim.getApexTicks() >= 20) {
                    RedDragonBossEntity.this.boltShootAnim.stop();
                    RedDragonBossEntity.this.boltChargeAnim.stop();
                    this.chargeTime = 0;
                }
            }
        }

        public void m_8041_() {
            this.boss.randomizeAttackType(this.boss.attackType);
            this.target = null;
            this.boss.boltChargeAnim.stop();
            this.boss.boltShootAnim.stop();
            this.boss.setNewTarget();
            this.boss.thunderCloudCooldown = Math.max(60, this.boss.thunderCloudCooldown);
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    class CloudLineGoal
    extends Goal {
        final RedDragonBossEntity boss;
        private ServerPlayer target;
        boolean spawnedClouds;
        BlockPos targetPos;

        public CloudLineGoal() {
            this.boss = RedDragonBossEntity.this;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            boolean base;
            boolean bl = base = this.boss.getPylonTime() <= 0 && this.boss.attackCooldown <= 0 && this.boss.attackType == AttackType.THUNDER && !this.boss.inWall && (this.target = this.boss.findTarget()) != null;
            if (base) {
                if (this.boss.m_20270_((Entity)this.target) < 50.0f) {
                    this.boss.setDragonTarget(null);
                } else {
                    if (this.boss.m_20270_((Entity)this.target) <= 60.0f) {
                        return true;
                    }
                    this.boss.setDragonTarget((Entity)this.target);
                }
            }
            return false;
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && this.target.m_6084_() && RedDragonBossEntity.this.cloudPrepAnim.getApexTicks() < 40;
        }

        public void m_8056_() {
            this.boss.cloudPrepAnim.play();
            this.spawnedClouds = false;
            this.boss.targetVec = null;
            this.boss.setDragonTarget(null);
        }

        public void m_8037_() {
            if (this.target == null || this.target.m_213877_() || !this.target.m_6084_()) {
                return;
            }
            Vec3 pv = this.target.m_20182_();
            float rotDest = -((float)Mth.m_14136_((double)(pv.m_7096_() - this.boss.m_20185_()), (double)(pv.m_7094_() - this.boss.m_20189_()))) * 57.295776f;
            this.boss.m_146922_(Mth.m_14189_((float)0.2f, (float)this.boss.m_146908_(), (float)rotDest));
            if (!this.spawnedClouds && this.boss.cloudPrepAnim.atApex()) {
                float f = (float)Mth.m_14136_((double)(this.target.m_20189_() - this.boss.m_20189_()), (double)(this.target.m_20185_() - this.boss.m_20185_()));
                for (int l = 0; l < 16; ++l) {
                    double d2 = 10.0 + 5.25 * ((double)l + 1.5);
                    int j = 30 + 3 * l;
                    this.spawnClouds(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * d2, this.boss.homePos != null ? (double)(this.boss.homePos.m_123342_() + 15) : this.boss.m_20186_() + 10.0, j);
                }
                this.spawnedClouds = true;
            }
        }

        public void m_8041_() {
            this.boss.randomizeAttackType(this.boss.attackType);
            this.target = null;
            this.boss.cloudPrepAnim.stop();
            this.boss.setNewTarget();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public void spawnClouds(double xPos, double zPos, double yPos, int warmupDelay) {
            Level level = this.boss.m_9236_();
            BlockPos blockpos = Positions.blockPos((double)xPos, (double)yPos, (double)zPos);
            boolean flag = true;
            double d0 = 0.0;
            if (flag && level.m_45772_(new AABB(blockpos))) {
                ThunderCloudEntity cloud = new ThunderCloudEntity(level, xPos, (double)blockpos.m_123342_() + d0, zPos);
                cloud.setDelay(warmupDelay);
                cloud.setDespawnDelay(30);
                cloud.setOwner((Entity)this.boss);
                level.m_7967_((Entity)cloud);
            }
        }
    }

    class FlapWindAttackGoal
    extends Goal {
        private final RedDragonBossEntity boss;
        private Direction offsetDir;
        private int ticks;

        public FlapWindAttackGoal() {
            this.boss = RedDragonBossEntity.this;
            this.offsetDir = Direction.NORTH;
            this.offsetDir = this.getRandomDirection();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            boolean base;
            boolean bl = base = this.boss.homePos != null && this.boss.getPylonTime() <= 0 && this.boss.attackCooldown <= 0 && this.boss.attackType == AttackType.WIND && !this.boss.inWall && !this.boss.m_9236_().m_6249_((Entity)this.boss, new AABB(this.boss.homePos).m_82400_(10.0), e -> ATTACKABLE_TARGET.test(this.boss, (Entity)e)).isEmpty();
            if (base) {
                BlockPos homeOffset = this.boss.homePos.m_5484_(this.offsetDir, 30);
                float dist = Mth.m_14116_((float)((float)this.boss.m_20275_(homeOffset.m_123341_(), this.boss.m_20186_(), homeOffset.m_123343_())));
                if (dist <= 5.0f) {
                    return true;
                }
                this.boss.targetVec = this.boss.m_20186_() - 8.0 > (double)homeOffset.m_123342_() ? new Vec3(this.boss.m_20185_(), (double)(homeOffset.m_123342_() + 5), this.boss.m_20189_()) : Vec3.m_82512_((Vec3i)homeOffset.m_6630_(5));
            }
            return false;
        }

        public boolean m_8045_() {
            return this.boss.windBlowAnim.getApexTicks() <= 160;
        }

        public void m_8056_() {
            this.ticks = 0;
            this.boss.windBlowAnim.play();
            this.boss.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_PREPARE_WIND_BLOW, this.boss.m_6121_(), 1.0f);
            this.boss.targetVec = null;
            this.boss.setDragonTarget(null);
        }

        public void m_8037_() {
            if (this.boss.homePos == null) {
                return;
            }
            this.boss.targetVec = null;
            Vec3 pv = Vec3.m_82512_((Vec3i)this.boss.homePos);
            float rotDest = -((float)Mth.m_14136_((double)(pv.m_7096_() - this.boss.m_20185_()), (double)(pv.m_7094_() - this.boss.m_20189_()))) * 57.295776f;
            this.boss.m_146922_(Mth.m_14189_((float)0.2f, (float)this.boss.m_146908_(), (float)rotDest));
            if (this.boss.windBlowAnim.getApexTicks() > 0) {
                this.boss.windBlowAnim.play();
                float boxDistance = 35.0f;
                float boxSize = 35.0f;
                Vector3f boxCenter = new Vector3f(0.0f, 0.0f, boxDistance).rotate((Quaternionfc)Axis.f_252392_.m_252977_(rotDest));
                Vec3 moveVec = this.boss.m_20182_().m_82520_((double)boxCenter.x(), (double)boxCenter.y(), (double)boxCenter.z());
                AABB windBox = AABB.m_82333_((Vec3)moveVec).m_82386_(-0.5, -0.5, -0.5).m_82400_((double)boxSize);
                for (Entity e : this.boss.m_9236_().m_45933_((Entity)this.boss, windBox)) {
                    Player p;
                    double d;
                    boolean sight = this.boss.m_21574_().m_148306_(e);
                    if (e instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)e;
                        d = 1.0 - Mth.m_14008_((double)living.m_21133_(Attributes.f_22278_), (double)0.0, (double)1.0);
                    } else {
                        d = 1.0;
                    }
                    double kb = d;
                    Vec3 motion = moveVec.m_82546_(this.boss.m_20182_()).m_82541_().m_82490_((double)(sight ? 0.2f : 0.04f) * kb);
                    if (e.m_9236_().m_45517_(LightLayer.SKY, e.m_20183_()) < 10 || e.m_5833_() || e instanceof Player && (p = (Player)e).m_7500_()) continue;
                    e.m_20260_(false);
                    if (e instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)e;
                        PacketHandler.sendToClient(new AddClientMotionPacket(motion.m_7096_(), motion.m_7098_(), motion.m_7094_()), player);
                        continue;
                    }
                    e.m_20256_(e.m_20184_().m_82549_(motion));
                }
                if (this.ticks % 40 == 0) {
                    this.boss.m_5496_(RediscoveredSounds.ENTITY_RED_DRAGON_WIND_BLOW, 8.0f, 1.0f);
                }
                ++this.ticks;
            }
        }

        public void m_8041_() {
            this.boss.randomizeAttackType(this.boss.attackType);
            this.boss.windCooldown = 140;
            this.boss.windBlowAnim.stop();
            this.boss.setNewTarget();
            this.boss.thunderCloudCooldown = Math.max(60, this.boss.thunderCloudCooldown);
            this.offsetDir = this.getRandomDirection();
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        private Direction getRandomDirection() {
            return Util.m_214676_(List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST), (RandomSource)this.boss.m_217043_()).orElse(Direction.NORTH);
        }
    }
}

