/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.dragon;

import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.particles.PylonShieldBlastData;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class PylonBurstEntity
extends Projectile {
    @Nullable
    private Entity finalTarget;
    public int timeUntilBlast = 60;
    @Nullable
    private UUID targetId;
    public float speedAddition = 0.0f;

    public PylonBurstEntity(EntityType<? extends PylonBurstEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public PylonBurstEntity(Level pLevel, LivingEntity pShooter, Entity pFinalTarget) {
        this(RediscoveredEntityTypes.PYLON_BURST, pLevel);
        this.m_5602_((Entity)pShooter);
        BlockPos blockpos = pShooter.m_20183_();
        double d0 = (double)blockpos.m_123341_() + 0.5;
        double d1 = (double)blockpos.m_123342_() + 0.5;
        double d2 = (double)blockpos.m_123343_() + 0.5;
        this.m_7678_(d0, d1, d2, this.m_146908_(), this.m_146909_());
        this.finalTarget = pFinalTarget;
        this.m_20242_(true);
    }

    public PylonBurstEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(RediscoveredEntityTypes.PYLON_BURST, world);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.finalTarget != null) {
            pCompound.m_128362_("Target", this.finalTarget.m_20148_());
        }
        pCompound.m_128405_("TimeUntilBlast", this.timeUntilBlast);
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.timeUntilBlast = pCompound.m_128451_("TimeUntilBlast");
        if (pCompound.m_128403_("Target")) {
            this.targetId = pCompound.m_128342_("Target");
        }
    }

    protected void m_8097_() {
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            HitResult hitresult;
            Player possibleNewTarget;
            ServerLevel serverLevel = (ServerLevel)this.m_9236_();
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = serverLevel.m_8791_(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if ((possibleNewTarget = this.m_9236_().m_45930_((Entity)this, 30.0)) != null && possibleNewTarget != this.finalTarget && EntitySelector.f_20406_.and(EntitySelector.f_20403_).test(possibleNewTarget)) {
                this.finalTarget = possibleNewTarget;
            }
            if (!(this.finalTarget == null || !this.finalTarget.m_6084_() || this.finalTarget instanceof Player && this.finalTarget.m_5833_() || this.finalTarget == null)) {
                boolean fresh;
                boolean bl = fresh = this.f_19797_ < 60 + this.m_20148_().hashCode() % 5 * 5;
                if (!fresh) {
                    this.m_20256_(this.m_20184_().m_82490_((double)0.9f).m_82549_(this.finalTarget.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_((double)(0.04f + this.speedAddition))));
                }
                if (this.m_20270_(this.finalTarget) <= 6.0f) {
                    this.playExplosionEffect(serverLevel);
                    for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(5.0), EntitySelector.f_20403_.and(EntitySelector.f_20406_))) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity living = (LivingEntity)entity;
                        this.m_6532_((HitResult)new EntityHitResult((Entity)living));
                    }
                    this.m_146870_();
                }
            }
            if ((hitresult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            if (this.timeUntilBlast > 0) {
                --this.timeUntilBlast;
            } else {
                this.playExplosionEffect(serverLevel);
                this.m_146870_();
            }
        }
        this.m_20101_();
        Vec3 vec31 = this.m_20184_();
        this.m_6034_(this.m_20185_() + vec31.f_82479_, this.m_20186_() + vec31.f_82480_, this.m_20189_() + vec31.f_82481_);
        ProjectileUtil.m_37284_((Entity)this, (float)0.5f);
        if (this.m_9236_().m_5776_() && this.f_19796_.m_188501_() < 0.5f) {
            float offset = 1.2f;
            this.m_9236_().m_6485_((ParticleOptions)ParticleTypes.f_123810_, true, this.m_20208_(offset), this.m_20187_(), this.m_20262_(offset), 0.0, 0.0, 0.0);
        }
    }

    public void playExplosionEffect(ServerLevel serverLevel) {
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.2, 0.2, 0.2, 0.4);
        serverLevel.m_8767_((ParticleOptions)new PylonShieldBlastData(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        this.m_216990_(RediscoveredSounds.ENTITY_PYLON_BURST_EXPLODE);
        this.m_5496_(SoundEvents.f_11913_, 0.2f, 1.5f);
    }

    protected boolean m_5603_(Entity hit) {
        return super.m_5603_(hit) && !hit.f_19794_ && !hit.m_7306_(this.m_19749_());
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected void m_5790_(EntityHitResult pResult) {
        boolean flag;
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        Entity entity1 = this.m_19749_();
        LivingEntity livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
        boolean bl = flag = entity == entity1 ? false : entity.m_6469_(this.m_269291_().m_269036_((Entity)this, (Entity)livingentity), 8.0f);
        if (flag) {
            this.m_19970_(livingentity, entity);
            if (entity instanceof LivingEntity) {
                // empty if block
            }
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        this.m_5496_(RediscoveredSounds.ENTITY_PYLON_BURST_EXPLODE, 1.0f, 1.0f);
    }

    private void destroy() {
        this.m_146870_();
        this.m_9236_().m_214171_(GameEvent.f_223706_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        this.destroy();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_9236_().m_5776_()) {
            this.m_5496_(RediscoveredSounds.ENTITY_PYLON_BURST_DESTROYED, 1.0f, 1.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.destroy();
        }
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

