/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.dragon;

import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.particles.PylonShieldBlastData;
import com.legacy.rediscovered.entity.dragon.RedDragonBossEntity;
import com.legacy.rediscovered.mixin.ClientLevelAccessor;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredPoiTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class DragonPylonEntity
extends LivingEntity {
    private static final EntityDataAccessor<Integer> LAYERS = SynchedEntityData.m_135353_(DragonPylonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> ATTACHED_DRAGON_UUID = SynchedEntityData.m_135353_(DragonPylonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public List<BlockPos> miniPylons = new ArrayList<BlockPos>();
    public int time;
    public boolean forceLayerUpdate;
    static final String DRAGON_KEY = "AttachedDragonUUID";
    static final String LAYERS_KEY = "Layers";
    @Nullable
    private RedDragonBossEntity clientDragonCache;

    public DragonPylonEntity(EntityType<? extends DragonPylonEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19850_ = true;
        this.time = this.f_19796_.m_188503_(100000);
    }

    public DragonPylonEntity(Level pLevel, double pX, double pY, double pZ) {
        this(RediscoveredEntityTypes.DRAGON_PYLON, pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    public DragonPylonEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(RediscoveredEntityTypes.DRAGON_PYLON, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 100.0);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LAYERS, (Object)0);
        this.m_20088_().m_135372_(ATTACHED_DRAGON_UUID, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.time;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            RedDragonBossEntity dragon;
            Optional<UUID> uuid;
            ServerLevel sl = (ServerLevel)level;
            if (this.getAttachedDragonUUID().isEmpty() && this.f_19797_ % 40 == 0 && (uuid = sl.m_45976_(RedDragonBossEntity.class, this.m_20191_().m_82377_(70.0, 80.0, 70.0)).stream().filter(e -> !e.m_213877_()).findFirst().map(e -> e.m_20148_())).isPresent()) {
                this.setAttachedDragonUUID(uuid.get());
            }
            if ((dragon = this.getAttachedDragon()) != null) {
                dragon.setPylonTime(20);
            }
            if (this.f_19797_ < 10 || this.f_19797_ % 100 == 0 || this.forceLayerUpdate) {
                int radius = 45;
                BlockPos startPos = this.m_20183_().m_6625_(15);
                PoiManager pointofinterestmanager = sl.m_8904_();
                pointofinterestmanager.m_27056_((LevelReader)sl, startPos, radius);
                this.miniPylons = sl.m_8904_().m_27166_(poiType -> poiType.m_203565_(RediscoveredPoiTypes.MINI_DRAGON_PYLON.getKey()), startPos, radius, PoiManager.Occupancy.ANY).map(record -> record.m_27257_()).toList();
                int currentCount = this.getLayerCount();
                this.setLayerCount(Math.min(this.miniPylons.size(), 4));
                if (this.getLayerCount() < currentCount) {
                    this.m_5496_(RediscoveredSounds.ENTITY_DRAGON_PYLON_SHIELD_LOST, 2.0f, 1.0f);
                    for (ServerPlayer player : sl.m_6907_()) {
                        sl.m_8624_(player, (ParticleOptions)new PylonShieldBlastData(30, 5.0f, 50.0f, 1.0f, 0.0f), true, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                this.forceLayerUpdate = false;
            }
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        if (this.getAttachedDragonUUID().isPresent()) {
            pCompound.m_128362_(DRAGON_KEY, this.getAttachedDragonUUID().get());
        }
        pCompound.m_128405_(LAYERS_KEY, this.getLayerCount());
    }

    public void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_(DRAGON_KEY)) {
            this.setAttachedDragonUUID(pCompound.m_128342_(DRAGON_KEY));
        }
        this.setLayerCount(pCompound.m_128451_(LAYERS_KEY));
    }

    public boolean m_6087_() {
        return true;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof RedDragonBossEntity) {
            return false;
        }
        if (this.getLayerCount() <= 0 && (pSource.m_7639_() instanceof Player || pSource.m_269533_(DamageTypeTags.f_268738_))) {
            return super.m_6469_(pSource, pAmount);
        }
        return false;
    }

    public void m_6074_() {
        this.setLayerCount(0);
        super.m_6074_();
    }

    public void setLayerCount(int layers) {
        this.m_20088_().m_135381_(LAYERS, (Object)layers);
    }

    public int getLayerCount() {
        return (Integer)this.m_20088_().m_135370_(LAYERS);
    }

    public Optional<UUID> getAttachedDragonUUID() {
        return (Optional)this.f_19804_.m_135370_(ATTACHED_DRAGON_UUID);
    }

    public void setAttachedDragonUUID(UUID id) {
        this.f_19804_.m_135381_(ATTACHED_DRAGON_UUID, Optional.of(id));
    }

    @Nullable
    public RedDragonBossEntity getAttachedDragon() {
        if (this.getAttachedDragonUUID().isPresent()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                return (RedDragonBossEntity)level2.m_8791_(this.getAttachedDragonUUID().get());
            }
            level = this.m_9236_();
            if (level instanceof ClientLevel) {
                ClientLevel level3 = (ClientLevel)level;
                if (this.clientDragonCache != null && this.clientDragonCache.m_213877_()) {
                    this.clientDragonCache = null;
                }
                if (this.clientDragonCache == null) {
                    this.clientDragonCache = (RedDragonBossEntity)((ClientLevelAccessor)level3).invokeGetEntities().m_142694_(this.getAttachedDragonUUID().get());
                }
                return this.clientDragonCache;
            }
        }
        return null;
    }

    public boolean m_6783_(double pDistance) {
        return super.m_6783_(pDistance) || this.getAttachedDragonUUID().isPresent();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Iterable<ItemStack> m_6167_() {
        return List.of();
    }

    public Iterable<ItemStack> m_6168_() {
        return List.of();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() == MobEffects.f_19619_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return RediscoveredSounds.ENTITY_DRAGON_PYLON_HURT;
    }

    protected SoundEvent m_5592_() {
        return RediscoveredSounds.ENTITY_DRAGON_PYLON_DEATH;
    }
}

