/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.dragon;

import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.entity.util.RedDragonEntityPart;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRedDragonEntity
extends TamableAnimal {
    public Vec3 targetVec;
    public double[][] positions = new double[64][3];
    public int posPointer = -1;
    @Nullable
    protected final PartEntity<AbstractRedDragonEntity>[] subEntities;
    protected RedDragonEntityPart head;
    protected RedDragonEntityPart neck;
    protected RedDragonEntityPart body;
    protected RedDragonEntityPart tail1;
    protected RedDragonEntityPart tail2;
    protected RedDragonEntityPart tail3;
    protected RedDragonEntityPart rightWing;
    protected RedDragonEntityPart leftWing;
    public float prevAnimTime = 0.0f;
    public float animTime = 0.0f;
    public boolean forceNewTarget = false;
    public boolean angry = false;
    public boolean renderTailSpike = false;
    public boolean inWall = false;
    private Entity target;
    public float yRotA = 0.0f;
    public BlockPos homePos;

    public AbstractRedDragonEntity(EntityType<? extends AbstractRedDragonEntity> type, Level level) {
        super(type, level);
        this.m_21153_(this.m_21233_());
        if (this.isMultipartEntity()) {
            this.head = new RedDragonEntityPart(this, "head", 1.0f, 1.0f);
            this.neck = new RedDragonEntityPart(this, "neck", 3.0f, 3.0f);
            this.body = new RedDragonEntityPart(this, "body", 5.0f, 3.0f);
            this.tail1 = new RedDragonEntityPart(this, "tail1", 2.0f, 2.0f);
            this.tail2 = new RedDragonEntityPart(this, "tail2", 2.0f, 2.0f);
            this.tail3 = new RedDragonEntityPart(this, "tail3", 2.0f, 2.0f);
            this.rightWing = new RedDragonEntityPart(this, "right_wing", 4.0f, 2.0f);
            this.leftWing = new RedDragonEntityPart(this, "left_wing", 4.0f, 2.0f);
            this.subEntities = new RedDragonEntityPart[]{this.head, this.neck, this.body, this.tail1, this.tail2, this.tail3, this.rightWing, this.leftWing};
            this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
        } else {
            this.subEntities = new RedDragonEntityPart[0];
        }
        this.f_19811_ = true;
    }

    public void m_20234_(int pId) {
        super.m_20234_(pId);
        if (this.isMultipartEntity()) {
            for (int i = 0; i < this.subEntities.length; ++i) {
                this.subEntities[i].m_20234_(pId + i + 1);
            }
        }
    }

    public static AttributeSupplier.Builder createDragonAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_8099_() {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public double[] getLatencyPos(int bufferIndexOffset, float partialTicks) {
        if (this.m_21224_() && !this.canPathfind()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.posPointer - bufferIndexOffset & 0x3F;
        int j = this.posPointer - bufferIndexOffset - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.positions[i][0];
        double d1 = Mth.m_14175_((double)(this.positions[j][0] - d0));
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.positions[i][1];
        d1 = this.positions[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)partialTicks, (double)this.positions[i][2], (double)this.positions[j][2]);
        return adouble;
    }

    protected boolean useNormalAI() {
        return false;
    }

    protected void playFlapSound() {
        if (!this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), RediscoveredSounds.ENTITY_RED_DRAGON_FLAP, this.m_5720_(), this.m_6121_(), 0.8f + this.f_19796_.m_188501_() * 0.3f, false);
        }
    }

    public boolean isFlying() {
        return true;
    }

    public void m_8107_() {
        if (this.useNormalAI()) {
            super.m_8107_();
        } else if (this.m_21515_() && this.m_6084_()) {
            this.m_9236_().m_46473_().m_6180_("sensing");
            this.m_21574_().m_26789_();
            this.m_9236_().m_46473_().m_7238_();
            int i = this.m_9236_().m_7654_().m_129921_() + this.m_19879_();
            if (i % 2 != 0 && this.f_19797_ > 1) {
                this.m_9236_().m_46473_().m_6180_("targetSelector");
                this.f_21346_.m_186081_(false);
                this.m_9236_().m_46473_().m_7238_();
                this.m_9236_().m_46473_().m_6180_("goalSelector");
                this.f_21345_.m_186081_(false);
                this.m_9236_().m_46473_().m_7238_();
            } else {
                this.m_9236_().m_46473_().m_6180_("targetSelector");
                this.f_21346_.m_25373_();
                this.m_9236_().m_46473_().m_7238_();
                this.m_9236_().m_46473_().m_6180_("goalSelector");
                this.f_21345_.m_25373_();
                this.m_9236_().m_46473_().m_7238_();
            }
        }
        if (this.m_9236_().m_5776_()) {
            float wingSin = Mth.m_14089_((float)(this.animTime * (float)Math.PI * 2.0f));
            float wingSinOld = Mth.m_14089_((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (wingSinOld <= -0.3f && wingSin >= -0.3f) {
                this.playFlapSound();
            }
        }
        this.prevAnimTime = this.animTime;
        if (this.canPathfind()) {
            Vec3 vec34 = this.m_20184_();
            float f9 = 0.2f / ((float)vec34.m_165924_() * 10.0f + 1.0f);
            this.animTime += this.getFlapSpeed(f9 *= (float)Math.pow(2.0, vec34.f_82480_));
            this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
            if (this.m_21525_()) {
                this.animTime = 0.5f;
            } else {
                if (this.posPointer < 0) {
                    for (int i = 0; i < this.positions.length; ++i) {
                        this.positions[i][0] = this.m_146908_();
                        this.positions[i][1] = this.m_20186_();
                    }
                }
                if (++this.posPointer == this.positions.length) {
                    this.posPointer = 0;
                }
                this.positions[this.posPointer][0] = this.m_146908_();
                this.positions[this.posPointer][1] = this.m_20186_();
                if (this.m_9236_().m_5776_()) {
                    if (this.f_20903_ > 0 && !this.useNormalAI()) {
                        double d7 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
                        double d0 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
                        double d1 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
                        double d2 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
                        this.m_146922_((float)((double)this.m_146908_() + d2 / (double)this.f_20903_));
                        this.m_146926_((float)((double)this.m_146909_() + (this.f_20908_ - (double)this.m_146909_()) / (double)this.f_20903_));
                        --this.f_20903_;
                        this.m_6034_(d7, d0, d1);
                        this.m_19915_(this.m_146908_(), this.m_146909_());
                    }
                } else {
                    Vec3 vec3 = this.targetVec;
                    if (vec3 != null) {
                        double d7 = vec3.f_82479_ - this.m_20185_();
                        double d8 = vec3.f_82480_ - this.m_20186_();
                        double d9 = vec3.f_82481_ - this.m_20189_();
                        double d3 = d7 * d7 + d8 * d8 + d9 * d9;
                        float flySpeed = this instanceof OwnableEntity ? 25.0f : 10.0f;
                        double d4 = Math.sqrt(d7 * d7 + d9 * d9);
                        if (d4 > 0.0) {
                            d8 = Mth.m_14008_((double)(d8 / d4), (double)(-flySpeed), (double)flySpeed);
                        }
                        this.m_20256_(this.m_20184_().m_82520_(0.0, d8 * 0.01, 0.0));
                        this.m_146922_(Mth.m_14177_((float)this.m_146908_()));
                        Vec3 vec31 = vec3.m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82541_();
                        Vec3 vec32 = new Vec3((double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), this.m_20184_().f_82480_, (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))))).m_82541_();
                        float f5 = Math.max(((float)vec32.m_82526_(vec31) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d7) > (double)1.0E-5f || Math.abs(d9) > (double)1.0E-5f) {
                            float rotDest = -((float)Mth.m_14136_((double)d7, (double)d9)) * 57.295776f;
                            float maxDelta = 50.0f;
                            float diff = Mth.m_14118_((float)this.m_146908_(), (float)rotDest);
                            float addition = Mth.m_14036_((float)diff, (float)(-maxDelta), (float)maxDelta);
                            float newDegrees = Mth.m_14189_((float)(this.getTurnSpeed() * 0.5f), (float)this.m_146908_(), (float)Mth.m_14177_((float)(this.m_146908_() + addition)));
                            this.m_146922_(Mth.m_14177_((float)newDegrees));
                        }
                        float f19 = (float)(2.0 / (d3 + 1.0));
                        this.m_19920_(0.06f * (f5 * f19 + (1.0f - f19)), new Vec3(0.0, 0.0, -1.0));
                        this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_(this.inWall ? (double)0.8f : 1.0).m_82542_(-1.0, 1.0, -1.0));
                        Vec3 vec33 = this.m_20184_().m_82541_();
                        double d5 = 0.8 + 0.15 * (vec33.m_82526_(vec32) + 1.0) / 2.0;
                        this.m_20256_(this.m_20184_().m_82542_(d5, (double)0.91f, d5));
                        double d101 = this.targetVec.m_7096_() - this.m_20185_();
                        double d0 = this.targetVec.m_7098_() - this.m_20186_();
                        double d1 = this.targetVec.m_7094_() - this.m_20189_();
                        double d2 = d101 * d101 + d0 * d0 + d1 * d1;
                        if (this.forceNewTarget || this.shouldEnforcedFlyingDistanceLimit() && (d2 < 100.0 || d2 > 22500.0)) {
                            this.targetVec = null;
                            this.forceNewTarget = false;
                            this.setNewTarget();
                        }
                    }
                    if (this.m_20197_().isEmpty()) {
                        if (this.getDragonTarget() != null) {
                            double d51;
                            this.targetVec = this.getDragonTarget().m_20182_();
                            double d31 = this.targetVec.m_7096_() - this.m_20185_();
                            double d7 = Math.sqrt(d31 * d31 + (d51 = this.targetVec.m_7094_() - this.m_20189_()) * d51);
                            double d81 = (double)0.4f + d7 / 80.0 - 1.0;
                            if (d81 > 10.0) {
                                d81 = 10.0;
                            }
                            this.targetVec = this.targetVec.m_193103_(Direction.Axis.Y, this.getDragonTarget().m_20186_() - 2.0);
                        } else if (this.targetVec != null) {
                            this.targetVec = this.targetVec.m_82520_(this.f_19796_.m_188583_() * 2.0, 0.0, this.f_19796_.m_188583_() * 2.0);
                        }
                    }
                }
                if (!this.m_20160_() && this.isFlying()) {
                    this.f_20883_ = this.m_146908_();
                }
                Vec3[] avec3 = this.subEntities != null && this.subEntities.length > 0 ? new Vec3[this.subEntities.length] : new Vec3[]{};
                for (int j = 0; j < this.subEntities.length; ++j) {
                    avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
                }
                float f12 = (float)(this.getLatencyPos(5, 1.0f)[1] - this.getLatencyPos(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
                float f13 = Mth.m_14089_((float)f12);
                float f = Mth.m_14031_((float)f12);
                float f14 = this.m_146908_() * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f14);
                float f15 = Mth.m_14089_((float)f14);
                this.tickPart(this.body, f1 * 0.5f, 0.0, -f15 * 0.5f);
                this.tickPart(this.rightWing, f15 * 4.5f, 2.0, f1 * 4.5f);
                this.tickPart(this.leftWing, f15 * -4.5f, 2.0, f1 * -4.5f);
                if (!this.m_9236_().m_5776_() && this.f_20916_ == 0 && this.isMultipartEntity()) {
                    this.knockBack(this.m_9236_().m_6249_((Entity)this, this.rightWing.m_20191_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
                    this.knockBack(this.m_9236_().m_6249_((Entity)this, this.leftWing.m_20191_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
                    this.hurt(this.m_9236_().m_6249_((Entity)this, this.head.m_20191_().m_82400_(1.0), EntitySelector.f_20406_));
                    this.hurt(this.m_9236_().m_6249_((Entity)this, this.neck.m_20191_().m_82400_(1.0), EntitySelector.f_20406_));
                }
                float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f16 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180) - this.yRotA * 0.01f));
                float f3 = this.getHeadYOffset();
                this.tickPart(this.head, f2 * 6.5f * f13, f3 + f * 6.5f, -f16 * 6.5f * f13);
                this.tickPart(this.neck, f2 * 5.5f * f13, f3 + f * 5.5f, -f16 * 5.5f * f13);
                double[] adouble = this.getLatencyPos(5, 1.0f);
                for (int k = 0; k < 3; ++k) {
                    RedDragonEntityPart tailPiece = null;
                    if (k == 0) {
                        tailPiece = this.tail1;
                    }
                    if (k == 1) {
                        tailPiece = this.tail2;
                    }
                    if (k == 2) {
                        tailPiece = this.tail3;
                    }
                    double[] adouble1 = this.getLatencyPos(12 + k * 2, 1.0f);
                    float f17 = this.m_146908_() * ((float)Math.PI / 180) + (float)Mth.m_14175_((double)(adouble1[0] - adouble[0])) * ((float)Math.PI / 180);
                    float f18 = Mth.m_14031_((float)f17);
                    float f20 = Mth.m_14089_((float)f17);
                    float f21 = 1.5f;
                    float f22 = (float)(k + 1) * 2.0f;
                    this.tickPart(tailPiece, -(f1 * f21 + f18 * f22) * f13, adouble1[1] - adouble[1] - (double)((f22 + f21) * f) + (double)f21, (f15 * f21 + f20 * f22) * f13);
                }
                if (!this.m_9236_().m_5776_()) {
                    this.inWall = this.head != null && this.destroyBlocksInAABB(this.head.m_20191_()) || this.body != null && this.destroyBlocksInAABB(this.body.m_20191_());
                }
                for (int l = 0; l < this.subEntities.length; ++l) {
                    this.subEntities[l].f_19854_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19855_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19856_ = avec3[l].f_82481_;
                    this.subEntities[l].f_19790_ = avec3[l].f_82479_;
                    this.subEntities[l].f_19791_ = avec3[l].f_82480_;
                    this.subEntities[l].f_19792_ = avec3[l].f_82481_;
                }
            }
            float amount = (float)Math.sin((float)this.f_19797_ / 200.0f) * 0.1f;
            if (this.isFlying()) {
                this.m_5618_(this.m_146908_());
            }
            this.forceDragonHeadRot();
        }
    }

    protected boolean shouldEnforcedFlyingDistanceLimit() {
        return true;
    }

    protected void forceDragonHeadRot() {
        this.m_5616_(this.m_146908_());
    }

    public float getFlapSpeed(float motion) {
        if (this.m_21224_()) {
            return 0.13f;
        }
        if (motion > 0.1f) {
            return 0.1f;
        }
        if (this.inWall) {
            return motion * 0.5f;
        }
        return motion;
    }

    private void tickPart(RedDragonEntityPart pPart, double pOffsetX, double pOffsetY, double pOffsetZ) {
        if (this.isMultipartEntity() && pPart != null) {
            pPart.m_6034_(this.m_20185_() + -pOffsetX, this.m_20186_() + pOffsetY, this.m_20189_() + -pOffsetZ);
        }
    }

    private float getHeadYOffset() {
        double[] adouble = this.getLatencyPos(5, 1.0f);
        double[] adouble1 = this.getLatencyPos(0, 1.0f);
        return (float)(adouble[1] - adouble1[1]);
    }

    protected boolean canPathfind() {
        return !this.m_21224_();
    }

    public float getTurnSpeed() {
        float f = (float)this.m_20184_().m_165924_() + 1.0f;
        float f1 = Math.min(f, 40.0f);
        return 0.7f / f1 / f;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public double m_6048_() {
        double offset = this.m_20184_().m_7098_() < 0.0 ? this.m_20184_().m_7098_() - this.m_20184_().m_7098_() * 2.0 : this.m_20184_().m_7098_();
        return Math.min(3.3, 3.0 + offset);
    }

    private void knockBack(List<Entity> pEntities) {
        double d0 = (this.body.m_20191_().f_82288_ + this.body.m_20191_().f_82291_) / 2.0;
        double d1 = (this.body.m_20191_().f_82290_ + this.body.m_20191_().f_82293_) / 2.0;
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            double d2 = entity.m_20185_() - d0;
            double d3 = entity.m_20189_() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.m_5997_(d2 / d4 * 4.0, (double)0.2f, d3 / d4 * 4.0);
            if (living.m_21213_() >= entity.f_19797_ - 2) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 5.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    private void hurt(List<Entity> pEntities) {
        for (Entity entity : pEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 10.0f);
            this.m_19970_((LivingEntity)this, entity);
        }
    }

    protected void setNewTarget() {
        double d2;
        double d1;
        Vec3 vec;
        double d0;
        boolean flag = false;
        do {
            Vec3 startVec = this.wanderCenterVector();
            this.targetVec = new Vec3(startVec.m_7096_() + (double)(this.f_19796_.m_188501_() * this.maxHorizontalWanderDistance() - this.f_19796_.m_188501_() * this.maxHorizontalWanderDistance()), startVec.m_7098_() + (double)this.verticalWanderDistance(), startVec.m_7094_() + (double)(this.f_19796_.m_188501_() * this.maxHorizontalWanderDistance() - this.f_19796_.m_188501_() * this.maxHorizontalWanderDistance()));
        } while (!(flag = (d0 = (vec = this.m_20182_()).m_7096_() - this.targetVec.m_7096_()) * d0 + (d1 = vec.m_7098_() - this.targetVec.m_7098_()) * d1 + (d2 = vec.m_7094_() - this.targetVec.m_7094_()) * d2 > 100.0));
        this.setDragonTarget(null);
    }

    public float maxHorizontalWanderDistance() {
        return 120.0f;
    }

    public float verticalWanderDistance() {
        return this.f_19796_.m_188501_() * 50.0f;
    }

    public Vec3 wanderCenterVector() {
        return this.homePos != null ? Vec3.m_82512_((Vec3i)this.homePos).m_82520_(0.0, 30.0, 0.0) : new Vec3(this.m_20185_(), 70.0, this.m_20189_());
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction pCallback) {
        if (this.m_20363_(passenger)) {
            pCallback.m_20372_(passenger, this.m_20185_(), this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_());
        }
    }

    private boolean destroyBlocksInAABB(AABB bounds) {
        boolean flag = false;
        boolean flag1 = false;
        if (this.m_9236_().m_186437_((Entity)this, bounds)) {
            flag = true;
        }
        if (flag1) {
            double d1 = bounds.f_82288_ + (bounds.f_82291_ - bounds.f_82288_) * (double)this.f_19796_.m_188501_();
            double d2 = bounds.f_82289_ + (bounds.f_82292_ - bounds.f_82289_) * (double)this.f_19796_.m_188501_();
            double d0 = bounds.f_82290_ + (bounds.f_82293_ - bounds.f_82290_) * (double)this.f_19796_.m_188501_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, d1, d2, d0, 0.0, 0.0, 0.0);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_20197_().isEmpty() && this.m_20197_().contains(source.m_7639_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
    }

    protected void m_6153_() {
        super.m_6153_();
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    @Nullable
    public PartEntity<AbstractRedDragonEntity>[] getParts() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public boolean m_6087_() {
        return !this.isMultipartEntity();
    }

    public float m_21692_(BlockPos pos) {
        return (float)this.m_9236_().m_46803_(pos) - 0.5f;
    }

    protected SoundEvent m_7515_() {
        return RediscoveredSounds.ENTITY_RED_DRAGON_IDLE;
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_9236_().m_6269_(null, (Entity)this, soundevent, this.m_5720_(), this.m_6121_(), this.m_6100_());
        }
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RediscoveredSounds.ENTITY_RED_DRAGON_HURT;
    }

    protected float m_6121_() {
        return 6.0f;
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageable) {
        return null;
    }

    public Entity getDragonTarget() {
        return this.target;
    }

    public void setDragonTarget(Entity target) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.target = target;
    }

    public void m_6074_() {
        this.m_146870_();
    }

    protected boolean shouldResetYawVelocity() {
        return false;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return RediscoveredBlocks.red_dragon_egg.m_5456_().m_7968_();
    }
}

