/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity.ai;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public abstract class SearchForPoiGoal<T extends Mob>
extends Goal {
    protected final T mob;
    protected final Function<T, BlockPos> start;
    protected final Predicate<Holder<PoiType>> poi;
    protected final int radius;
    protected final int checkDelay;
    protected final int delayOffset;
    protected int currentDelay;
    @Nullable
    protected BlockPos foundPos;
    public boolean actionComplete;

    public SearchForPoiGoal(T mob, Function<T, BlockPos> start, Predicate<Holder<PoiType>> poi, int radius, int checkDelay, int delayOffset) {
        this.mob = mob;
        this.start = start;
        this.poi = poi;
        this.radius = radius;
        this.checkDelay = checkDelay / 2;
        this.delayOffset = delayOffset;
    }

    public SearchForPoiGoal(T mob, Function<T, BlockPos> start, ResourceKey<PoiType> poi, int radius, int checkDelay, int delayOffset) {
        this(mob, start, (Holder<PoiType> p) -> p.m_203565_(poi), radius, checkDelay, delayOffset);
    }

    public SearchForPoiGoal(T mob, Function<T, BlockPos> start, ResourceKey<PoiType> poi, int radius, int checkDelay) {
        this(mob, start, (Holder<PoiType> p) -> p.m_203565_(poi), radius, checkDelay, 0);
    }

    public SearchForPoiGoal<T> setMovementFlags() {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        return this;
    }

    public boolean m_8036_() {
        return --this.currentDelay <= 0;
    }

    public boolean m_8045_() {
        return this.foundPos != null && !this.actionComplete;
    }

    public void m_8056_() {
        BlockPos start = this.start.apply(this.mob);
        Stream<PoiRecord> poi = this.getPoisInCircle(this.mob.m_9236_(), start, this.poi, this.radius).sorted(Comparator.comparingDouble(record -> record.m_27257_().m_123331_((Vec3i)start))).filter(this.poiFilter());
        Optional<PoiRecord> optional = poi.findFirst();
        if (optional.isPresent()) {
            this.foundPos = optional.get().m_27257_();
            this.onPoiFound(this.foundPos);
        }
    }

    public void m_8037_() {
        if (this.foundPos != null) {
            this.tickFound(this.foundPos);
        }
    }

    public void m_8041_() {
        this.resetDelay();
        if (this.foundPos == null) {
            this.onPoiNotFound();
        }
        this.foundPos = null;
        this.actionComplete = false;
    }

    public boolean m_183429_() {
        return false;
    }

    public abstract void onPoiFound(BlockPos var1);

    public void tickFound(BlockPos pos) {
    }

    public void onPoiNotFound() {
    }

    protected final void finish() {
        this.actionComplete = true;
    }

    protected final void resetDelay() {
        this.currentDelay = this.delayOffset <= 0 ? this.checkDelay : this.checkDelay + this.mob.m_217043_().m_188503_(this.delayOffset);
    }

    public Predicate<PoiRecord> poiFilter() {
        return record -> true;
    }

    protected final float distanceTo() {
        return Mth.m_14116_((float)((float)this.mob.m_20238_(Vec3.m_82512_((Vec3i)this.foundPos))));
    }

    protected final float distanceToBottom() {
        return Mth.m_14116_((float)((float)this.mob.m_20238_(Vec3.m_82539_((Vec3i)this.foundPos))));
    }

    protected PoiManager.Occupancy getOccupancyType() {
        return PoiManager.Occupancy.ANY;
    }

    public Stream<PoiRecord> getPoisInCircle(Entity entity, Predicate<Holder<PoiType>> type, int radius) {
        return this.getPoisInCircle(entity.m_9236_(), entity.m_20183_(), type, radius);
    }

    public Stream<PoiRecord> getPoisInCircle(Level level, BlockPos startPos, Predicate<Holder<PoiType>> type, int radius) {
        if (!(level instanceof ServerLevel)) {
            return Stream.empty();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PoiManager poiManager = serverLevel.m_8904_();
        poiManager.m_27056_((LevelReader)level, startPos, radius);
        Stream stream = serverLevel.m_8904_().m_27181_(type, startPos, radius, this.getOccupancyType());
        return stream;
    }
}

