/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.entity.pigman.GuardPigmanEntity;
import com.legacy.rediscovered.entity.pigman.PigmanEntity;
import com.legacy.rediscovered.entity.pigman.data.PigmanData;
import com.legacy.rediscovered.entity.util.IPigman;
import com.legacy.rediscovered.entity.util.IPigmanDataHolder;
import com.legacy.rediscovered.registry.RediscoveredDataSerialization;
import com.legacy.rediscovered.registry.RediscoveredTriggers;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.Logger;

public class ZombiePigmanEntity
extends ZombifiedPiglin
implements IPigmanDataHolder {
    protected static final EntityDataAccessor<PigmanData> PIGMAN_DATA = SynchedEntityData.m_135353_(ZombiePigmanEntity.class, RediscoveredDataSerialization.PIGMAN_DATA);
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.m_135353_(ZombiePigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> CONVERSION_TYPE = SynchedEntityData.m_135353_(ZombiePigmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int conversionTime;
    private UUID converstionStarter;
    @Nullable
    public CompoundTag tradeOffers;
    public int traderXp;
    private static final String CONVERSION_PLAYER_KEY = "ConversionPlayer";
    private static final String CONVERSION_TIME_KEY = "ConversionTime";
    private static final String CONVERSION_TYPE_KEY = "ConversionType";
    private static final String TRADER_XP_KEY = "Xp";
    private static final String TRADER_OFFERS_KEY = "Offers";

    public ZombiePigmanEntity(EntityType<? extends ZombiePigmanEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CONVERTING, (Object)false);
        this.f_19804_.m_135372_(CONVERSION_TYPE, (Object)0);
        this.f_19804_.m_135372_(PIGMAN_DATA, (Object)new PigmanData(PigmanData.Profession.NONE, 1));
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        if (this.getConversionType() > 0) {
            return;
        }
        this.m_8061_(EquipmentSlot.MAINHAND, Items.f_42383_.m_7968_());
    }

    protected void m_213946_(RandomSource random, DifficultyInstance difficulty) {
        if (this.getConversionType() > 0) {
            return;
        }
        super.m_213946_(random, difficulty);
    }

    protected void m_8024_() {
        Level level;
        super.m_8024_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.isConverting() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = this.getConversionProgress();
            this.conversionTime -= i;
            if (this.conversionTime <= 0) {
                this.finishCure(serverLevel);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        PigmanData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getPigmanData()).resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(data -> compound.m_128365_("PigmanData", data));
        if (this.tradeOffers != null) {
            compound.m_128365_(TRADER_OFFERS_KEY, (Tag)this.tradeOffers);
        }
        compound.m_128405_(TRADER_XP_KEY, this.traderXp);
        compound.m_128344_(CONVERSION_TYPE_KEY, this.getConversionType());
        compound.m_128405_(CONVERSION_TIME_KEY, this.isConverting() ? this.conversionTime : -1);
        if (this.converstionStarter != null) {
            compound.m_128362_(CONVERSION_PLAYER_KEY, this.converstionStarter);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("PigmanData", 10)) {
            DataResult dataresult = PigmanData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("PigmanData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)RediscoveredMod.LOGGER).error(arg_0)).ifPresent(this::setPigmanData);
        }
        if (compound.m_128425_(TRADER_OFFERS_KEY, 10)) {
            this.tradeOffers = compound.m_128469_(TRADER_OFFERS_KEY);
        }
        if (compound.m_128425_(TRADER_XP_KEY, 3)) {
            this.traderXp = compound.m_128451_(TRADER_XP_KEY);
        }
        this.setConversionType(compound.m_128445_(CONVERSION_TYPE_KEY));
        if (compound.m_128425_(CONVERSION_TIME_KEY, 99) && compound.m_128451_(CONVERSION_TIME_KEY) > -1) {
            this.startConverting(compound.m_128403_(CONVERSION_PLAYER_KEY) ? compound.m_128342_(CONVERSION_PLAYER_KEY) : null, compound.m_128451_(CONVERSION_TIME_KEY));
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack playerItem = player.m_21120_(hand);
        if (this.m_21023_(MobEffects.f_19613_) && playerItem.m_150930_(Items.f_42677_)) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            this.startConverting(player.m_20148_(), this.m_9236_().m_213780_().m_188503_(2400) + 3600);
            if (!this.m_20067_()) {
                this.m_5496_(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_CURE, 1.0f + this.m_9236_().m_213780_().m_188501_(), this.m_9236_().m_213780_().m_188501_() * 0.7f + 0.3f);
            }
            if (!player.m_7500_()) {
                playerItem.m_41774_(1);
            }
            if (this.m_21519_(EquipmentSlot.MAINHAND) < 1.0f) {
                this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isConverting() && this.isApplicableConversionItem(playerItem)) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.trySetConversionType(playerItem)) {
                this.m_21468_(EquipmentSlot.MAINHAND, playerItem.m_255036_(1));
                if (!player.m_7500_()) {
                    playerItem.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(CONVERTING);
    }

    public int getConversionTime() {
        return this.conversionTime;
    }

    public int getConversionProgress() {
        int i = 1;
        if (this.m_9236_().m_213780_().m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.m_20189_() - 4; i1 < (int)this.m_20189_() + 4 && j < 14; ++i1) {
                        Block block = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k, l, i1)).m_60734_();
                        if (block != Blocks.f_50183_ && !(block instanceof BedBlock)) continue;
                        if (this.m_9236_().m_213780_().m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    protected boolean m_8028_() {
        return IPigman.Type.get(this.getConversionType()) == IPigman.Type.UNASSIGNED;
    }

    protected SoundEvent m_7515_() {
        return this.m_21660_() ? RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_ANGRY : RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_HURT;
    }

    protected SoundEvent m_5592_() {
        return RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_DEATH;
    }

    public void m_34476_() {
        this.m_5496_(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_ANGRY, this.m_6121_() * 2.0f, this.m_6100_() * 1.8f);
    }

    public void setPigmanData(PigmanData data) {
        PigmanData currentData = this.getPigmanData();
        if (currentData.getProfession() != data.getProfession()) {
            this.tradeOffers = null;
        }
        this.f_19804_.m_135381_(PIGMAN_DATA, (Object)data);
    }

    @Override
    public PigmanData getPigmanData() {
        return (PigmanData)this.f_19804_.m_135370_(PIGMAN_DATA);
    }

    public void setConversionType(byte type) {
        this.f_19804_.m_135381_(CONVERSION_TYPE, (Object)type);
    }

    public byte getConversionType() {
        return (Byte)this.f_19804_.m_135370_(CONVERSION_TYPE);
    }

    public void startConverting(@Nullable UUID conversionStarter, int conversionTime) {
        this.m_21553_(true);
        this.converstionStarter = conversionStarter;
        this.conversionTime = conversionTime;
        this.m_20088_().m_135381_(CONVERTING, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, conversionTime, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
    }

    private <P extends Mob> void finishCure(ServerLevel level) {
        Player player;
        byte typeId = this.getConversionType();
        IPigman.Type wow = IPigman.Type.get(typeId);
        RediscoveredMod.LOGGER.debug("Zombie Pigman cured into type {} ({}) at {} in {}", (Object)typeId, (Object)wow, (Object)this.m_20183_(), (Object)this.m_9236_().m_46472_());
        Mob pigman = this.m_21406_(wow.getTypeResult(), typeId > 0);
        pigman.m_6518_((ServerLevelAccessor)level, level.m_6436_(pigman.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
        pigman.m_21559_(this.m_21526_());
        pigman.m_6863_(this.m_6162_());
        pigman.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!pigman.m_20067_()) {
            pigman.m_9236_().m_5594_(null, pigman.m_20183_(), RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_FINISH_CURE, pigman.m_5720_(), 1.5f, 1.0f);
        }
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            ItemStack itemstack = pigman.m_6844_(equipmentslot);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack) || !itemstack.m_41763_() || !(this.m_21519_(equipmentslot) < 2.0f)) continue;
            itemstack.m_41721_(itemstack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(itemstack.m_41776_() - 3, 1))));
            pigman.m_8061_(equipmentslot, itemstack.m_41777_());
            pigman.m_21508_(equipmentslot);
        }
        if (pigman instanceof GuardPigmanEntity) {
            GuardPigmanEntity guard = (GuardPigmanEntity)pigman;
            guard.setPlayerCured(true);
        }
        if (pigman instanceof PigmanEntity) {
            PigmanEntity trader = (PigmanEntity)pigman;
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                ItemStack itemstack = this.m_6844_(equipmentslot);
                if (itemstack.m_41619_()) continue;
                if (EnchantmentHelper.m_44920_((ItemStack)itemstack)) {
                    trader.m_141942_(equipmentslot.m_20749_() + 300).m_142104_(itemstack);
                    continue;
                }
                double d0 = this.m_21519_(equipmentslot);
                if (!(d0 > 1.0)) continue;
                this.m_19983_(itemstack);
            }
            trader.m_21553_(false);
            if (this.converstionStarter != null) {
                trader.curedUuids.add(this.converstionStarter);
            }
            trader.setXp(this.traderXp);
            trader.setPigmanData(this.getPigmanData());
            if (this.tradeOffers != null) {
                trader.setOffers(new MerchantOffers(this.tradeOffers));
            }
        }
        if (this.converstionStarter != null && (player = level.m_46003_(this.converstionStarter)) instanceof ServerPlayer) {
            RediscoveredTriggers.CURE_PIGMAN.trigger((ServerPlayer)player, (Entity)pigman);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)pigman);
    }

    protected void m_7581_(ItemEntity item) {
        ItemStack stack = item.m_32055_().m_41777_();
        super.m_7581_(item);
        if (this.conversionTime > 0) {
            this.trySetConversionType(stack);
        }
    }

    public boolean m_7243_(ItemStack stack) {
        return super.m_7243_(stack);
    }

    protected boolean m_7808_(ItemStack pCandidate, ItemStack pExisting) {
        if (this.conversionTime > 0) {
            return this.isApplicableConversionItem(pCandidate);
        }
        return super.m_7808_(pCandidate, pExisting);
    }

    private boolean isApplicableConversionItem(ItemStack candidate) {
        return this.getConversionType() <= 0 && IPigman.Type.isValidHandEquipForAny(candidate);
    }

    private boolean trySetConversionType(ItemStack stack) {
        if (IPigman.Type.get(this.getConversionType()) == IPigman.Type.UNASSIGNED && !this.m_6162_()) {
            for (IPigman.Type type : IPigman.Type.values()) {
                if (!type.isValidHandEquip(stack)) continue;
                this.m_5496_(type.getZombieTypeSelectSound(), 2.0f, 1.0f);
                this.setConversionType((byte)type.ordinal());
                return true;
            }
        }
        return false;
    }
}

