/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity;

import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.fluids.FluidType;

public class ScarecrowEntity
extends LivingEntity {
    private static final byte HURT_EVENT = 32;
    private static final byte HURT_BY_ENTITY_EVENT = 33;
    public long lastHit;
    public boolean shouldDance = false;
    @Nullable
    private BlockPos jukebox;

    public ScarecrowEntity(EntityType<? extends ScarecrowEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.0f);
    }

    public ScarecrowEntity(Level worldIn, double posX, double posY, double posZ) {
        this(RediscoveredEntityTypes.SCARECROW, worldIn);
        this.m_6034_(posX, posY, posZ);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 10.0);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 4.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.shouldDance = false;
            this.jukebox = null;
        }
        this.m_21153_(this.m_21223_() + 0.5f);
        super.m_8107_();
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public Iterable<ItemStack> m_6167_() {
        return List.of();
    }

    public Iterable<ItemStack> m_6168_() {
        return List.of();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public boolean m_7066_(ItemStack pItemstack) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_213877_() && !this.m_9236_().m_5776_()) {
            if (source.m_269533_(DamageTypeTags.f_268738_)) {
                this.m_6074_();
                return false;
            }
            if (!this.m_6673_(source)) {
                if (source.m_269533_(DamageTypeTags.f_268415_)) {
                    this.brokenByAnything(source);
                    this.m_6074_();
                    return false;
                }
                if (source.m_269533_(DamageTypeTags.f_268745_)) {
                    if (this.m_6060_()) {
                        this.causeDamage(source, amount * 1.0f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (source.m_276093_(DamageTypes.f_268612_)) {
                    return false;
                }
                Entity entity = source.m_7640_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    amount = player.m_7500_() ? this.m_21233_() : Math.max(amount * 3.0f, 5.0f);
                }
                this.m_9236_().m_7605_((Entity)this, source.m_7640_() != null ? (byte)33 : 32);
                this.m_146852_(GameEvent.f_223706_, source.m_7639_());
                this.showBreakingParticles(Mth.m_14045_((int)((int)amount), (int)1, (int)20));
                this.causeDamage(source, amount);
                return true;
            }
        }
        return false;
    }

    private void showBreakingParticles(int amount) {
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50335_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), amount, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource damage, float amount) {
        float health = this.m_21223_();
        if ((health -= amount) <= 0.5f) {
            this.brokenByAnything(damage);
            this.m_6074_();
        } else {
            this.m_21153_(health);
            this.m_146852_(GameEvent.f_223706_, damage.m_7639_());
        }
    }

    private void brokenByAnything(DamageSource damage) {
        Player player;
        this.playBrokenSound();
        Entity entity = damage.m_7640_();
        if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
            this.m_6668_(damage);
        }
    }

    private void playBrokenSound() {
        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    public void m_7822_(byte event) {
        if (event == 32 || event == 33) {
            if (this.m_9236_().m_5776_() && (event == 33 || this.m_9236_().m_46467_() - this.lastHit > 7L)) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.m_9236_().m_46467_();
            }
        } else {
            super.m_7822_(event);
        }
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_() == MobEffects.f_19619_;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    protected float m_5632_(float pYRot, float pAnimStep) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * (this.m_6162_() ? 0.5f : 0.9f);
    }

    public double m_6049_() {
        return 0.1;
    }

    public void m_5618_(float pOffset) {
        this.f_20884_ = this.f_19859_ = pOffset;
        this.f_20886_ = this.f_20885_ = pOffset;
    }

    public void m_5616_(float pRotation) {
        this.f_20884_ = this.f_19859_ = pRotation;
        this.f_20886_ = this.f_20885_ = pRotation;
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    public boolean m_6128_() {
        return this.m_20145_();
    }

    public boolean m_7313_(Entity pEntity) {
        return pEntity instanceof Player && !this.m_9236_().m_7966_((Player)pEntity, this.m_20183_());
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11682_, SoundEvents.f_11682_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11683_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public boolean m_5801_() {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_5789_() {
        return false;
    }

    public ItemStack m_142340_() {
        ItemStack stack = RediscoveredItems.scarecrow.m_7968_();
        if (this.m_8077_()) {
            stack.m_41714_(this.m_5446_());
        }
        return stack;
    }

    public boolean m_142065_() {
        return !this.m_20145_();
    }

    public void m_6818_(BlockPos jukeboxPos, boolean isPlaying) {
        this.jukebox = jukeboxPos;
        this.shouldDance = isPlaying;
    }
}

