/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity;

import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.data.RediscoveredLootProv;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.ai.SearchForItemGoal;
import com.legacy.rediscovered.registry.RediscoveredTriggers;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class RanaEntity
extends PathfinderMob {
    protected static final EntityDataAccessor<Integer> TRADE_COOLDOWN = SynchedEntityData.m_135353_(RanaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int throwDelay;
    protected static final String TRADE_COOLDOWN_KEY = "TradeCooldown";
    protected static final String THROW_DELAY_KEY = "ThrowDelay";

    public RanaEntity(EntityType<? extends RanaEntity> type, Level world) {
        super(type, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21553_(true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)0.7f));
        this.f_21345_.m_25352_(2, (Goal)new SearchForItemGoal<RanaEntity>(this, (double)0.65f, RediscoveredTags.Items.RANA_CURRENCY){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && RanaEntity.this.m_21206_().m_41619_() && RanaEntity.this.getTradeCooldown() <= 0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal(this, 0.6f, Ingredient.m_204132_(RediscoveredTags.Items.RANA_CURRENCY), false){

            public boolean m_8036_() {
                return super.m_8036_() && RanaEntity.this.m_21206_().m_41619_() && RanaEntity.this.getTradeCooldown() <= 0;
            }

            public void m_8037_() {
                super.m_8037_();
                if (this.m_25955_() && !this.f_25924_.m_21691_()) {
                    if (this.f_25924_.m_20096_()) {
                        this.f_25924_.m_21569_().m_24901_();
                    }
                    if (!this.f_25924_.f_20911_ && this.f_25924_.f_19797_ % 5 == this.f_25924_.m_217043_().m_188503_(2)) {
                        this.f_25924_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRADE_COOLDOWN, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_(TRADE_COOLDOWN_KEY, this.getTradeCooldown());
        tag.m_128405_(THROW_DELAY_KEY, this.throwDelay);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setTradeCooldown(tag.m_128451_(TRADE_COOLDOWN_KEY));
        this.throwDelay = tag.m_128451_(THROW_DELAY_KEY);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.9f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22276_, 30.0);
    }

    public boolean m_7327_(Entity entityIn) {
        return super.m_7327_(entityIn);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.getTradeCooldown() > 0) {
            this.setTradeCooldown(this.getTradeCooldown() - 1);
        } else if (this.isCurrency(this.m_21206_())) {
            this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            this.m_216990_(SoundEvents.f_11675_);
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return RediscoveredSounds.ENTITY_RANA_HURT;
    }

    protected SoundEvent m_5592_() {
        return RediscoveredSounds.ENTITY_RANA_DEATH;
    }

    public boolean m_8023_() {
        return true;
    }

    public void setTradeCooldown(int flag) {
        this.m_20088_().m_135381_(TRADE_COOLDOWN, (Object)flag);
    }

    public int getTradeCooldown() {
        return (Integer)this.m_20088_().m_135370_(TRADE_COOLDOWN);
    }

    public boolean m_7307_(Entity entity) {
        if (entity.m_6095_().m_204039_(RediscoveredTags.Entities.PIGMAN_ALLIES)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return this.m_20031_(entity.m_5647_());
    }

    private void tradeItem(Vec3 pos, @Nullable Entity gifter) {
        this.setTradeCooldown((60 + this.f_19796_.m_188503_(30)) * 20);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            LootTable loottable = sl.m_7654_().m_278653_().m_278676_(RediscoveredLootProv.RANA_TRADING);
            ObjectArrayList list = loottable.m_287195_(new LootParams.Builder(sl).m_287286_(LootContextParams.f_81460_, (Object)this.m_146892_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_));
            if (!list.isEmpty()) {
                this.m_6674_(InteractionHand.OFF_HAND);
                for (ItemStack itemstack : list) {
                    BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)itemstack, (Vec3)pos.m_82520_(0.0, 1.0, 0.0));
                }
            }
            if (gifter instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)gifter;
                RediscoveredTriggers.GIVE_RANA_ITEM.trigger(sp, (Entity)this);
            }
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.getTradeCooldown() <= 0 && this.isCurrency(itemstack)) {
            if (player.m_9236_().m_5776_()) {
                return InteractionResult.CONSUME;
            }
            this.tradeItem(player.m_20182_(), (Entity)player);
            ItemStack held = itemstack.m_41777_();
            held.m_41764_(1);
            itemstack.m_41774_(1);
            this.holdInOffHand(held);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    protected void m_7581_(ItemEntity entity) {
        if (this.isCurrency(entity.m_32055_())) {
            this.tradeItem(entity.m_19749_() != null ? entity.m_19749_().m_20182_() : this.m_20182_(), entity.m_19749_());
            this.m_21053_(entity);
            this.m_7938_((Entity)entity, 1);
            this.holdInOffHand(RanaEntity.removeOneItemFromItemEntity(entity));
        } else {
            super.m_7581_(entity);
        }
    }

    protected void holdInOffHand(ItemStack stack) {
        if (this.isCurrency(stack)) {
            this.m_8061_(EquipmentSlot.OFFHAND, stack);
            this.m_21508_(EquipmentSlot.OFFHAND);
        } else {
            this.m_21468_(EquipmentSlot.OFFHAND, stack);
        }
    }

    public boolean m_7243_(ItemStack stack) {
        return ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.m_21531_() && stack.m_204117_(RediscoveredTags.Items.RANA_CURRENCY) && this.m_21206_().m_41619_();
    }

    private static ItemStack removeOneItemFromItemEntity(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.m_32055_();
        ItemStack itemstack1 = itemstack.m_41620_(1);
        if (itemstack.m_41619_()) {
            pItemEntity.m_146870_();
        } else {
            pItemEntity.m_32045_(itemstack);
        }
        return itemstack1;
    }

    public void m_7938_(Entity pEntity, int pAmount) {
        if (!pEntity.m_213877_() && !this.m_9236_().f_46443_ && (pEntity instanceof ItemEntity || pEntity instanceof AbstractArrow || pEntity instanceof ExperienceOrb)) {
            ((ServerLevel)this.m_9236_()).m_7726_().m_8445_(pEntity, (Packet)new ClientboundTakeItemEntityPacket(pEntity.m_19879_(), this.m_19879_(), pAmount));
        }
    }

    private final boolean isCurrency(ItemStack stack) {
        return stack.m_204117_(RediscoveredTags.Items.RANA_CURRENCY);
    }
}

