/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.entity;

import com.legacy.rediscovered.block.BaseFakeFireBlock;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.entity.util.IMD3Entity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractSteveEntity
extends Monster
implements IMD3Entity {
    protected int fireCooldown = 0;
    protected static final String FIRE_COOLDOWN_KEY = "FireCooldown";

    public AbstractSteveEntity(EntityType<? extends AbstractSteveEntity> type, Level world) {
        super(type, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(1, (Goal)new BurnGroundGoal(this, this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.65, true));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, mob -> mob instanceof Enemy && !(mob instanceof Creeper)));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_(FIRE_COOLDOWN_KEY, this.fireCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.fireCooldown = tag.m_128451_(FIRE_COOLDOWN_KEY);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.9f;
    }

    public static AttributeSupplier.Builder createBaseSteveAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22276_, 50.0);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return super.m_7975_(damageSourceIn);
    }

    protected SoundEvent m_5592_() {
        return super.m_5592_();
    }

    public boolean m_8023_() {
        return true;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_7307_(Entity entity) {
        if (entity.m_6095_().m_204039_(RediscoveredTags.Entities.PIGMAN_ALLIES)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return this.m_20031_(entity.m_5647_());
    }

    public static class BurnGroundGoal<T extends AbstractSteveEntity>
    extends Goal {
        private final T mob;
        private final ItemStack item;
        private BlockPos burnPos;
        private int ticksSinceFire;
        final /* synthetic */ AbstractSteveEntity this$0;

        public BurnGroundGoal(T pMob) {
            this.this$0 = this$0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.mob = pMob;
            this.item = Items.f_42409_.m_7968_();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            if (((AbstractSteveEntity)this.mob).fireCooldown > 0) {
                return false;
            }
            LivingEntity target = this.mob.m_5448_();
            if (target == null) return false;
            if (target.m_6060_()) return false;
            if (!(this.mob.m_20270_((Entity)target) < 5.0f)) return false;
            if (!(this.mob.m_20270_((Entity)target) > 2.0f)) return false;
            if (this.mob.m_21033_(EquipmentSlot.OFFHAND)) return false;
            this.burnPos = target.m_20183_();
            if (!BaseFireBlock.m_49255_((Level)this.mob.m_9236_(), (BlockPos)this.burnPos, (Direction)Direction.DOWN)) return false;
            if (!this.mob.m_9236_().m_45933_((Entity)target, target.m_20191_().m_82400_(1.5)).isEmpty()) return false;
            return true;
        }

        public boolean m_8045_() {
            return this.mob.m_5448_() != null && this.burnPos != null && this.mob.m_9236_().m_8055_(this.burnPos).m_60734_() instanceof BaseFireBlock;
        }

        public void m_8056_() {
            this.mob.m_8061_(EquipmentSlot.OFFHAND, this.item.m_41777_());
            this.mob.m_21011_(InteractionHand.OFF_HAND, true);
            Level level = this.mob.m_9236_();
            BlockPos pos = this.burnPos;
            level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            BlockState blockstate1 = BaseFakeFireBlock.getState((BlockGetter)level, pos);
            level.m_7731_(pos, blockstate1, 11);
            level.m_142346_(this.mob, GameEvent.f_157797_, pos);
        }

        public void m_8037_() {
            LivingEntity target;
            ++this.ticksSinceFire;
            if (this.burnPos != null) {
                ((AbstractSteveEntity)this.mob).f_21365_.m_24964_(Vec3.m_82512_((Vec3i)this.burnPos));
            }
            if ((target = this.mob.m_5448_()) != null && this.burnPos != null && (target.m_6060_() || this.ticksSinceFire >= 10)) {
                this.mob.m_21011_(InteractionHand.OFF_HAND, true);
                this.mob.m_9236_().m_46961_(this.burnPos, false);
                this.mob.m_9236_().m_5594_(null, this.burnPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (((AbstractSteveEntity)this.mob).f_19796_.m_188501_() - ((AbstractSteveEntity)this.mob).f_19796_.m_188501_()) * 0.8f);
            }
        }

        public void m_8041_() {
            this.mob.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
            this.burnPos = null;
            this.ticksSinceFire = 0;
            ((AbstractSteveEntity)this.mob).fireCooldown = 100;
        }
    }
}

