/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data_handler;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.RediscoveredUtil;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.phys.Vec3;

public class TailorArmorStandDataHandler
extends ProbabilityDataHandler<TailorArmorStandDataHandler> {
    public static final DataHandlerType<TailorArmorStandDataHandler> TYPE = new DataHandlerType(RediscoveredMod.locate("tailor_armor_stand"), TailorArmorStandDataHandler::new, TailorArmorStandDataHandler::parser);
    private static final DataParser PARSER = DataParser.of((DataHandlerType)DataHandlerType.ENTITY, parser -> parser.add("spawn_chance", 1.0f, 0.0f, 1.0f));

    public TailorArmorStandDataHandler(DataMap data) {
        super(data, "spawn_chance");
    }

    public static DataParser parser() {
        return PARSER;
    }

    protected void handle(DataHandler.Context context) {
        WorldGenLevel level = context.getLevel();
        BlockState dataHandler = context.getDataHandlerState();
        Vec3 pos = context.getPos();
        RandomSource rand = context.getRandom();
        ArmorStand armorStand = new ArmorStand((Level)level.m_6018_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Direction facing = dataHandler.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)dataHandler.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.SOUTH;
        float yRot = facing.m_122434_() != Direction.Axis.Y ? facing.m_122435_() : armorStand.m_146908_();
        armorStand.m_7678_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), yRot, armorStand.m_146909_());
        Object[] colors = new DyeColor[]{DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.RED, DyeColor.PINK, DyeColor.BLUE, DyeColor.CYAN, DyeColor.LIGHT_GRAY, DyeColor.LIGHT_BLUE, DyeColor.YELLOW};
        EnumMap<EquipmentSlot, TagKey<Item>> armorOptions = new EnumMap<EquipmentSlot, TagKey<Item>>(EquipmentSlot.class);
        armorOptions.put(EquipmentSlot.HEAD, RediscoveredTags.Items.TAILOR_ARMOR_STAND_HELMETS);
        armorOptions.put(EquipmentSlot.CHEST, RediscoveredTags.Items.TAILOR_ARMOR_STAND_CHESTPLATES);
        armorOptions.put(EquipmentSlot.LEGS, RediscoveredTags.Items.TAILOR_ARMOR_STAND_LEGGINGS);
        armorOptions.put(EquipmentSlot.FEET, RediscoveredTags.Items.TAILOR_ARMOR_STAND_BOOTS);
        boolean skippedAnItem = false;
        for (Map.Entry entry : Util.m_214661_(armorOptions.entrySet().stream(), (RandomSource)rand)) {
            if (!skippedAnItem && rand.m_188501_() > 0.8f) {
                skippedAnItem = true;
                continue;
            }
            Optional<Holder<Item>> item = RediscoveredUtil.getRandomItem((TagKey<Item>)((TagKey)entry.getValue()), (ServerLevelAccessor)level, rand);
            if (!item.isPresent()) continue;
            ItemStack stack = ((Item)item.get().m_203334_()).m_7968_();
            Item item2 = stack.m_41720_();
            if (item2 instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeable = (DyeableLeatherItem)item2;
                if (rand.m_188501_() < 0.9f) {
                    List<DyeItem> dyes = List.of(DyeItem.m_41082_((DyeColor)((DyeColor)Util.m_214670_((Object[])colors, (RandomSource)rand))), DyeItem.m_41082_((DyeColor)((DyeColor)Util.m_214670_((Object[])colors, (RandomSource)rand))));
                    stack = DyeableLeatherItem.m_41118_((ItemStack)stack, dyes);
                }
            }
            armorStand.m_8061_((EquipmentSlot)entry.getKey(), stack);
        }
        level.m_47205_((Entity)armorStand);
    }

    @Deprecated
    protected void handle(BlockState dataHandler, BlockPos pos, WorldGenLevel level, RandomSource rand, BoundingBox bounds, StructurePiece piece) {
    }
}

