/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data.triggers;

import com.google.gson.JsonObject;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.registry.RediscoveredDimensions;
import java.util.Optional;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InFarlandsTrigger
extends SimpleCriterionTrigger<Instance> {
    static final ResourceLocation ID = RediscoveredMod.locate("in_farlands");
    public static final int MIN_FARLANDS = -12550824;
    public static final int MAX_FARLANDS = 12550817;

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject json, ContextAwarePredicate entityPredicate, DeserializationContext conditionsParser) {
        int minX = GsonHelper.m_13927_((JsonObject)json, (String)"min_x");
        int maxX = GsonHelper.m_13927_((JsonObject)json, (String)"max_x");
        int minZ = GsonHelper.m_13927_((JsonObject)json, (String)"min_z");
        int maxZ = GsonHelper.m_13927_((JsonObject)json, (String)"max_z");
        Optional<ResourceKey<Level>> dimension = json.has("dimension") ? Optional.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"dimension")))) : Optional.empty();
        return new Instance(entityPredicate, minX, maxX, minZ, maxZ, dimension);
    }

    public void trigger(ServerPlayer player) {
        this.m_66234_(player, instance -> instance.test(player.m_20182_(), (ResourceKey<Level>)player.m_9236_().m_46472_()));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final Optional<ResourceKey<Level>> dimension;
        private final int minX;
        private final int maxX;
        private final int minZ;
        private final int maxZ;

        public Instance(ContextAwarePredicate contextPredicate, int minX, int maxX, int minZ, int maxZ, Optional<ResourceKey<Level>> dimension) {
            super(ID, contextPredicate);
            this.dimension = dimension;
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext pConditions) {
            JsonObject json = new JsonObject();
            json.addProperty("min_x", (Number)this.minX);
            json.addProperty("max_x", (Number)this.maxX);
            json.addProperty("min_z", (Number)this.minZ);
            json.addProperty("max_z", (Number)this.maxZ);
            if (this.dimension.isPresent()) {
                json.addProperty("dimension", this.dimension.get().m_135782_().toString());
            }
            return json;
        }

        public static Instance skylands() {
            return new Instance(ContextAwarePredicate.f_285567_, -12550824, 12550817, -12550824, 12550817, Optional.of(RediscoveredDimensions.skylandsKey()));
        }

        private boolean test(Vec3 pos, ResourceKey<Level> dimension) {
            return (pos.f_82479_ <= (double)this.minX || pos.f_82479_ >= (double)this.maxX || pos.f_82481_ <= (double)this.minZ || pos.f_82481_ >= (double)this.maxZ) && (this.dimension.isEmpty() || this.dimension.get().equals(dimension));
        }
    }
}

