/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data.loot_functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.item.util.QuiverData;
import com.legacy.rediscovered.registry.RediscoveredLootFunctions;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetQuiverContentsFunction
extends LootItemConditionalFunction {
    private final ResourceLocation lootTable;

    protected SetQuiverContentsFunction(LootItemCondition[] condition, ResourceLocation lootTable) {
        super(condition);
        this.lootTable = lootTable;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)RediscoveredLootFunctions.SET_QUIVER_CONTENTS.get();
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (stack.m_204117_(RediscoveredTags.Items.QUIVERS)) {
            SimpleContainer container = new SimpleContainer(5);
            context.m_278643_().m_278676_(this.lootTable).m_287188_((Container)container, new LootParams.Builder(context.m_78952_()).m_287239_(context.m_78945_()).m_287235_(LootContextParamSets.f_81410_), context.m_230907_().m_188505_());
            QuiverData quiver = QuiverData.getOrCreate(stack);
            quiver.injectData((NonNullList<ItemStack>)container.f_19147_);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> withContents(ResourceLocation lootTable) {
        return SetQuiverContentsFunction.m_80683_(condition -> new SetQuiverContentsFunction((LootItemCondition[])condition, lootTable));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetQuiverContentsFunction> {
        public void serialize(JsonObject json, SetQuiverContentsFunction function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            json.addProperty("loot_table", function.lootTable.toString());
        }

        public SetQuiverContentsFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] condition) {
            try {
                ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"loot_table"));
                return new SetQuiverContentsFunction(condition, lootTable);
            }
            catch (ResourceLocationException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }
    }
}

