/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data.loot_functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.legacy.rediscovered.data.loot_functions.SetAttachedItemFunction;
import com.legacy.rediscovered.data.loot_functions.SetQuiverContentsFunction;
import com.legacy.rediscovered.registry.RediscoveredLootFunctions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetAttachedQuiverFunction
extends LootItemConditionalFunction {
    private final ItemStack attachedItem;
    private final ResourceLocation lootTable;

    protected SetAttachedQuiverFunction(LootItemCondition[] condition, ItemStack attachedItem, ResourceLocation lootTable) {
        super(condition);
        this.attachedItem = attachedItem;
        this.lootTable = lootTable;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)RediscoveredLootFunctions.SET_ATTACHED_QUIVER.get();
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        SetQuiverContentsFunction setContents = new SetQuiverContentsFunction(this.f_80676_, this.lootTable);
        return new SetAttachedItemFunction(this.f_80676_, setContents.apply(this.attachedItem.m_41777_(), context)).apply(stack, context);
    }

    public static LootItemConditionalFunction.Builder<?> attachQuiver(ItemStack attachedItem, ResourceLocation lootTable) {
        return SetAttachedQuiverFunction.m_80683_(condition -> new SetAttachedQuiverFunction((LootItemCondition[])condition, attachedItem, lootTable));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetAttachedQuiverFunction> {
        public void serialize(JsonObject json, SetAttachedQuiverFunction function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)function.attachedItem.m_41720_());
            if (id == null) {
                throw new IllegalArgumentException("Can't serialize unknown item " + function.attachedItem.m_41720_());
            }
            json.addProperty("item", id.toString());
            if (function.attachedItem.m_41783_() != null) {
                json.addProperty("tag", function.attachedItem.m_41783_().toString());
            }
            json.addProperty("loot_table", function.lootTable.toString());
        }

        public SetAttachedQuiverFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] condition) {
            try {
                ItemStack attachedItem = GsonHelper.m_144746_((JsonObject)json, (String)"item", (Item)Items.f_41852_).m_7968_();
                if (json.has("tag")) {
                    CompoundTag tag = TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
                    attachedItem.m_41751_(tag);
                }
                ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"loot_table"));
                return new SetAttachedQuiverFunction(condition, attachedItem, lootTable);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
            catch (ResourceLocationException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }
    }
}

