/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data.loot_functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.legacy.rediscovered.item.util.AttachedItem;
import com.legacy.rediscovered.registry.RediscoveredLootFunctions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetAttachedItemFunction
extends LootItemConditionalFunction {
    private final ItemStack attachedItem;

    protected SetAttachedItemFunction(LootItemCondition[] condition, ItemStack attachedItem) {
        super(condition);
        this.attachedItem = attachedItem;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)RediscoveredLootFunctions.SET_ATTACHED_ITEM.get();
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        return AttachedItem.attachItem(stack, this.attachedItem);
    }

    public static LootItemConditionalFunction.Builder<?> attachItem(ItemStack attachedItem) {
        return SetAttachedItemFunction.m_80683_(condition -> new SetAttachedItemFunction((LootItemCondition[])condition, attachedItem));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetAttachedItemFunction> {
        public void serialize(JsonObject json, SetAttachedItemFunction function, JsonSerializationContext context) {
            super.m_6170_(json, (LootItemConditionalFunction)function, context);
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)function.attachedItem.m_41720_());
            if (id == null) {
                throw new IllegalArgumentException("Can't serialize unknown item " + function.attachedItem.m_41720_());
            }
            json.addProperty("item", id.toString());
            if (function.attachedItem.m_41783_() != null) {
                json.addProperty("tag", function.attachedItem.m_41783_().toString());
            }
        }

        public SetAttachedItemFunction deserialize(JsonObject json, JsonDeserializationContext context, LootItemCondition[] condition) {
            try {
                ItemStack attachedItem = GsonHelper.m_144746_((JsonObject)json, (String)"item", (Item)Items.f_41852_).m_7968_();
                if (json.has("tag")) {
                    CompoundTag tag = TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
                    attachedItem.m_41751_(tag);
                }
                return new SetAttachedItemFunction(condition, attachedItem);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }
    }
}

