/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data;

import com.legacy.rediscovered.block.BaseFakeFireBlock;
import com.legacy.rediscovered.block.ChairBlock;
import com.legacy.rediscovered.block.DirtSlabBlock;
import com.legacy.rediscovered.block.GrassSlabBlock;
import com.legacy.rediscovered.block.ShallowDirtSlabBlock;
import com.legacy.rediscovered.block.TableBlock;
import com.legacy.rediscovered.data.RediscoveredTags;
import com.legacy.rediscovered.registry.RediscoveredBiomes;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredDamageTypes;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.registry.RediscoveredPaintings;
import com.legacy.rediscovered.registry.RediscoveredStructures;
import com.legacy.rediscovered.world.structure.IndevHouseStructure;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RediscoveredTagProv {

    public static class PaintingVariantProv
    extends PaintingVariantTagsProvider {
        public PaintingVariantProv(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider lookupProvider) {
            this.m_206424_(PaintingVariantTags.f_215870_).m_255204_(RediscoveredPaintings.FOG.getKey());
        }
    }

    public static class DamageTypeProv
    extends DamageTypeTagsProvider {
        public DamageTypeProv(DataGenerator generatorIn, @Nullable ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> pLookupProvider) {
            super(generatorIn.getPackOutput(), pLookupProvider, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(RediscoveredTags.DamageTypes.IS_DEATHLY).m_211101_(new ResourceKey[]{DamageTypes.f_268493_, DamageTypes.f_268641_});
            this.m_206424_(RediscoveredTags.DamageTypes.IS_SPIKES).m_255204_(RediscoveredDamageTypes.SPIKES.getKey());
            this.m_206424_(DamageTypeTags.f_276146_).m_206428_(RediscoveredTags.DamageTypes.IS_SPIKES);
            this.m_206424_(DamageTypeTags.f_268490_).m_206428_(RediscoveredTags.DamageTypes.IS_SPIKES);
        }
    }

    public static class StructureProv
    extends StructureTagsProvider {
        public StructureProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.m_206424_(RediscoveredTags.Structures.INDEV_HOUSE).m_211101_(new ResourceKey[]{RediscoveredStructures.INDEV_HOUSE.getStructure(IndevHouseStructure.Type.DEFAULT.m_7912_()).getKey(), RediscoveredStructures.INDEV_HOUSE.getStructure(IndevHouseStructure.Type.MOSSY.m_7912_()).getKey(), RediscoveredStructures.INDEV_HOUSE.getStructure(IndevHouseStructure.Type.CHERRY.m_7912_()).getKey()});
            this.m_206424_(RediscoveredTags.Structures.PIGMAN_VILLAGE_AVOIDS).m_255204_(RediscoveredStructures.BRICK_PYRAMID.getStructure().getKey());
            this.m_206424_(RediscoveredTags.Structures.OBSIDIAN_WALL_AVOIDS).m_211101_(new ResourceKey[]{RediscoveredStructures.BRICK_PYRAMID.getStructure().getKey(), RediscoveredStructures.PIGMAN_VILLAGE.getStructure().getKey()});
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return super.m_213708_(cache);
        }

        public String m_6055_() {
            return "rediscovered Structure Tags";
        }
    }

    public static class PoiProv
    extends PoiTypeTagsProvider {
        public PoiProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.m_206424_(RediscoveredTags.Poi.APPLICABLE_PIGMAN_WORKSTATION).m_211101_(new ResourceKey[]{PoiTypes.f_218058_, PoiTypes.f_218053_, PoiTypes.f_218055_, PoiTypes.f_218057_, PoiTypes.f_218050_});
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return super.m_213708_(cache);
        }

        public String m_6055_() {
            return "rediscovered PoiType Tags";
        }
    }

    public static class BiomeProv
    extends BiomeTagsProvider {
        public BiomeProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.rediscovered();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return super.m_213708_(cache);
        }

        private void rediscovered() {
            this.m_206424_(RediscoveredTags.Biomes.IS_SKYLANDS).m_211101_(new ResourceKey[]{RediscoveredBiomes.SKYLANDS.getKey(), RediscoveredBiomes.COLD_SKYLANDS.getKey(), RediscoveredBiomes.WOODED_SKYLANDS.getKey(), RediscoveredBiomes.RAINFOREST.getKey()});
            this.m_206424_(RediscoveredTags.Biomes.HAS_PIGMAN_VILLAGE).m_211101_(new ResourceKey[]{RediscoveredBiomes.SKYLANDS.getKey(), RediscoveredBiomes.WOODED_SKYLANDS.getKey()});
            this.m_206424_(RediscoveredTags.Biomes.HAS_BRICK_PYRAMID).m_211101_(new ResourceKey[]{RediscoveredBiomes.RAINFOREST.getKey(), RediscoveredBiomes.WOODED_SKYLANDS.getKey()});
            this.m_206424_(RediscoveredTags.Biomes.HAS_OBSIDIAN_WALL).m_206428_(RediscoveredTags.Biomes.IS_SKYLANDS);
            this.m_206424_(RediscoveredTags.Biomes.HAS_DEFAULT_INDEV_HOUSE).m_211101_(new ResourceKey[]{RediscoveredBiomes.SKYLANDS.getKey(), RediscoveredBiomes.COLD_SKYLANDS.getKey()});
            this.m_206424_(RediscoveredTags.Biomes.HAS_MOSSY_INDEV_HOUSE).m_255204_(RediscoveredBiomes.RAINFOREST.getKey());
            this.m_206424_(RediscoveredTags.Biomes.HAS_CHERRY_INDEV_HOUSE).m_255204_(RediscoveredBiomes.WOODED_SKYLANDS.getKey());
            this.m_206424_(RediscoveredTags.Biomes.HAS_RUBY_ORE).m_206428_(BiomeTags.f_207610_).m_206428_(BiomeTags.f_215816_);
            this.m_206424_(RediscoveredTags.Biomes.HAS_FISH_SPAWNS).addTags(new TagKey[]{BiomeTags.f_207603_, BiomeTags.f_207605_});
        }

        private void vanilla() {
        }

        private void forge() {
        }

        public String m_6055_() {
            return "rediscovered Biome Tags";
        }
    }

    public static class EntityProv
    extends EntityTypeTagsProvider {
        public EntityProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.m_206424_(RediscoveredTags.Entities.PLATE_ARMOR_SPAWNS).m_255179_((Object[])new EntityType[]{EntityType.f_20501_, EntityType.f_20458_, EntityType.f_20524_, EntityType.f_20481_, RediscoveredEntityTypes.ZOMBIE_PIGMAN});
            this.m_206424_(RediscoveredTags.Entities.MD3).m_255179_((Object[])new EntityType[]{RediscoveredEntityTypes.STEVE, RediscoveredEntityTypes.BLACK_STEVE, RediscoveredEntityTypes.BEAST_BOY, RediscoveredEntityTypes.RANA});
            this.m_206424_(RediscoveredTags.Entities.PIGMAN).m_255179_((Object[])new EntityType[]{RediscoveredEntityTypes.PIGMAN, RediscoveredEntityTypes.MELEE_PIGMAN, RediscoveredEntityTypes.RANGED_PIGMAN});
            this.m_206424_(RediscoveredTags.Entities.PIGMAN_VILLAGE_GUARDS).m_255179_((Object[])new EntityType[]{RediscoveredEntityTypes.MELEE_PIGMAN, RediscoveredEntityTypes.RANGED_PIGMAN});
            this.m_206424_(RediscoveredTags.Entities.PIGMAN_ALLIES).addTags(new TagKey[]{RediscoveredTags.Entities.PIGMAN, RediscoveredTags.Entities.MD3});
            this.m_206424_(RediscoveredTags.Entities.GOLDEN_AURA_APPLICABLE).m_255179_((Object[])new EntityType[]{EntityType.f_20492_, EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20456_, RediscoveredEntityTypes.PIGMAN, RediscoveredEntityTypes.MELEE_PIGMAN, RediscoveredEntityTypes.RANGED_PIGMAN});
            this.m_206424_(RediscoveredTags.Entities.CRIMSON_VEIL_AFFECTED).m_255179_((Object[])new EntityType[]{EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20456_});
            this.m_206424_(RediscoveredTags.Entities.BRICK_PYRAMID_SPAWNER).m_255179_((Object[])new EntityType[]{EntityType.f_20501_, EntityType.f_20524_});
            this.m_206424_(RediscoveredTags.Entities.BECOMES_ZOMBIE_HORSE_IN_ZOMBIE_VILLAGE).m_255179_((Object[])new EntityType[]{EntityType.f_20457_, EntityType.f_20560_, EntityType.f_20503_, EntityType.f_20557_, EntityType.f_20510_, EntityType.f_20520_});
            this.m_206424_(RediscoveredTags.Entities.TARGETS_SCARECROW).m_255179_((Object[])new EntityType[]{EntityType.f_20501_, EntityType.f_20530_, EntityType.f_20562_, EntityType.f_20458_, EntityType.f_20500_, EntityType.f_20456_, EntityType.f_20454_, EntityType.f_147035_, EntityType.f_20518_});
            this.addOptional(RediscoveredTags.Entities.TARGETS_SCARECROW, "alexsmobs", "tusklin");
            this.addOptional(RediscoveredTags.Entities.FEARS_SCARECROW, "alexsmobs", "seagull", "crow");
            this.m_206424_(RediscoveredTags.Entities.IGNORES_SCARECROW).m_255179_((Object[])new EntityType[]{EntityType.f_20514_, EntityType.f_20507_, EntityType.f_20525_, EntityType.f_20502_, EntityType.f_20490_, EntityType.f_217013_, EntityType.f_20494_, EntityType.f_20492_, RediscoveredEntityTypes.RED_DRAGON_OFFSPRING});
            this.m_206424_(RediscoveredTags.Entities.IGNORES_SCARECROW).addTags(new TagKey[]{RediscoveredTags.Entities.PIGMAN, RediscoveredTags.Entities.MD3, Tags.EntityTypes.BOSSES, EntityTypeTags.f_13121_});
            this.addOptional(RediscoveredTags.Entities.IGNORES_SCARECROW, "alexsmobs", "grizzly_bear", "cockroach", "tiger");
            this.addOptionalTags(RediscoveredTags.Entities.IGNORES_SCARECROW, "irons_spellbooks", "summons");
            this.m_206424_(EntityTypeTags.f_13123_).m_255245_(RediscoveredEntityTypes.PURPLE_ARROW);
            this.m_206424_(EntityTypeTags.f_273841_).m_255179_((Object[])new EntityType[]{RediscoveredEntityTypes.RED_DRAGON_BOSS, RediscoveredEntityTypes.RED_DRAGON_OFFSPRING});
            this.m_206424_(EntityTypeTags.f_275751_).m_255245_(RediscoveredEntityTypes.RED_DRAGON_OFFSPRING);
            this.m_206424_(Tags.EntityTypes.BOSSES).m_255245_(RediscoveredEntityTypes.RED_DRAGON_BOSS);
            this.tag(new ResourceLocation("aether", "pigs")).m_206428_(RediscoveredTags.Entities.PIGMAN);
        }

        private IntrinsicHolderTagsProvider.IntrinsicTagAppender<EntityType<?>> tag(ResourceLocation tag) {
            return this.m_206424_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)tag));
        }

        private IntrinsicHolderTagsProvider.IntrinsicTagAppender<EntityType<?>> addOptional(TagKey<EntityType<?>> tag, String modid, String ... values) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender appender = this.m_206424_(tag);
            for (String v : values) {
                appender.m_176839_(new ResourceLocation(modid, v));
            }
            return appender;
        }

        private IntrinsicHolderTagsProvider.IntrinsicTagAppender<EntityType<?>> addOptionalTags(TagKey<EntityType<?>> tag, String modid, String ... values) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender appender = this.m_206424_(tag);
            for (String v : values) {
                appender.m_176841_(new ResourceLocation(modid, v));
            }
            return appender;
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return super.m_213708_(cache);
        }

        public String m_6055_() {
            return "rediscovered EntityType Tags";
        }
    }

    public static class ItemProv
    extends ItemTagsProvider {
        public ItemProv(DataGenerator gen, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProv, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(gen.getPackOutput(), lookup, blockTagProv, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.rediscovered();
            this.vanilla();
            this.forge();
        }

        void rediscovered() {
            this.m_206421_(RediscoveredTags.Blocks.CHAIRS, RediscoveredTags.Items.CHAIRS);
            this.m_206421_(RediscoveredTags.Blocks.TABLES, RediscoveredTags.Items.TABLES);
            this.m_206424_(RediscoveredTags.Items.PLATE_ARMOR).m_255179_((Object[])new Item[]{RediscoveredItems.plate_boots, RediscoveredItems.plate_leggings, RediscoveredItems.plate_chestplate, RediscoveredItems.plate_helmet});
            this.m_206424_(RediscoveredTags.Items.STUDDED_ARMOR).m_255179_((Object[])new Item[]{RediscoveredItems.studded_boots, RediscoveredItems.studded_leggings, RediscoveredItems.studded_chestplate, RediscoveredItems.studded_helmet});
            this.m_206424_(RediscoveredTags.Items.QUIVERS).m_255245_((Object)RediscoveredItems.quiver);
            this.m_206424_(RediscoveredTags.Items.QUIVER_APPLICABLE).m_206428_(Tags.Items.ARMORS_CHESTPLATES);
            this.m_206424_(RediscoveredTags.Items.QUIVER_INAPPLICABLE).m_206428_(RediscoveredTags.Items.QUIVERS);
            this.m_206424_(RediscoveredTags.Items.QUIVER_USER).m_206428_(Tags.Items.TOOLS_BOWS).m_206428_(Tags.Items.TOOLS_CROSSBOWS);
            this.m_206424_(RediscoveredTags.Items.QUIVER_AMMO).m_206428_(ItemTags.f_13161_).m_255245_((Object)Items.f_42688_);
            this.m_206424_(RediscoveredTags.Items.QUIVER_AUTO_ADD).m_206428_(ItemTags.f_13161_);
            this.m_206424_(RediscoveredTags.Items.PIGMAN_GUARD_PAYMENTS).m_206428_(RediscoveredTags.Items.GEMS_RUBY);
            this.m_206424_(RediscoveredTags.Items.RANA_CURRENCY).m_255245_((Object)RediscoveredBlocks.cyan_rose.m_5456_());
            this.m_206424_(RediscoveredTags.Items.TAILOR_ARMOR_STAND_HELMETS).m_255179_((Object[])new Item[]{RediscoveredItems.studded_helmet, Items.f_42407_, Items.f_42464_});
            this.m_206424_(RediscoveredTags.Items.TAILOR_ARMOR_STAND_CHESTPLATES).m_255179_((Object[])new Item[]{RediscoveredItems.studded_chestplate, Items.f_42408_, Items.f_42465_});
            this.m_206424_(RediscoveredTags.Items.TAILOR_ARMOR_STAND_LEGGINGS).m_255179_((Object[])new Item[]{RediscoveredItems.studded_leggings, Items.f_42462_, Items.f_42466_});
            this.m_206424_(RediscoveredTags.Items.TAILOR_ARMOR_STAND_BOOTS).m_255179_((Object[])new Item[]{RediscoveredItems.studded_boots, Items.f_42463_, Items.f_42467_});
            this.m_206424_(RediscoveredTags.Items.TAILOR_UNSELLABLE_FLOWERS).m_255179_((Object[])new Item[]{Blocks.f_50070_.m_5456_(), Blocks.f_271329_.m_5456_()});
            this.m_206424_(RediscoveredTags.Items.BOWYER_UNSELLABLE_ARROWS);
            this.m_206424_(RediscoveredTags.Items.BRICK_PYRAMID_POTTERY_SHERDS).m_255179_((Object[])new Item[]{Items.f_279584_, Items.f_279606_, Items.f_279528_, Items.f_279642_, Items.f_279567_});
            this.m_206424_(RediscoveredTags.Items.DRAGON_ARMOR_MATERIALS).m_206428_(ItemTags.f_265843_);
            this.m_206424_(RediscoveredTags.Items.QUIVER_REPAIR_MATERIALS).m_206428_(Tags.Items.LEATHER);
            this.m_206424_(RediscoveredTags.Items.STUDDED_ARMOR_REPAIR_MATERIALS).m_206428_(Tags.Items.INGOTS_IRON);
            this.m_206424_(RediscoveredTags.Items.PLATE_ARMOR_REPAIR_MATERIALS).m_206428_(Tags.Items.INGOTS_IRON);
        }

        void vanilla() {
            this.m_206421_(BlockTags.f_13031_, ItemTags.f_13139_);
            this.m_206421_(BlockTags.f_13030_, ItemTags.f_13138_);
            this.m_206421_(BlockTags.f_13032_, ItemTags.f_13140_);
            this.m_206421_(BlockTags.f_13037_, ItemTags.f_13145_);
            this.m_206421_(BlockTags.f_13089_, ItemTags.f_13167_);
            this.m_206421_(BlockTags.f_215838_, ItemTags.f_215867_);
            this.m_206421_(BlockTags.f_13104_, ItemTags.f_13180_);
            this.m_206424_(ItemTags.f_13156_).m_255179_((Object[])new Item[]{RediscoveredItems.raw_fish, RediscoveredItems.cooked_fish});
            this.m_206424_(ItemTags.f_13161_).m_255245_((Object)RediscoveredItems.purple_arrow);
            this.m_206424_(ItemTags.f_13158_).m_255245_((Object)RediscoveredItems.music_disc_calm4);
            this.m_206424_(ItemTags.f_13164_).m_255245_((Object)RediscoveredItems.ruby);
            this.m_206424_(ItemTags.f_144320_).m_206428_(RediscoveredTags.Items.STUDDED_ARMOR);
            this.m_206424_(ItemTags.f_265942_).m_206428_(RediscoveredTags.Items.STUDDED_ARMOR).m_206428_(RediscoveredTags.Items.PLATE_ARMOR);
            this.m_206424_(ItemTags.f_265940_).m_255245_((Object)RediscoveredItems.draconic_trim);
            this.m_206424_(ItemTags.f_265843_).m_255245_((Object)RediscoveredItems.ruby);
        }

        void forge() {
            this.m_206424_(RediscoveredTags.Items.GEMS_RUBY).m_255245_((Object)RediscoveredItems.ruby);
            this.m_206421_(RediscoveredTags.Blocks.STORAGE_BLOCKS_RUBY, RediscoveredTags.Items.STORAGE_BLOCKS_RUBY);
            this.m_206421_(RediscoveredTags.Blocks.ORES_RUBY, RediscoveredTags.Items.ORES_RUBY);
            this.m_206424_(Tags.Items.GEMS).m_206428_(RediscoveredTags.Items.GEMS_RUBY);
            this.m_206424_(Tags.Items.ARMORS_HELMETS).m_255179_((Object[])new Item[]{RediscoveredItems.studded_helmet, RediscoveredItems.plate_helmet});
            this.m_206424_(Tags.Items.ARMORS_CHESTPLATES).m_255179_((Object[])new Item[]{RediscoveredItems.studded_chestplate, RediscoveredItems.plate_chestplate}).m_206428_(RediscoveredTags.Items.QUIVERS);
            this.m_206424_(Tags.Items.ARMORS_LEGGINGS).m_255179_((Object[])new Item[]{RediscoveredItems.studded_leggings, RediscoveredItems.plate_leggings});
            this.m_206424_(Tags.Items.ARMORS_BOOTS).m_255179_((Object[])new Item[]{RediscoveredItems.studded_boots, RediscoveredItems.plate_boots});
        }

        public String m_6055_() {
            return "rediscovered Item Tags";
        }
    }

    public static class BlockProv
    extends BlockTagsProvider {
        public BlockProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "rediscovered", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.vanilla();
            this.forge();
            this.rediscovered();
        }

        void vanilla() {
            this.addMatching((TagKey<Block>)BlockTags.f_13045_, b -> b instanceof FlowerPotBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13031_, b -> b instanceof SlabBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13030_, b -> b instanceof StairBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13032_, b -> b instanceof WallBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13037_, b -> b instanceof FlowerBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13040_, b -> b instanceof TallFlowerBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13048_, b -> b instanceof GrassBlock);
            this.m_206424_(BlockTags.f_13035_).m_255245_((Object)RediscoveredBlocks.ancient_cherry_leaves);
            this.m_206424_(BlockTags.f_13104_).m_255245_((Object)RediscoveredBlocks.ancient_cherry_sapling);
            this.m_206424_(BlockTags.f_144286_).m_255179_((Object[])new Block[]{RediscoveredBlocks.gear, RediscoveredBlocks.nether_reactor_core});
            this.m_206424_(BlockTags.f_144285_).m_255179_((Object[])new Block[]{RediscoveredBlocks.ruby_ore, RediscoveredBlocks.deepslate_ruby_ore, RediscoveredBlocks.ruby_block});
            this.m_206424_(BlockTags.f_144284_).m_255179_((Object[])new Block[]{RediscoveredBlocks.ancient_crying_obsidian, RediscoveredBlocks.glowing_obsidian});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{RediscoveredBlocks.ruby_ore, RediscoveredBlocks.deepslate_ruby_ore, RediscoveredBlocks.ruby_block, RediscoveredBlocks.ancient_crying_obsidian, RediscoveredBlocks.glowing_obsidian, RediscoveredBlocks.obsidian_bulb, RediscoveredBlocks.gear, RediscoveredBlocks.rotational_converter, RediscoveredBlocks.nether_reactor_core, RediscoveredBlocks.large_bricks, RediscoveredBlocks.large_brick_stairs, RediscoveredBlocks.large_brick_slab, RediscoveredBlocks.large_brick_wall, RediscoveredBlocks.brittle_packed_mud, RediscoveredBlocks.brittle_mud_bricks});
            this.m_206424_(BlockTags.f_144280_).m_255245_((Object)RediscoveredBlocks.spikes);
            this.addMatching((TagKey<Block>)BlockTags.f_144280_, b -> b instanceof ChairBlock || b instanceof TableBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_144283_, b -> b instanceof DirtSlabBlock || b instanceof GrassSlabBlock || b instanceof ShallowDirtSlabBlock);
            this.m_206424_(BlockTags.f_13069_).m_255179_((Object[])new Block[]{RediscoveredBlocks.red_dragon_egg, RediscoveredBlocks.ancient_crying_obsidian, RediscoveredBlocks.glowing_obsidian, RediscoveredBlocks.obsidian_bulb, RediscoveredBlocks.dragon_altar});
            this.m_206424_(BlockTags.f_13070_).m_255245_((Object)RediscoveredBlocks.dragon_altar);
            this.m_206424_(BlockTags.f_144287_).m_255245_((Object)RediscoveredBlocks.dragon_altar);
            this.m_206424_(BlockTags.f_144288_).m_255245_((Object)RediscoveredBlocks.dragon_altar);
            this.m_206424_(BlockTags.f_13079_).m_255245_((Object)RediscoveredBlocks.ruby_block);
            this.m_206424_(BlockTags.f_13089_).m_255179_((Object[])new Block[]{RediscoveredBlocks.bright_green_wool, RediscoveredBlocks.rose_wool, RediscoveredBlocks.lavender_wool, RediscoveredBlocks.sky_blue_wool, RediscoveredBlocks.slate_blue_wool, RediscoveredBlocks.spring_green_wool});
            this.m_206424_(BlockTags.f_215838_).m_255179_((Object[])new Block[]{RediscoveredBlocks.bright_green_carpet, RediscoveredBlocks.rose_carpet, RediscoveredBlocks.lavender_carpet, RediscoveredBlocks.sky_blue_carpet, RediscoveredBlocks.slate_blue_carpet, RediscoveredBlocks.spring_green_carpet});
            this.addMatching((TagKey<Block>)BlockTags.f_278394_, b -> b.m_49966_().m_247087_());
            this.addMatching((TagKey<Block>)BlockTags.f_13076_, b -> b instanceof BaseFakeFireBlock);
            this.m_206424_(BlockTags.f_13042_).m_255245_((Object)RediscoveredBlocks.fake_soul_fire);
            this.m_206424_(BlockTags.f_13075_).m_255245_((Object)RediscoveredBlocks.skylands_portal);
            this.m_206424_(BlockTags.f_13057_).m_255179_((Object[])new Block[]{RediscoveredBlocks.podzol_slab, RediscoveredBlocks.mycelium_slab});
            this.addMatching((TagKey<Block>)BlockTags.f_144274_, b -> b instanceof DirtSlabBlock || b instanceof GrassSlabBlock);
        }

        void forge() {
            this.m_206424_(RediscoveredTags.Blocks.STORAGE_BLOCKS_RUBY).m_255245_((Object)RediscoveredBlocks.ruby_block);
            this.m_206424_(RediscoveredTags.Blocks.ORES_RUBY).m_255245_((Object)RediscoveredBlocks.ruby_ore);
            this.m_206424_(Tags.Blocks.STORAGE_BLOCKS).m_206428_(RediscoveredTags.Blocks.STORAGE_BLOCKS_RUBY);
            this.m_206424_(Tags.Blocks.ORES).m_206428_(RediscoveredTags.Blocks.ORES_RUBY);
        }

        void rediscovered() {
            this.addMatching(RediscoveredTags.Blocks.CHAIRS, b -> b instanceof ChairBlock);
            this.addMatching(RediscoveredTags.Blocks.TABLES, b -> b instanceof TableBlock);
            this.m_206424_(RediscoveredTags.Blocks.NETHER_REACTOR_STRONG_POWER_BLOCK).m_206428_(Tags.Blocks.STORAGE_BLOCKS_NETHERITE);
            this.m_206424_(RediscoveredTags.Blocks.NETHER_REACTOR_POWER_BLOCK).m_206428_(Tags.Blocks.STORAGE_BLOCKS_GOLD).m_206428_(RediscoveredTags.Blocks.NETHER_REACTOR_STRONG_POWER_BLOCK);
            this.m_206424_(RediscoveredTags.Blocks.NETHER_REACTOR_BASE_BLOCK).m_206428_(Tags.Blocks.COBBLESTONE_NORMAL).m_206428_(Tags.Blocks.COBBLESTONE_DEEPSLATE).m_255179_((Object[])new Block[]{Blocks.f_50730_, RediscoveredBlocks.glowing_obsidian});
            this.m_206424_(RediscoveredTags.Blocks.SKYLANDS_PORTAL_FRAME).m_255179_((Object[])new Block[]{RediscoveredBlocks.large_bricks, Blocks.f_50076_});
            this.m_206424_(RediscoveredTags.Blocks.SKYLANDS_PORTAL_BASE).m_255179_((Object[])new Block[]{RediscoveredBlocks.glowing_obsidian, RediscoveredBlocks.dragon_altar});
            this.m_206424_(RediscoveredTags.Blocks.PIGMAN_VILLAGE_FLOWERS).m_255179_((Object[])new Block[]{RediscoveredBlocks.rose, RediscoveredBlocks.paeonia});
            this.m_206424_(RediscoveredTags.Blocks.PIGMAN_VILLAGE_RARE_FLOWERS).m_255245_((Object)RediscoveredBlocks.cyan_rose);
            this.m_206424_(RediscoveredTags.Blocks.SKYLANDS_POOL_REPLACEABLE).m_206428_(BlockTags.f_215820_).m_206428_(Tags.Blocks.ORES);
        }

        private Stream<Block> getMatching(Function<Block, Boolean> condition) {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("rediscovered") && (Boolean)condition.apply((Block)block) != false);
        }

        private void addMatching(TagKey<Block> blockTag, Function<Block, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.m_206424_(blockTag)).m_255245_(arg_0));
        }

        public String m_6055_() {
            return "rediscovered Block Tags";
        }
    }
}

