/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredSounds;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;

public class RediscoveredSoundProv
extends SoundDefinitionsProvider {
    public RediscoveredSoundProv(PackOutput output, ExistingFileHelper helper) {
        super(output, "rediscovered", helper);
    }

    public void registerSounds() {
        String block = "nether_reactor";
        this.add(RediscoveredSounds.BLOCK_NETHER_REACTOR_ACTIVATE, RediscoveredSoundProv.blockDef(block, "activate", 1));
        this.add(RediscoveredSounds.BLOCK_NETHER_REACTOR_IDLE, RediscoveredSoundProv.blockDef(block, "idle", 1, 5));
        this.add(RediscoveredSounds.BLOCK_NETHER_REACTOR_DEACTIVATE, RediscoveredSoundProv.blockDef(block, "deactivate", 1));
        block = "red_dragon_egg";
        this.add(RediscoveredSounds.BLOCK_RED_DRAGON_EGG_FERTILIZE, RediscoveredSoundProv.blockDef(block, "fertilize", 1));
        this.add(RediscoveredSounds.BLOCK_RED_DRAGON_EGG_SHAKE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12450_)).subtitle(RediscoveredSoundProv.blockSub(block + ".shake")));
        this.add(RediscoveredSounds.BLOCK_RED_DRAGON_EGG_HATCH, RediscoveredSoundProv.blockDef(block, "hatch", 1));
        this.add(RediscoveredSounds.BLOCK_ROTATIONAL_CONVERTER_CLICK, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12088_)).subtitle(RediscoveredSoundProv.blockSub("rotational_converter.click")));
        this.add(RediscoveredSounds.BLOCK_TABLE_ADD_ITEM, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12013_)).subtitle(RediscoveredSoundProv.blockSub("table.add_item")));
        this.add(RediscoveredSounds.BLOCK_TABLE_REMOVE_ITEM, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12016_)).subtitle(RediscoveredSoundProv.blockSub("table.remove_item")));
        this.add(RediscoveredSounds.ITEM_ARMOR_EQUIP_STUDDED, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11672_)).subtitle(RediscoveredSoundProv.itemSub("armor.equip_studded")));
        this.add(RediscoveredSounds.ITEM_ARMOR_EQUIP_PLATE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11679_)).subtitle(RediscoveredSoundProv.itemSub("armor.equip_plate")));
        String entity = "pigman";
        this.add(RediscoveredSounds.ENTITY_PIGMAN_IDLE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12233_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".idle")));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_HURT, RediscoveredSoundProv.entityDef(entity, "hurt", 2));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12234_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_SCARED, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(RediscoveredSounds.ENTITY_PIGMAN_HURT)).subtitle(RediscoveredSoundProv.entitySub(entity + ".scared")));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_ZOMBIFY, RediscoveredSoundProv.entityDef(entity, "zombify", 2));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_AGREE, RediscoveredSoundProv.entityDef(entity, "agree", 1));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_DISAGREE, RediscoveredSoundProv.entityDef(entity, "disagree", 2));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_METALWORKER, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12574_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".work_metalworker")));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_BOWYER, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12569_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".work_bowyer")));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_TECHNICIAN, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_144059_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".work_technician")));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_TAILOR, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12573_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".work_tailor")));
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_DOCTOR, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12566_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".work_doctor")));
        entity = "zombie_pigman";
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_IDLE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12610_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".idle")));
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_HURT, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12613_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".hurt")));
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12612_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_ANGRY, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12611_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".angry")));
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_CURE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12644_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".cure")));
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_FINISH_CURE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12616_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".finish_cure")));
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_SELECT_MELEE, RediscoveredSoundProv.entityDef(entity, "select_melee", 1));
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_SELECT_RANGED, RediscoveredSoundProv.entityDef(entity, "select_ranged", 1));
        entity = "steve";
        this.add(RediscoveredSounds.ENTITY_STEVE_HURT, RediscoveredSoundProv.entityDef(entity, "hurt", 1));
        this.add(RediscoveredSounds.ENTITY_STEVE_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(RediscoveredSounds.ENTITY_STEVE_HURT)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        entity = "black_steve";
        this.add(RediscoveredSounds.ENTITY_BLACK_STEVE_HURT, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(RediscoveredSounds.ENTITY_STEVE_HURT)).subtitle(RediscoveredSoundProv.entitySub(entity + ".hurt")));
        this.add(RediscoveredSounds.ENTITY_BLACK_STEVE_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(RediscoveredSounds.ENTITY_STEVE_HURT)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        entity = "beast_boy";
        this.add(RediscoveredSounds.ENTITY_BEAST_BOY_HURT, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(RediscoveredSounds.ENTITY_STEVE_HURT)).subtitle(RediscoveredSoundProv.entitySub(entity + ".hurt")));
        this.add(RediscoveredSounds.ENTITY_BEAST_BOY_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(RediscoveredSounds.ENTITY_STEVE_HURT)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        entity = "rana";
        this.add(RediscoveredSounds.ENTITY_RANA_HURT, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11915_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".hurt")));
        this.add(RediscoveredSounds.ENTITY_RANA_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11915_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        entity = "fish";
        this.add(RediscoveredSounds.ENTITY_FISH_HURT, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11761_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".hurt")));
        this.add(RediscoveredSounds.ENTITY_FISH_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11759_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        this.add(RediscoveredSounds.ENTITY_FISH_FLOP, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11760_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".flop")));
        entity = "pylon_burst";
        this.add(RediscoveredSounds.ENTITY_PYLON_BURST_DESTROYED, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12411_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".destroyed")));
        this.add(RediscoveredSounds.ENTITY_PYLON_BURST_EXPLODE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12410_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".explode")));
        entity = "dragon_pylon";
        this.add(RediscoveredSounds.ENTITY_DRAGON_PYLON_SHIELD_LOST, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event((SoundEvent)SoundEvents.f_12377_.m_203334_())).subtitle(RediscoveredSoundProv.entitySub(entity + ".shield_lost")));
        this.add(RediscoveredSounds.ENTITY_DRAGON_PYLON_HURT, RediscoveredSoundProv.entityDef(entity, "hurt", 3));
        this.add(RediscoveredSounds.ENTITY_DRAGON_PYLON_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11913_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        entity = "red_dragon";
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_IDLE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11890_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".idle")));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_IDLE_CALM, RediscoveredSoundProv.entityDef(entity, "idle_calm", 2));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_HURT, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11895_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".hurt")));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_DEATH, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11891_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".death")));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_FLAP, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11893_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".flap")));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_STEP, RediscoveredSoundProv.entityDef(entity, "step", 4).subtitle("subtitles.block.generic.footsteps"));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_SHIELD_DOWN, RediscoveredSoundProv.entityDef(entity, "shield_down", 1));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_BOLT_BALL_CHARGE, RediscoveredSoundProv.entityDef(entity, "bolt_ball_charge", 1));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_BOLT_BALL_SHOOT, RediscoveredSoundProv.entityDef(entity, "bolt_ball_shoot", 2));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_PREPARE_WIND_BLOW, RediscoveredSoundProv.entityDef(entity, "prepare_wind_blow", 1));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_WIND_BLOW, RediscoveredSoundProv.entityDef(entity, "wind", 4));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_SHED_BURSTS, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12417_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".shed_bursts")));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_EQUIP_SADDLE, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_12034_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".equip_saddle")));
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_EQUIP_ARMOR, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.event(SoundEvents.f_11973_)).subtitle(RediscoveredSoundProv.entitySub(entity + ".equip_armor")));
        String record = "records/";
        this.add(RediscoveredSounds.RECORDS_MAGNETIC_CIRCUIT, RediscoveredSoundProv.definition().with(RediscoveredSoundProv.make(record.concat("calm4")).stream()));
    }

    protected static SoundDefinition def(Dir dir, String name, String subtitle) {
        return RediscoveredSoundProv.def(dir, name, 1, subtitle);
    }

    protected static SoundDefinition def(Dir dir, String name, int count, String subtitle) {
        return RediscoveredSoundProv.def(dir, name, count, subtitle, s -> {});
    }

    protected static SoundDefinition def(Dir dir, String name, int count, String subtitle, Consumer<SoundDefinition.Sound> extra) {
        SoundDefinition def;
        SoundDefinition soundDefinition = def = count > 1 ? RediscoveredSoundProv.definition().with(RediscoveredSoundProv.make(dir.folderName.concat(name), count, extra)) : RediscoveredSoundProv.definition().with(RediscoveredSoundProv.make(dir.folderName.concat(name), extra));
        return def.subtitle(dir == Dir.ENTITY ? RediscoveredSoundProv.entitySub(subtitle) : (dir == Dir.BLOCKS ? RediscoveredSoundProv.blockSub(subtitle) : (dir == Dir.ITEMS ? RediscoveredSoundProv.itemSub(subtitle) : subtitle)));
    }

    protected static SoundDefinition.Sound make(String name) {
        return RediscoveredSoundProv.make(name, s -> {});
    }

    protected static SoundDefinition.Sound make(String name, Consumer<SoundDefinition.Sound> extra) {
        SoundDefinition.Sound sound = RediscoveredSoundProv.sound((ResourceLocation)RediscoveredMod.locate(name));
        extra.accept(sound);
        return sound;
    }

    protected static SoundDefinition.Sound[] make(String name, int count) {
        return RediscoveredSoundProv.make(name, count, s -> {});
    }

    protected static SoundDefinition.Sound[] make(String name, int count, Consumer<SoundDefinition.Sound> extra) {
        ArrayList<SoundDefinition.Sound> sounds = new ArrayList<SoundDefinition.Sound>();
        for (int i = 1; i <= count; ++i) {
            SoundDefinition.Sound sound = RediscoveredSoundProv.make(name.concat("_" + i));
            extra.accept(sound);
            sounds.add(sound);
        }
        return sounds.toArray(new SoundDefinition.Sound[count]);
    }

    protected static SoundDefinition.Sound event(SoundEvent event) {
        return RediscoveredSoundProv.sound((ResourceLocation)BuiltInRegistries.f_256894_.m_7981_((Object)event), (SoundDefinition.SoundType)SoundDefinition.SoundType.EVENT);
    }

    protected static String sub(String name) {
        return "subtitles.".concat("rediscovered." + name);
    }

    protected static String blockSub(String name) {
        return RediscoveredSoundProv.sub("block.".concat(name));
    }

    protected static String itemSub(String name) {
        return RediscoveredSoundProv.sub("item.".concat(name));
    }

    protected static String entitySub(String name) {
        return RediscoveredSoundProv.sub("entity.".concat(name));
    }

    protected static SoundDefinition musicDef(String name) {
        return RediscoveredSoundProv.musicDef(name, false);
    }

    protected static SoundDefinition musicDef(String name, boolean preload) {
        String music = "music/";
        return RediscoveredSoundProv.definition().with(RediscoveredSoundProv.make(music.concat(name)).stream().preload(preload));
    }

    protected static SoundDefinition entityDef(String entityName, String soundName, int count, String subtitle) {
        return RediscoveredSoundProv.def(Dir.ENTITY, entityName + "/" + soundName, count, entityName + "." + subtitle);
    }

    protected static SoundDefinition entityDef(String entityName, String soundName, int count) {
        return RediscoveredSoundProv.entityDef(entityName, soundName, count, soundName);
    }

    protected static SoundDefinition blockDef(String blockName, String soundName, int count) {
        return RediscoveredSoundProv.blockDef(blockName, soundName, count, 0);
    }

    protected static SoundDefinition blockDef(String blockName, String soundName, int count, int attenuationDistance) {
        String defName = blockName + "/" + soundName;
        String defSubtitle = blockName + "." + soundName;
        return RediscoveredSoundProv.def(Dir.BLOCKS, defName, count, defSubtitle, s -> {
            if (attenuationDistance > 0) {
                s.attenuationDistance(attenuationDistance);
            }
        });
    }

    protected static SoundDefinition itemDef(String itemName, String soundName, int count, String subtitle) {
        return RediscoveredSoundProv.def(Dir.ITEMS, itemName + "/" + soundName, count, itemName + "." + subtitle);
    }

    protected static SoundDefinition itemDef(String itemName, String soundName, int count) {
        return RediscoveredSoundProv.def(Dir.ITEMS, itemName + "/" + soundName, count, itemName);
    }

    private static enum Dir {
        BLOCKS("block/"),
        ITEMS("item/"),
        ENTITY("entity/"),
        MUSIC("music/");

        public final String folderName;

        private Dir(String folderName) {
            this.folderName = folderName;
        }
    }
}

