/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.block.BrittleBlock;
import com.legacy.rediscovered.block.ChairBlock;
import com.legacy.rediscovered.block.DragonAltarBlock;
import com.legacy.rediscovered.block.NetherReactorBlock;
import com.legacy.rediscovered.block.ObsidianBulbBlock;
import com.legacy.rediscovered.block.ShallowDirtSlabBlock;
import com.legacy.rediscovered.block.TableBlock;
import com.legacy.rediscovered.item.util.DragonArmorTrim;
import com.legacy.rediscovered.registry.RediscoveredArmorTrims;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.ModelProvider;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class RediscoveredModelProv {
    private static final String GENERATED = "item/generated";
    private static final String HANDHELD = "item/handheld";

    protected static List<Block> getAllBlocks() {
        return BuiltInRegistries.f_256975_.m_123024_().filter(block -> BuiltInRegistries.f_256975_.m_7981_(block).m_135827_().equals("rediscovered")).toList();
    }

    protected static List<Item> getAllItems(Function<Item, Boolean> condition) {
        return BuiltInRegistries.f_257033_.m_123024_().filter(item -> BuiltInRegistries.f_257033_.m_7981_(item).m_135827_().equals("rediscovered") && (Boolean)condition.apply((Item)item) != false).toList();
    }

    protected static List<Item> getAllItems() {
        return RediscoveredModelProv.getAllItems(i -> true);
    }

    public static class States
    extends BlockStateProvider {
        private static final String GRASS_SLAB_SNOW = "grass_slab_snow";
        private static final String GRASS_SLAB_TOP_SNOW = "grass_slab_top_snow";
        public static final Direction[] HORIZONTAL = (Direction[])Arrays.stream(Direction.values()).filter(d -> d.m_122434_() != Direction.Axis.Y).toArray(Direction[]::new);

        public States(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "rediscovered", existingFileHelper);
        }

        protected void registerStatesAndModels() {
            this.leaves((LeavesBlock)RediscoveredBlocks.ancient_cherry_leaves, null);
            this.cross(RediscoveredBlocks.ancient_cherry_sapling);
            this.pottedCross(RediscoveredBlocks.potted_ancient_cherry_sapling, null);
            this.cross(RediscoveredBlocks.paeonia);
            this.pottedCross(RediscoveredBlocks.potted_paeonia, null);
            this.cross(RediscoveredBlocks.rose);
            this.pottedCross(RediscoveredBlocks.potted_rose, null);
            this.cross(RediscoveredBlocks.cyan_rose);
            this.pottedCross(RediscoveredBlocks.potted_cyan_rose, null);
            this.tallCross(RediscoveredBlocks.empty_peony_bush);
            this.tallCross(RediscoveredBlocks.empty_rose_bush);
            this.simpleBlock(RediscoveredBlocks.ruby_block);
            this.simpleBlock(RediscoveredBlocks.ruby_ore);
            this.simpleBlock(RediscoveredBlocks.deepslate_ruby_ore);
            this.simpleBlock(RediscoveredBlocks.ancient_crying_obsidian);
            this.simpleBlock(RediscoveredBlocks.glowing_obsidian);
            this.obsidianLamp(RediscoveredBlocks.obsidian_bulb);
            this.simpleBlock(RediscoveredBlocks.bright_green_wool);
            this.simpleBlock(RediscoveredBlocks.spring_green_wool);
            this.simpleBlock(RediscoveredBlocks.sky_blue_wool);
            this.simpleBlock(RediscoveredBlocks.slate_blue_wool);
            this.simpleBlock(RediscoveredBlocks.lavender_wool);
            this.simpleBlock(RediscoveredBlocks.rose_wool);
            this.simpleBlock(RediscoveredBlocks.large_bricks);
            this.dragonAltar(RediscoveredBlocks.dragon_altar);
            this.carpet(RediscoveredBlocks.bright_green_carpet, RediscoveredBlocks.bright_green_wool);
            this.carpet(RediscoveredBlocks.spring_green_carpet, RediscoveredBlocks.spring_green_wool);
            this.carpet(RediscoveredBlocks.sky_blue_carpet, RediscoveredBlocks.sky_blue_wool);
            this.carpet(RediscoveredBlocks.slate_blue_carpet, RediscoveredBlocks.slate_blue_wool);
            this.carpet(RediscoveredBlocks.lavender_carpet, RediscoveredBlocks.lavender_wool);
            this.carpet(RediscoveredBlocks.rose_carpet, RediscoveredBlocks.rose_wool);
            this.stairs(RediscoveredBlocks.large_brick_stairs, RediscoveredBlocks.large_bricks);
            this.models().slab(GRASS_SLAB_SNOW, this.modLoc("block/grass_slab_snow"), this.blockTexture(Blocks.f_50493_), this.blockTexture(Blocks.f_50125_));
            this.models().slabTop(GRASS_SLAB_TOP_SNOW, this.blockTexture(Blocks.f_50440_).m_266382_("_snow"), this.blockTexture(Blocks.f_50493_), this.blockTexture(Blocks.f_50125_));
            this.slab(RediscoveredBlocks.dirt_slab, Blocks.f_50493_);
            this.slab(RediscoveredBlocks.coarse_dirt_slab, Blocks.f_50546_);
            this.slab(RediscoveredBlocks.rooted_dirt_slab, Blocks.f_152549_);
            this.grassSlab(RediscoveredBlocks.grass_slab, Blocks.f_50440_, true, Blocks.f_50493_);
            this.grassSlab(RediscoveredBlocks.mycelium_slab, Blocks.f_50195_, false, Blocks.f_50493_);
            this.grassSlab(RediscoveredBlocks.podzol_slab, Blocks.f_50599_, false, Blocks.f_50493_);
            this.grassSlab(RediscoveredBlocks.dirt_path_slab, Blocks.f_152481_, false, Blocks.f_50493_);
            this.slab(RediscoveredBlocks.large_brick_slab, RediscoveredBlocks.large_bricks);
            this.wall(RediscoveredBlocks.large_brick_wall, RediscoveredBlocks.large_bricks);
            this.furniture(RediscoveredBlocks.oak_chair, RediscoveredBlocks.oak_table, Blocks.f_50705_);
            this.furniture(RediscoveredBlocks.spruce_chair, RediscoveredBlocks.spruce_table, Blocks.f_50741_);
            this.furniture(RediscoveredBlocks.birch_chair, RediscoveredBlocks.birch_table, Blocks.f_50742_);
            this.furniture(RediscoveredBlocks.jungle_chair, RediscoveredBlocks.jungle_table, Blocks.f_50743_);
            this.furniture(RediscoveredBlocks.acacia_chair, RediscoveredBlocks.acacia_table, Blocks.f_50744_);
            this.furniture(RediscoveredBlocks.dark_oak_chair, RediscoveredBlocks.dark_oak_table, Blocks.f_50745_);
            this.furniture(RediscoveredBlocks.mangrove_chair, RediscoveredBlocks.mangrove_table, Blocks.f_220865_);
            this.furniture(RediscoveredBlocks.cherry_chair, RediscoveredBlocks.cherry_table, Blocks.f_271304_);
            this.furniture(RediscoveredBlocks.bamboo_chair, RediscoveredBlocks.bamboo_table, Blocks.f_244477_);
            this.furniture(RediscoveredBlocks.crimson_chair, RediscoveredBlocks.crimson_table, Blocks.f_50655_);
            this.furniture(RediscoveredBlocks.warped_chair, RediscoveredBlocks.warped_table, Blocks.f_50656_);
            this.redDragonEgg();
            this.netherReactor(RediscoveredBlocks.nether_reactor_core);
            this.fakeFire(RediscoveredBlocks.fake_fire, Blocks.f_50083_, 2);
            this.fakeFire(RediscoveredBlocks.fake_soul_fire, Blocks.f_50084_, 2);
            this.rubyEye(RediscoveredBlocks.ruby_eye);
            this.horizontalPortal(RediscoveredBlocks.skylands_portal);
            this.brittleBlock(RediscoveredBlocks.brittle_packed_mud);
            this.brittleBlock(RediscoveredBlocks.brittle_mud_bricks);
            this.dragonPylon(RediscoveredBlocks.mini_dragon_pylon, RediscoveredMod.locate("entity/dragon_pylon/core_particle"));
            for (Block block : this.registeredBlocks.keySet()) {
                boolean contained;
                boolean bl = contained = !this.itemModels().generatedModels.containsKey(this.modLoc("block/" + this.name(block))) && !this.itemModels().generatedModels.containsKey(this.modLoc("item/" + this.name(block)));
                Item possibleItem = (Item)BuiltInRegistries.f_257033_.m_7745_(this.key(block));
                if (possibleItem == null || possibleItem == Blocks.f_50016_.m_5456_() || !contained) continue;
                try {
                    this.itemModels().withExistingParent(this.name(block), this.modLoc("block/" + this.name(block)));
                }
                catch (Exception exception) {}
            }
        }

        public void dragonAltar(Block block) {
            String name = this.name(block);
            ResourceLocation topEdgeTex = this.blockTexture(block).m_266382_("_top_edge");
            ResourceLocation topCornerTex = this.blockTexture(block).m_266382_("_top_corner");
            ResourceLocation sideTex = this.blockTexture(block).m_266382_("_side");
            ResourceLocation copperTex = this.blockTexture(Blocks.f_152504_);
            BlockModelBuilder edgeModel = this.cubeColumnMatchingEnds(name + "_edge", sideTex, copperTex, topEdgeTex);
            BlockModelBuilder cornerModel = this.cubeColumnMatchingEnds(name + "_corner", copperTex, copperTex, topCornerTex);
            ModelFile.ExistingModelFile centerModel = this.models().getExistingFile(this.blockFolder(this.name(RediscoveredBlocks.glowing_obsidian)));
            VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
            for (DragonAltarBlock.Shape shape : DragonAltarBlock.SHAPE.m_6908_()) {
                BlockModelBuilder model = shape == DragonAltarBlock.Shape.CORNER ? cornerModel : (shape == DragonAltarBlock.Shape.CENTER ? centerModel : edgeModel);
                for (Direction facing : DragonAltarBlock.FACING.m_6908_()) {
                    variantBuilder.partialState().with(DragonAltarBlock.SHAPE, (Comparable)((Object)shape)).with(DragonAltarBlock.FACING, (Comparable)facing).addModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(shape == DragonAltarBlock.Shape.CENTER ? 0 : (int)facing.m_122435_()).build());
                }
            }
            this.itemModels().withExistingParent(name, edgeModel.getLocation());
        }

        public BlockModelBuilder cubeColumnMatchingEnds(String name, ResourceLocation sideTexture, ResourceLocation frontTexture, ResourceLocation endTexture) {
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcBlockFolder("block"))).texture("end", endTexture)).texture("side", sideTexture)).texture("front", frontTexture)).texture("particle", "#end")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#side").uvs(0.0f, 0.0f, 16.0f, 16.0f).end().face(Direction.SOUTH).texture("#side").uvs(0.0f, 0.0f, 16.0f, 16.0f).end().face(Direction.EAST).texture("#front").uvs(0.0f, 0.0f, 16.0f, 16.0f).end().face(Direction.WEST).texture("#front").uvs(0.0f, 0.0f, 16.0f, 16.0f).end().face(Direction.UP).texture("#end").uvs(0.0f, 0.0f, 16.0f, 16.0f).end().face(Direction.DOWN).texture("#end").uvs(0.0f, 16.0f, 16.0f, 0.0f).end().end();
        }

        public void dragonPylon(Block block, ResourceLocation texture) {
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(this.name(block), texture);
            this.simpleBlock(block, (ModelFile)model);
        }

        public void rubyEye(Block block) {
            this.simpleBlock(block, (ModelFile)this.models().getBuilder(this.name(block)));
            Item item = block.m_5456_();
            String name = this.name(item);
            ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent(name, RediscoveredModelProv.GENERATED)).texture("layer0", this.itemFolder(name).m_266382_("_4"));
            for (int i = 0; i <= 4; ++i) {
                builder.override().predicate(RediscoveredMod.locate("eye_glow"), (float)i / 4.0f).model((ModelFile)((ItemModelBuilder)this.itemModels().withExistingParent(name + "_" + i, RediscoveredModelProv.GENERATED)).texture("layer0", this.itemFolder(name).m_266382_("_" + i)));
            }
        }

        public void brittleBlock(Block block) {
            String name = this.name(block);
            VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
            int size = BrittleBlock.STRENGTH.m_6908_().size();
            BlockModelBuilder[] models = new BlockModelBuilder[size];
            for (int i = 0; i < size; ++i) {
                BlockModelBuilder model;
                String suffix = "_" + i;
                models[i] = model = (BlockModelBuilder)this.models().cubeAll(name + suffix, this.blockTexture(block).m_266382_(suffix));
                variantBuilder.partialState().with((Property)BrittleBlock.STRENGTH, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
            }
            this.itemModels().withExistingParent(name, models[0].getLocation());
        }

        public void horizontalPortal(Block block) {
            String name = this.name(block);
            ResourceLocation texture = this.blockTexture(block);
            String portal = "portal";
            String portalKey = "#" + portal;
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).texture(portal, texture)).texture("particle", texture)).renderType("translucent")).ao(false)).element().from(0.0f, 6.0f, 0.0f).to(16.0f, 10.0f, 16.0f).face(Direction.UP).texture(portalKey).end().face(Direction.DOWN).texture(portalKey).end().end();
            this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }

        public void obsidianLamp(Block block) {
            String name = this.name(block);
            ResourceLocation texture = this.blockTexture(block);
            BlockModelBuilder unpowered = (BlockModelBuilder)this.models().cubeAll(name, texture);
            BlockModelBuilder unpowered_lit = (BlockModelBuilder)this.models().cubeAll(name + "_lit", texture.m_266382_("_lit"));
            BlockModelBuilder powered = (BlockModelBuilder)this.models().cubeAll(name + "_powered", texture.m_266382_("_powered"));
            BlockModelBuilder powered_lit = (BlockModelBuilder)this.models().cubeAll(name + "_powered_lit", texture.m_266382_("_powered_lit"));
            VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
            Iterator iterator = ObsidianBulbBlock.LIGHT_LEVEL.m_6908_().iterator();
            while (iterator.hasNext()) {
                int light = (Integer)iterator.next();
                boolean lit = light > 0;
                variantBuilder.partialState().with((Property)ObsidianBulbBlock.POWERED, (Comparable)Boolean.valueOf(false)).with((Property)ObsidianBulbBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)(lit ? unpowered_lit : unpowered))});
                variantBuilder.partialState().with((Property)ObsidianBulbBlock.POWERED, (Comparable)Boolean.valueOf(true)).with((Property)ObsidianBulbBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)(lit ? powered_lit : powered))});
            }
            this.itemModels().withExistingParent(name, unpowered.getLocation());
        }

        public void fakeFire(Block fakeFire, Block fire, int variants) {
            String name = this.name(fakeFire);
            ResourceLocation tempFloor = new ResourceLocation("block/template_fire_floor");
            ResourceLocation tempSide = new ResourceLocation("block/template_fire_side");
            ResourceLocation tempSideAlt = new ResourceLocation("block/template_fire_side_alt");
            ArrayList<BlockModelBuilder> floorModels = new ArrayList<BlockModelBuilder>();
            ArrayList<BlockModelBuilder> sideModels = new ArrayList<BlockModelBuilder>();
            ArrayList<BlockModelBuilder> sideAltModels = new ArrayList<BlockModelBuilder>();
            for (int variant = 0; variant < variants; ++variant) {
                String renderType = "cutout";
                String v = variants > 0 ? Integer.toString(variant) : "";
                ResourceLocation texture = this.blockTexture(fire).m_266382_((String)(v.isEmpty() ? "" : "_" + v));
                floorModels.add((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_floor" + v, tempFloor)).texture("fire", texture)).renderType(renderType));
                sideModels.add((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_side" + v, tempSide)).texture("fire", texture)).renderType(renderType));
                sideAltModels.add((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_side_alt" + v, tempSideAlt)).texture("fire", texture)).renderType(renderType));
            }
            MultiPartBlockStateBuilder multiPart = this.getMultipartBuilder(fakeFire);
            ConfiguredModel.Builder floorBuilder = multiPart.part();
            for (int i = 0; i < variants; ++i) {
                floorBuilder = floorBuilder.modelFile((ModelFile)floorModels.get(i));
                if (i >= variants - 1) continue;
                floorBuilder = floorBuilder.nextModel();
            }
            floorBuilder.addModel();
            for (int rotation : new int[]{0, 90, 180, 270}) {
                ConfiguredModel.Builder sideBuilder = multiPart.part();
                for (int i = 0; i < variants; ++i) {
                    sideBuilder = sideBuilder.modelFile((ModelFile)sideModels.get(i)).rotationY(rotation).nextModel().modelFile((ModelFile)sideAltModels.get(i)).rotationY(rotation);
                    if (i >= variants - 1) continue;
                    sideBuilder = sideBuilder.nextModel();
                }
                sideBuilder.addModel();
            }
        }

        public void netherReactor(Block block) {
            String name = this.name(block);
            ResourceLocation texture = this.blockTexture(block);
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(name, texture);
            BlockModelBuilder activeModel = (BlockModelBuilder)this.models().cubeAll(name + "_active", texture.m_266382_("_active"));
            this.getVariantBuilder(block).partialState().with((Property)NetherReactorBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)}).partialState().with((Property)NetherReactorBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)activeModel)});
            this.itemModels().withExistingParent(name, model.getLocation());
        }

        public void pillarBlock(Block block, Block topTextureParent) {
            this.pillarBlock(block, topTextureParent, null);
        }

        public void pillarBlock(Block block, Block textureParent, @Nullable String renderType) {
            ResourceLocation baseName = this.blockTexture(textureParent != null ? textureParent : block);
            if (block instanceof RotatedPillarBlock) {
                RotatedPillarBlock pillar = (RotatedPillarBlock)block;
                ResourceLocation side = this.extend(baseName, "_side");
                this.axisBlockWithRenderType(pillar, side, textureParent != null ? side : this.extend(baseName, "_top"), renderType != null ? renderType : "solid");
            } else {
                RediscoveredMod.LOGGER.error("Tried to datagen model for non pillar block: {}", (Object)baseName);
            }
        }

        public void door(Block block, Item item, @Nullable String renderType) {
            if (block instanceof DoorBlock) {
                DoorBlock door = (DoorBlock)block;
                this.doorBlockWithRenderType(door, this.extend(this.blockTexture((Block)door), "_lower"), this.extend(this.blockTexture((Block)door), "_upper"), renderType != null ? renderType : "cutout");
                this.itemModels().basicItem(item);
            }
        }

        public void trapDoor(Block block, boolean orientable) {
            if (block instanceof TrapDoorBlock) {
                TrapDoorBlock door = (TrapDoorBlock)block;
                this.trapdoorBlockWithRenderType(door, this.blockTexture((Block)door), orientable, "cutout");
                this.itemModels().withExistingParent(this.name((Block)door), this.extend(this.blockTexture((Block)door), "_bottom"));
            }
        }

        public void trapDoor(Block block, boolean orientable, @Nullable String renderType) {
            if (block instanceof TrapDoorBlock) {
                TrapDoorBlock door = (TrapDoorBlock)block;
                this.trapdoorBlockWithRenderType(door, this.blockTexture((Block)door), orientable, renderType != null ? renderType : "cutout");
                this.itemModels().withExistingParent(this.name((Block)door), this.extend(this.blockTexture((Block)door), "_bottom"));
            }
        }

        public void vine(Block b) {
            BlockModelBuilder vineModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(b), "block/vine")).texture("vine", this.blockTexture(b))).texture("particle", "#vine")).renderType("cutout");
            MultiPartBlockStateBuilder vineStateBuilder = this.getMultipartBuilder(b);
            for (Direction dir : VineBlock.f_57838_.keySet().stream().sorted().toList()) {
                int y = dir.m_122424_().m_122416_() * 90;
                ((MultiPartBlockStateBuilder.PartBuilder)vineStateBuilder.part().modelFile((ModelFile)vineModel).uvLock(true).rotationX(dir == Direction.UP ? 270 : 0).rotationY(y % 360).addModel()).condition((Property)VineBlock.f_57838_.get(dir), (Comparable[])new Boolean[]{true}).end();
            }
            this.item((ItemLike)b.m_5456_(), true);
        }

        public void cross(Block block) {
            this.cross(block, this.name(block), true);
        }

        public void cross(Block block, String name, boolean item) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcBlockFolder("cross"))).texture("cross", this.blockFolder(name))).renderType("cutout"));
            if (item) {
                this.item((ItemLike)block.m_5456_(), true);
            }
        }

        public void pottedCross(Block block, ResourceLocation texture) {
            if (texture == null) {
                texture = this.blockTexture(block);
                texture = texture.m_247449_(texture.m_135815_().replace("potted_", ""));
            }
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcBlockFolder("flower_pot_cross"))).texture("plant", texture)).renderType("cutout");
            this.simpleBlock(block, (ModelFile)model);
        }

        public void tallCross(Block block) {
            BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block).concat("_top"), this.mcBlockFolder("cross"))).renderType("cutout");
            BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block).concat("_bottom"), this.mcBlockFolder("cross"))).renderType("cutout");
            ResourceLocation topTex = this.extend(this.blockTexture(block), "_top");
            ResourceLocation bottomTex = this.extend(this.blockTexture(block), "_bottom");
            top = (BlockModelBuilder)top.texture("cross", topTex);
            bottom = (BlockModelBuilder)bottom.texture("cross", bottomTex);
            BlockModelBuilder topFinal = top;
            BlockModelBuilder bottomFinal = bottom;
            this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? topFinal : bottomFinal)).build(), new Property[0]);
            this.item((ItemLike)block.m_5456_(), this.extend(BuiltInRegistries.f_257033_.m_7981_((Object)block.m_5456_()), "_top"), true);
        }

        public void stairs(Block block, Block parent) {
            if (block instanceof StairBlock) {
                StairBlock stairs = (StairBlock)block;
                ResourceLocation tex = this.blockTexture(parent);
                this.stairsBlock(stairs, tex);
            } else {
                RediscoveredMod.LOGGER.error("Tried to datagen model for non stairs block: {}", (Object)this.key(block));
            }
        }

        public void slab(Block block, Block parent) {
            if (block instanceof SlabBlock) {
                SlabBlock slab = (SlabBlock)block;
                super.slabBlock(slab, this.blockTexture(parent), this.blockTexture(parent));
            } else {
                RediscoveredMod.LOGGER.error("Tried to datagen model for non slab block: {}", (Object)this.key(block));
            }
        }

        public void grassSlab(Block block, Block parent, boolean hasOverlay, Block bottom) {
            this.grassSlab(block, parent, hasOverlay, block, parent, bottom, parent);
        }

        public void grassSlab(Block block, Block parent, boolean hasOverlay, Block lowerSide, Block side, Block bottom, Block top) {
            if (block instanceof SlabBlock) {
                SlabBlock slab = (SlabBlock)block;
                ResourceLocation lowerSideTex = this.blockTexture(lowerSide).m_266382_("_side");
                ResourceLocation sideTex = this.blockTexture(side).m_266382_("_side");
                ResourceLocation bottomTex = this.blockTexture(bottom);
                ResourceLocation topTex = this.blockTexture(top).m_266382_("_top");
                if (hasOverlay) {
                    this.grassSlab(slab, (ModelFile)this.slabWithOverlay(this.name(block), lowerSideTex, bottomTex, topTex), (ModelFile)this.slabTopWithOverlay(this.name(block) + "_top", sideTex, bottomTex, topTex), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_double", this.blockTexture(parent))).renderType("cutout"));
                } else if (block instanceof ShallowDirtSlabBlock) {
                    this.grassSlab(slab, (ModelFile)this.slabShallow(this.name(block), lowerSideTex, bottomTex, topTex), (ModelFile)this.slabTopShallow(this.name(block) + "_top", sideTex, bottomTex, topTex), (ModelFile)this.models().getExistingFile(this.blockTexture(parent)));
                } else {
                    this.grassSlab(slab, (ModelFile)this.models().slab(this.name(block), lowerSideTex, bottomTex, topTex), (ModelFile)this.models().slabTop(this.name(block) + "_top", sideTex, bottomTex, topTex), (ModelFile)this.models().getExistingFile(this.blockTexture(parent)));
                }
            } else {
                RediscoveredMod.LOGGER.error("Tried to datagen model for non slab block: {}", (Object)this.key(block));
            }
        }

        public void grassSlab(SlabBlock block, ModelFile bottom, ModelFile top, ModelFile doubleslab) {
            if (block.m_49966_().m_61138_((Property)BlockStateProperties.f_61451_)) {
                VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(bottom)});
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(top)});
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(doubleslab)});
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.modLoc(GRASS_SLAB_SNOW)))});
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.modLoc(GRASS_SLAB_TOP_SNOW)))});
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).with((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(this.mcLoc("grass_block_snow")))});
            } else {
                VariantBlockStateBuilder builder = this.getVariantBuilder((Block)block);
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM).addModels(new ConfiguredModel[]{new ConfiguredModel(bottom)});
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP).addModels(new ConfiguredModel[]{new ConfiguredModel(top)});
                builder.partialState().with((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE).addModels(new ConfiguredModel[]{new ConfiguredModel(doubleslab)});
            }
        }

        public BlockModelBuilder slabShallow(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
            BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(name, "block/block");
            builder.renderType("solid");
            builder.texture("particle", bottom);
            builder.texture("bottom", bottom);
            builder.texture("top", top);
            builder.texture("side", side);
            String b = "#bottom";
            String t = "#top";
            String s = "#side";
            builder.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 7.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(b).cullface(Direction.DOWN).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(t).end().face(Direction.NORTH).uvs(0.0f, 9.0f, 16.0f, 16.0f).texture(s).cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 9.0f, 16.0f, 16.0f).texture(s).cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 9.0f, 16.0f, 16.0f).texture(s).cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 9.0f, 16.0f, 16.0f).texture(s).cullface(Direction.EAST).end().end();
            return builder;
        }

        public BlockModelBuilder slabTopShallow(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
            BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(name, "block/block");
            builder.renderType("solid");
            builder.texture("particle", bottom);
            builder.texture("bottom", bottom);
            builder.texture("top", top);
            builder.texture("side", side);
            String b = "#bottom";
            String t = "#top";
            String s = "#side";
            builder.element().from(0.0f, 8.0f, 0.0f).to(16.0f, 15.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(b).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(t).cullface(Direction.UP).end().face(Direction.NORTH).uvs(0.0f, 1.0f, 16.0f, 8.0f).texture(s).cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 1.0f, 16.0f, 8.0f).texture(s).cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 1.0f, 16.0f, 8.0f).texture(s).cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 1.0f, 16.0f, 8.0f).texture(s).cullface(Direction.EAST).end().end();
            return builder;
        }

        public BlockModelBuilder slabWithOverlay(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
            BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(name, "block/block");
            builder.renderType("cutout");
            builder.texture("particle", bottom);
            builder.texture("bottom", bottom);
            builder.texture("top", top);
            builder.texture("side", side);
            builder.texture("overlay", side.m_266382_("_overlay"));
            String b = "#bottom";
            String t = "#top";
            String s = "#side";
            String o = "#overlay";
            builder.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(b).cullface(Direction.DOWN).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(t).tintindex(0).end().face(Direction.NORTH).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(s).cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(s).cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(s).cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(s).cullface(Direction.EAST).end().end();
            builder.element().from(0.0f, 0.0f, 0.0f).to(16.0f, 8.0f, 16.0f).face(Direction.NORTH).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(o).tintindex(0).cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(o).tintindex(0).cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(o).tintindex(0).cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 8.0f, 16.0f, 16.0f).texture(o).tintindex(0).cullface(Direction.EAST).end().end();
            return builder;
        }

        public BlockModelBuilder slabTopWithOverlay(String name, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
            BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(name, "block/block");
            builder.renderType("cutout");
            builder.texture("particle", bottom);
            builder.texture("bottom", bottom);
            builder.texture("top", top);
            builder.texture("side", side);
            builder.texture("overlay", side.m_266382_("_overlay"));
            String b = "#bottom";
            String t = "#top";
            String s = "#side";
            String o = "#overlay";
            builder.element().from(0.0f, 8.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(b).end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture(t).tintindex(0).cullface(Direction.UP).end().face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(s).cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(s).cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(s).cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(s).cullface(Direction.EAST).end().end();
            builder.element().from(0.0f, 8.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(o).tintindex(0).cullface(Direction.NORTH).end().face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(o).tintindex(0).cullface(Direction.SOUTH).end().face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(o).tintindex(0).cullface(Direction.WEST).end().face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 8.0f).texture(o).tintindex(0).cullface(Direction.EAST).end().end();
            return builder;
        }

        public void fences(Block block, Block gate, Block parent) {
            FenceBlock fence;
            ResourceLocation tex = this.blockTexture(parent);
            if (block instanceof FenceBlock) {
                fence = (FenceBlock)block;
                this.fenceBlock(fence, tex);
                this.itemModels().fenceInventory(this.name((Block)fence), tex);
            } else {
                RediscoveredMod.LOGGER.error("Tried to datagen model for non fence block: {}", (Object)this.key(block));
            }
            if (gate instanceof FenceGateBlock) {
                fence = (FenceGateBlock)gate;
                this.fenceGateBlock((FenceGateBlock)fence, tex);
            } else {
                RediscoveredMod.LOGGER.error("Tried to datagen model for non gate block: {}", (Object)this.key(gate));
            }
        }

        public void wall(Block block, Block parent) {
            this.wall(block, this.blockTexture(parent), null);
        }

        public void wall(Block block, ResourceLocation tex, @Nullable String renderType) {
            if (block instanceof WallBlock) {
                WallBlock wall = (WallBlock)block;
                if (renderType != null) {
                    this.wallBlockWithRenderType(wall, tex, renderType);
                } else {
                    this.wallBlock(wall, tex);
                }
                this.itemModels().wallInventory(this.name((Block)wall), tex);
            } else {
                RediscoveredMod.LOGGER.error("Tried to datagen model for non wall block: {}", (Object)this.key(block));
            }
        }

        public void button(ButtonBlock block, ResourceLocation texture, @Nullable String renderType) {
            this.buttonBlock(block, texture);
            this.itemModels().buttonInventory(this.name((Block)block), texture);
        }

        public void sign(StandingSignBlock signBlock, WallSignBlock wallSignBlock, ResourceLocation texture) {
            this.signBlock(signBlock, wallSignBlock, texture);
            this.item((ItemLike)signBlock.m_5456_(), false);
        }

        public void craftingTable(Block block, Block bottom) {
            ResourceLocation texture = this.blockTexture(block);
            this.simpleBlock(block, (ModelFile)this.models().orientableWithBottom(this.name(block), this.extend(texture, "_side"), this.extend(texture, "_front"), this.blockTexture(bottom), this.extend(texture, "_top")));
        }

        public void ladder(Block block) {
            ResourceLocation texture = this.blockTexture(block);
            BlockModelBuilder vineModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "block/ladder")).texture("texture", texture)).texture("particle", "#texture")).renderType("cutout");
            MultiPartBlockStateBuilder ladderStateBuilder = this.getMultipartBuilder(block);
            for (Direction dir : (Direction[])Arrays.stream(Direction.values()).filter(d -> d.m_122434_() != Direction.Axis.Y).toArray(Direction[]::new)) {
                int y = dir.m_122424_().m_122416_() * 90;
                ((MultiPartBlockStateBuilder.PartBuilder)ladderStateBuilder.part().modelFile((ModelFile)vineModel).uvLock(true).rotationX(0).rotationY(y % 360).addModel()).condition((Property)LadderBlock.f_54337_, (Comparable[])new Direction[]{dir}).end();
            }
            this.item((ItemLike)block.m_5456_(), true);
        }

        public void pressurePlate(PressurePlateBlock block, ResourceLocation texture, @Nullable String renderType) {
            BlockModelBuilder pressurePlate = (BlockModelBuilder)this.models().pressurePlate(this.name((Block)block), texture);
            BlockModelBuilder pressurePlateDown = (BlockModelBuilder)this.models().pressurePlateDown(this.name((Block)block) + "_down", texture);
            if (renderType != null) {
                pressurePlate.renderType(renderType);
                pressurePlateDown.renderType(renderType);
            }
            this.pressurePlate(block, (ModelFile)pressurePlate, (ModelFile)pressurePlateDown);
        }

        public void pressurePlate(PressurePlateBlock block, ModelFile pressurePlate, ModelFile pressurePlateDown) {
            this.getVariantBuilder((Block)block).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(pressurePlateDown)}).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(pressurePlate)});
        }

        public void blockEntity(Block block, Block parent) {
            this.simpleBlock(block, (ModelFile)this.models().withExistingParent(this.name(block), this.key(parent)));
            this.itemModels().withExistingParent(this.name(block), this.key(Blocks.f_50087_));
        }

        public void leaves(LeavesBlock block, String renderType) {
            ResourceLocation texture = this.blockTexture((Block)block);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), this.mcBlockFolder("leaves"))).texture("all", texture);
            if (renderType != null) {
                model.renderType(renderType);
            }
            this.simpleBlock((Block)block, (ModelFile)model);
        }

        public void carpet(Block block, Block parent) {
            ResourceLocation texture = this.blockTexture(parent);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcBlockFolder("carpet"))).texture("wool", texture)).texture("particle", texture);
            this.simpleBlock(block, (ModelFile)model);
        }

        public void furniture(Block chair, Block table, Block parent) {
            ResourceLocation texture = this.blockTexture(parent);
            BlockModelBuilder chairModel = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(chair), this.blockFolder("template/chair_base"))).texture("texture", texture);
            MultiPartBlockStateBuilder chairStateBuilder = this.getMultipartBuilder(chair);
            for (Direction dir : HORIZONTAL) {
                int y = dir.m_122424_().m_122416_() * 90;
                ((MultiPartBlockStateBuilder.PartBuilder)chairStateBuilder.part().modelFile((ModelFile)chairModel).rotationX(0).rotationY(y % 360).addModel()).condition((Property)ChairBlock.FACING, (Comparable[])new Direction[]{dir}).end();
            }
            ((BlockModelBuilder)this.models().withExistingParent(this.name(table), this.blockFolder("template/table_base"))).texture("texture", texture);
            BlockModelBuilder tableTop = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(table) + "_top", this.blockFolder("template/table_top"))).texture("texture", texture);
            BlockModelBuilder tableCorner = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(table) + "_corner_nw", this.blockFolder("template/table_corner_nw"))).texture("texture", texture);
            BlockModelBuilder tableEdge = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(table) + "_edge_n", this.blockFolder("template/table_edge_n"))).texture("texture", texture);
            BlockModelBuilder tableLeg = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(table) + "_leg_nw", this.blockFolder("template/table_leg_nw"))).texture("texture", texture);
            MultiPartBlockStateBuilder multiPart = this.getMultipartBuilder(table);
            multiPart.part().modelFile((ModelFile)tableTop).addModel();
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableLeg).addModel()).condition((Property)TableBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)TableBlock.WEST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableCorner).addModel()).condition((Property)TableBlock.NW, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableEdge).addModel()).condition((Property)TableBlock.NORTH, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableLeg).uvLock(true).rotationY(90).addModel()).condition((Property)TableBlock.EAST, (Comparable[])new Boolean[]{false}).condition((Property)TableBlock.NORTH, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableCorner).uvLock(true).rotationY(90).addModel()).condition((Property)TableBlock.NE, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableEdge).uvLock(true).rotationY(90).addModel()).condition((Property)TableBlock.EAST, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableLeg).uvLock(true).rotationY(180).addModel()).condition((Property)TableBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)TableBlock.EAST, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableCorner).uvLock(true).rotationY(180).addModel()).condition((Property)TableBlock.SE, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableEdge).uvLock(true).rotationY(180).addModel()).condition((Property)TableBlock.SOUTH, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableLeg).uvLock(true).rotationY(270).addModel()).condition((Property)TableBlock.WEST, (Comparable[])new Boolean[]{false}).condition((Property)TableBlock.SOUTH, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableCorner).uvLock(true).rotationY(270).addModel()).condition((Property)TableBlock.SW, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)multiPart.part().modelFile((ModelFile)tableEdge).uvLock(true).rotationY(270).addModel()).condition((Property)TableBlock.WEST, (Comparable[])new Boolean[]{true});
        }

        public void redDragonEgg() {
            Block block = RediscoveredBlocks.red_dragon_egg;
            ResourceLocation texture = this.blockTexture(block);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcBlockFolder("dragon_egg"))).texture("all", texture)).texture("particle", texture);
            this.simpleBlock(block, (ModelFile)model);
        }

        public BlockModelBuilder cube(Block block) {
            return this.cube(block, this.blockTexture(block));
        }

        public BlockModelBuilder cube(Block block, ResourceLocation tex) {
            return (BlockModelBuilder)this.models().cubeAll(this.name(block), tex);
        }

        public void bookshelf(Block block, Block plank) {
            ResourceLocation plankTex = this.blockTexture(plank);
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(this.name(block), this.blockTexture(block), plankTex, plankTex);
            this.simpleBlock(block, (ModelFile)model);
        }

        public void simpleBlock(Block block) {
            this.simpleBlock(block, null);
        }

        public void simpleBlock(Block block, @Nullable String renderType) {
            ModelFile model = this.cubeAll(block);
            if (renderType != null && model instanceof BlockModelBuilder) {
                BlockModelBuilder b = (BlockModelBuilder)model;
                b.renderType(renderType);
            }
            super.simpleBlock(block, model);
        }

        private ResourceLocation key(Block block) {
            return BuiltInRegistries.f_256975_.m_7981_((Object)block);
        }

        private String name(Block block) {
            return this.key(block).m_135815_();
        }

        private ResourceLocation key(Item item) {
            return BuiltInRegistries.f_257033_.m_7981_((Object)item);
        }

        private String name(Item item) {
            return this.key(item).m_135815_();
        }

        public ResourceLocation itemFolder(String key) {
            return this.modLoc("item/" + key);
        }

        private ResourceLocation extend(ResourceLocation rl, String suffix) {
            return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
        }

        public ResourceLocation blockFolder(String key) {
            return this.modLoc("block/" + key);
        }

        public ResourceLocation mcBlockFolder(String key) {
            return this.mcLoc("block/" + key);
        }

        public ItemModelBuilder item(ItemLike item, boolean blockFolder) {
            if (item == null || item == Blocks.f_50016_.m_5456_() || item.m_5456_() == null) {
                return null;
            }
            return this.item(item, BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()), blockFolder);
        }

        public ItemModelBuilder item(ItemLike item, ResourceLocation texture, boolean blockFolder) {
            if (item == null || item == Blocks.f_50016_.m_5456_()) {
                return null;
            }
            String dir = blockFolder ? "block" : "item";
            ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(key.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(RediscoveredModelProv.GENERATED))).texture("layer0", new ResourceLocation(texture.m_135827_(), dir + "/" + texture.m_135815_()));
        }
    }

    public static class ItemModels
    extends ItemModelProvider {
        @Deprecated
        private static final List<TrimModelData> GENERATED_TRIM_MATERIALS = List.of(new TrimModelData("quartz", 0.1f, Map.of()), new TrimModelData("iron", 0.2f, Map.of(ArmorMaterials.IRON, "iron_darker")), new TrimModelData("netherite", 0.3f, Map.of(ArmorMaterials.NETHERITE, "netherite_darker")), new TrimModelData("redstone", 0.4f, Map.of()), new TrimModelData("copper", 0.5f, Map.of()), new TrimModelData("gold", 0.6f, Map.of(ArmorMaterials.GOLD, "gold_darker")), new TrimModelData("emerald", 0.7f, Map.of()), new TrimModelData("diamond", 0.8f, Map.of(ArmorMaterials.DIAMOND, "diamond_darker")), new TrimModelData("lapis", 0.9f, Map.of()), new TrimModelData("amethyst", 1.0f, Map.of()));
        private static final List<TrimModelData> TRIM_MATERIALS = (List)Util.m_137537_(() -> {
            ArrayList<TrimModelData> list = new ArrayList<TrimModelData>();
            list.addAll(GENERATED_TRIM_MATERIALS);
            list.add(TrimModelData.modded(RediscoveredArmorTrims.Materials.RUBY, 0.400173f, Map.of()));
            list.sort((a, b) -> Float.compare(a.itemModelIndex, b.itemModelIndex));
            return list;
        });

        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "rediscovered", existingFileHelper);
        }

        protected void registerModels() {
            Item converter = RediscoveredBlocks.rotational_converter.m_5456_();
            this.withExistingParent(this.name(converter), this.modLoc("block/" + this.name(converter)));
            Item spikes = RediscoveredBlocks.spikes.m_5456_();
            this.withExistingParent(this.name(spikes), this.modLoc("block/" + this.name(spikes)));
            this.basicItem(RediscoveredBlocks.gear.m_5456_());
            this.basicItem(RediscoveredItems.ruby);
            this.basicItem(RediscoveredItems.purple_arrow);
            this.basicItem(RediscoveredItems.raw_fish);
            this.basicItem(RediscoveredItems.cooked_fish);
            this.basicItem(RediscoveredItems.fish_bucket);
            this.basicItem(RediscoveredItems.scarecrow);
            this.basicItem(RediscoveredItems.draconic_trim);
            this.basicItem(RediscoveredItems.dragon_armor_chain_smithing_template);
            this.basicItem(RediscoveredItems.dragon_armor_plating_smithing_template);
            this.basicItem(RediscoveredItems.dragon_armor_inlay_smithing_template);
            this.basicItem(RediscoveredItems.music_disc_calm4);
            this.flute(RediscoveredItems.ruby_flute);
            this.tintedOverlay(RediscoveredItems.quiver);
            this.tintedOverlay(((ResourceKey)RediscoveredItems.quiver.m_204114_().m_203543_().get()).m_135782_().m_266382_("_chestplate"));
            this.trimmableArmorItem(RediscoveredItems.studded_helmet);
            this.trimmableArmorItem(RediscoveredItems.studded_chestplate);
            this.trimmableArmorItem(RediscoveredItems.studded_leggings);
            this.trimmableArmorItem(RediscoveredItems.studded_boots);
            this.trimmableArmorItem(RediscoveredItems.plate_helmet);
            this.trimmableArmorItem(RediscoveredItems.plate_chestplate);
            this.trimmableArmorItem(RediscoveredItems.plate_leggings);
            this.trimmableArmorItem(RediscoveredItems.plate_boots);
            this.dragonArmor(RediscoveredItems.dragon_armor);
            RediscoveredModelProv.getAllItems(i -> i instanceof SpawnEggItem).forEach(item -> this.withExistingParent(BuiltInRegistries.f_257033_.m_7981_(item).m_135815_(), new ResourceLocation("item/template_spawn_egg")));
        }

        public ItemModelBuilder flute(Item item) {
            String name = this.name(item);
            ResourceLocation texture = this.texLoc(name);
            ItemModelBuilder playing = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_playing", RediscoveredModelProv.GENERATED)).texture("layer0", texture)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(5.0f, -56.0f, 51.0f).translation(-3.75f, -0.25f, -1.75f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(5.0f, 124.0f, -51.0f).translation(-3.75f, -0.25f, -1.75f).scale(0.5f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-45.0f, 4.0f, 36.0f).translation(-4.0f, -6.0f, -11.0f).scale(1.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-45.0f, -176.0f, -36.0f).translation(-4.0f, -6.0f, -11.0f).scale(1.0f).end().end();
            ItemModelBuilder model = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, RediscoveredModelProv.GENERATED)).texture("layer0", texture)).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 180.0f, 0.0f).translation(0.0f, 3.0f, 1.0f).scale(0.55f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 1.0f).scale(0.55f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(0.68f).end().end()).override().predicate(RediscoveredMod.locate("playing"), 1.0f).model((ModelFile)playing).end();
            return model;
        }

        public ItemModelBuilder tintedOverlay(Item item) {
            return this.tintedOverlay(BuiltInRegistries.f_257033_.m_7981_((Object)item));
        }

        public ItemModelBuilder tintedOverlay(ResourceLocation id) {
            ResourceLocation texture = new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_());
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(RediscoveredModelProv.GENERATED))).texture("layer0", texture)).texture("layer1", texture.m_266382_("_overlay"));
        }

        public ItemModelBuilder handheldItem(Item item) {
            return this.handheldItem(Objects.requireNonNull(BuiltInRegistries.f_257033_.m_7981_((Object)item)));
        }

        public ItemModelBuilder handheldItem(ResourceLocation item) {
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(RediscoveredModelProv.HANDHELD))).texture("layer0", item.m_246208_("item/"));
        }

        public ItemModelBuilder basicItemInLoc(String name, ResourceLocation item) {
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.replace("block/", "item/"))).parent((ModelFile)new ModelFile.UncheckedModelFile(RediscoveredModelProv.GENERATED))).texture("layer0", item);
        }

        public ItemModelBuilder basicItemInLoc(ResourceLocation item) {
            return this.basicItemInLoc(item.toString(), item);
        }

        public ResourceLocation texLoc(String key) {
            return this.modLoc("item/" + key);
        }

        public ResourceLocation mcTexLoc(String key) {
            return this.mcLoc("item/" + key);
        }

        public ItemModelBuilder trimmableArmorItem(Item item) {
            if (!(item instanceof ArmorItem)) {
                throw new IllegalArgumentException(item + " is not an ArmorItem");
            }
            ArmorItem armorItem = (ArmorItem)item;
            String name = this.name((Item)armorItem);
            ArmorItem.Type armorType = armorItem.m_266204_();
            ArmorMaterial material = armorItem.m_40401_();
            HashMap<String, ItemModelBuilder> overrides = new HashMap<String, ItemModelBuilder>();
            for (TrimModelData t : TRIM_MATERIALS) {
                int layer = 0;
                String trimPalette = t.overrideArmorMaterials.getOrDefault(material, t.name);
                ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_" + trimPalette + "_trim", RediscoveredModelProv.GENERATED)).texture("layer" + layer++, this.texLoc(this.name((Item)armorItem)));
                if (armorItem.m_40401_() == ArmorMaterials.LEATHER || armorItem instanceof DyeableLeatherItem) {
                    builder.texture("layer" + layer++, this.texLoc(this.name((Item)armorItem) + "_overlay"));
                }
                ResourceLocation trimTexture = new ResourceLocation("trims/items/" + armorType.m_266355_() + "_trim_" + trimPalette);
                this.existingFileHelper.trackGenerated(trimTexture, (ExistingFileHelper.IResourceType)ModelProvider.TEXTURE);
                builder.texture("layer" + layer++, trimTexture);
                overrides.put(t.name, builder);
            }
            int layer = 0;
            ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, RediscoveredModelProv.GENERATED)).texture("layer" + layer++, this.texLoc(this.name((Item)armorItem)));
            if (armorItem.m_40401_() == ArmorMaterials.LEATHER || armorItem instanceof DyeableLeatherItem) {
                builder.texture("layer" + layer++, this.texLoc(this.name((Item)armorItem) + "_overlay"));
            }
            for (TrimModelData t : TRIM_MATERIALS) {
                builder.override().predicate(ItemModelGenerators.f_265922_, t.itemModelIndex).model((ModelFile)overrides.get(t.name));
            }
            return builder;
        }

        public ItemModelBuilder dragonArmor(Item item) {
            String name = this.name(item);
            ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, RediscoveredModelProv.GENERATED);
            int layer = 0;
            for (DragonArmorTrim.Decoration dec : DragonArmorTrim.Decoration.values()) {
                builder.texture("layer" + layer++, this.texLoc(name + "_" + dec.m_7912_()));
            }
            return builder;
        }

        private ResourceLocation key(Item item) {
            return BuiltInRegistries.f_257033_.m_7981_((Object)item);
        }

        private String name(Item item) {
            return this.key(item).m_135815_();
        }

        record TrimModelData(String name, float itemModelIndex, Map<ArmorMaterial, String> overrideArmorMaterials) {
            public String name(ArmorMaterial armorMaterial) {
                return this.overrideArmorMaterials.getOrDefault(armorMaterial, this.name);
            }

            public static TrimModelData modded(ResourceKey<TrimMaterial> key, float itemModelIndex, Map<ArmorMaterial, String> overrideArmorMaterials) {
                return new TrimModelData(RediscoveredArmorTrims.Materials.assetID(key), itemModelIndex, overrideArmorMaterials);
            }
        }
    }
}

