/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.block.BaseFakeFireBlock;
import com.legacy.rediscovered.block.BrittleBlock;
import com.legacy.rediscovered.block.GearBlock;
import com.legacy.rediscovered.block.GrassSlabBlock;
import com.legacy.rediscovered.block.RedDragonEggBlock;
import com.legacy.rediscovered.data.loot_functions.SetAttachedQuiverFunction;
import com.legacy.rediscovered.data.loot_functions.SetQuiverContentsFunction;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.data.loot.packs.VanillaEntityLoot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public class RediscoveredLootProv
extends LootTableProvider {
    public static final ResourceLocation PIGMAN_VILLAGE_WATCHTOWER = RediscoveredMod.locate("chests/pigman_village/watchtower");
    public static final ResourceLocation PIGMAN_VILLAGE_METALWORKER = RediscoveredMod.locate("chests/pigman_village/metalworker");
    public static final ResourceLocation PIGMAN_VILLAGE_BOWYER = RediscoveredMod.locate("chests/pigman_village/bowyer");
    public static final ResourceLocation PIGMAN_VILLAGE_TECHNICIAN = RediscoveredMod.locate("chests/pigman_village/technician");
    public static final ResourceLocation PIGMAN_VILLAGE_TAILOR = RediscoveredMod.locate("chests/pigman_village/tailor");
    public static final ResourceLocation PIGMAN_VILLAGE_DOCTOR = RediscoveredMod.locate("chests/pigman_village/doctor");
    public static final ResourceLocation PIGMAN_VILLAGE_FISH_STALL = RediscoveredMod.locate("chests/pigman_village/fish_stall");
    public static final ResourceLocation QUIVER_CONTENTS = RediscoveredMod.locate("chests/quiver_contents");
    public static final ResourceLocation RANA_TRADING = RediscoveredMod.locate("gameplay/rana_trading");
    public static final ResourceLocation TRAIL_RUINS_PORTAL_ARCHAEOLOGY_COMMON = RediscoveredMod.locate("archaeology/trail_ruins_portal_common");
    public static final ResourceLocation TRAIL_RUINS_PORTAL_ARCHAEOLOGY_RARE = RediscoveredMod.locate("archaeology/trail_ruins_portal_rare");
    public static final ResourceLocation BRICK_PYRAMID_COMMON = RediscoveredMod.locate("chests/brick_pyramid_common");
    public static final ResourceLocation BRICK_PYRAMID_RARE = RediscoveredMod.locate("chests/brick_pyramid_rare");
    public static final ResourceLocation BRICK_PYRAMID_POT = RediscoveredMod.locate("chests/brick_pyramid_pot");
    public static final ResourceLocation PURPLE_ARROW_DISPENSER = RediscoveredMod.locate("chests/purple_arrow_dispenser");
    public static final ResourceLocation FIRE_CHARGE_DISPENSER = RediscoveredMod.locate("chests/fire_charge_dispenser");

    public RediscoveredLootProv(PackOutput output) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ChestLoot::new, LootContextParamSets.f_81411_), new LootTableProvider.SubProviderEntry(EntityLoot::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(TradeLoot::new, LootContextParamSets.f_81417_), new LootTableProvider.SubProviderEntry(ArchaeologyLoot::new, LootContextParamSets.f_271368_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
        map.forEach((name, lootTable) -> lootTable.m_79136_(context.m_79355_(lootTable.m_79122_()).m_278632_("{" + name + "}", new LootDataId(LootDataType.f_278413_, name))));
    }

    private static interface LootPoolUtil {
        public static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        public static final LootItemCondition.Builder SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
        public static final LootItemCondition.Builder SILK_TOUCH_OR_SHEARS = SHEARS.m_285888_(SILK_TOUCH);
        public static final LootItemCondition.Builder NOT_SILK_TOUCH_OR_SHEARS = SILK_TOUCH_OR_SHEARS.m_81807_();
        public static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        default public String modID() {
            return "rediscovered";
        }

        default public LootTable.Builder table(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.m_79147_();
            pools.forEach(pool -> table.m_79161_(pool));
            return table;
        }

        default public LootTable.Builder table(LootPool.Builder pool) {
            return LootTable.m_79147_().m_79161_(pool);
        }

        default public LootTable.Builder table(LootPool.Builder ... pools) {
            LootTable.Builder table = LootTable.m_79147_();
            for (LootPool.Builder pool : pools) {
                table.m_79161_(pool);
            }
            return table;
        }

        default public LootPool.Builder pool(ItemLike item, int min, int max, float chance) {
            return LootPool.m_79043_().m_79076_(this.item(item, min, max).m_79080_(this.randomChance(chance)));
        }

        default public LootPool.Builder pool(ItemLike item, int min, int max) {
            return LootPool.m_79043_().m_79076_(this.item(item, min, max));
        }

        default public LootPool.Builder pool(ItemLike item) {
            return LootPool.m_79043_().m_79076_(this.item(item));
        }

        default public LootPool.Builder pool(LootPoolEntryContainer.Builder<?> ... lootEntries) {
            LootPool.Builder pool = LootPool.m_79043_();
            for (LootPoolEntryContainer.Builder<?> entry : lootEntries) {
                pool.m_79076_(entry);
            }
            return pool;
        }

        default public LootPool.Builder pool(Collection<LootPoolEntryContainer.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.m_79043_();
            for (LootPoolEntryContainer.Builder<?> entry : lootEntries) {
                pool.m_79076_(entry);
            }
            return pool;
        }

        default public LootPool.Builder randomItemPool(List<ItemLike> items) {
            return this.pool((LootPoolEntryContainer.Builder[])items.stream().map((? super T i) -> this.item((ItemLike)i)).toArray(LootPoolEntryContainer.Builder[]::new));
        }

        default public LootPool.Builder lootingPool(ItemLike item, int min, int max, int minLooting, int maxLooting) {
            return this.pool(item, min, max).m_79078_((LootItemFunction.Builder)this.looting(minLooting, maxLooting));
        }

        default public LootPool.Builder lootingPool(ItemLike item, int min, int max, int minLooting, int maxLooting, float chance) {
            return this.lootingPool(item, min, max, minLooting, maxLooting).m_79080_(this.randomChance(chance));
        }

        default public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int min, int max) {
            return this.item(item).m_79078_(this.setCount(min, max));
        }

        default public LootPoolSingletonContainer.Builder<?> item(ItemLike item, int count) {
            return LootItem.m_79579_((ItemLike)item).m_79078_(this.setCount(count));
        }

        default public LootPoolSingletonContainer.Builder<?> item(ItemLike item) {
            return LootItem.m_79579_((ItemLike)item);
        }

        default public LootPoolSingletonContainer.Builder<?> tagEntry(TagKey<Item> tag, int min, int max) {
            return TagEntry.m_205095_(tag).m_79078_(this.setCount(min, max));
        }

        default public LootPoolSingletonContainer.Builder<?> tagEntry(TagKey<Item> tag, int count) {
            return TagEntry.m_205095_(tag).m_79078_(this.setCount(count));
        }

        default public LootPoolSingletonContainer.Builder<?> tagEntry(TagKey<Item> tag) {
            return this.tagEntry(tag, 1);
        }

        default public LootItemConditionalFunction.Builder<?> setDamage(int min, int max) {
            return SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)((float)min / 100.0f), (float)((float)max / 100.0f)));
        }

        default public LootItemConditionalFunction.Builder<?> smeltItem(EntityPredicate.Builder predicate) {
            return SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)predicate));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(int minLevel, int maxLevel) {
            return EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)minLevel, (float)maxLevel));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(Enchantment ... enchantments) {
            EnchantRandomlyFunction.Builder func = new EnchantRandomlyFunction.Builder();
            for (Enchantment enchantment : enchantments) {
                func.m_80444_(enchantment);
            }
            return func;
        }

        default public LootItemConditionalFunction.Builder<?> setNbt(Consumer<CompoundTag> nbt) {
            return SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt)));
        }

        default public LootItemConditionalFunction.Builder<?> map(TagKey<Structure> structure) {
            return ExplorationMapFunction.m_80554_().m_210658_(structure).m_80573_(MapDecoration.Type.RED_X).m_80569_((byte)1).m_80575_(false);
        }

        default public LootItemConditionalFunction.Builder<?> setCount(float min, float max) {
            if (min == max) {
                return this.setCount(min);
            }
            return SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
        }

        default public LootItemConditionalFunction.Builder<?> setCount(float count) {
            return SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count));
        }

        default public LootItemCondition.Builder playerKill() {
            return LootItemKilledByPlayerCondition.m_81901_();
        }

        default public LootItemCondition.Builder randomChance(float chance) {
            return LootItemRandomChanceCondition.m_81927_((float)chance);
        }

        default public LootingEnchantFunction.Builder looting(float minLooting, float maxLooting) {
            return LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)minLooting, (float)maxLooting));
        }
    }

    private static class ArchaeologyLoot
    implements LootTableSubProvider,
    LootPoolUtil {
        private ArchaeologyLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> output) {
            output.accept(TRAIL_RUINS_PORTAL_ARCHAEOLOGY_COMMON, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)RediscoveredItems.ruby).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42405_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)RediscoveredItems.purple_arrow).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41983_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42460_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42497_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42489_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42492_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42535_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42536_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151081_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151072_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151076_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151075_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42178_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42182_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42187_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42185_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42190_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42180_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42186_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_271501_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_244406_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42749_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42413_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42404_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42733_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41866_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42618_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42655_))));
            output.accept(TRAIL_RUINS_PORTAL_ARCHAEOLOGY_RARE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_279650_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_279619_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_279584_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_279623_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_279606_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_279598_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_279545_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_276612_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_276465_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_276546_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_276433_)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)RediscoveredBlocks.ancient_crying_obsidian))));
        }
    }

    private static class TradeLoot
    implements LootTableSubProvider,
    LootPoolUtil {
        private TradeLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> output) {
            output.accept(RANA_TRADING, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)Items.f_42437_).m_79707_(1).m_79080_(this.randomChance(0.05f)), this.item((ItemLike)Items.f_42436_).m_79707_(1), this.item((ItemLike)RediscoveredItems.ruby, 1, 2).m_79707_(5), this.item((ItemLike)Items.f_42417_, 1, 2).m_79707_(10), this.item((ItemLike)Items.f_42410_, 3, 5).m_79707_(16)})));
        }
    }

    private static class BlockLoot
    extends VanillaBlockLoot
    implements LootPoolUtil {
        private BlockLoot() {
        }

        private void blockLoot(Block block) {
            if (block == RediscoveredBlocks.ancient_cherry_leaves) {
                this.m_246481_(block, b -> this.leaves((Block)b, (ItemLike)RediscoveredBlocks.ancient_cherry_sapling, (ItemLike)Items.f_42398_));
            } else if (block == RediscoveredBlocks.ruby_ore || block == RediscoveredBlocks.deepslate_ruby_ore) {
                this.m_246481_(block, b -> this.m_246109_((Block)b, RediscoveredItems.ruby));
            } else if (block == RediscoveredBlocks.gear) {
                this.m_246481_(block, b -> {
                    ArrayList<LootPool.Builder> pools = new ArrayList<LootPool.Builder>(6);
                    for (GearBlock.GearFace face : GearBlock.GearFace.values()) {
                        pools.add(this.pool((ItemLike)b).m_79080_(ExplosionCondition.m_81661_()).m_79080_(InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67700_(face.stateProperty, GearBlock.GearState.NONE.m_7912_())))));
                    }
                    return this.table(pools);
                });
            } else if (block instanceof ChestBlock) {
                this.m_247577_(block, this.m_246180_(block));
            } else if (block instanceof SlabBlock) {
                if (block instanceof GrassSlabBlock) {
                    Block other = RediscoveredBlocks.dirt_slab;
                    LootTable.Builder lootTable = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(SILK_TOUCH)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))))).m_7170_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)other, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)other).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))))));
                    this.m_247577_(block, lootTable);
                } else if (block == RediscoveredBlocks.dirt_path_slab) {
                    Block other = RediscoveredBlocks.dirt_slab;
                    LootTable.Builder lootTable = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)other, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)other).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))))));
                    this.m_247577_(block, lootTable);
                } else {
                    this.m_247577_(block, this.m_247233_(block));
                }
            } else if (block instanceof DoorBlock) {
                this.m_246481_(block, b -> this.m_245178_((Block)b, (Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
            } else if (block instanceof FlowerPotBlock) {
                this.m_246535_(block);
            } else if (block instanceof BaseFakeFireBlock) {
                this.m_246481_(block, b -> BlockLoot.m_246386_());
            } else if (block instanceof BrittleBlock) {
                this.silkOrElse(block, (ItemLike)Items.f_41852_);
            } else if (block instanceof RedDragonEggBlock) {
                this.m_246481_(block, b -> this.table(this.pool((ItemLike)b).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)this.copyBlockEntityTags("age", "can_hatch", "owner"))));
            } else if (block == RediscoveredBlocks.dragon_altar) {
                this.m_247577_(block, this.table(new LootPool.Builder[0]));
            } else {
                this.m_245724_(block);
            }
        }

        public CopyNbtFunction.Builder copyBlockEntityTags(String ... tagPaths) {
            CopyNbtFunction.Builder builder = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
            for (String tag : tagPaths) {
                builder.m_80279_(tag, "BlockEntityTag." + tag);
            }
            return builder;
        }

        protected void m_245660_() {
            this.getKnownBlocks().forEach(this::blockLoot);
        }

        protected Iterable<Block> getKnownBlocks() {
            return StreamSupport.stream(super.getKnownBlocks().spliterator(), false).filter(b -> ForgeRegistries.BLOCKS.getKey(b).m_135827_().equals(this.modID()) && !b.m_60589_().equals((Object)BuiltInLootTables.f_78712_))::iterator;
        }

        private void silkOrElse(Block withSilk, ItemLike without) {
            this.m_246481_(withSilk, b -> this.m_245514_((Block)b, without));
        }

        private LootTable.Builder leaves(Block block, ItemLike sapling, ItemLike stick) {
            return BlockLoot.m_246160_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)sapling))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])DEFAULT_SAPLING_DROP_RATES))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(NOT_SILK_TOUCH_OR_SHEARS).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)stick).m_79078_((LootItemFunction.Builder)this.setCount(1.0f, 2.0f)))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }
    }

    private static class EntityLoot
    extends VanillaEntityLoot
    implements LootPoolUtil {
        private EntityLoot() {
        }

        public void m_246942_() {
            this.m_245309_(RediscoveredEntityTypes.FISH, this.table(new LootPool.Builder[]{this.pool((ItemLike)RediscoveredItems.raw_fish).m_79078_((LootItemFunction.Builder)this.smeltItem(f_244460_)), this.pool((ItemLike)Items.f_42499_, 1, 1, 0.05f)}));
            this.m_245309_(RediscoveredEntityTypes.PIGMAN, this.table(this.lootingPool((ItemLike)Items.f_42485_, 1, 2, 0, 2).m_79078_((LootItemFunction.Builder)this.smeltItem(f_244460_))));
            this.m_245309_(RediscoveredEntityTypes.MELEE_PIGMAN, this.table(this.lootingPool((ItemLike)Items.f_42485_, 1, 2, 0, 2).m_79078_((LootItemFunction.Builder)this.smeltItem(f_244460_))));
            this.m_245309_(RediscoveredEntityTypes.RANGED_PIGMAN, this.table(this.lootingPool((ItemLike)Items.f_42485_, 1, 2, 0, 2).m_79078_((LootItemFunction.Builder)this.smeltItem(f_244460_))));
            this.m_245309_(RediscoveredEntityTypes.ZOMBIE_PIGMAN, this.table(new LootPool.Builder[]{this.lootingPool((ItemLike)Items.f_42583_, 0, 1, 0, 1), this.lootingPool((ItemLike)Items.f_42749_, 0, 1, 0, 1).m_79080_(this.randomChance(0.5f)), this.pool((ItemLike)Items.f_42416_).m_79080_(this.playerKill()).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.0125f, (float)0.01f))}));
            LootPool.Builder stevePool = this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)Items.f_42403_, 0, 2), this.item((ItemLike)Items.f_42402_, 0, 2), this.item((ItemLike)Items.f_42401_, 0, 2)}).m_79078_((LootItemFunction.Builder)this.looting(0.0f, 2.0f));
            this.m_245309_(RediscoveredEntityTypes.STEVE, this.table(stevePool));
            this.m_245309_(RediscoveredEntityTypes.BLACK_STEVE, this.table(stevePool));
            this.m_245309_(RediscoveredEntityTypes.BEAST_BOY, this.table(stevePool));
            this.m_245309_(RediscoveredEntityTypes.RANA, this.table(new LootPool.Builder[]{this.lootingPool((ItemLike)Items.f_42410_, 0, 2, 0, 1), this.lootingPool((ItemLike)RediscoveredBlocks.rose, 0, 1, 0, 1), this.pool((ItemLike)RediscoveredBlocks.cyan_rose, 1, 1, 0.01f)}));
            this.m_245309_(RediscoveredEntityTypes.RED_DRAGON_BOSS, this.table(new LootPool.Builder[0]));
            this.m_245309_(RediscoveredEntityTypes.RED_DRAGON_OFFSPRING, this.table(new LootPool.Builder[0]));
            this.m_245309_(RediscoveredEntityTypes.SCARECROW, this.table(this.pool((ItemLike)RediscoveredItems.scarecrow).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.THIS))));
        }

        public Stream<EntityType<?>> getKnownEntityTypes() {
            return super.getKnownEntityTypes().filter(e -> ForgeRegistries.ENTITY_TYPES.getKey(e).m_135827_().equals(this.modID()));
        }

        protected boolean m_245552_(EntityType<?> type) {
            return super.m_245552_(type) || type == RediscoveredEntityTypes.SCARECROW;
        }
    }

    private static class ChestLoot
    implements LootPoolUtil,
    LootTableSubProvider {
        private ChestLoot() {
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> output) {
            output.accept(QUIVER_CONTENTS, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)Items.f_42412_, 2, 3).m_79707_(2), this.item((ItemLike)RediscoveredItems.purple_arrow)}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            output.accept(PIGMAN_VILLAGE_WATCHTOWER, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.ruby, 0, 1).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42619_, 1, 3), this.item((ItemLike)Items.f_42416_, 1, 4), this.item((ItemLike)Items.f_42411_).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)RediscoveredItems.quiver).m_79078_(SetQuiverContentsFunction.withContents(QUIVER_CONTENTS)).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42412_, 1, 4), this.item((ItemLike)Items.f_42408_).m_79078_(SetAttachedQuiverFunction.attachQuiver(RediscoveredItems.quiver.m_7968_(), QUIVER_CONTENTS)).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42415_).m_79080_(this.randomChance(0.025f)), this.item((ItemLike)Items.f_42587_, 1, 4).m_79080_(this.randomChance(0.333f)), this.item((ItemLike)Items.f_42398_)}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)8.0f, (float)11.0f))));
            output.accept(PIGMAN_VILLAGE_METALWORKER, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.ruby, 1, 2).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42619_, 1, 3), this.item((ItemLike)Items.f_42416_, 1, 4), this.item((ItemLike)RediscoveredBlocks.gear, 1, 4).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42403_, 1, 2), this.item((ItemLike)Items.f_42677_, 1, 2).m_79080_(this.randomChance(0.333f)), this.item((ItemLike)Items.f_42446_), this.item((ItemLike)Items.f_42415_).m_79080_(this.randomChance(0.025f)), this.item((ItemLike)Items.f_42587_, 1, 4).m_79080_(this.randomChance(0.333f))}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)9.0f, (float)11.0f))));
            output.accept(PIGMAN_VILLAGE_BOWYER, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.ruby, 0, 1).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42619_, 1, 4), this.item((ItemLike)Items.f_42484_, 1, 2), this.item((ItemLike)Items.f_42411_).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42717_).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42412_, 4, 9), this.item((ItemLike)RediscoveredItems.purple_arrow, 3, 5), this.item((ItemLike)RediscoveredItems.quiver).m_79078_(SetQuiverContentsFunction.withContents(QUIVER_CONTENTS)), this.item((ItemLike)Items.f_42401_, 1, 4).m_79080_(this.randomChance(0.333f)), this.item((ItemLike)Items.f_42398_)}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)9.0f, (float)11.0f))));
            output.accept(PIGMAN_VILLAGE_TECHNICIAN, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.ruby, 0, 1).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42619_, 1, 3), this.item((ItemLike)Items.f_42692_, 1, 2), this.item((ItemLike)RediscoveredBlocks.gear, 2, 6).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42451_, 2, 4), this.item((ItemLike)Items.f_42350_), this.item((ItemLike)RediscoveredBlocks.rotational_converter), this.item((ItemLike)Items.f_42416_, 1, 4), this.item((ItemLike)Items.f_271154_, 1, 4), this.item((ItemLike)Items.f_42398_, 1, 2), this.item((ItemLike)RediscoveredItems.music_disc_calm4).m_79080_(this.randomChance(0.5f))}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)9.0f, (float)11.0f))));
            float tailorStuddedChance = 0.15f;
            output.accept(PIGMAN_VILLAGE_TAILOR, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.ruby, 0, 1).m_79080_(this.randomChance(0.5f)), this.item((ItemLike)Items.f_42619_, 1, 4), this.item((ItemLike)RediscoveredItems.studded_helmet).m_79080_(this.randomChance(tailorStuddedChance)), this.item((ItemLike)RediscoveredItems.studded_chestplate).m_79080_(this.randomChance(tailorStuddedChance)), this.item((ItemLike)RediscoveredItems.studded_leggings).m_79080_(this.randomChance(tailorStuddedChance)), this.item((ItemLike)RediscoveredItems.studded_boots).m_79080_(this.randomChance(tailorStuddedChance)), this.item((ItemLike)Items.f_42407_), this.item((ItemLike)Items.f_42408_), this.item((ItemLike)Items.f_42462_), this.item((ItemLike)Items.f_42463_), this.item((ItemLike)Items.f_42454_, 2, 3), this.item((ItemLike)Items.f_41870_, 2, 4), this.item((ItemLike)RediscoveredBlocks.bright_green_wool), this.item((ItemLike)RediscoveredBlocks.lavender_wool), this.item((ItemLike)RediscoveredBlocks.slate_blue_wool), this.item((ItemLike)Items.f_42401_, 2, 5), this.item((ItemLike)Items.f_42497_), this.item((ItemLike)Items.f_42489_), this.item((ItemLike)Items.f_42492_).m_79080_(this.randomChance(0.333f))}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)9.0f, (float)11.0f))));
            output.accept(PIGMAN_VILLAGE_DOCTOR, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.ruby, 0, 1).m_79080_(this.randomChance(0.3f)), this.item((ItemLike)Items.f_42619_, 1, 3), this.item((ItemLike)Items.f_42525_, 1, 2), this.item((ItemLike)Items.f_42451_, 1, 2), this.item((ItemLike)RediscoveredBlocks.rose, 1, 2), this.item((ItemLike)RediscoveredBlocks.cyan_rose).m_79080_(this.randomChance(0.1f)), this.item((ItemLike)Items.f_42587_, 3, 5), this.item((ItemLike)Items.f_42590_, 1, 3), this.item((ItemLike)Items.f_42589_).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)((Potion)RediscoveredEffects.GOLDEN_AURA_POTION.get()))), this.item((ItemLike)Items.f_42677_, 3, 6)}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f))));
            output.accept(PIGMAN_VILLAGE_FISH_STALL, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.raw_fish, 1, 2).m_79707_(12), this.item((ItemLike)RediscoveredItems.cooked_fish, 1, 2).m_79707_(20), this.item((ItemLike)Items.f_42401_, 1, 2).m_79707_(9), this.item((ItemLike)Items.f_42446_).m_79707_(4), this.item((ItemLike)RediscoveredItems.ruby)}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f))));
            output.accept(BRICK_PYRAMID_COMMON, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)Items.f_42460_, 1, 2).m_79707_(7), this.item((ItemLike)Items.f_42412_, 1, 2).m_79707_(6), this.item((ItemLike)Items.f_151052_, 1, 3).m_79707_(6), this.item((ItemLike)Items.f_42749_, 1, 3).m_79707_(6), this.item((ItemLike)Items.f_42500_, 1, 2).m_79707_(3), this.item((ItemLike)Items.f_42403_, 1, 2).m_79707_(3), this.item((ItemLike)RediscoveredBlocks.glowing_obsidian, 1, 2).m_79707_(3).m_79711_(3), this.item((ItemLike)Items.f_42584_).m_79707_(2).m_79711_(3).m_79711_(3), this.item((ItemLike)Items.f_279584_).m_79707_(1).m_79711_(2), this.item((ItemLike)Items.f_279567_).m_79707_(1).m_79711_(2), this.item((ItemLike)Items.f_279606_).m_79707_(1).m_79711_(2), this.item((ItemLike)RediscoveredItems.ruby).m_79707_(1).m_79711_(3), this.item((ItemLike)RediscoveredItems.draconic_trim).m_79707_(2).m_79711_(3), this.item((ItemLike)RediscoveredItems.dragon_armor).m_79707_(1).m_79711_(3), this.item((ItemLike)RediscoveredItems.dragon_armor_chain_smithing_template).m_79707_(1).m_79711_(2), this.item((ItemLike)RediscoveredItems.dragon_armor_plating_smithing_template).m_79707_(1).m_79711_(2), this.item((ItemLike)RediscoveredItems.dragon_armor_inlay_smithing_template).m_79707_(1).m_79711_(2)}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f))));
            output.accept(BRICK_PYRAMID_RARE, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)Items.f_42460_, 1, 2).m_79707_(5), this.item((ItemLike)RediscoveredItems.purple_arrow, 1, 2).m_79707_(5), this.item((ItemLike)RediscoveredBlocks.ancient_crying_obsidian, 2, 4).m_79707_(8).m_79711_(3), this.item((ItemLike)RediscoveredBlocks.glowing_obsidian, 2, 4).m_79707_(8), this.item((ItemLike)Items.f_42416_, 1, 3).m_79707_(8), this.item((ItemLike)Items.f_42692_, 2, 4).m_79707_(8).m_79711_(3), this.item((ItemLike)RediscoveredItems.ruby).m_79707_(4).m_79711_(3), this.item((ItemLike)RediscoveredBlocks.ruby_eye, 2, 3).m_79707_(2).m_79711_(3), this.item((ItemLike)RediscoveredItems.draconic_trim).m_79707_(2).m_79711_(4), this.item((ItemLike)RediscoveredItems.dragon_armor).m_79707_(2).m_79711_(3), this.item((ItemLike)RediscoveredItems.dragon_armor_chain_smithing_template).m_79707_(2).m_79711_(2), this.item((ItemLike)RediscoveredItems.dragon_armor_plating_smithing_template).m_79707_(2).m_79711_(2), this.item((ItemLike)RediscoveredItems.dragon_armor_inlay_smithing_template).m_79707_(2).m_79711_(2)}).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f))));
            output.accept(BRICK_PYRAMID_POT, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.ruby).m_79707_(5), this.item((ItemLike)RediscoveredBlocks.ancient_crying_obsidian).m_79707_(5), this.item((ItemLike)Items.f_42692_).m_79707_(5), this.item((ItemLike)Items.f_42416_).m_79707_(5), this.item((ItemLike)Items.f_42403_).m_79707_(5), this.item((ItemLike)Items.f_42584_).m_79707_(5), this.item((ItemLike)RediscoveredItems.draconic_trim).m_79711_(2), this.item((ItemLike)RediscoveredItems.dragon_armor_chain_smithing_template).m_79707_(1).m_79711_(2), this.item((ItemLike)RediscoveredItems.dragon_armor_plating_smithing_template).m_79707_(1).m_79711_(2), this.item((ItemLike)RediscoveredItems.dragon_armor_inlay_smithing_template).m_79707_(1).m_79711_(2)}).m_79080_(this.randomChance(0.1f))));
            output.accept(PURPLE_ARROW_DISPENSER, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)RediscoveredItems.purple_arrow, 4, 9)})));
            output.accept(FIRE_CHARGE_DISPENSER, this.table(this.pool(new LootPoolEntryContainer.Builder[]{this.item((ItemLike)Items.f_42613_, 3, 12)})));
        }
    }
}

