/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data;

import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.RediscoveredSounds;
import com.legacy.rediscovered.client.gui.GuardPigmanInventoryScreen;
import com.legacy.rediscovered.data.RediscoveredAdvancementProv;
import com.legacy.rediscovered.entity.pigman.data.PigmanData;
import com.legacy.rediscovered.item.util.DragonArmorTrim;
import com.legacy.rediscovered.registry.RediscoveredAttributes;
import com.legacy.rediscovered.registry.RediscoveredBlocks;
import com.legacy.rediscovered.registry.RediscoveredDamageTypes;
import com.legacy.rediscovered.registry.RediscoveredEffects;
import com.legacy.rediscovered.registry.RediscoveredEnchantments;
import com.legacy.rediscovered.registry.RediscoveredEntityTypes;
import com.legacy.rediscovered.registry.RediscoveredItems;
import com.legacy.rediscovered.registry.RediscoveredPaintings;
import com.legacy.rediscovered.registry.RediscoveredStats;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.data.LanguageProvider;

public class RediscoveredLangProv
extends LanguageProvider {
    public static final String GOLDEN_AURA_EFFECT = "potion.rediscovered.golden_aura_effect";
    public static final String CRIMSON_VEIL_EFFECT = "potion.rediscovered.crimson_veil_effect";
    public static final String DRAGON_ARMOR_SMITHING_TEMPLATE_CHAIN = Util.m_137492_((String)"item", (ResourceLocation)RediscoveredMod.locate("smithing_template.dragon_smithing_template." + DragonArmorTrim.Decoration.CHAIN.m_7912_()));
    public static final String DRAGON_ARMOR_SMITHING_TEMPLATE_PLATING = Util.m_137492_((String)"item", (ResourceLocation)RediscoveredMod.locate("smithing_template.dragon_smithing_template." + DragonArmorTrim.Decoration.PLATING.m_7912_()));
    public static final String DRAGON_ARMOR_SMITHING_TEMPLATE_INLAY = Util.m_137492_((String)"item", (ResourceLocation)RediscoveredMod.locate("smithing_template.dragon_smithing_template." + DragonArmorTrim.Decoration.INLAY.m_7912_()));
    public static final String DRAGON_ARMOR_SMITHING_TEMPLATE_APPLIES_TO = Util.m_137492_((String)"item", (ResourceLocation)RediscoveredMod.locate("smithing_template.dragon_smithing_template.applies_to"));
    public static final String DRAGON_ARMOR_SMITHING_TEMPLATE_BASE_SLOT_DESCRIPTION = Util.m_137492_((String)"item", (ResourceLocation)RediscoveredMod.locate("smithing_template.dragon_smithing_template.base_slot_description"));
    private final CompletableFuture<HolderLookup.Provider> lookup;
    private Set<String> existing = new HashSet<String>();

    public RediscoveredLangProv(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup) {
        super(packOutput, "rediscovered", "en_us");
        this.lookup = lookup;
    }

    protected void addTranslations() {
        this.add(RediscoveredItems.music_disc_calm4, "Lost Music Disc");
        this.add(RediscoveredItems.music_disc_calm4.m_5524_() + ".desc", "Notch - Magnetic Circuit");
        this.add(RediscoveredBlocks.ruby_block, "Block of Ruby");
        this.add(RediscoveredItems.fish_bucket, "Bucket of Fish");
        this.addPainting((ResourceKey<PaintingVariant>)RediscoveredPaintings.FOG.getKey(), "Fog", "Silver_David");
        this.addDamageType((ResourceKey<DamageType>)RediscoveredDamageTypes.SPIKES.getKey(), "%1$s was impaled by spikes", "%1$s landed in spikes whilst trying to escape %2$s");
        this.addPotion((Supplier<MobEffect>)RediscoveredEffects.GOLDEN_AURA);
        this.addPotion((Supplier<MobEffect>)RediscoveredEffects.CRIMSON_VEIL);
        this.add(GOLDEN_AURA_EFFECT, "Prevents zombification");
        this.add(CRIMSON_VEIL_EFFECT, "Grants a Nether atmosphere");
        this.addAttribute((Supplier<Attribute>)RediscoveredAttributes.UNDEAD_DAMAGE_SCALING, "Undead Resistance");
        this.addAttribute((Supplier<Attribute>)RediscoveredAttributes.CRIMSON_VEIL_DAMAGE_SCALING, "Damage Resistance");
        this.addAttribute((Supplier<Attribute>)RediscoveredAttributes.EXPLOSION_RESISTANCE, "Explosion Resistance");
        this.addAttribute((Supplier<Attribute>)RediscoveredAttributes.FIRE_RESISTANCE, "Fire Resistance");
        String pigmanId = RediscoveredEntityTypes.PIGMAN.m_20675_();
        this.add(pigmanId, PigmanData.Profession.METALWORKER, "Metalworker");
        this.add(pigmanId, PigmanData.Profession.BOWYER, "Bowyer");
        this.add(pigmanId, PigmanData.Profession.TECHNICIAN, "Technician");
        this.add(pigmanId, PigmanData.Profession.TAILOR, "Tailor");
        this.add(pigmanId, PigmanData.Profession.DOCTOR, "Doctor");
        this.addDefault(Registries.f_256747_, Map.of(RediscoveredBlocks.mini_dragon_pylon.m_204297_().m_205785_().m_135782_(), "Dragon Pylon"));
        this.addDefault(Registries.f_256944_, Map.of());
        Map itemOverrides = (Map)Util.m_137469_(new HashMap(), m -> {
            String smithingTemplate = "Smithing Template";
            m.put(RediscoveredItems.draconic_trim, smithingTemplate);
            m.put(RediscoveredItems.dragon_armor_chain_smithing_template, smithingTemplate);
            m.put(RediscoveredItems.dragon_armor_plating_smithing_template, smithingTemplate);
            m.put(RediscoveredItems.dragon_armor_inlay_smithing_template, smithingTemplate);
        });
        this.addDefault(Registries.f_256913_, itemOverrides.entrySet().stream().collect(Collectors.toMap(e -> ((Item)e.getKey()).m_204114_().m_205785_().m_135782_(), Map.Entry::getValue)));
        this.addDefault(Registries.f_256939_, Map.of(RediscoveredEntityTypes.RED_DRAGON_OFFSPRING.m_204041_().m_205785_().m_135782_(), "Red Dragon"));
        this.addDefault(Registries.f_256952_, Map.of());
        this.addDefault(Registries.f_256783_, Map.of());
        this.addDefault(Registries.f_256762_, Map.of());
        this.addDefault(Registries.f_256887_, Map.of(RediscoveredStats.INTERACT_WITH_TABLE, "Interactions with Table"));
        this.addDefault(Registries.f_256929_, Map.of());
        this.addDefault(Registries.f_266063_, Map.of());
        this.addDefault(Registries.f_266076_, Map.of());
        this.addEnchantDesc(RediscoveredEnchantments.RAPID_SHOT, "Quickly shoot arrows without needing to pull back the bow. They don't go very far though.");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.getRuby, "Red Like a Rose", "Obtain a Ruby");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.locatePortal, "Ancient Investigation", "Follow a Ruby Eye to the Trail Ruins to rediscover the Skylands Portal within");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.enterSkylands, "We Need to Go Higher!", "Enter the Skylands Portal");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.rideZombieHorse, "A Vengeful Steed", "Find and ride a Zombie Horse");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.shearRoseBush, "By Any Other Name", "Use Shears to get the Roses from a Rose Bush");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.allFlowers, "Something Old, New, And Blue", "Obtain all the forgotten flowers");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.craftScarecrow, "Without a Brain", "Craft a Scarecrow to keep animals away from your crops");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.craftQuiver, "Long Range Utility", "Craft a Quiver to hold your arrows");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.attachQuiver, "Ready For Action", "Attach a Quiver to a Chestplate with an Anvil");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.removeQuiver, "Back to Fashion", "Remove a Quiver from a Chestplate with a Grindstone");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.purpleArrowSnipe, "No Scope Needed", "Land a killing blow from as least 100 meters away");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.craftGears, "Spinning Power", "Craft a Gear and a Rotational Converter");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.spikySpkies, "Spiky Spikes", "Use Spikes to kill a Guardian");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.craftNetherReactor, "Reactive", "Craft a Nether Reactor Core");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.activateNetherReactor, "Pocket Biome", "Construct and activate a Nether Reactor");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.activateFullNetherReactor, "Lethal Region", "Construct and activate a fully powered Nether Reactor");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.curePigman, "An Ancient Ally", "Weaken and then cure a Zombie Pigman");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.curePigmanMelee, "The Loyal Guard", "Give a Zombie Pigman a sword while curing to encourage melee combat");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.curePigmanRanged, "Boar and Arrow", "Give a Zombie Pigman a bow while curing to encourage ranged combat");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.skylandsRoot, "Skylands", "A world far above the clouds");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.enterBrickPyramid, "Bygone Ruins", "Enter a Brick Pyramid");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.slayRedDragon, "Out With The Old...", "Slay the Red Dragon");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.hatchRedDragon, "In With The New", "Pour Dragon Breath over a Red Dragon Egg and wait for it to hatch");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.redDragonCatch, "Falling in Style", "Use a Ruby Flute to summon your Red Dragon for a mid-air catch");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.redDragonTeleport, "Trust the Process", "Fly below the Skylands and into the Overworld on your Red Dragon");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.summonRedDragon, "Calling The Storm", "Place 4 Dragon Pylons on the altar atop the Brick Pyramid to summon a Red Dragon");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.enterPigmanVillage, "Can They Fly?", "Enter a Pigman Village");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.tradeWithPigman, "A Different Currency", "Use rubies to trade with a Pigman");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.giveRanaGift, "Smells Just As Sweet", "Gift Rana a Cyan Rose");
        this.addAdvancement(RediscoveredAdvancementProv.Advancements.reachFarlands, "An Extensive Journey", "Venture off into the far lands");
        this.add(RediscoveredSounds.BLOCK_NETHER_REACTOR_ACTIVATE, "Nether Reactor activates");
        this.add(RediscoveredSounds.BLOCK_NETHER_REACTOR_IDLE, "Nether Reactor warbles");
        this.add(RediscoveredSounds.BLOCK_NETHER_REACTOR_DEACTIVATE, "Nether Reactor deactivates");
        this.add(RediscoveredSounds.BLOCK_RED_DRAGON_EGG_FERTILIZE, "Dragon Breath pours");
        this.add(RediscoveredSounds.BLOCK_RED_DRAGON_EGG_SHAKE, "Red Dragon Egg shakes");
        this.add(RediscoveredSounds.BLOCK_RED_DRAGON_EGG_HATCH, "Red Dragon Egg hatches");
        this.add(RediscoveredSounds.BLOCK_ROTATIONAL_CONVERTER_CLICK, "Rotational Converter clicks");
        this.add(RediscoveredSounds.BLOCK_TABLE_ADD_ITEM, "Item placed on table");
        this.add(RediscoveredSounds.BLOCK_TABLE_REMOVE_ITEM, "Item removed from table");
        this.add(RediscoveredSounds.ITEM_ARMOR_EQUIP_STUDDED, "Studded armor jingles");
        this.add(RediscoveredSounds.ITEM_ARMOR_EQUIP_PLATE, "Plate armor clanks");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_IDLE, "Pigman oinks");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_HURT, "Pigman hurts");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_DEATH, "Pigman dies");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_ANGRY, "Pigman growls");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_SCARED, "Pigman cries");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_AGREE, "Pigman agrees");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_DISAGREE, "Pigman disagrees");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_ZOMBIFY, "Pigman converts to Zombie Pigman");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_METALWORKER, "Metalworker works");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_BOWYER, "Bowyer works");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_TECHNICIAN, "Technician works");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_TAILOR, "Tailor works");
        this.add(RediscoveredSounds.ENTITY_PIGMAN_WORK_DOCTOR, "Doctor works");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_IDLE, "Zombie Pigman groans");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_HURT, "Zombie Pigman hurts");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_DEATH, "Zombie Pigman dies");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_ANGRY, "Zombie Pigman grunts angrily");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_CURE, "Zombie Pigman snuffles");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_FINISH_CURE, "Zombie Pigman vociferates");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_SELECT_MELEE, "Zombie Pigman accepts melee weapon");
        this.add(RediscoveredSounds.ENTITY_ZOMBIE_PIGMAN_SELECT_RANGED, "Zombie Pigman accepts ranged weapon");
        this.add(RediscoveredSounds.ENTITY_STEVE_HURT, "Steve hurts");
        this.add(RediscoveredSounds.ENTITY_STEVE_DEATH, "Steve dies");
        this.add(RediscoveredSounds.ENTITY_BLACK_STEVE_HURT, "Black Steve hurts");
        this.add(RediscoveredSounds.ENTITY_BLACK_STEVE_DEATH, "Black Steve dies");
        this.add(RediscoveredSounds.ENTITY_BEAST_BOY_HURT, "Beast Boy hurts");
        this.add(RediscoveredSounds.ENTITY_BEAST_BOY_DEATH, "Beast Boy dies");
        this.add(RediscoveredSounds.ENTITY_RANA_HURT, "Rana hurts");
        this.add(RediscoveredSounds.ENTITY_RANA_DEATH, "Rana dies");
        this.add(RediscoveredSounds.ENTITY_FISH_HURT, "Fish hurts");
        this.add(RediscoveredSounds.ENTITY_FISH_DEATH, "Fish dies");
        this.add(RediscoveredSounds.ENTITY_FISH_FLOP, "Fish flops");
        this.add(RediscoveredSounds.ENTITY_PYLON_BURST_DESTROYED, "Pylon Burst destroyed");
        this.add(RediscoveredSounds.ENTITY_PYLON_BURST_EXPLODE, "Pylon Burst explodes");
        this.add(RediscoveredSounds.ENTITY_DRAGON_PYLON_SHIELD_LOST, "Dragon Pylon drops shield");
        this.add(RediscoveredSounds.ENTITY_DRAGON_PYLON_HURT, "Dragon Pylon damaged");
        this.add(RediscoveredSounds.ENTITY_DRAGON_PYLON_DEATH, "Dragon Pylon destroyed");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_IDLE, "Red Dragon roars");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_IDLE_CALM, "Red Dragon huffs");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_HURT, "Red Dragon hurts");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_DEATH, "Red Dragon dies");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_FLAP, "Red Dragon flaps");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_SHIELD_DOWN, "Red Dragon roars angrily");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_BOLT_BALL_CHARGE, "Red Dragon charges");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_BOLT_BALL_SHOOT, "Red Dragon shoots");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_PREPARE_WIND_BLOW, "Red Dragon prepares winds");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_WIND_BLOW, "Harsh wind blows");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_SHED_BURSTS, "Dragon Pylon generates bursts");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_EQUIP_SADDLE, "Red Dragon saddle equips");
        this.add(RediscoveredSounds.ENTITY_RED_DRAGON_EQUIP_ARMOR, "Red Dragon armor equips");
        this.add("rediscovered.message.dragon_hatch_disabled", "Red Dragon hatching has been disabled in this world.");
        this.add("rediscovered.message.dragon_not_loaded", "The notes echoed, but there was no response...");
        this.add("rediscovered.message.dragon_stuck", "%s was unable to reach your location.");
        this.add("rediscovered.message.dragon_too_tired", "%s is too tired out to be able to travel.");
        this.add("gui.rediscovered.tooltip.mount_red_dragon", "Right-Click or Press %s While Grounded to Dismount");
        this.add(GuardPigmanInventoryScreen.GUARDING_STATUS_KEY, "Guarding");
        this.add(GuardPigmanInventoryScreen.SEARCHING_STATUS_KEY, "Searching for Safety");
        this.add(GuardPigmanInventoryScreen.IDLE_STATUS_KEY, "Idle");
        this.add(GuardPigmanInventoryScreen.START_GUARD_KEY, "Start guarding");
        this.add(GuardPigmanInventoryScreen.STOP_GUARD_KEY, "Dismiss early");
        this.add(DRAGON_ARMOR_SMITHING_TEMPLATE_CHAIN, "Dragon Armor Chain");
        this.add(DRAGON_ARMOR_SMITHING_TEMPLATE_PLATING, "Dragon Armor Plating");
        this.add(DRAGON_ARMOR_SMITHING_TEMPLATE_INLAY, "Dragon Armor Inlay");
        this.add(DRAGON_ARMOR_SMITHING_TEMPLATE_APPLIES_TO, "Dragon Armor");
        this.add(DRAGON_ARMOR_SMITHING_TEMPLATE_BASE_SLOT_DESCRIPTION, "Add %s");
        this.add(DragonArmorTrim.Decoration.CHAIN.localeKey(), "Chain");
        this.add(DragonArmorTrim.Decoration.PLATING.localeKey(), "Plating");
        this.add(DragonArmorTrim.Decoration.INLAY.localeKey(), "Inlay");
        this.add("block_type.rediscovered.table", "%s Table");
        this.add("block_type.rediscovered.chair", "%s Chair");
    }

    public void addEnchantDesc(Enchantment enchantment, String desc) {
        this.addEnchantDesc((ResourceKey<Enchantment>)((ResourceKey)BuiltInRegistries.f_256876_.m_7854_((Object)enchantment).get()), desc);
    }

    public void addEnchantDesc(ResourceKey<Enchantment> enchantment, String desc) {
        ResourceLocation key = enchantment.m_135782_();
        this.add("enchantment." + key.m_135827_() + "." + key.m_135815_() + ".desc", desc);
    }

    public void addPainting(ResourceKey<PaintingVariant> painting, String title, String author) {
        ResourceLocation key = painting.m_135782_();
        String s = "painting." + key.m_135827_() + "." + key.m_135815_() + ".";
        this.add(s + "title", title);
        this.add(s + "author", author);
    }

    public void addAttribute(Supplier<Attribute> attribute, String name) {
        this.add(attribute.get().m_22087_(), name);
    }

    public void addPotion(Supplier<MobEffect> potion) {
        ResourceLocation key = BuiltInRegistries.f_256974_.m_7981_((Object)potion.get());
        String path = key.m_135815_();
        String name = this.toName(path);
        this.add("item.minecraft.potion.effect." + path, "Potion of " + name);
        this.add("item.minecraft.splash_potion.effect." + path, "Splash Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect." + path, "Lingering Potion of " + name);
        this.add("item.minecraft.tipped_arrow.effect." + path, "Arrow of " + name);
    }

    public static String mapName(StructureRegistrar<?> structure) {
        return "filled_map." + structure.getRegistryName();
    }

    private void addDamageType(ResourceKey<DamageType> damageType, String deathMessage, String playerKillMessage) {
        try {
            String messageID = "death.attack." + ((DamageType)this.lookup.get().m_255025_(Registries.f_268580_).m_255043_(damageType).get()).f_268677_();
            this.add(messageID, deathMessage);
            this.add(messageID + ".player", playerKillMessage);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void addAdvancement(Advancement advancement, String title, String desc) {
        DisplayInfo display = advancement.m_138320_();
        this.add(display.m_14977_().getString(), title);
        this.add(display.m_14985_().getString(), desc);
    }

    private <T> void addDefault(ResourceKey<Registry<T>> registry, Map<ResourceLocation, String> overrides) {
        this.addDefault_(registry, overrides.entrySet().stream().collect(Collectors.toMap(e -> ResourceKey.m_135785_((ResourceKey)registry, (ResourceLocation)((ResourceLocation)e.getKey())), e -> (String)e.getValue())));
    }

    private <T> void addDefault_(ResourceKey<Registry<T>> registry, Map<ResourceKey<T>, String> overrides) {
        try {
            this.lookup.get().m_255025_(registry).m_255209_().distinct().filter(key -> "rediscovered".equals(key.m_135782_().m_135827_())).filter(key -> !overrides.containsKey(key)).forEach(this::add);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        overrides.forEach(this::add);
    }

    private void add(ResourceKey<?> key) {
        this.add(key, this.toName(key));
    }

    private void add(ResourceKey<?> key, String translation) {
        this.add(this.makeDescriptionID(key), translation);
    }

    private void add(Supplier<SoundEvent> sound, String translation) {
        this.add(sound.get(), translation);
    }

    private void add(SoundEvent sound, String translation) {
        this.add("subtitles.rediscovered." + sound.m_11660_().m_135815_(), translation);
    }

    private void addItemInfo(Supplier<Item> item, String key, String translation) {
        ResourceKey resourceKey = (ResourceKey)BuiltInRegistries.f_257033_.m_7854_((Object)item.get()).get();
        ResourceLocation location = resourceKey.m_135782_();
        this.add(Util.m_137492_((String)resourceKey.m_211136_().m_135815_().replace('/', '.'), (ResourceLocation)new ResourceLocation(location.m_135827_(), location.m_135815_() + "." + key)), translation);
    }

    private String toName(ResourceKey<?> key) {
        String suffix = key.m_211136_().equals((Object)Registries.f_266076_.m_135782_()) ? " Material" : (key.m_211136_().equals((Object)Registries.f_266063_.m_135782_()) ? " Armor Trim" : "");
        return this.toName(key.m_135782_().m_135815_()) + suffix;
    }

    private String toName(String key) {
        CharSequence[] words = key.split("_");
        for (int i = words.length - 1; i > -1; --i) {
            words[i] = ((String)words[i]).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)words[i]).substring(1).toLowerCase(Locale.ENGLISH);
        }
        return String.join((CharSequence)" ", words);
    }

    private String makeDescriptionID(ResourceKey<?> resourceKey) {
        String registryPath = resourceKey.m_211136_().m_135815_();
        if (registryPath.equals("custom_stat")) {
            registryPath = "stat";
        } else if (registryPath.equals(Registries.f_256952_.m_135782_().m_135815_())) {
            registryPath = "biome";
        }
        return Util.m_137492_((String)registryPath.replace('/', '.'), (ResourceLocation)resourceKey.m_135782_()).replace("entity_type", "entity").replace("mob_effect", "effect");
    }

    public void add(String key, String value) {
        if (this.existing.add(key)) {
            super.add(key, value);
        }
    }

    public void add(String key, PigmanData.Profession profession, String value) {
        this.add(key + "." + profession.profName, value);
    }
}

