/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.data;

import com.legacy.rediscovered.data.RediscoveredAdvancementProv;
import com.legacy.rediscovered.data.RediscoveredLangProv;
import com.legacy.rediscovered.data.RediscoveredLootModifierProv;
import com.legacy.rediscovered.data.RediscoveredLootProv;
import com.legacy.rediscovered.data.RediscoveredModelProv;
import com.legacy.rediscovered.data.RediscoveredRecipeProv;
import com.legacy.rediscovered.data.RediscoveredSoundProv;
import com.legacy.rediscovered.data.RediscoveredTagProv;
import com.legacy.structure_gel.api.data.providers.NestedDataProvider;
import com.legacy.structure_gel.api.data.providers.RegistrarDatapackEntriesProvider;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rediscovered", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RediscoveredDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        boolean client = event.includeClient();
        PackOutput output = gen.getPackOutput();
        RegistrarDatapackEntriesProvider provider = RegistrarHandler.createGenerator((PackOutput)output, (String)"rediscovered", (String[])new String[0]);
        CompletableFuture lookup = provider.getLookupProvider();
        gen.addProvider(server, (DataProvider)provider);
        RediscoveredTagProv.BlockProv blockTagProv = new RediscoveredTagProv.BlockProv(gen, helper, lookup);
        gen.addProvider(server, (DataProvider)blockTagProv);
        gen.addProvider(server, (DataProvider)new RediscoveredTagProv.ItemProv(gen, blockTagProv.m_274426_(), helper, lookup));
        gen.addProvider(server, (DataProvider)new RediscoveredTagProv.EntityProv(gen, helper, lookup));
        gen.addProvider(server, (DataProvider)new RediscoveredTagProv.BiomeProv(gen, helper, lookup));
        gen.addProvider(server, (DataProvider)new RediscoveredTagProv.PoiProv(gen, helper, lookup));
        gen.addProvider(server, (DataProvider)new RediscoveredTagProv.StructureProv(gen, helper, lookup));
        gen.addProvider(server, (DataProvider)new RediscoveredTagProv.DamageTypeProv(gen, helper, lookup));
        gen.addProvider(server, (DataProvider)new RediscoveredTagProv.PaintingVariantProv(output, lookup, helper));
        gen.addProvider(server, (DataProvider)new RediscoveredAdvancementProv(output, lookup, helper));
        gen.addProvider(server, (DataProvider)new RediscoveredRecipeProv(output));
        gen.addProvider(server, (DataProvider)new RediscoveredLootProv(output));
        gen.addProvider(server, (DataProvider)new RediscoveredLootModifierProv(output));
        gen.addProvider(server, RediscoveredDataGen.packMcmeta(output, "Rediscovered Mod's resources"));
        PackOutput legacyPackOutput = gen.getPackOutput("assets/rediscovered/legacy_pack");
        gen.addProvider(server, RediscoveredDataGen.packMcmeta(legacyPackOutput, "Original look of the Rediscovered Mod (optional)"));
        gen.addProvider(client, (DataProvider)new RediscoveredModelProv.States(output, helper));
        gen.addProvider(client, (DataProvider)new RediscoveredModelProv.ItemModels(output, helper));
        gen.addProvider(client, (DataProvider)new RediscoveredSoundProv(output, helper));
        gen.addProvider(client, (DataProvider)new RediscoveredLangProv(output, lookup));
    }

    private static final NestedDataProvider<PackMetadataGenerator> packMcmeta(PackOutput output, String description) {
        Map packVersionMap = Stream.of(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0)));
        int packVersion = packVersionMap.get(PackType.SERVER_DATA);
        return NestedDataProvider.of((DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)description), packVersion, packVersionMap)), (String)description);
    }
}

