/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.world;

import com.legacy.rediscovered.registry.RediscoveredDimensions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SkylandsSkyRenderer {
    private static final ResourceLocation SUN_TEXTURE = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation MOON_TEXTURES = new ResourceLocation("textures/environment/moon_phases.png");
    private VertexBuffer starBuffer;
    private VertexBuffer skyBuffer;
    public static final SkylandsSkyRenderer INSTANCE = new SkylandsSkyRenderer();

    public SkylandsSkyRenderer() {
        this.generateStars();
        this.generateSky();
    }

    public float sunriseColors(long timeIn) {
        double d0 = Mth.m_14185_((double)((double)timeIn / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public static float getOverworldBias(float cameraY, float minBuildHeight) {
        if (cameraY <= minBuildHeight) {
            return Math.min((cameraY - minBuildHeight) / -64.0f, 1.0f);
        }
        return 0.0f;
    }

    public static Vec3 modifyFogColor(Vec3 fogColor, float fogBrightness) {
        Vec3 color = fogColor.m_82542_((double)(fogBrightness * 0.94f + 0.06f), (double)(fogBrightness * 0.94f + 0.06f), (double)(fogBrightness * 0.91f + 0.09f));
        Minecraft mc = Minecraft.m_91087_();
        float overworldBias = SkylandsSkyRenderer.getOverworldBias((float)mc.f_91063_.m_109153_().m_90583_().f_82480_, mc.f_91073_.m_141937_());
        if (overworldBias > 0.0f) {
            Biome plainsBiome = (Biome)mc.f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_6246_(Biomes.f_48202_);
            Vec3 plainsColor = Vec3.m_82501_((int)(plainsBiome != null ? plainsBiome.m_47539_() : 12638463));
            float timeModifier = Mth.m_14036_((float)(Mth.m_14089_((float)(mc.f_91073_.m_46942_(0.0f) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            float skylandsBias = 1.0f - overworldBias;
            float m = overworldBias * timeModifier;
            color = color.m_82542_((double)skylandsBias, (double)skylandsBias, (double)skylandsBias).m_82549_(plainsColor.m_82542_((double)m, (double)m, (double)m));
        }
        return color;
    }

    public static Vec3 getSkyColor(Vec3 pPos, float pPartialTick, ClientLevel level) {
        int i;
        float f9;
        float f = level.m_46942_(pPartialTick);
        Vec3 vec3 = pPos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        BiomeManager biomemanager = level.m_7062_();
        Vec3 vec31 = CubicSampler.m_130038_((Vec3)vec3, (x, y, z) -> Vec3.m_82501_((int)((Biome)biomemanager.m_204210_(x, y, z).m_203334_()).m_47463_()));
        float overworldBias = SkylandsSkyRenderer.getOverworldBias((float)pPos.f_82480_, level.m_141937_());
        if (overworldBias > 0.0f) {
            Biome plainsBiome = (Biome)level.m_9598_().m_175515_(Registries.f_256952_).m_6246_(Biomes.f_48202_);
            Vec3 plainsColor = Vec3.m_82501_((int)(plainsBiome != null ? plainsBiome.m_47463_() : 7907327));
            float skylandsBias = 1.0f - overworldBias;
            vec31 = vec31.m_82542_((double)skylandsBias, (double)skylandsBias, (double)skylandsBias).m_82549_(plainsColor.m_82542_((double)overworldBias, (double)overworldBias, (double)overworldBias));
        }
        float f1 = Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        float f2 = (float)vec31.f_82479_ * f1;
        float f3 = (float)vec31.f_82480_ * f1;
        float f4 = (float)vec31.f_82481_ * f1;
        float f5 = level.m_46722_(pPartialTick);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.75f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        if ((f9 = level.m_46661_(pPartialTick)) > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.75f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        if ((i = level.m_104819_()) > 0) {
            float f11 = (float)i - pPartialTick;
            if (f11 > 1.0f) {
                f11 = 1.0f;
            }
            f2 = f2 * (1.0f - (f11 *= 0.45f)) + 0.8f * f11;
            f3 = f3 * (1.0f - f11) + 0.8f * f11;
            f4 = f4 * (1.0f - f11) + 1.0f * f11;
        }
        return new Vec3((double)f2, (double)f3, (double)f4);
    }

    public void render(int ticks, float partialTicks, PoseStack pose, ClientLevel level, Camera camera, Matrix4f matrix, Runnable fog) {
        fog.run();
        Vec3 skyColor = SkylandsSkyRenderer.getSkyColor(camera.m_90583_(), partialTicks, level);
        float skyR = (float)skyColor.f_82479_;
        float skyG = (float)skyColor.f_82480_;
        float skyB = (float)skyColor.f_82481_;
        FogRenderer.m_109036_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_253207_(pose.m_85850_().m_252922_(), matrix, shaderinstance);
        VertexBuffer.m_85931_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] afloat = level.m_104583_().m_7518_(level.m_46942_(partialTicks), partialTicks);
        if (afloat != null) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            pose.m_85836_();
            pose.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float f3 = Mth.m_14031_((float)level.m_46490_(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            pose.m_252781_(Axis.f_252403_.m_252977_(f3));
            pose.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            float f4 = afloat[0];
            float f5 = afloat[1];
            float f6 = afloat[2];
            Matrix4f matrix4f = pose.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_252986_(matrix4f, 0.0f, 100.0f, 0.0f).m_85950_(f4, f5, f6, afloat[3]).m_5752_();
            for (int j = 0; j <= 16; ++j) {
                float f7 = (float)j * ((float)Math.PI * 2) / 16.0f;
                float f8 = Mth.m_14031_((float)f7);
                float f9 = Mth.m_14089_((float)f7);
                bufferbuilder.m_252986_(matrix4f, f8 * 120.0f, f9 * 120.0f, -f9 * 40.0f * afloat[3]).m_85950_(afloat[0], afloat[1], afloat[2], 0.0f).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            pose.m_85849_();
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        pose.m_85836_();
        float rainAlpha = 1.0f - level.m_46722_(partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rainAlpha);
        pose.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        pose.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTicks) * 360.0f));
        Matrix4f matrix4f1 = pose.m_85850_().m_252922_();
        float f12 = 30.0f;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_TEXTURE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        f12 = 20.0f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_TEXTURES);
        int k = level.m_46941_();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f13 = (float)(l + 0) / 4.0f;
        float f14 = (float)(i1 + 0) / 2.0f;
        float f15 = (float)(l + 1) / 4.0f;
        float f16 = (float)(i1 + 1) / 2.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, f12).m_7421_(f15, f16).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, f12).m_7421_(f13, f16).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, f12, -100.0f, -f12).m_7421_(f13, f14).m_5752_();
        bufferbuilder.m_252986_(matrix4f1, -f12, -100.0f, -f12).m_7421_(f15, f14).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        float f10 = level.m_104811_(partialTicks) * rainAlpha;
        if (f10 > 0.0f) {
            RenderSystem.setShaderColor((float)f10, (float)f10, (float)f10, (float)f10);
            FogRenderer.m_109017_();
            this.starBuffer.m_85921_();
            this.starBuffer.m_253207_(pose.m_85850_().m_252922_(), matrix, GameRenderer.m_172808_());
            VertexBuffer.m_85931_();
            fog.run();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        pose.m_85849_();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (level.m_104583_().m_108882_()) {
            RenderSystem.setShaderColor((float)(skyR * 0.2f + 0.04f), (float)(skyG * 0.2f + 0.04f), (float)(skyB * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    private void generateStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer box = this.renderStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(box);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer renderStars(BufferBuilder bufferBuilderIn) {
        Random random = new Random("Stormister".hashCode());
        bufferBuilderIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                bufferBuilderIn.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return bufferBuilderIn.m_231175_();
    }

    private void generateSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer box = this.buildSkybox(bufferbuilder, 16.0f);
        this.skyBuffer.m_85921_();
        this.skyBuffer.m_231221_(box);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer buildSkybox(BufferBuilder bufferBuilderIn, float posY) {
        float f = Math.signum(posY) * 512.0f;
        RenderSystem.setShader(GameRenderer::m_172808_);
        bufferBuilderIn.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        bufferBuilderIn.m_5483_(0.0, (double)posY, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilderIn.m_5483_((double)(f * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)posY, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return bufferBuilderIn.m_231175_();
    }

    public Float modifyVoidDarkness() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level.m_46472_().equals(RediscoveredDimensions.skylandsKey())) {
            float originalLogic = (float)Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().f_82480_ - (float)level.m_141937_();
            return Float.valueOf(1.0f / originalLogic);
        }
        return null;
    }
}

