/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.world;

import com.legacy.rediscovered.RediscoveredConfig;
import com.legacy.rediscovered.RediscoveredMod;
import com.legacy.rediscovered.client.render.RediscoveredRenderType;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SkylandsCloudRenderer {
    private static final List<SkylandsCloudRenderer> RENDERERS = new ArrayList<SkylandsCloudRenderer>(List.of(new SkylandsCloudRenderer(0.0f, -192.0f, 0.0f, 0.03f, true, -1), new SkylandsCloudRenderer(0.0f, -192.1f, 0.0f, 0.03f, false, 1), new SkylandsCloudRenderer(-80.0f, -40.0f, 120.0f, 0.02f), new SkylandsCloudRenderer(0.0f, 0.0f, 0.0f, 0.03f), new SkylandsCloudRenderer(30.0f, 215.0f, 60.0f, 0.07f), new SkylandsCloudRenderer(-30.0f, 280.0f, -60.0f, 0.05f)));
    private static final SkylandsCloudRenderer VANILLA_OVERRIDE = new SkylandsCloudRenderer(0.0f, 0.0f, 0.0f, 0.03f, true, 0){

        @Override
        public float getHeight() {
            return SkylandsCloudRenderer.mc().f_91073_.m_104583_().m_108871_();
        }
    };
    private static final ResourceLocation VANILLA_CLOUDS = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation CLOUD_SCREEN = RediscoveredMod.locate("textures/environment/cloud_screen.png");
    private static final ResourceLocation CLOUD_FLUFF = RediscoveredMod.locate("textures/environment/fluff.png");
    private final float xOffset;
    private final float yHeight;
    private final float zOffset;
    private final float speedModifier;
    private final boolean fluffy;
    private final int fadeState;
    @Nullable
    private VertexBuffer cloudBuffer;
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private Vec3 prevCloudColor = Vec3.f_82478_;
    @Nullable
    private CloudStatus prevCloudsType;
    private boolean generateClouds = true;
    private static boolean wasInMiddle = false;

    public SkylandsCloudRenderer(float xOffset, float yHeight, float zOffset, float speedModifier, boolean fluffy, int fadeState) {
        this.xOffset = xOffset;
        this.yHeight = yHeight;
        this.zOffset = zOffset;
        this.speedModifier = speedModifier;
        this.fluffy = fluffy;
        this.fadeState = fadeState;
    }

    public SkylandsCloudRenderer(float xOffset, float yHeight, float zOffset, float speedModifier) {
        this(xOffset, yHeight, zOffset, speedModifier, true, 0);
    }

    public static void renderLayers(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        boolean inMiddle;
        boolean bl = inMiddle = camY < 200.0 && camY > 15.0;
        if (!inMiddle || inMiddle != wasInMiddle) {
            RENDERERS.sort((o1, o2) -> Double.compare(Math.abs(camY - (double)o2.yHeight), Math.abs(camY - (double)o1.yHeight)));
        }
        for (SkylandsCloudRenderer renderer : RENDERERS) {
            renderer.renderClouds(level, ticks, poseStack, projectionMatrix, partialTick, camX, camY, camZ);
        }
        wasInMiddle = inMiddle;
    }

    public boolean useFluffyClouds() {
        return (this.fluffy || RediscoveredConfig.CLIENT.overrideVanillaClouds()) && RediscoveredRenderType.getFluffyCloudsShader() != null;
    }

    public static boolean renderCloudOverride(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ) {
        if (RediscoveredConfig.CLIENT.overrideVanillaClouds()) {
            Minecraft mc = SkylandsCloudRenderer.mc();
            VANILLA_OVERRIDE.renderClouds(mc.f_91073_, mc.f_91060_.getTicks(), poseStack, projectionMatrix, partialTick, camX, camY, camZ);
            return true;
        }
        return false;
    }

    public ShaderInstance getShader() {
        return this.useFluffyClouds() ? RediscoveredRenderType.getFluffyCloudsShader() : GameRenderer.m_172838_();
    }

    public void setShaderTextures() {
        if (this.useFluffyClouds()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CLOUD_SCREEN);
            RenderSystem.setShaderTexture((int)1, (ResourceLocation)CLOUD_FLUFF);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)VANILLA_CLOUDS);
        }
    }

    public float getHeight() {
        return this.yHeight;
    }

    public void renderClouds(ClientLevel level, int ticks, PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, double camX, double camY, double camZ) {
        float height = this.getHeight();
        if (!Float.isNaN(height)) {
            float xOffset = this.xOffset;
            float zOffset = this.zOffset;
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            float f1 = 12.0f;
            float f2 = 4.0f;
            double d0 = 2.0E-4;
            double d1 = ((float)ticks + partialTick) * this.speedModifier;
            double d2 = ((double)xOffset + camX + d1) / 12.0;
            double d3 = height - (float)camY + 0.33f;
            double d4 = (double)zOffset + camZ / 12.0 + (double)0.33f;
            d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * f2;
            float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
            Vec3 vec3 = level.m_104808_(partialTick);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || SkylandsCloudRenderer.mc().f_91066_.m_92174_() != this.prevCloudsType || this.prevCloudColor.m_82557_(vec3) > d0) {
                this.prevCloudX = i;
                this.prevCloudY = j;
                this.prevCloudZ = k;
                this.prevCloudColor = vec3;
                this.prevCloudsType = SkylandsCloudRenderer.mc().f_91066_.m_92174_();
                this.generateClouds = true;
            }
            if (this.generateClouds) {
                this.generateClouds = false;
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                if (this.cloudBuffer != null) {
                    this.cloudBuffer.close();
                }
                this.cloudBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.buildClouds(bufferbuilder, d2, d3, d4, vec3);
                this.cloudBuffer.m_85921_();
                this.cloudBuffer.m_231221_(bufferbuilder$renderedbuffer);
                VertexBuffer.m_85931_();
            }
            if (this.cloudBuffer != null) {
                poseStack.m_85836_();
                poseStack.m_85841_(f1, 1.0f, f1);
                poseStack.m_252880_(-f3, f4, -f5);
                float alpha = 1.0f;
                double startFade = SkylandsCloudRenderer.mc().f_91073_.m_141937_();
                if (this.fadeState != 0 && camY <= startFade) {
                    double endFade = startFade - 44.0;
                    double y = camY - startFade;
                    double percent = y / (endFade - startFade);
                    if (this.fadeState <= -1) {
                        alpha = 1.0f * (1.0f - (float)percent);
                    } else if (this.fadeState >= 1) {
                        alpha = 1.0f * (float)percent;
                    }
                } else if (this.fadeState == 1 && camY > startFade) {
                    alpha = 0.0f;
                }
                alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
                if (alpha > 0.0f) {
                    this.cloudBuffer.m_85921_();
                    int l = this.prevCloudsType == CloudStatus.FANCY ? 0 : 1;
                    RenderSystem.setShader(this::getShader);
                    this.setShaderTextures();
                    FogRenderer.m_109036_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    for (int i1 = l; i1 < 2; ++i1) {
                        if (i1 == 0) {
                            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                        } else {
                            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                        }
                        ShaderInstance shader = RenderSystem.getShader();
                        if (shader == null) continue;
                        this.cloudBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shader);
                    }
                    VertexBuffer.m_85931_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                poseStack.m_85849_();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    public BufferBuilder.RenderedBuffer buildClouds(BufferBuilder pBuilder, double pX, double pY, double pZ, Vec3 pCloudColor) {
        float f = 4.0f;
        float f1 = 0.00390625f;
        int i = 8;
        int j = 4;
        float f2 = 9.765625E-4f;
        float f3 = (float)Mth.m_14107_((double)pX) * 0.00390625f;
        float f4 = (float)Mth.m_14107_((double)pZ) * 0.00390625f;
        float f5 = (float)pCloudColor.f_82479_;
        float f6 = (float)pCloudColor.f_82480_;
        float f7 = (float)pCloudColor.f_82481_;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float bottomColorScale = 0.9f;
        float bottomR = f5 * bottomColorScale;
        float bottomG = f6 * bottomColorScale;
        float bottomB = f7 * bottomColorScale;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        RenderSystem.setShader(this::getShader);
        pBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        float f17 = (float)Math.floor(pY / 4.0) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int k = -7; k <= 8; ++k) {
                for (int l = -7; l <= 8; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(bottomR, bottomG, bottomB, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(bottomR, bottomG, bottomB, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(bottomR, bottomG, bottomB, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(bottomR, bottomG, bottomB, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    }
                    if (f17 <= 5.0f) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - f2), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - f2), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - f2), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - f2), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - f2), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - f2), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - f2), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + (float)j2 + 1.0f - f2), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - f2)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - f2)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - f2)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        pBuilder.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - f2)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                    }
                }
            }
        } else {
            boolean j1 = true;
            int k1 = 32;
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    pBuilder.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    pBuilder.m_5483_((double)(l1 + 0), (double)f17, (double)(i2 + 0)).m_7421_((float)(l1 + 0) * 0.00390625f + f3, (float)(i2 + 0) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                }
            }
        }
        return pBuilder.m_231175_();
    }

    private static final Minecraft mc() {
        return Minecraft.m_91087_();
    }
}

