/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.rediscovered.client.render.model;

import com.legacy.rediscovered.entity.ScarecrowEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ScarecrowModel<T extends ScarecrowEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart base;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart hat;
    private final ModelPart leftArm;
    private final ModelPart rightArm;

    public ScarecrowModel(ModelPart root) {
        this.root = root;
        this.base = root.m_171324_("base");
        this.body = this.base.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.hat = this.head.m_171324_("hat");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightArm = this.body.m_171324_("right_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition base = partdefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-1.0f, -16.0f, -1.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = base.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-5.5f, -8.0f, -3.0f, 11.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(-5.0f, 0.0f, -2.5f, 10.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(34, 21).m_171488_(-0.5f, -1.025f, -1.0f, 13.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(34, 25).m_171488_(-0.5f, -1.975f, -2.0f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.5f, (float)-5.975f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(34, 21).m_171480_().m_171488_(-12.5f, -1.025f, -1.0f, 13.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(34, 25).m_171480_().m_171488_(-8.5f, -1.975f, -2.0f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.5f, (float)-5.975f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.5f, -1.75f, -4.5f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(53, 0).m_171488_(-7.5f, 1.25f, -7.5f, 15.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.75f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float age, float netHeadYaw, float headPitch) {
        float hit;
        float d = (float)Math.PI / 180;
        this.base.f_104203_ = -0.2f * d;
        this.base.f_104204_ = 0.0f;
        this.base.f_104205_ = -0.1f * d;
        this.base.f_104201_ = 24.0f;
        this.body.f_104203_ = 0.15f * d;
        this.body.f_104204_ = 0.0f;
        this.body.f_104205_ = 0.1f * d;
        this.body.f_104201_ = -15.0f;
        this.head.f_104203_ = 6.0f * d;
        this.head.f_104204_ = 3.0f * d;
        this.head.f_104205_ = -3.0f * d;
        this.hat.f_104203_ = -7.0f * d;
        this.leftArm.f_104205_ = 5.1f * d;
        this.leftArm.f_104204_ = 1.1f * d;
        this.rightArm.f_104205_ = -5.0f * d;
        this.rightArm.f_104204_ = -1.0f * d;
        float partialTicks = age - (float)((ScarecrowEntity)((Object)entity)).f_19797_;
        if (((ScarecrowEntity)((Object)entity)).shouldDance) {
            float dance = partialTicks + (float)Minecraft.m_91087_().f_91074_.f_19797_;
            this.base.f_104203_ = (float)Math.sin((double)dance * 0.07) * 0.2f;
            this.base.f_104205_ = (float)Math.sin((double)dance * 0.2) * 0.5f;
            this.body.f_104203_ = (float)Math.cos((double)dance * 0.15) * 0.55f;
            this.body.f_104205_ = -this.base.f_104205_ * 0.4f;
            this.rightArm.f_104205_ = this.leftArm.f_104205_ = (float)Math.sin((double)dance * 0.5) * 0.8f;
            this.head.f_104205_ = (float)Math.sin((double)dance * 0.2) * 0.4f;
            this.head.f_104203_ = (float)Math.sin((double)dance * 0.3) * 0.2f;
            this.base.f_104201_ = this.base.f_104201_ + 1.0f + (float)Math.sin((double)dance * 0.4) * 2.0f;
            this.body.f_104201_ += (float)Math.sin((double)dance * 0.4) * 2.0f;
        }
        if ((hit = (float)entity.m_9236_().m_46467_() - (float)((ScarecrowEntity)((Object)entity)).lastHit + partialTicks) < 5.0f) {
            this.base.f_104204_ -= Mth.m_14031_((float)(hit / 1.5f * (float)Math.PI)) * ((float)Math.PI / 180) * 2.0f;
            float armR = Mth.m_14031_((float)(hit / 3.0f * (float)Math.PI)) * ((float)Math.PI / 180) * 2.0f;
            this.leftArm.f_104205_ -= armR;
            this.rightArm.f_104205_ += armR;
            this.head.f_104205_ += armR;
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

